/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.indexer.entities;

import com.intellij.ml.llm.embeddings.indexer.entities.FileBasedIndexableEntity;
import com.intellij.ml.llm.embeddings.utils.IndexingUtilsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/embeddings/indexer/entities/IndexableFileContent;", "Lcom/intellij/ml/llm/embeddings/indexer/entities/FileBasedIndexableEntity;", "name", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getName", "()Ljava/lang/String;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setVirtualFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "indexableRepresentation", "getIndexableRepresentation", "equals", "", "other", "", "hashCode", "", "intellij.ml.llm.embeddings"})
public class IndexableFileContent
implements FileBasedIndexableEntity {
    @NotNull
    private final String name;
    @NotNull
    private final TextRange textRange;
    @Nullable
    private VirtualFile virtualFile;

    public IndexableFileContent(@NotNull String name, @NotNull TextRange textRange, @Nullable VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        this.name = name;
        this.textRange = textRange;
        this.virtualFile = virtualFile;
    }

    public /* synthetic */ IndexableFileContent(String string, TextRange textRange, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            virtualFile = null;
        }
        this(string, textRange, virtualFile);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Override
    public void setVirtualFile(@Nullable VirtualFile virtualFile) {
        this.virtualFile = virtualFile;
    }

    @Override
    @NotNull
    public String getIndexableRepresentation() {
        Object object;
        block3: {
            block2: {
                object = this.getVirtualFile();
                if (object == null) break block2;
                VirtualFile it = object;
                boolean bl = false;
                Object object2 = ReadAction.compute(() -> IndexableFileContent._get_indexableRepresentation_$lambda$1$lambda$0(it, this));
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"compute(...)");
                String string = IndexingUtilsKt.splitIdentifierIntoTokens$default((String)object2, false, 2, null);
                object = string;
                if (string != null) break block3;
            }
            throw new RuntimeException("Virtual file is not set when calculating indexable representation");
        }
        return object;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexableFileContent)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((IndexableFileContent)other).getName(), (Object)this.getName()) && Intrinsics.areEqual((Object)((IndexableFileContent)other).textRange, (Object)this.textRange);
    }

    public int hashCode() {
        return 31 * this.getName().hashCode() + this.textRange.hashCode();
    }

    private static final String _get_indexableRepresentation_$lambda$1$lambda$0(VirtualFile $it, IndexableFileContent this$0) {
        Document document = VirtualFileUtil.findDocument((VirtualFile)$it);
        return String.valueOf(document != null ? document.getText(this$0.textRange) : null);
    }
}

