/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.InlineMe;
import io.grpc.Attributes;
import io.grpc.ChannelLogger;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ExperimentalApi;
import io.grpc.MetricRecorder;
import io.grpc.ProxyDetector;
import io.grpc.Status;
import io.grpc.StatusOr;
import io.grpc.SynchronizationContext;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URI;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
public abstract class NameResolver {
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11989")
    public static final Attributes.Key<String> ATTR_BACKEND_SERVICE = Attributes.Key.create("io.grpc.NameResolver.ATTR_BACKEND_SERVICE");

    public abstract String getServiceAuthority();

    public void start(final Listener listener2) {
        if (listener2 instanceof Listener2) {
            this.start((Listener2)listener2);
        } else {
            this.start(new Listener2(){

                @Override
                public void onError(Status error) {
                    listener2.onError(error);
                }

                @Override
                public void onResult(ResolutionResult resolutionResult) {
                    listener2.onAddresses(resolutionResult.getAddressesOrError().getValue(), resolutionResult.getAttributes());
                }
            });
        }
    }

    public void start(Listener2 listener2) {
        this.start((Listener)listener2);
    }

    public abstract void shutdown();

    public void refresh() {
    }

    @Nullable
    private static IdentityHashMap<Args.Key<?>, Object> cloneCustomArgs(@Nullable IdentityHashMap<Args.Key<?>, Object> customArgs) {
        return customArgs != null ? new IdentityHashMap(customArgs) : null;
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static final class ConfigOrError {
        private final Status status;
        private final Object config;

        public static ConfigOrError fromConfig(Object config) {
            return new ConfigOrError(config);
        }

        public static ConfigOrError fromError(Status status) {
            return new ConfigOrError(status);
        }

        private ConfigOrError(Object config) {
            this.config = Preconditions.checkNotNull((Object)config, (Object)"config");
            this.status = null;
        }

        private ConfigOrError(Status status) {
            this.config = null;
            this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
            Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (String)"cannot use OK status: %s", (Object)status);
        }

        @Nullable
        public Object getConfig() {
            return this.config;
        }

        @Nullable
        public Status getError() {
            return this.status;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigOrError that = (ConfigOrError)o;
            return Objects.equal((Object)this.status, (Object)that.status) && Objects.equal((Object)this.config, (Object)that.config);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.status, this.config});
        }

        public String toString() {
            if (this.config != null) {
                return MoreObjects.toStringHelper((Object)this).add("config", this.config).toString();
            }
            assert (this.status != null);
            return MoreObjects.toStringHelper((Object)this).add("error", (Object)this.status).toString();
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static final class ResolutionResult {
        private final StatusOr<List<EquivalentAddressGroup>> addressesOrError;
        private final Attributes attributes;
        @Nullable
        private final ConfigOrError serviceConfig;

        ResolutionResult(StatusOr<List<EquivalentAddressGroup>> addressesOrError, Attributes attributes, ConfigOrError serviceConfig) {
            this.addressesOrError = addressesOrError;
            this.attributes = (Attributes)Preconditions.checkNotNull((Object)attributes, (Object)"attributes");
            this.serviceConfig = serviceConfig;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return ResolutionResult.newBuilder().setAddressesOrError(this.addressesOrError).setAttributes(this.attributes).setServiceConfig(this.serviceConfig);
        }

        @Deprecated
        public List<EquivalentAddressGroup> getAddresses() {
            return this.addressesOrError.getValue();
        }

        public StatusOr<List<EquivalentAddressGroup>> getAddressesOrError() {
            return this.addressesOrError;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        @Nullable
        public ConfigOrError getServiceConfig() {
            return this.serviceConfig;
        }

        public String toString() {
            MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this);
            stringHelper.add("addressesOrError", (Object)this.addressesOrError.toString());
            stringHelper.add("attributes", (Object)this.attributes);
            stringHelper.add("serviceConfigOrError", (Object)this.serviceConfig);
            return stringHelper.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResolutionResult)) {
                return false;
            }
            ResolutionResult that = (ResolutionResult)obj;
            return Objects.equal(this.addressesOrError, that.addressesOrError) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal((Object)this.serviceConfig, (Object)that.serviceConfig);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.addressesOrError, this.attributes, this.serviceConfig});
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
        public static final class Builder {
            private StatusOr<List<EquivalentAddressGroup>> addresses = StatusOr.fromValue(Collections.emptyList());
            private Attributes attributes = Attributes.EMPTY;
            @Nullable
            private ConfigOrError serviceConfig;

            Builder() {
            }

            @Deprecated
            public Builder setAddresses(List<EquivalentAddressGroup> addresses) {
                this.setAddressesOrError(StatusOr.fromValue(addresses));
                return this;
            }

            public Builder setAddressesOrError(StatusOr<List<EquivalentAddressGroup>> addresses) {
                this.addresses = (StatusOr)Preconditions.checkNotNull(addresses, (Object)"StatusOr addresses cannot be null.");
                return this;
            }

            public Builder setAttributes(Attributes attributes) {
                this.attributes = attributes;
                return this;
            }

            public Builder setServiceConfig(@Nullable ConfigOrError serviceConfig) {
                this.serviceConfig = serviceConfig;
                return this;
            }

            public ResolutionResult build() {
                return new ResolutionResult(this.addresses, this.attributes, this.serviceConfig);
            }
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class ServiceConfigParser {
        public abstract ConfigOrError parseServiceConfig(Map<String, ?> var1);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static final class Args {
        private final int defaultPort;
        private final ProxyDetector proxyDetector;
        private final SynchronizationContext syncContext;
        private final ServiceConfigParser serviceConfigParser;
        @Nullable
        private final ScheduledExecutorService scheduledExecutorService;
        @Nullable
        private final ChannelLogger channelLogger;
        @Nullable
        private final Executor executor;
        @Nullable
        private final String overrideAuthority;
        @Nullable
        private final MetricRecorder metricRecorder;
        @Nullable
        private final IdentityHashMap<Key<?>, Object> customArgs;

        private Args(Builder builder) {
            this.defaultPort = (Integer)Preconditions.checkNotNull((Object)builder.defaultPort, (Object)"defaultPort not set");
            this.proxyDetector = (ProxyDetector)Preconditions.checkNotNull((Object)builder.proxyDetector, (Object)"proxyDetector not set");
            this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)builder.syncContext, (Object)"syncContext not set");
            this.serviceConfigParser = (ServiceConfigParser)Preconditions.checkNotNull((Object)builder.serviceConfigParser, (Object)"serviceConfigParser not set");
            this.scheduledExecutorService = builder.scheduledExecutorService;
            this.channelLogger = builder.channelLogger;
            this.executor = builder.executor;
            this.overrideAuthority = builder.overrideAuthority;
            this.metricRecorder = builder.metricRecorder;
            this.customArgs = NameResolver.cloneCustomArgs(builder.customArgs);
        }

        public int getDefaultPort() {
            return this.defaultPort;
        }

        public ProxyDetector getProxyDetector() {
            return this.proxyDetector;
        }

        public SynchronizationContext getSynchronizationContext() {
            return this.syncContext;
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6454")
        public ScheduledExecutorService getScheduledExecutorService() {
            if (this.scheduledExecutorService == null) {
                throw new IllegalStateException("ScheduledExecutorService not set in Builder");
            }
            return this.scheduledExecutorService;
        }

        public ServiceConfigParser getServiceConfigParser() {
            return this.serviceConfigParser;
        }

        @Nullable
        public <T> T getArg(Key<T> key) {
            return (T)(this.customArgs != null ? this.customArgs.get(key) : null);
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6438")
        public ChannelLogger getChannelLogger() {
            if (this.channelLogger == null) {
                throw new IllegalStateException("ChannelLogger is not set in Builder");
            }
            return this.channelLogger;
        }

        @Nullable
        public Executor getOffloadExecutor() {
            return this.executor;
        }

        @Nullable
        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9406")
        public String getOverrideAuthority() {
            return this.overrideAuthority;
        }

        @Nullable
        public MetricRecorder getMetricRecorder() {
            return this.metricRecorder;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("defaultPort", this.defaultPort).add("proxyDetector", (Object)this.proxyDetector).add("syncContext", (Object)this.syncContext).add("serviceConfigParser", (Object)this.serviceConfigParser).add("customArgs", this.customArgs).add("scheduledExecutorService", (Object)this.scheduledExecutorService).add("channelLogger", (Object)this.channelLogger).add("executor", (Object)this.executor).add("overrideAuthority", (Object)this.overrideAuthority).add("metricRecorder", (Object)this.metricRecorder).toString();
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.setDefaultPort(this.defaultPort);
            builder.setProxyDetector(this.proxyDetector);
            builder.setSynchronizationContext(this.syncContext);
            builder.setServiceConfigParser(this.serviceConfigParser);
            builder.setScheduledExecutorService(this.scheduledExecutorService);
            builder.setChannelLogger(this.channelLogger);
            builder.setOffloadExecutor(this.executor);
            builder.setOverrideAuthority(this.overrideAuthority);
            builder.setMetricRecorder(this.metricRecorder);
            builder.customArgs = NameResolver.cloneCustomArgs(this.customArgs);
            return builder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        @Immutable
        public static final class Key<T> {
            private final String debugString;

            private Key(String debugString) {
                this.debugString = debugString;
            }

            public String toString() {
                return this.debugString;
            }

            public static <T> Key<T> create(String debugString) {
                return new Key<T>(debugString);
            }
        }

        public static final class Builder {
            private Integer defaultPort;
            private ProxyDetector proxyDetector;
            private SynchronizationContext syncContext;
            private ServiceConfigParser serviceConfigParser;
            private ScheduledExecutorService scheduledExecutorService;
            private ChannelLogger channelLogger;
            private Executor executor;
            private String overrideAuthority;
            private MetricRecorder metricRecorder;
            private IdentityHashMap<Key<?>, Object> customArgs;

            Builder() {
            }

            public Builder setDefaultPort(int defaultPort) {
                this.defaultPort = defaultPort;
                return this;
            }

            public Builder setProxyDetector(ProxyDetector proxyDetector) {
                this.proxyDetector = (ProxyDetector)Preconditions.checkNotNull((Object)proxyDetector);
                return this;
            }

            public Builder setSynchronizationContext(SynchronizationContext syncContext) {
                this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext);
                return this;
            }

            @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6454")
            public Builder setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
                this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService);
                return this;
            }

            public Builder setServiceConfigParser(ServiceConfigParser parser) {
                this.serviceConfigParser = (ServiceConfigParser)Preconditions.checkNotNull((Object)parser);
                return this;
            }

            @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6438")
            public Builder setChannelLogger(ChannelLogger channelLogger) {
                this.channelLogger = (ChannelLogger)Preconditions.checkNotNull((Object)channelLogger);
                return this;
            }

            public Builder setOffloadExecutor(Executor executor) {
                this.executor = executor;
                return this;
            }

            @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9406")
            public Builder setOverrideAuthority(String authority) {
                this.overrideAuthority = authority;
                return this;
            }

            public <T> Builder setArg(Key<T> key, T value) {
                Preconditions.checkNotNull(key, (Object)"key");
                Preconditions.checkNotNull(value, (Object)"value");
                if (this.customArgs == null) {
                    this.customArgs = new IdentityHashMap();
                }
                this.customArgs.put(key, value);
                return this;
            }

            public Builder setMetricRecorder(MetricRecorder metricRecorder) {
                this.metricRecorder = metricRecorder;
                return this;
            }

            public Args build() {
                return new Args(this);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4972")
    public static @interface ResolutionResultAttr {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class Listener2
    implements Listener {
        @Override
        @Deprecated
        @InlineMe(replacement="this.onResult(ResolutionResult.newBuilder().setAddressesOrError(StatusOr.fromValue(servers)).setAttributes(attributes).build())", imports={"io.grpc.NameResolver.ResolutionResult", "io.grpc.StatusOr"})
        public final void onAddresses(List<EquivalentAddressGroup> servers, Attributes attributes) {
            this.onResult(ResolutionResult.newBuilder().setAddressesOrError(StatusOr.fromValue(servers)).setAttributes(attributes).build());
        }

        public abstract void onResult(ResolutionResult var1);

        @Override
        public abstract void onError(Status var1);

        public Status onResult2(ResolutionResult resolutionResult) {
            this.onResult(resolutionResult);
            return Status.OK;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    @ThreadSafe
    public static interface Listener {
        public void onAddresses(List<EquivalentAddressGroup> var1, Attributes var2);

        public void onError(Status var1);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class Factory {
        public abstract NameResolver newNameResolver(URI var1, Args var2);

        public abstract String getDefaultScheme();
    }
}

