/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslEngineMap;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSession;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSessionCache;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSL;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.util.HashMap;
import java.util.Map;

final class OpenSslClientSessionCache
extends OpenSslSessionCache {
    private final Map<HostPort, OpenSslSessionCache.NativeSslSession> sessions = new HashMap<HostPort, OpenSslSessionCache.NativeSslSession>();

    OpenSslClientSessionCache(OpenSslEngineMap engineMap) {
        super(engineMap);
    }

    @Override
    protected boolean sessionCreated(OpenSslSessionCache.NativeSslSession session) {
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(session.getPeerHost(), session.getPeerPort());
        if (hostPort == null || this.sessions.containsKey(hostPort)) {
            return false;
        }
        this.sessions.put(hostPort, session);
        return true;
    }

    @Override
    protected void sessionRemoved(OpenSslSessionCache.NativeSslSession session) {
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(session.getPeerHost(), session.getPeerPort());
        if (hostPort == null) {
            return;
        }
        this.sessions.remove(hostPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean setSession(long ssl, OpenSslSession session, String host, int port2) {
        boolean reused;
        OpenSslSessionCache.NativeSslSession nativeSslSession;
        HostPort hostPort = OpenSslClientSessionCache.keyFor(host, port2);
        if (hostPort == null) {
            return false;
        }
        boolean singleUsed = false;
        OpenSslClientSessionCache openSslClientSessionCache = this;
        synchronized (openSslClientSessionCache) {
            nativeSslSession = this.sessions.get(hostPort);
            if (nativeSslSession == null) {
                return false;
            }
            if (!nativeSslSession.isValid()) {
                this.removeSessionWithId(nativeSslSession.sessionId());
                return false;
            }
            reused = SSL.setSession(ssl, nativeSslSession.session());
            if (reused) {
                singleUsed = nativeSslSession.shouldBeSingleUse();
            }
        }
        if (reused) {
            if (singleUsed) {
                nativeSslSession.invalidate();
                session.invalidate();
            }
            nativeSslSession.setLastAccessedTime(System.currentTimeMillis());
            session.setSessionDetails(nativeSslSession.getCreationTime(), nativeSslSession.getLastAccessedTime(), nativeSslSession.sessionId(), nativeSslSession.keyValueStorage);
        }
        return reused;
    }

    private static HostPort keyFor(String host, int port2) {
        if (host == null && port2 < 1) {
            return null;
        }
        return new HostPort(host, port2);
    }

    @Override
    synchronized void clear() {
        super.clear();
        this.sessions.clear();
    }

    private static final class HostPort {
        private final int hash;
        private final String host;
        private final int port;

        HostPort(String host, int port2) {
            this.host = host;
            this.port = port2;
            this.hash = 31 * AsciiString.hashCode(host) + port2;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HostPort)) {
                return false;
            }
            HostPort other = (HostPort)obj;
            return this.port == other.port && this.host.equalsIgnoreCase(other.host);
        }

        public String toString() {
            return "HostPort{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }
}

