/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.layer.recurrent.lstm;

import io.kinference.core.operators.layer.recurrent.LayerDirection;
import io.kinference.core.operators.layer.recurrent.lstm.AbstractLSTMInput;
import io.kinference.core.operators.layer.recurrent.lstm.AbstractLSTMWeights;
import io.kinference.core.operators.layer.recurrent.lstm.BiLSTMLayer;
import io.kinference.core.operators.layer.recurrent.lstm.LSTMLayer;
import io.kinference.core.operators.layer.recurrent.lstm.LSTMLayerOutput;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.NumberNDArrayCore;
import io.kinference.primitives.types.DataType;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ`\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020 H\u00a6@\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lio/kinference/core/operators/layer/recurrent/lstm/LSTMLayerBase;", "", "hiddenSize", "", "activations", "", "", "direction", "Lio/kinference/core/operators/layer/recurrent/LayerDirection;", "<init>", "(ILjava/util/List;Lio/kinference/core/operators/layer/recurrent/LayerDirection;)V", "getHiddenSize", "()I", "getActivations", "()Ljava/util/List;", "getDirection", "()Lio/kinference/core/operators/layer/recurrent/LayerDirection;", "apply", "Lio/kinference/core/operators/layer/recurrent/lstm/LSTMLayerOutput;", "input", "Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMInput;", "weights", "Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMWeights;", "recurrentWeights", "bias", "Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "sequenceLens", "Lio/kinference/ndarray/arrays/IntNDArray;", "initialHiddenState", "initialCellState", "peepholes", "dataType", "Lio/kinference/primitives/types/DataType;", "(Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMInput;Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMWeights;Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMWeights;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/IntNDArray;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/primitives/types/DataType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "inference-core"})
public abstract class LSTMLayerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int hiddenSize;
    @NotNull
    private final List<String> activations;
    @NotNull
    private final LayerDirection direction;

    public LSTMLayerBase(int hiddenSize, @NotNull List<String> activations, @NotNull LayerDirection direction) {
        Intrinsics.checkNotNullParameter(activations, (String)"activations");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.hiddenSize = hiddenSize;
        this.activations = activations;
        this.direction = direction;
    }

    public final int getHiddenSize() {
        return this.hiddenSize;
    }

    @NotNull
    public final List<String> getActivations() {
        return this.activations;
    }

    @NotNull
    public final LayerDirection getDirection() {
        return this.direction;
    }

    @Nullable
    public abstract Object apply(@NotNull AbstractLSTMInput var1, @NotNull AbstractLSTMWeights var2, @NotNull AbstractLSTMWeights var3, @Nullable NumberNDArrayCore var4, @Nullable IntNDArray var5, @Nullable NumberNDArrayCore var6, @Nullable NumberNDArrayCore var7, @Nullable NumberNDArrayCore var8, @NotNull DataType var9, @NotNull Continuation<? super LSTMLayerOutput> var10);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lio/kinference/core/operators/layer/recurrent/lstm/LSTMLayerBase$Companion;", "", "<init>", "()V", "create", "Lio/kinference/core/operators/layer/recurrent/lstm/LSTMLayerBase;", "hiddenSize", "", "activations", "", "", "direction", "Lio/kinference/core/operators/layer/recurrent/LayerDirection;", "inference-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LSTMLayerBase create(int hiddenSize, @NotNull List<String> activations, @NotNull LayerDirection direction) {
            Intrinsics.checkNotNullParameter(activations, (String)"activations");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1, 2 -> new LSTMLayer(hiddenSize, activations, direction);
                case 3 -> new BiLSTMLayer(hiddenSize, activations);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LayerDirection.values().length];
                try {
                    nArray[LayerDirection.FORWARD.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LayerDirection.REVERSE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LayerDirection.BIDIRECTIONAL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

