/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.broadcasting;

import io.kinference.ndarray.arrays.DoubleBinaryOperation;
import io.kinference.ndarray.arrays.DoubleNDArray;
import io.kinference.ndarray.arrays.MutableDoubleNDArray;
import io.kinference.ndarray.extensions.broadcasting.BroadcastingInfo;
import io.kinference.ndarray.extensions.broadcasting.ReshapeViewKt;
import io.kinference.ndarray.extensions.broadcasting.ScalarBroadcastFun;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a(\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"broadcastTwoTensorsDouble", "Lio/kinference/ndarray/arrays/MutableDoubleNDArray;", "left", "Lio/kinference/ndarray/arrays/DoubleNDArray;", "right", "dest", "op", "Lio/kinference/ndarray/arrays/DoubleBinaryOperation;", "executeWithoutBroadcasting", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nBroadcastTwoArgumentsDouble.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroadcastTwoArgumentsDouble.kt\nio/kinference/ndarray/extensions/broadcasting/BroadcastTwoArgumentsDoubleKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class BroadcastTwoArgumentsDoubleKt {
    @NotNull
    public static final MutableDoubleNDArray broadcastTwoTensorsDouble(@NotNull DoubleNDArray left, @NotNull DoubleNDArray right, @NotNull MutableDoubleNDArray dest, @NotNull DoubleBinaryOperation op) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Object[] objectArray = new DoubleNDArray[]{left, right};
        BroadcastingInfo broadcastingInfo = BroadcastingInfo.Companion.create(CollectionsKt.listOf((Object[])objectArray));
        if (!Arrays.equals(dest.getShape(), broadcastingInfo.getDestShape())) {
            boolean bl = false;
            String string = "Destination has incorrect shape, expected: " + ArraysKt.joinToString$default((int[])broadcastingInfo.getDestShape(), null, null, null, (int)0, null, null, (int)63, null) + ", actual " + ArraysKt.joinToString$default((int[])dest.getShape(), null, null, null, (int)0, null, null, (int)63, null);
            throw new IllegalArgumentException(string.toString());
        }
        if (broadcastingInfo.getBroadcastingAxes().isEmpty()) {
            return BroadcastTwoArgumentsDoubleKt.executeWithoutBroadcasting(left, right, dest, op);
        }
        int totalAxesToBroadcast = broadcastingInfo.getBroadcastAlongLastAxis() ? broadcastingInfo.getBroadcastingAxes().size() - 1 : broadcastingInfo.getBroadcastingAxes().size();
        int[][] nArray = broadcastingInfo.getBroadcastingShapes();
        int[] leftBroadcastingShape = (int[])((Object[])nArray)[0];
        int[] rightBroadcastingShape = (int[])((Object[])nArray)[1];
        int[] destBroadcastingShape = broadcastingInfo.getBroadcastingDestShape();
        int destBlocksInRow = ArraysKt.last((int[])destBroadcastingShape) / dest.getArray().getBlockSize();
        int[] leftOffsets = ReshapeViewKt.makeOffsets(leftBroadcastingShape, ArraysKt.last((int[])leftBroadcastingShape) / left.getArray().getBlockSize());
        int[] rightOffsets = ReshapeViewKt.makeOffsets(rightBroadcastingShape, ArraysKt.last((int[])rightBroadcastingShape) / right.getArray().getBlockSize());
        int[] destOffsets = ReshapeViewKt.makeOffsets(destBroadcastingShape, destBlocksInRow);
        boolean leftIsScalar = broadcastingInfo.getBroadcastAlongLastAxis() && ArraysKt.last((int[])leftBroadcastingShape) == 1;
        boolean rightIsScalar = broadcastingInfo.getBroadcastAlongLastAxis() && ArraysKt.last((int[])rightBroadcastingShape) == 1;
        double[][] leftBlocks = left.getArray().getBlocks();
        double[][] rightBlocks = right.getArray().getBlocks();
        double[][] destBlocks = dest.getArray().getBlocks();
        ScalarBroadcastFun leftIsScalarFun = (arg_0, arg_1, arg_2, arg_3) -> BroadcastTwoArgumentsDoubleKt.broadcastTwoTensorsDouble$lambda$1(destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, leftBlocks, destBlocksInRow, destBlocks, rightBlocks, op, arg_0, arg_1, arg_2, arg_3);
        ScalarBroadcastFun rightIsScalarFun = (arg_0, arg_1, arg_2, arg_3) -> BroadcastTwoArgumentsDoubleKt.broadcastTwoTensorsDouble$lambda$2(destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, rightBlocks, destBlocksInRow, destBlocks, leftBlocks, op, arg_0, arg_1, arg_2, arg_3);
        ScalarBroadcastFun defaultFun = (arg_0, arg_1, arg_2, arg_3) -> BroadcastTwoArgumentsDoubleKt.broadcastTwoTensorsDouble$lambda$3(destBlocksInRow, leftBlocks, rightBlocks, destBlocks, op, arg_0, arg_1, arg_2, arg_3);
        ScalarBroadcastFun broadcastingFun = leftIsScalar ? leftIsScalarFun : (rightIsScalar ? rightIsScalarFun : defaultFun);
        BroadcastTwoArgumentsDoubleKt.broadcastTwoTensorsDouble$broadcast(totalAxesToBroadcast, broadcastingFun, destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, leftBroadcastingShape, rightBroadcastingShape, 0, 0, 0, 0);
        return dest;
    }

    private static final MutableDoubleNDArray executeWithoutBroadcasting(DoubleNDArray left, DoubleNDArray right, MutableDoubleNDArray dest, DoubleBinaryOperation op) {
        double[][] leftBlocks = left.getArray().getBlocks();
        double[][] rightBlocks = right.getArray().getBlocks();
        double[][] destBlocks = dest.getArray().getBlocks();
        int n = ((Object[])destBlocks).length;
        for (int blockIdx = 0; blockIdx < n; ++blockIdx) {
            double[] destBlock = destBlocks[blockIdx];
            double[] leftBlock = leftBlocks[blockIdx];
            double[] rightBlock = rightBlocks[blockIdx];
            int n2 = destBlock.length;
            for (int idx = 0; idx < n2; ++idx) {
                destBlock[idx] = op.invoke(leftBlock[idx], rightBlock[idx]);
            }
        }
        return dest;
    }

    private static final void broadcastTwoTensorsDouble$lambda$1(int[] $destBroadcastingShape, int[] $leftOffsets, int[] $rightOffsets, int[] $destOffsets, double[][] $leftBlocks, int $destBlocksInRow, double[][] $destBlocks, double[][] $rightBlocks, DoubleBinaryOperation $op, int leftOffset, int rightOffset, int destOffset, int axisToBroadcastIdx) {
        Intrinsics.checkNotNullParameter((Object)$destBroadcastingShape, (String)"$destBroadcastingShape");
        Intrinsics.checkNotNullParameter((Object)$leftOffsets, (String)"$leftOffsets");
        Intrinsics.checkNotNullParameter((Object)$rightOffsets, (String)"$rightOffsets");
        Intrinsics.checkNotNullParameter((Object)$destOffsets, (String)"$destOffsets");
        Intrinsics.checkNotNullParameter((Object)$leftBlocks, (String)"$leftBlocks");
        Intrinsics.checkNotNullParameter((Object)$destBlocks, (String)"$destBlocks");
        Intrinsics.checkNotNullParameter((Object)$rightBlocks, (String)"$rightBlocks");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        int shapeIdx = axisToBroadcastIdx * 2;
        int batchSize = $destBroadcastingShape[shapeIdx];
        for (int batchIdx = 0; batchIdx < batchSize; ++batchIdx) {
            int leftBatchOffset = leftOffset + $leftOffsets[shapeIdx] * batchIdx;
            int rightBatchOffset = rightOffset + $rightOffsets[shapeIdx] * batchIdx;
            int destBatchOffset = destOffset + $destOffsets[shapeIdx] * batchIdx;
            double leftScalar = $leftBlocks[leftBatchOffset][0];
            for (int blockIdx = 0; blockIdx < $destBlocksInRow; ++blockIdx) {
                double[] destBlock = $destBlocks[destBatchOffset + blockIdx];
                double[] rightBlock = $rightBlocks[rightBatchOffset + blockIdx];
                int n = destBlock.length;
                for (int idx = 0; idx < n; ++idx) {
                    destBlock[idx] = $op.invoke(leftScalar, rightBlock[idx]);
                }
            }
        }
    }

    private static final void broadcastTwoTensorsDouble$lambda$2(int[] $destBroadcastingShape, int[] $leftOffsets, int[] $rightOffsets, int[] $destOffsets, double[][] $rightBlocks, int $destBlocksInRow, double[][] $destBlocks, double[][] $leftBlocks, DoubleBinaryOperation $op, int leftOffset, int rightOffset, int destOffset, int axisToBroadcastIdx) {
        Intrinsics.checkNotNullParameter((Object)$destBroadcastingShape, (String)"$destBroadcastingShape");
        Intrinsics.checkNotNullParameter((Object)$leftOffsets, (String)"$leftOffsets");
        Intrinsics.checkNotNullParameter((Object)$rightOffsets, (String)"$rightOffsets");
        Intrinsics.checkNotNullParameter((Object)$destOffsets, (String)"$destOffsets");
        Intrinsics.checkNotNullParameter((Object)$rightBlocks, (String)"$rightBlocks");
        Intrinsics.checkNotNullParameter((Object)$destBlocks, (String)"$destBlocks");
        Intrinsics.checkNotNullParameter((Object)$leftBlocks, (String)"$leftBlocks");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        int shapeIdx = axisToBroadcastIdx * 2;
        int batchSize = $destBroadcastingShape[shapeIdx];
        for (int batchIdx = 0; batchIdx < batchSize; ++batchIdx) {
            int leftBatchOffset = leftOffset + $leftOffsets[shapeIdx] * batchIdx;
            int rightBatchOffset = rightOffset + $rightOffsets[shapeIdx] * batchIdx;
            int destBatchOffset = destOffset + $destOffsets[shapeIdx] * batchIdx;
            double rightScalar = $rightBlocks[rightBatchOffset][0];
            for (int blockIdx = 0; blockIdx < $destBlocksInRow; ++blockIdx) {
                double[] destBlock = $destBlocks[destBatchOffset + blockIdx];
                double[] leftBlock = $leftBlocks[leftBatchOffset + blockIdx];
                int n = destBlock.length;
                for (int idx = 0; idx < n; ++idx) {
                    destBlock[idx] = $op.invoke(leftBlock[idx], rightScalar);
                }
            }
        }
    }

    private static final void broadcastTwoTensorsDouble$lambda$3(int $destBlocksInRow, double[][] $leftBlocks, double[][] $rightBlocks, double[][] $destBlocks, DoubleBinaryOperation $op, int leftOffset, int rightOffset, int destOffset, int n) {
        Intrinsics.checkNotNullParameter((Object)$leftBlocks, (String)"$leftBlocks");
        Intrinsics.checkNotNullParameter((Object)$rightBlocks, (String)"$rightBlocks");
        Intrinsics.checkNotNullParameter((Object)$destBlocks, (String)"$destBlocks");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        for (int blockIdx = 0; blockIdx < $destBlocksInRow; ++blockIdx) {
            double[] leftBlock = $leftBlocks[leftOffset + blockIdx];
            double[] rightBlock = $rightBlocks[rightOffset + blockIdx];
            double[] destBlock = $destBlocks[destOffset + blockIdx];
            int n2 = destBlock.length;
            for (int idx = 0; idx < n2; ++idx) {
                destBlock[idx] = $op.invoke(leftBlock[idx], rightBlock[idx]);
            }
        }
    }

    private static final void broadcastTwoTensorsDouble$broadcast(int totalAxesToBroadcast, ScalarBroadcastFun broadcastingFun, int[] destBroadcastingShape, int[] leftOffsets, int[] rightOffsets, int[] destOffsets, int[] leftBroadcastingShape, int[] rightBroadcastingShape, int leftOffset, int rightOffset, int destOffset, int axisToBroadcastIdx) {
        if (axisToBroadcastIdx == totalAxesToBroadcast) {
            broadcastingFun.invoke(leftOffset, rightOffset, destOffset, axisToBroadcastIdx);
        } else {
            int shapeIdx = axisToBroadcastIdx * 2;
            int batchSize = destBroadcastingShape[shapeIdx];
            int dimSize = destBroadcastingShape[shapeIdx + 1];
            for (int batchIdx = 0; batchIdx < batchSize; ++batchIdx) {
                int leftBatchOffset = leftOffset + leftOffsets[shapeIdx] * batchIdx;
                int rightBatchOffset = rightOffset + rightOffsets[shapeIdx] * batchIdx;
                int destBatchOffset = destOffset + destOffsets[shapeIdx] * batchIdx;
                for (int dimIdx = 0; dimIdx < dimSize; ++dimIdx) {
                    int leftFullOffset = leftBatchOffset + dimIdx % leftBroadcastingShape[shapeIdx + 1] * leftOffsets[shapeIdx + 1];
                    int rightFullOffset = rightBatchOffset + dimIdx % rightBroadcastingShape[shapeIdx + 1] * rightOffsets[shapeIdx + 1];
                    int destFullOffset = destBatchOffset + dimIdx * destOffsets[shapeIdx + 1];
                    BroadcastTwoArgumentsDoubleKt.broadcastTwoTensorsDouble$broadcast(totalAxesToBroadcast, broadcastingFun, destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, leftBroadcastingShape, rightBroadcastingShape, leftFullOffset, rightFullOffset, destFullOffset, axisToBroadcastIdx + 1);
                }
            }
        }
    }
}

