/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongIndirectPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongSemiIndirectHeaps;
import java.util.NoSuchElementException;

public class LongHeapSemiIndirectPriorityQueue
implements LongIndirectPriorityQueue {
    protected final long[] refArray;
    protected int[] heap = IntArrays.EMPTY_ARRAY;
    protected int size;
    protected LongComparator c;

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int capacity, LongComparator c) {
        if (capacity > 0) {
            this.heap = new int[capacity];
        }
        this.refArray = refArray;
        this.c = c;
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, LongComparator c) {
        this(refArray, refArray.length, c);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray) {
        this(refArray, refArray.length, null);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int[] a, int size, LongComparator c) {
        this(refArray, 0, c);
        this.heap = a;
        this.size = size;
        LongSemiIndirectHeaps.makeHeap(refArray, a, size, c);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int[] a, LongComparator c) {
        this(refArray, a, a.length, c);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    protected void ensureElement(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.refArray.length) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is larger than or equal to reference array size (" + this.refArray.length + ")");
        }
    }

    @Override
    public void enqueue(int x) {
        this.ensureElement(x);
        if (this.size == this.heap.length) {
            this.heap = IntArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x;
        LongSemiIndirectHeaps.upHeap(this.refArray, this.heap, this.size, this.size - 1, this.c);
    }

    @Override
    public int dequeue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            LongSemiIndirectHeaps.downHeap(this.refArray, this.heap, this.size, 0, this.c);
        }
        return result;
    }

    @Override
    public int first() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.heap[0];
    }

    @Override
    public void changed() {
        LongSemiIndirectHeaps.downHeap(this.refArray, this.heap, this.size, 0, this.c);
    }

    @Override
    public void allChanged() {
        LongSemiIndirectHeaps.makeHeap(this.refArray, this.heap, this.size, this.c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = IntArrays.trim(this.heap, this.size);
    }

    @Override
    public LongComparator comparator() {
        return this.c;
    }

    @Override
    public int front(int[] a) {
        return this.c == null ? LongSemiIndirectHeaps.front(this.refArray, this.heap, this.size, a) : LongSemiIndirectHeaps.front(this.refArray, this.heap, this.size, a, this.c);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(this.refArray[this.heap[i]]);
        }
        s.append("]");
        return s.toString();
    }
}

