/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptlog;

import com.intellij.ml.llm.core.promptlog.CleanUp;
import com.intellij.ml.llm.core.promptlog.CountingOutputStream;
import com.intellij.ml.llm.core.promptlog.FileData;
import com.intellij.ml.llm.core.promptlog.LLMPromptLogHelper;
import com.intellij.ml.llm.core.promptlog.LogFileProvider;
import com.intellij.ml.llm.core.promptlog.OutputStreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/core/promptlog/FileDataOutputStreamProvider;", "Lcom/intellij/ml/llm/core/promptlog/OutputStreamProvider;", "dir", "Ljava/nio/file/Path;", "suffix", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "fileData", "Lcom/intellij/ml/llm/core/promptlog/FileData;", "getFileData", "()Lcom/intellij/ml/llm/core/promptlog/FileData;", "fileData$delegate", "Lkotlin/Lazy;", "getOutputStream", "Lcom/intellij/ml/llm/core/promptlog/CountingOutputStream;", "close", "", "getLogFileName", "getActiveFile", "Ljava/io/File;", "getDir", "Companion", "DirCleanUp", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMPromptLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMPromptLogger.kt\ncom/intellij/ml/llm/core/promptlog/FileDataOutputStreamProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n14#2:310\n*S KotlinDebug\n*F\n+ 1 LLMPromptLogger.kt\ncom/intellij/ml/llm/core/promptlog/FileDataOutputStreamProvider\n*L\n168#1:310\n*E\n"})
public final class FileDataOutputStreamProvider
implements OutputStreamProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path dir;
    @NotNull
    private final String suffix;
    @NotNull
    private final Lazy fileData$delegate;
    @NotNull
    private static final Logger logger;

    public FileDataOutputStreamProvider(@NotNull Path dir, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.dir = dir;
        this.suffix = suffix;
        this.fileData$delegate = LazyKt.lazy(() -> FileDataOutputStreamProvider.fileData_delegate$lambda$0(this));
    }

    private final FileData getFileData() {
        Lazy lazy = this.fileData$delegate;
        return (FileData)lazy.getValue();
    }

    @Override
    @NotNull
    public CountingOutputStream getOutputStream() {
        return this.getFileData().getOutputStream();
    }

    @Override
    public void close() {
        this.getFileData().close();
    }

    private final String getLogFileName() {
        File file = this.getFileData().getLogFile();
        return file != null ? file.getName() : null;
    }

    @Override
    @Nullable
    public File getActiveFile() {
        return this.getFileData().getLogFile();
    }

    @Override
    @NotNull
    public Path getDir() {
        return this.dir;
    }

    private static final FileData fileData_delegate$lambda$0(FileDataOutputStreamProvider this$0) {
        return new FileData(this$0.dir, (Function1<? super Path, ? extends File>)((Function1)new LogFileProvider(this$0.suffix)));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileDataOutputStreamProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FileDataOutputStreamProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/promptlog/FileDataOutputStreamProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\b\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/core/promptlog/FileDataOutputStreamProvider$DirCleanUp;", "Lcom/intellij/ml/llm/core/promptlog/CleanUp;", "maxFileAge", "", "<init>", "(Lcom/intellij/ml/llm/core/promptlog/FileDataOutputStreamProvider;J)V", "oldestExistingFile", "cleanUpOldFiles", "", "oldestAcceptable", "cleanUp", "intellij.ml.llm.core"})
    public final class DirCleanUp
    implements CleanUp {
        private final long maxFileAge;
        private long oldestExistingFile;

        public DirCleanUp(long maxFileAge) {
            this.maxFileAge = maxFileAge;
            this.oldestExistingFile = -1L;
        }

        @Override
        public void cleanUpOldFiles() {
            long oldestAcceptable = System.currentTimeMillis() - this.maxFileAge;
            if (this.oldestExistingFile != -1L && oldestAcceptable < this.oldestExistingFile) {
                return;
            }
            this.cleanUpOldFiles(oldestAcceptable);
        }

        private final void cleanUpOldFiles(long oldestAcceptable) {
            List<File> logs = LLMPromptLogHelper.Companion.getInstance().getFilesInDirectory(FileDataOutputStreamProvider.this.dir);
            if (logs.isEmpty()) {
                return;
            }
            String activeLog = FileDataOutputStreamProvider.this.getLogFileName();
            long oldestFile = -1L;
            for (File file : logs) {
                if (Intrinsics.areEqual((Object)file.getName(), (Object)activeLog)) continue;
                long lastModified = file.lastModified();
                if (lastModified < oldestAcceptable) {
                    if (file.delete()) continue;
                    logger.error("Failed deleting old prompt log file " + file);
                    continue;
                }
                if (lastModified >= oldestFile && oldestFile != -1L) continue;
                oldestFile = lastModified;
            }
            this.oldestExistingFile = oldestFile;
        }

        @Override
        public void cleanUp() {
            FileDataOutputStreamProvider.this.close();
            List<File> files = LLMPromptLogHelper.Companion.getInstance().getFilesInDirectory(FileDataOutputStreamProvider.this.dir);
            for (File file : files) {
                if (file.delete()) continue;
                logger.error("Failed deleting old prompt log file " + file);
            }
        }
    }
}

