/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptlog;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/core/promptlog/LLMPromptLogHelper;", "", "<init>", "()V", "getPromptLogPath", "Ljava/nio/file/Path;", "cleanPromptLogPath", "", "getFilesInDirectory", "", "Ljava/io/File;", "path", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMPromptLogHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMPromptLogHelper.kt\ncom/intellij/ml/llm/core/promptlog/LLMPromptLogHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,34:1\n14#2:35\n*S KotlinDebug\n*F\n+ 1 LLMPromptLogHelper.kt\ncom/intellij/ml/llm/core/promptlog/LLMPromptLogHelper\n*L\n13#1:35\n*E\n"})
public final class LLMPromptLogHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @NotNull
    public final Path getPromptLogPath() {
        Path path = PathManager.getLogDir().resolve("ai-assistant-log-data");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public final void cleanPromptLogPath() {
        Path path = this.getPromptLogPath();
        File[] fileArray = path.toFile().listFiles(LLMPromptLogHelper::cleanPromptLogPath$lambda$0);
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (File subDir : fileArray) {
            Path path2 = subDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            List<File> files = this.getFilesInDirectory(path2);
            for (File file : files) {
                if (file.delete()) continue;
                logger.error("Failed deleting old prompt log file " + file);
            }
        }
    }

    @NotNull
    public final List<File> getFilesInDirectory(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = path.toFile().listFiles();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final boolean cleanPromptLogPath$lambda$0(File file) {
        return file.isDirectory();
    }

    @JvmStatic
    @NotNull
    public static final LLMPromptLogHelper getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LLMPromptLogHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LLMPromptLogHelper.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/core/promptlog/LLMPromptLogHelper$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ml/llm/core/promptlog/LLMPromptLogHelper;", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nLLMPromptLogHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMPromptLogHelper.kt\ncom/intellij/ml/llm/core/promptlog/LLMPromptLogHelper$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,34:1\n40#2,3:35\n*S KotlinDebug\n*F\n+ 1 LLMPromptLogHelper.kt\ncom/intellij/ml/llm/core/promptlog/LLMPromptLogHelper$Companion\n*L\n16#1:35,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LLMPromptLogHelper getInstance() {
            boolean $i$f$service = false;
            Class<LLMPromptLogHelper> serviceClass$iv = LLMPromptLogHelper.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LLMPromptLogHelper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

