/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptlog;

import com.intellij.ml.llm.core.httpClient.AiaHttpClientCallBody;
import com.intellij.ml.llm.core.httpClient.AiaHttpClientCallEvent;
import com.intellij.ml.llm.core.promptlog.CleanUp;
import com.intellij.ml.llm.core.promptlog.CountingOutputStream;
import com.intellij.ml.llm.core.promptlog.FileDataOutputStreamProvider;
import com.intellij.ml.llm.core.promptlog.LLMPromptLogHelper;
import com.intellij.ml.llm.core.promptlog.LLMPromptLoggerKt;
import com.intellij.ml.llm.core.promptlog.OutputStreamProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\u0006\u0010\u0018\u001a\u00020\rJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/core/promptlog/LLMPromptLogger;", "Lcom/intellij/openapi/Disposable;", "outputStreamProvider", "Lcom/intellij/ml/llm/core/promptlog/OutputStreamProvider;", "cleanUp", "Lcom/intellij/ml/llm/core/promptlog/CleanUp;", "maxFileSizeInBytes", "", "<init>", "(Lcom/intellij/ml/llm/core/promptlog/OutputStreamProvider;Lcom/intellij/ml/llm/core/promptlog/CleanUp;I)V", "lock", "", "log", "", "httpCall", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallEvent;", "formatHttpCallHeaders", "", "headers", "", "formatHttpCallBody", "body", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallBody;", "dispose", "cleanup", "getActiveLogFile", "Ljava/io/File;", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMPromptLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMPromptLogger.kt\ncom/intellij/ml/llm/core/promptlog/LLMPromptLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n1#2:310\n126#3:311\n153#3,3:312\n14#4:315\n*S KotlinDebug\n*F\n+ 1 LLMPromptLogger.kt\ncom/intellij/ml/llm/core/promptlog/LLMPromptLogger\n*L\n82#1:311\n82#1:312,3\n21#1:315\n*E\n"})
public class LLMPromptLogger
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputStreamProvider outputStreamProvider;
    @NotNull
    private final CleanUp cleanUp;
    private final int maxFileSizeInBytes;
    @NotNull
    private final Object lock;
    @NotNull
    private static final Logger logger;
    private static final DateTimeFormatter formatter;
    private static final long MAX_FILE_AGE = 2592000000L;
    private static final int MAX_FILE_SIZE_BYTES = 204800;

    public LLMPromptLogger(@NotNull OutputStreamProvider outputStreamProvider, @NotNull CleanUp cleanUp, int maxFileSizeInBytes) {
        Intrinsics.checkNotNullParameter((Object)outputStreamProvider, (String)"outputStreamProvider");
        Intrinsics.checkNotNullParameter((Object)cleanUp, (String)"cleanUp");
        this.outputStreamProvider = outputStreamProvider;
        this.cleanUp = cleanUp;
        this.maxFileSizeInBytes = maxFileSizeInBytes;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(@NotNull AiaHttpClientCallEvent httpCall) {
        Intrinsics.checkNotNullParameter((Object)httpCall, (String)"httpCall");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                Pair pair;
                Throwable it;
                Object object2;
                Object $this$log_u24lambda_u246_u24lambda_u240;
                CountingOutputStream stream = this.outputStreamProvider.getOutputStream();
                if (stream.isJustCreated()) {
                    this.cleanUp.cleanUpOldFiles();
                }
                String now = formatter.format(LocalDateTime.now());
                Object object3 = this;
                try {
                    $this$log_u24lambda_u246_u24lambda_u240 = object3;
                    boolean bl2 = false;
                    $this$log_u24lambda_u246_u24lambda_u240 = Result.constructor-impl((Object)new URL(httpCall.getRequestUrl()).getPath());
                }
                catch (Throwable bl2) {
                    $this$log_u24lambda_u246_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object3 = $this$log_u24lambda_u246_u24lambda_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                if (throwable == null) {
                    object2 = object3;
                } else {
                    it = throwable;
                    boolean bl3 = false;
                    object2 = httpCall.getRequestUrl();
                }
                String urlPath = (String)object2;
                it = httpCall;
                if (it instanceof AiaHttpClientCallEvent.HttpRequestEvent) {
                    pair = TuplesKt.to((Object)"Request", (Object)(((AiaHttpClientCallEvent.HttpRequestEvent)httpCall).getRequestMethod() + " " + urlPath));
                } else if (it instanceof AiaHttpClientCallEvent.HttpResponseEvent) {
                    pair = TuplesKt.to((Object)"Response", (Object)((AiaHttpClientCallEvent.HttpResponseEvent)httpCall).getStatus());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                object3 = pair;
                String requestOrResponse = (String)object3.component1();
                String caption = (String)object3.component2();
                OutputStream outputStream = stream;
                Charset charset = Charsets.UTF_8;
                OutputStreamWriter $this$log_u24lambda_u246_u24lambda_u245 = new OutputStreamWriter(outputStream, charset);
                boolean bl4 = false;
                ((Appendable)$this$log_u24lambda_u246_u24lambda_u245).append('\n');
                ((Appendable)$this$log_u24lambda_u246_u24lambda_u245).append("---").append('\n');
                ((Appendable)$this$log_u24lambda_u246_u24lambda_u245).append("#### `[" + now + "]` " + caption + " ####").append('\n');
                ((Appendable)$this$log_u24lambda_u246_u24lambda_u245).append(LLMPromptLoggerKt.access$markdownLineBreak("> Request URL: " + httpCall.getRequestUrl())).append('\n');
                ((Appendable)$this$log_u24lambda_u246_u24lambda_u245).append(LLMPromptLoggerKt.access$markdownLineBreak("> Request Method: " + httpCall.getRequestMethod())).append('\n');
                if (httpCall instanceof AiaHttpClientCallEvent.HttpResponseEvent) {
                    ((Appendable)$this$log_u24lambda_u246_u24lambda_u245).append(LLMPromptLoggerKt.access$markdownLineBreak("> Status Code: " + ((AiaHttpClientCallEvent.HttpResponseEvent)httpCall).getStatus())).append('\n');
                }
                LLMPromptLoggerKt.markdownDetails$default($this$log_u24lambda_u246_u24lambda_u245, requestOrResponse + " Headers", false, arg_0 -> LLMPromptLogger.log$lambda$6$lambda$5$lambda$2(this, httpCall, arg_0), 2, null).append('\n');
                AiaHttpClientCallBody aiaHttpClientCallBody = httpCall.getBody();
                if (aiaHttpClientCallBody != null) {
                    AiaHttpClientCallBody body = aiaHttpClientCallBody;
                    boolean bl5 = false;
                    LLMPromptLoggerKt.access$markdownDetails($this$log_u24lambda_u246_u24lambda_u245, requestOrResponse + " Body", true, arg_0 -> LLMPromptLogger.log$lambda$6$lambda$5$lambda$4$lambda$3(this, body, arg_0)).append('\n');
                }
                ((Appendable)$this$log_u24lambda_u246_u24lambda_u245).append('\n');
                $this$log_u24lambda_u246_u24lambda_u245.flush();
                if (stream.getBytesWritten() > (long)this.maxFileSizeInBytes) {
                    this.outputStreamProvider.close();
                }
            }
            catch (IOException e) {
                logger.error("Failed to write to prompt log", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String formatHttpCallHeaders(Map<String, String> headers) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = headers;
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            collection.add(key + ": " + value);
        }
        return LLMPromptLoggerKt.access$markdownCodeBlock(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), "properties");
    }

    private final String formatHttpCallBody(AiaHttpClientCallBody body) {
        String string;
        String[] stringArray = new String[]{";"};
        String string2 = ((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)body.getContentType(), (String[])stringArray, (boolean)false, (int)2, (int)2, null))).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        if (Intrinsics.areEqual((Object)string3, (Object)"application/json")) {
            String string4 = body.getContent();
            String string5 = string4 != null ? LLMPromptLoggerKt.access$toPrettyJsonString(string4) : null;
            if (string5 == null) {
                string5 = "";
            }
            string = LLMPromptLoggerKt.access$markdownCodeBlock(string5, "json");
        } else if (Intrinsics.areEqual((Object)string3, (Object)"text/event-stream")) {
            String string6 = body.getContent();
            if (string6 == null) {
                string6 = "";
            }
            string = LLMPromptLoggerKt.access$markdownCodeBlock(string6, "yaml");
        } else {
            String string7 = body.getContent();
            if (string7 == null) {
                string7 = "";
            }
            string = LLMPromptLoggerKt.markdownCodeBlock$default(string7, null, 1, null);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                this.outputStreamProvider.close();
            }
            catch (IOException e) {
                logger.error("Failed to close prompt log", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanup() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                this.cleanUp.cleanUp();
            }
            catch (IOException e) {
                logger.error("Failed to close prompt log", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final File getActiveLogFile() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            File file = this.outputStreamProvider.getActiveFile();
            return file;
        }
    }

    private static final Unit log$lambda$6$lambda$5$lambda$2(LLMPromptLogger this$0, AiaHttpClientCallEvent $httpCall, OutputStreamWriter $this$markdownDetails) {
        Intrinsics.checkNotNullParameter((Object)$this$markdownDetails, (String)"$this$markdownDetails");
        ((Appendable)$this$markdownDetails).append(this$0.formatHttpCallHeaders($httpCall.getHeaders())).append('\n').append('\n');
        return Unit.INSTANCE;
    }

    private static final Unit log$lambda$6$lambda$5$lambda$4$lambda$3(LLMPromptLogger this$0, AiaHttpClientCallBody $body, OutputStreamWriter $this$markdownDetails) {
        Intrinsics.checkNotNullParameter((Object)$this$markdownDetails, (String)"$this$markdownDetails");
        ((Appendable)$this$markdownDetails).append(this$0.formatHttpCallBody($body)).append('\n').append('\n');
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LLMPromptLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LLMPromptLogger.logger = logger;
        formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/core/promptlog/LLMPromptLogger$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "MAX_FILE_AGE", "", "MAX_FILE_SIZE_BYTES", "", "create", "Lcom/intellij/ml/llm/core/promptlog/LLMPromptLogger;", "suffix", "", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLMPromptLogger create(@NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Path dir = LLMPromptLogHelper.Companion.getInstance().getPromptLogPath();
            FileDataOutputStreamProvider provider = new FileDataOutputStreamProvider(dir, suffix);
            return new LLMPromptLogger(provider, provider.new FileDataOutputStreamProvider.DirCleanUp(2592000000L), 204800);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

