/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.llmInstaller.api.AiPluginCoreConstants;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.chat.limits.UserMessageTrimmingThreshold;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.license.AiSubscriptionPlan;
import com.intellij.ml.llm.core.settings.LLMConfigurableUtils;
import com.intellij.ml.llm.core.settings.LLMFeatureSettings;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantAuthorizationEventLogger;
import com.intellij.ml.llm.grazie.auth.GrazieAuthFacade;
import com.intellij.ml.llm.grazie.auth.GrazieAuthState;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ui.CellKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0014*\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "authState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/ml/llm/grazie/auth/GrazieAuthState;", "getAuthState", "()Lkotlinx/coroutines/flow/StateFlow;", "settings", "Lcom/intellij/ml/llm/core/settings/LLMSettingsManager;", "getSettings", "()Lcom/intellij/ml/llm/core/settings/LLMSettingsManager;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "paidPanel", "", "Lcom/intellij/ui/dsl/builder/Panel;", "trialPanel", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMConfigurable.kt\ncom/intellij/ml/llm/core/settings/LLMConfigurable\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,159:1\n40#2,3:160\n24#3:163\n*S KotlinDebug\n*F\n+ 1 LLMConfigurable.kt\ncom/intellij/ml/llm/core/settings/LLMConfigurable\n*L\n44#1:160,3\n40#1:163\n*E\n"})
public final class LLMConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    public static final int HUMAN_LANGUAGE_MAX_LENGTH = 30;
    @NotNull
    private static final Logger LOG;

    public LLMConfigurable(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(LLMBundle.message("settings.configurable.display.name", new Object[0]), "ai.assistant.reference.settings", null, 4, null);
        this.project = project;
        this.scope = scope;
    }

    private final StateFlow<GrazieAuthState> getAuthState() {
        return GrazieAuthFacade.Companion.getInstance().getAuthState();
    }

    private final LLMSettingsManager getSettings() {
        boolean $i$f$service = false;
        Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (LLMSettingsManager)object;
    }

    @NotNull
    public DialogPanel createPanel() {
        ComponentPredicate authedPredicate = ComponentPredicateKt.predicate(this.getAuthState(), (CoroutineScope)this.scope, LLMConfigurable::createPanel$lambda$0);
        return com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> LLMConfigurable.createPanel$lambda$20(this, authedPredicate, arg_0));
    }

    private final void paidPanel(Panel $this$paidPanel) {
        Panel.row$default((Panel)$this$paidPanel, null, arg_0 -> LLMConfigurable.paidPanel$lambda$22(this, arg_0), (int)1, null).visibleIf(ComponentPredicateKt.predicate(this.getAuthState(), (CoroutineScope)this.scope, LLMConfigurable::paidPanel$lambda$23));
    }

    private final void trialPanel(Panel $this$trialPanel) {
        $this$trialPanel.rowsRange(arg_0 -> LLMConfigurable.trialPanel$lambda$27(this, arg_0)).visibleIf(ComponentPredicateKt.predicate(this.getAuthState(), (CoroutineScope)this.scope, LLMConfigurable::trialPanel$lambda$28));
    }

    private static final boolean createPanel$lambda$0(GrazieAuthState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof GrazieAuthState.Authenticated;
    }

    private static final Project createPanel$lambda$20$lambda$3$lambda$2$lambda$1(LLMConfigurable this$0, JButton jButton) {
        Intrinsics.checkNotNullParameter((Object)jButton, (String)"<unused var>");
        return this$0.project;
    }

    private static final Unit createPanel$lambda$20$lambda$3(LLMConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        LLMConfigurableUtils $this$createPanel_u24lambda_u2420_u24lambda_u243_u24lambda_u242 = LLMConfigurableUtils.INSTANCE;
        boolean bl = false;
        $this$createPanel_u24lambda_u2420_u24lambda_u243_u24lambda_u242.llmActivationButton($this$row, (Function1<? super JButton, ? extends Project>)((Function1)arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$3$lambda$2$lambda$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$4(LLMConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        for (LLMFeatureSettings featureSettings : LLMFeatureSettings.Companion.getEP_NAME().getExtensionList()) {
            try {
                CoroutineScope coroutineScope = this$0.scope;
                String string = featureSettings.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                CoroutineScope featureScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)string, null, (boolean)false, (int)6, null);
                $this$group.panel(featureSettings.buildSettingsUi(this$0.project, this$0.getSettings(), featureScope)).visible(featureSettings.getShouldDisplaySettings());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$12$lambda$5(Ref.ObjectRef $languageSelection, LLMConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        Cell cell = ButtonKt.bindSelected((Cell)$this$row.checkBox(LLMBundle.message("settings.chat.natural.language.checkbox.enable.language.label", objectArray)), (Function0)((Function0)new Function0<Boolean>((Object)this$0.getSettings()){

            public final Boolean invoke() {
                return ((LLMSettingsManager)this.receiver).isChatNaturalLanguageSelectionEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.getSettings()){

            public final void invoke(boolean p0) {
                ((LLMSettingsManager)this.receiver).setChatNaturalLanguageSelectionEnabled(p0);
            }
        })).gap(RightGap.SMALL);
        objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        $languageSelection.element = Cell.comment$default((Cell)cell, (String)LLMBundle.message("settings.chat.natural.language.checkbox.enable.language.description", objectArray), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final PSString createPanel$lambda$20$lambda$12$lambda$11$lambda$10$lambda$6(LLMConfigurable this$0) {
        return this$0.getSettings().getChatNaturalLanguage();
    }

    private static final Unit createPanel$lambda$20$lambda$12$lambda$11$lambda$10$lambda$7(LLMConfigurable this$0, PSString value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.getSettings().setChatNaturalLanguage(value);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$12$lambda$11$lambda$10$lambda$8(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        UiUtils.setEmptyState((Component)((Component)$this$applyToComponent), (String)LLMBundle.message("settings.chat.natural.language.checkbox.enable.language.placeholder", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createPanel$lambda$20$lambda$12$lambda$11$lambda$10$lambda$9(ValidationInfoBuilder $this$validationOnInput, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return $this$validationOnInput.error(LLMBundle.message("settings.chat.natural.language.checkbox.enable.language.field.not.blank", new Object[0]));
        }
        if (it.getText().length() > 30) {
            return $this$validationOnInput.error(LLMBundle.message("settings.chat.natural.language.checkbox.enable.language.field.too.long", new Object[0]));
        }
        return null;
    }

    private static final Unit createPanel$lambda$20$lambda$12$lambda$11$lambda$10(Ref.ObjectRef $languageSelection, LLMConfigurable this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell2 = Cell.comment$default((Cell)TextFieldKt.columns((Cell)CellKt.bindText((Cell)$this$row.textField(), () -> LLMConfigurable.createPanel$lambda$20$lambda$12$lambda$11$lambda$10$lambda$6(this$0), arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$12$lambda$11$lambda$10$lambda$7(this$0, arg_0)).applyToComponent(LLMConfigurable::createPanel$lambda$20$lambda$12$lambda$11$lambda$10$lambda$8), (int)25).gap(RightGap.SMALL), (String)LLMBundle.message("settings.chat.natural.language.checkbox.enable.language.comment", new Object[0]), (int)0, null, (int)6, null);
        if ($languageSelection.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"languageSelection");
            cell = null;
        } else {
            cell = (Cell)$languageSelection.element;
        }
        cell2.enabledIf(ButtonKt.getSelected((Cell)cell)).validationOnInput(LLMConfigurable::createPanel$lambda$20$lambda$12$lambda$11$lambda$10$lambda$9);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$12$lambda$11(Ref.ObjectRef $languageSelection, LLMConfigurable this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$12$lambda$11$lambda$10($languageSelection, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$12(LLMConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Ref.ObjectRef languageSelection = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$group, null, arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$12$lambda$5(languageSelection, this$0, arg_0), (int)1, null);
        $this$group.indent(arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$12$lambda$11(languageSelection, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$18$lambda$13(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)LLMBundle.message("settings.chat.message.trimming.section.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$20$lambda$18$lambda$17$lambda$16$lambda$14(UserMessageTrimmingThreshold it) {
        UserMessageTrimmingThreshold userMessageTrimmingThreshold = it;
        return (userMessageTrimmingThreshold != null ? Integer.valueOf(userMessageTrimmingThreshold.getPercentage()) : null) + "%";
    }

    private static final Unit createPanel$lambda$20$lambda$18$lambda$17$lambda$16$lambda$15(LLMConfigurable this$0, CollectionComboBoxModel $model, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LLMSettingsManager lLMSettingsManager = this$0.getSettings();
        Object object = $model.getSelected();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.limits.UserMessageTrimmingThreshold");
        lLMSettingsManager.setUserMessageTrimmingThreshold((UserMessageTrimmingThreshold)((Object)object));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$18$lambda$17$lambda$16(LLMConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        CollectionComboBoxModel model = new CollectionComboBoxModel((List)UserMessageTrimmingThreshold.getEntries(), (Object)this$0.getSettings().getUserMessageTrimmingThreshold());
        $this$row.comboBox((ComboBoxModel)model, BuilderKt.textListCellRenderer(LLMConfigurable::createPanel$lambda$20$lambda$18$lambda$17$lambda$16$lambda$14)).onChanged(arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$18$lambda$17$lambda$16$lambda$15(this$0, model, arg_0));
        Row.text$default((Row)$this$row, (String)LLMBundle.message("settings.chat.message.trimming.threshold.label.suffix", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$18$lambda$17(LLMConfigurable this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.row(LLMBundle.message("settings.chat.message.trimming.threshold.label.prefix", new Object[0]), arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$18$lambda$17$lambda$16(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$18(LLMConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, LLMConfigurable::createPanel$lambda$20$lambda$18$lambda$13, (int)1, null);
        $this$group.indent(arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$18$lambda$17(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20$lambda$19(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AIAssistantUIUtilKt.howCompletelyDisableLink($this$row);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$20(LLMConfigurable this$0, ComponentPredicate $authedPredicate, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.paidPanel($this$panel);
        this$0.trialPanel($this$panel);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$3(this$0, arg_0), (int)1, null).visibleIf(ComponentPredicateKt.not((ComponentPredicate)$authedPredicate));
        Panel.group$default((Panel)$this$panel, (String)LLMBundle.message("settings.group.features", new Object[0]), (boolean)false, arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$4(this$0, arg_0), (int)2, null).visibleIf($authedPredicate);
        Panel.group$default((Panel)$this$panel, (String)LLMBundle.message("settings.group.natural.language.selection", new Object[0]), (boolean)false, arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$12(this$0, arg_0), (int)2, null).visibleIf($authedPredicate);
        if (Registry.Companion.is("llm.chat.use.model.context.size")) {
            $this$panel.group(LLMBundle.message("settings.group.message.trimming.section", new Object[0]), false, arg_0 -> LLMConfigurable.createPanel$lambda$20$lambda$18(this$0, arg_0)).visibleIf($authedPredicate);
        }
        Panel.row$default((Panel)$this$panel, null, LLMConfigurable::createPanel$lambda$20$lambda$19, (int)1, null).visibleIf($authedPredicate);
        return Unit.INSTANCE;
    }

    private static final void paidPanel$lambda$22$lambda$21(LLMConfigurable this$0, HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.browse((String)"https://jb.gg/aimanage");
        AIAssistantAuthorizationEventLogger.INSTANCE.logManageSubscriptionsClicked(this$0.project);
    }

    private static final Unit paidPanel$lambda$22(LLMConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)DocumentationMarkup.EXTERNAL_LINK_ICON.toString(), (String)"toString(...)");
        Row.text$default((Row)$this$row, (String)LLMBundle.message("settings.manage.subscription", objectArray), (int)0, arg_0 -> LLMConfigurable.paidPanel$lambda$22$lambda$21(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final boolean paidPanel$lambda$23(GrazieAuthState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof GrazieAuthState.Authenticated && ((GrazieAuthState.Authenticated)it).getPlan() == AiSubscriptionPlan.PRO;
    }

    private static final Unit trialPanel$lambda$27$lambda$26$lambda$24(LLMConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.open((String)AiPluginCoreConstants.INSTANCE.getLandingPlansAugmented());
        AIAssistantAuthorizationEventLogger.INSTANCE.logUnlimitedAiClickedInSettings(this$0.project);
        return Unit.INSTANCE;
    }

    private static final Unit trialPanel$lambda$27$lambda$26$lambda$25(LLMConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JButton");
        LLMConfigurableUtils.INSTANCE.closeSettings((JButton)object);
        AIAssistantUIUtil.INSTANCE.showLicensePickerView(this$0.project);
        AIAssistantAuthorizationEventLogger.INSTANCE.logActivateSubscriptionClickedInSettings(this$0.project);
        return Unit.INSTANCE;
    }

    private static final Unit trialPanel$lambda$27$lambda$26(LLMConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(LLMBundle.message("settings.getUnlimitedPrompts", new Object[0]), arg_0 -> LLMConfigurable.trialPanel$lambda$27$lambda$26$lambda$24(this$0, arg_0));
        $this$row.button(LLMBundle.message("settings.activate", new Object[0]), arg_0 -> LLMConfigurable.trialPanel$lambda$27$lambda$26$lambda$25(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit trialPanel$lambda$27(LLMConfigurable this$0, Panel $this$rowsRange) {
        Intrinsics.checkNotNullParameter((Object)$this$rowsRange, (String)"$this$rowsRange");
        AIAssistantUIUtil.INSTANCE.trialRemainedPanel($this$rowsRange);
        Panel.row$default((Panel)$this$rowsRange, null, arg_0 -> LLMConfigurable.trialPanel$lambda$27$lambda$26(this$0, arg_0), (int)1, null).topGap(TopGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final boolean trialPanel$lambda$28(GrazieAuthState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof GrazieAuthState.Authenticated && ((GrazieAuthState.Authenticated)it).getPlan() == AiSubscriptionPlan.LITE;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMConfigurable$Companion;", "", "<init>", "()V", "HUMAN_LANGUAGE_MAX_LENGTH", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

