/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub;

import com.intellij.ide.BrowserUtil;
import com.intellij.llmInstaller.ui.hub.states.AIHubUIKt;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.chat.ui.LicenseType;
import com.intellij.ml.llm.core.chat.ui.QuotaAvailableInfo;
import com.intellij.ml.llm.core.chat.ui.QuotaTimeData;
import com.intellij.ml.llm.core.quota.QuotaInfo;
import com.intellij.ml.llm.core.quota.QuotaManager2;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Placeholder;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UiScopeKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0003H\u0002J\u0012\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/hub/AIHubPaygQuotes;", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "popup", "Lcom/intellij/ui/popup/WizardPopup;", "actionGroupContent", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/ui/dsl/builder/Panel;Lcom/intellij/ui/popup/WizardPopup;Ljavax/swing/JComponent;)V", "creditsLabel", "Ljavax/swing/JEditorPane;", "creditTooltipPlaceholder", "Lcom/intellij/ui/dsl/builder/Placeholder;", "progressBar", "Ljavax/swing/JProgressBar;", "renewLabel", "Ljavax/swing/JLabel;", "personalRows", "Lcom/intellij/ui/dsl/builder/RowsRange;", "personalTopUpCreditsLabel", "commercialRows", "commercialCreditsLabel", "commercialProgressBar", "customSeparator", "", "updateQuotes", "quota", "Lcom/intellij/ml/llm/core/quota/QuotaInfo$SuccessfulQuotaInfo;", "percentage", "", "available", "Ljava/math/BigDecimal;", "maximum", "intellij.ml.llm.core"})
public final class AIHubPaygQuotes {
    private JEditorPane creditsLabel;
    private Placeholder creditTooltipPlaceholder;
    private JProgressBar progressBar;
    private JLabel renewLabel;
    @NotNull
    private final RowsRange personalRows;
    private JEditorPane personalTopUpCreditsLabel;
    @NotNull
    private final RowsRange commercialRows;
    private JEditorPane commercialCreditsLabel;
    private JProgressBar commercialProgressBar;

    public AIHubPaygQuotes(@NotNull Panel panel, @NotNull WizardPopup popup, @NotNull JComponent actionGroupContent) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)actionGroupContent, (String)"actionGroupContent");
        Panel $this$_init__u24lambda_u2412 = panel;
        boolean bl = false;
        Panel.row$default((Panel)$this$_init__u24lambda_u2412, null, arg_0 -> AIHubPaygQuotes.lambda$12$lambda$0(this, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$_init__u24lambda_u2412, null, arg_0 -> AIHubPaygQuotes.lambda$12$lambda$2(this, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$_init__u24lambda_u2412, null, arg_0 -> AIHubPaygQuotes.lambda$12$lambda$3(this, arg_0), (int)1, null);
        this.personalRows = $this$_init__u24lambda_u2412.rowsRange(arg_0 -> AIHubPaygQuotes.lambda$12$lambda$6(this, arg_0));
        this.commercialRows = $this$_init__u24lambda_u2412.rowsRange(arg_0 -> AIHubPaygQuotes.lambda$12$lambda$11(this, arg_0));
        UiScopeKt.launchOnShow$default((Component)actionGroupContent, (String)"AIHubInstalled.disabledNotification", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, popup, null){
            int label;
            final /* synthetic */ AIHubPaygQuotes this$0;
            final /* synthetic */ WizardPopup $popup;
            {
                this.this$0 = $receiver;
                this.$popup = $popup;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().collect(new FlowCollector(){

                            public final Object emit(QuotaInfo.SuccessfulQuotaInfo it, Continuation<? super Unit> $completion) {
                                this$0.updateQuotes(it);
                                AIAssistantUIUtilKt.repack((AbstractPopup)$popup);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.updateQuotes((QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue());
    }

    private final void customSeparator(Panel $this$customSeparator) {
        Panel.row$default((Panel)$this$customSeparator, null, AIHubPaygQuotes::customSeparator$lambda$14, (int)1, null);
    }

    private final void updateQuotes(QuotaInfo.SuccessfulQuotaInfo quota) {
        Placeholder placeholder;
        Object object;
        QuotaInfo.QuotaDetails tariffQuota;
        Boolean personal = AIAssistantUIUtilKt.isLicensePersonal();
        LicenseType licenseType = AIAssistantUIUtilKt.getLicenseType();
        String greyColor = GuiUtils.colorToHex((Color)JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        QuotaInfo.QuotaDetails quotaDetails = tariffQuota = quota != null ? quota.getTariffQuota() : null;
        if (tariffQuota == null) {
            String nullValue = AIAssistantUIUtil.INSTANCE.quotaToCreditString(null);
            JEditorPane jEditorPane = this.creditsLabel;
            if (jEditorPane == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"creditsLabel");
                jEditorPane = null;
            }
            var7_7 = new Object[3];
            var7_7[0] = nullValue;
            var7_7[1] = nullValue;
            Intrinsics.checkNotNull((Object)greyColor);
            var7_7[2] = greyColor;
            jEditorPane.setText(LLMBundle.message("ai.hub.quota.monthly.credits.left", var7_7));
            JProgressBar jProgressBar = this.progressBar;
            if (jProgressBar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
                jProgressBar = null;
            }
            jProgressBar.setValue(0);
        } else {
            BigDecimal bigDecimal;
            var7_7 = quota;
            if (var7_7 instanceof QuotaInfo.Reached) {
                bigDecimal = BigDecimal.ZERO;
            } else if (var7_7 instanceof QuotaInfo.Available) {
                bigDecimal = tariffQuota.getAvailable();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            BigDecimal tariffQuotaAvailable = bigDecimal;
            BigDecimal tariffQuotaMaximum = tariffQuota.getMaximum();
            JEditorPane jEditorPane = this.creditsLabel;
            if (jEditorPane == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"creditsLabel");
                jEditorPane = null;
            }
            object = new Object[3];
            object[0] = AIAssistantUIUtil.INSTANCE.quotaToCreditString(tariffQuotaAvailable);
            object[1] = AIAssistantUIUtil.INSTANCE.quotaToCreditString(tariffQuotaMaximum);
            Intrinsics.checkNotNull((Object)greyColor);
            object[2] = greyColor;
            jEditorPane.setText(LLMBundle.message("ai.hub.quota.monthly.credits.left", object));
            JProgressBar jProgressBar = this.progressBar;
            if (jProgressBar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
                jProgressBar = null;
            }
            Intrinsics.checkNotNull((Object)tariffQuotaAvailable);
            jProgressBar.setValue(this.percentage(tariffQuotaAvailable, tariffQuotaMaximum));
        }
        if ((placeholder = this.creditTooltipPlaceholder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"creditTooltipPlaceholder");
            placeholder = null;
        }
        if (placeholder.getComponent() == null && personal != null) {
            String description = personal != false ? LLMBundle.message("ai.hub.quota.help.personal.monthly", new Object[0]) : LLMBundle.message("ai.hub.quota.help.commercial.monthly", new Object[0]);
            Placeholder placeholder2 = this.creditTooltipPlaceholder;
            if (placeholder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"creditTooltipPlaceholder");
                placeholder2 = null;
            }
            placeholder2.setComponent((JComponent)ContextHelpLabel.createWithLink(null, (String)description, (String)LLMBundle.message("ai.hub.quota.help.my.subscriptions", new Object[0]), (boolean)true, AIHubPaygQuotes::updateQuotes$lambda$15));
        }
        QuotaTimeData quotaTimeData = AIAssistantUIUtil.INSTANCE.getQuotaTimeData();
        JLabel jLabel = this.renewLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renewLabel");
            jLabel = null;
        }
        jLabel.setText(AIAssistantUIUtil.INSTANCE.formatQuotaInfoLabel(quotaTimeData));
        Object object2 = quota;
        BigDecimal topUpQuotaAvailable = quota != null && (object2 = AIAssistantUIUtilKt.getQuotaAvailableInfo((QuotaInfo)object2)) != null ? ((QuotaAvailableInfo)object2).getTopUpQuotaAvailable() : null;
        object = personal;
        if (Intrinsics.areEqual((Object)object, (Object)true)) {
            this.personalRows.visible(licenseType != LicenseType.FREE);
            this.commercialRows.visible(false);
            JEditorPane jEditorPane = this.personalTopUpCreditsLabel;
            if (jEditorPane == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"personalTopUpCreditsLabel");
                jEditorPane = null;
            }
            Object[] objectArray = new Object[]{AIAssistantUIUtil.INSTANCE.quotaToCreditString(topUpQuotaAvailable), greyColor};
            jEditorPane.setText(LLMBundle.message("ai.hub.quota.top.up.credits.left", objectArray));
        } else if (Intrinsics.areEqual((Object)object, (Object)false)) {
            Object object3 = quota;
            BigDecimal topUpQuotaMaximum = quota != null && (object3 = object3.getTopUpQuota()) != null ? ((QuotaInfo.QuotaDetails)object3).getMaximum() : null;
            boolean showSharedQuota = topUpQuotaAvailable != null && topUpQuotaMaximum != null;
            this.personalRows.visible(false);
            this.commercialRows.visible(showSharedQuota);
            if (showSharedQuota) {
                JProgressBar jProgressBar = this.commercialProgressBar;
                if (jProgressBar == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"commercialProgressBar");
                    jProgressBar = null;
                }
                jProgressBar.setValue(this.percentage(topUpQuotaAvailable, topUpQuotaMaximum));
                JEditorPane jEditorPane = this.commercialCreditsLabel;
                if (jEditorPane == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"commercialCreditsLabel");
                    jEditorPane = null;
                }
                Object[] objectArray = new Object[]{AIAssistantUIUtil.INSTANCE.quotaToCreditString(topUpQuotaAvailable), AIAssistantUIUtil.INSTANCE.quotaToCreditString(topUpQuotaMaximum), greyColor};
                jEditorPane.setText(LLMBundle.message("ai.hub.quota.shared.credits.left", objectArray));
            }
        } else if (object == null) {
            this.personalRows.visible(false);
            this.commercialRows.visible(false);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final int percentage(BigDecimal available, BigDecimal maximum) {
        if (Intrinsics.areEqual((Object)maximum, (Object)BigDecimal.ZERO)) {
            return 0;
        }
        BigDecimal bigDecimal = available.multiply(new BigDecimal(100));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
        BigDecimal bigDecimal2 = bigDecimal.divide(maximum, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"divide(...)");
        BigDecimal result2 = bigDecimal2;
        return RangesKt.coerceIn((int)result2.intValue(), (int)0, (int)100);
    }

    private static final Unit lambda$12$lambda$0(AIHubPaygQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.creditsLabel = (JEditorPane)Row.text$default((Row)$this$row, (String)"", (int)Integer.MAX_VALUE, null, (int)4, null).resizableColumn().getComponent();
        this$0.creditTooltipPlaceholder = $this$row.placeholder();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$2$lambda$1(JProgressBar $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setValue(0);
        $this$applyToComponent.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.NONE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$2(AIHubPaygQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.progressBar = (JProgressBar)AIHubUIKt.hubProgressBar((Row)$this$row, (int)0, (int)100).align((Align)AlignX.FILL.INSTANCE).applyToComponent(AIHubPaygQuotes::lambda$12$lambda$2$lambda$1).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$3(AIHubPaygQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.renewLabel = (JLabel)AIAssistantUIUtilKt.greyForeground($this$row.label("")).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$6$lambda$5$lambda$4(ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.browse((String)"https://jetbrains.com/shop/buy?item=P:N:AIGC");
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$6$lambda$5(AIHubPaygQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.personalTopUpCreditsLabel = (JEditorPane)Row.text$default((Row)$this$row, (String)"", (int)Integer.MAX_VALUE, null, (int)4, null).gap(RightGap.SMALL).getComponent();
        $this$row.link(LLMBundle.message("ai.hub.quota.add.credits", new Object[0]), AIHubPaygQuotes::lambda$12$lambda$6$lambda$5$lambda$4);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$6(AIHubPaygQuotes this$0, Panel $this$rowsRange) {
        Intrinsics.checkNotNullParameter((Object)$this$rowsRange, (String)"$this$rowsRange");
        Panel.row$default((Panel)$this$rowsRange, null, arg_0 -> AIHubPaygQuotes.lambda$12$lambda$6$lambda$5(this$0, arg_0), (int)1, null);
        this$0.customSeparator($this$rowsRange);
        return Unit.INSTANCE;
    }

    private static final void lambda$12$lambda$11$lambda$8$lambda$7() {
        BrowserUtil.browse((String)"https://jb.gg/available-subscription-options-with-organizational-jetbrains-account");
    }

    private static final Unit lambda$12$lambda$11$lambda$8(AIHubPaygQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.commercialCreditsLabel = (JEditorPane)Row.text$default((Row)$this$row, (String)"", (int)Integer.MAX_VALUE, null, (int)4, null).resizableColumn().getComponent();
        ContextHelpLabel contextHelpLabel = ContextHelpLabel.createWithLink(null, (String)LLMBundle.message("ai.hub.quota.help.commercial.shared", new Object[0]), (String)LLMBundle.message("ai.hub.quota.help.my.subscriptions", new Object[0]), (boolean)true, AIHubPaygQuotes::lambda$12$lambda$11$lambda$8$lambda$7);
        Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel, (String)"createWithLink(...)");
        $this$row.cell((JComponent)contextHelpLabel);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$11$lambda$10$lambda$9(JProgressBar $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setValue(0);
        $this$applyToComponent.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, new VerticalComponentGap(Boolean.valueOf(false), null, 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$11$lambda$10(AIHubPaygQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.commercialProgressBar = (JProgressBar)AIHubUIKt.hubProgressBar((Row)$this$row, (int)0, (int)100).align((Align)AlignX.FILL.INSTANCE).applyToComponent(AIHubPaygQuotes::lambda$12$lambda$11$lambda$10$lambda$9).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$11(AIHubPaygQuotes this$0, Panel $this$rowsRange) {
        Intrinsics.checkNotNullParameter((Object)$this$rowsRange, (String)"$this$rowsRange");
        Panel.row$default((Panel)$this$rowsRange, null, arg_0 -> AIHubPaygQuotes.lambda$12$lambda$11$lambda$8(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$rowsRange, null, arg_0 -> AIHubPaygQuotes.lambda$12$lambda$11$lambda$10(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit customSeparator$lambda$14$lambda$13(SeparatorComponent $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty((Object)DslComponentProperty.VERTICAL_COMPONENT_GAP, (Object)new VerticalComponentGap(null, Boolean.valueOf(false), 1, null));
        return Unit.INSTANCE;
    }

    private static final Unit customSeparator$lambda$14(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)new SeparatorComponent(0, 0, JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), null)).align((Align)AlignX.FILL.INSTANCE).applyToComponent(AIHubPaygQuotes::customSeparator$lambda$14$lambda$13);
        return Unit.INSTANCE;
    }

    private static final void updateQuotes$lambda$15() {
        String url = Intrinsics.areEqual((Object)AIAssistantUIUtilKt.isLicensePersonal(), (Object)false) ? "https://jb.gg/available-subscription-options-with-organizational-jetbrains-account" : "https://jb.gg/aimanage";
        BrowserUtil.browse((String)url);
    }
}

