/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.promptTree;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.promptTree.Trim;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011JR\u0010\u0012\u001a\u00020\r\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\b\b\u0002\u0010\u0010\u001a\u00020\u00112,\u0010\u0016\u001a(\u0012\u0004\u0012\u00020\u0000\u0012\u0013\u0012\u0011H\u0013\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\r0\u0017\u00a2\u0006\u0002\b\u001bJ\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J)\u0010\u001c\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\r0\u001e\u00a2\u0006\u0002\b\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/promptTree/PromptBuilder;", "", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "node", "Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode$Section;", "<init>", "(Lcom/intellij/ml/llm/tokenizer/Tokenizer;Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode$Section;)V", "getTokenizer", "()Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "getNode", "()Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode$Section;", "appendLine", "", "line", "Lcom/intellij/ml/llm/privacy/PSString;", "trim", "Lcom/intellij/ml/llm/promptTree/Trim;", "appendAll", "T", "parts", "", "builder", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "element", "Lkotlin/ExtensionFunctionType;", "append", "part", "Lkotlin/Function1;", "PromptNode", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nPromptTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptTree.kt\ncom/intellij/ml/llm/promptTree/PromptBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1869#2,2:157\n*S KotlinDebug\n*F\n+ 1 PromptTree.kt\ncom/intellij/ml/llm/promptTree/PromptBuilder\n*L\n116#1:157,2\n*E\n"})
public final class PromptBuilder {
    @NotNull
    private final Tokenizer tokenizer;
    @NotNull
    private final PromptNode.Section node;

    public PromptBuilder(@NotNull Tokenizer tokenizer, @NotNull PromptNode.Section node) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.tokenizer = tokenizer;
        this.node = node;
    }

    @NotNull
    public final Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    @NotNull
    public final PromptNode.Section getNode() {
        return this.node;
    }

    public final void appendLine(@NotNull PSString line, @NotNull Trim trim) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)trim, (String)"trim");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{line};
        this.append(ConstantsKt.getPrivacyConst((String)"%s\n").format(pSStringConvertibleArray), trim);
    }

    public static /* synthetic */ void appendLine$default(PromptBuilder promptBuilder, PSString pSString, Trim trim, int n, Object object) {
        if ((n & 2) != 0) {
            trim = Trim.Required.INSTANCE;
        }
        promptBuilder.appendLine(pSString, trim);
    }

    public final void appendLine(@NotNull Trim trim) {
        Intrinsics.checkNotNullParameter((Object)trim, (String)"trim");
        this.append(ConstantsKt.getPrivacyConst((String)"\n"), trim);
    }

    public static /* synthetic */ void appendLine$default(PromptBuilder promptBuilder, Trim trim, int n, Object object) {
        if ((n & 1) != 0) {
            trim = Trim.Required.INSTANCE;
        }
        promptBuilder.appendLine(trim);
    }

    public final <T> void appendAll(@NotNull List<? extends T> parts, @NotNull Trim trim, @NotNull Function2<? super PromptBuilder, ? super T, Unit> builder) {
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        Intrinsics.checkNotNullParameter((Object)trim, (String)"trim");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.append(trim, (Function1<? super PromptBuilder, Unit>)((Function1)arg_0 -> PromptBuilder.appendAll$lambda$2(parts, builder, arg_0)));
    }

    public static /* synthetic */ void appendAll$default(PromptBuilder promptBuilder, List list, Trim trim, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            trim = Trim.Required.INSTANCE;
        }
        promptBuilder.appendAll(list, trim, function2);
    }

    public final void append(@NotNull PSString part, @NotNull Trim trim) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        Intrinsics.checkNotNullParameter((Object)trim, (String)"trim");
        this.node.getChildren().add(new PromptNode.Text(this, part, trim));
    }

    public static /* synthetic */ void append$default(PromptBuilder promptBuilder, PSString pSString, Trim trim, int n, Object object) {
        if ((n & 2) != 0) {
            trim = Trim.Required.INSTANCE;
        }
        promptBuilder.append(pSString, trim);
    }

    public final void append(@NotNull Trim trim, @NotNull Function1<? super PromptBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)trim, (String)"trim");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        PromptNode.Section section = new PromptNode.Section(trim);
        this.node.getChildren().add(section);
        builder.invoke((Object)new PromptBuilder(this.tokenizer, section));
    }

    public static /* synthetic */ void append$default(PromptBuilder promptBuilder, Trim trim, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            trim = Trim.Required.INSTANCE;
        }
        promptBuilder.append(trim, (Function1<? super PromptBuilder, Unit>)function1);
    }

    private static final Unit appendAll$lambda$2$lambda$1$lambda$0(Function2 $builder, Object $it, PromptBuilder $this$append) {
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"$this$append");
        $builder.invoke((Object)$this$append, $it);
        return Unit.INSTANCE;
    }

    private static final Unit appendAll$lambda$2(List $parts, Function2 $builder, PromptBuilder $this$append) {
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"$this$append");
        int i = 0;
        Iterable $this$forEach$iv = $parts;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            int n = i;
            i = n + 1;
            $this$append.append(new Trim.ByOrder(n, false, 2, null), (Function1<? super PromptBuilder, Unit>)((Function1)arg_0 -> PromptBuilder.appendAll$lambda$2$lambda$1$lambda$0($builder, it, arg_0)));
        }
        return Unit.INSTANCE;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u0002\u001f \u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode;", "", "<init>", "()V", "include", "", "getInclude", "()Z", "setInclude", "(Z)V", "trim", "Lcom/intellij/ml/llm/promptTree/Trim;", "getTrim", "()Lcom/intellij/ml/llm/promptTree/Trim;", "size", "", "getSize", "()I", "render", "", "builder", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "children", "", "getChildren", "()Ljava/util/List;", "limit", "allOrderedTrimableChildren", "orderedTrimableChildren", "Text", "Section", "Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode$Section;", "Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode$Text;", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nPromptTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptTree.kt\ncom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,156:1\n1869#2,2:157\n1869#2,2:159\n1491#2:161\n1516#2,3:162\n1519#2,3:172\n774#2:175\n865#2,2:176\n1374#2:178\n1460#2,5:179\n1374#2:184\n1460#2,5:185\n1068#2:190\n382#3,7:165\n*S KotlinDebug\n*F\n+ 1 PromptTree.kt\ncom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode\n*L\n26#1:157,2\n30#1:159,2\n47#1:161\n47#1:162,3\n47#1:172,3\n47#1:175\n47#1:176,2\n51#1:178\n51#1:179,5\n57#1:184\n57#1:185,5\n64#1:190\n47#1:165,7\n*E\n"})
    public static abstract class PromptNode {
        private boolean include = true;

        private PromptNode() {
        }

        public final boolean getInclude() {
            return this.include;
        }

        public final void setInclude(boolean bl) {
            this.include = bl;
        }

        @NotNull
        public abstract Trim getTrim();

        public abstract int getSize();

        public abstract void render(@NotNull ConcatenateBuilder var1);

        @NotNull
        public abstract List<PromptNode> getChildren();

        public final void render(@NotNull ConcatenateBuilder builder, int limit) {
            PromptNode it;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            List<PromptNode> orderedTrimableChildren = this.allOrderedTrimableChildren();
            Iterable $this$forEach$iv = orderedTrimableChildren;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PromptNode)element$iv;
                boolean bl = false;
                it.include = true;
            }
            $this$forEach$iv = orderedTrimableChildren;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PromptNode)element$iv;
                boolean bl = false;
                if (this.getSize() <= limit) continue;
                it.include = false;
            }
            if (this.getSize() > limit) {
                builder.append(ConstantsKt.getPrivacyConst((String)"Error"));
            } else {
                this.render(builder);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<PromptNode> allOrderedTrimableChildren() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable list$iv$iv;
            PromptNode it;
            Iterable $this$groupByTo$iv$iv;
            List<PromptNode> childrenAtLevel = this.orderedTrimableChildren();
            Iterable $this$groupBy$iv = childrenAtLevel;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                it = (PromptNode)element$iv$iv;
                boolean bl = false;
                Trim trim = it.getTrim();
                Intrinsics.checkNotNull((Object)trim, (String)"null cannot be cast to non-null type com.intellij.ml.llm.promptTree.Trim.ByOrder");
                Integer key$iv$iv = ((Trim.ByOrder)trim).getOrder();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filter$iv = MapsKt.toList((Map)destination$iv$iv);
            boolean $i$f$filter = false;
            $this$groupByTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(((Collection)it.getSecond()).size() > 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Pair nodesWithTheSameOrder = (Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (nodesWithTheSameOrder != null) {
                throw new IllegalStateException(("Prompt nodes can not have the same level '" + nodesWithTheSameOrder.getFirst() + "'").toString());
            }
            Iterable $this$flatMap$iv = childrenAtLevel;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (PromptNode)element$iv$iv;
                boolean bl = false;
                list$iv$iv = CollectionsKt.plus((Collection)it.allOrderedTrimableChildren(), (Iterable)CollectionsKt.listOf((Object)it));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<PromptNode> orderedTrimableChildren() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.getChildren();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PromptNode it = (PromptNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getTrim() instanceof Trim.ByOrder ? CollectionsKt.listOf((Object)it) : it.orderedTrimableChildren();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PromptNode it = (PromptNode)b;
                    boolean bl = false;
                    Trim trim = it.getTrim();
                    Intrinsics.checkNotNull((Object)trim, (String)"null cannot be cast to non-null type com.intellij.ml.llm.promptTree.Trim.ByOrder");
                    it = (PromptNode)a;
                    Comparable comparable = Integer.valueOf(((Trim.ByOrder)trim).getOrder());
                    bl = false;
                    Trim trim2 = it.getTrim();
                    Intrinsics.checkNotNull((Object)trim2, (String)"null cannot be cast to non-null type com.intellij.ml.llm.promptTree.Trim.ByOrder");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(((Trim.ByOrder)trim2).getOrder()));
                }
            });
        }

        public /* synthetic */ PromptNode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode$Section;", "Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode;", "trim", "Lcom/intellij/ml/llm/promptTree/Trim;", "<init>", "(Lcom/intellij/ml/llm/promptTree/Trim;)V", "getTrim", "()Lcom/intellij/ml/llm/promptTree/Trim;", "children", "", "getChildren", "()Ljava/util/List;", "size", "", "getSize", "()I", "render", "", "builder", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "toString", "", "intellij.ml.llm.core"})
        @SourceDebugExtension(value={"SMAP\nPromptTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptTree.kt\ncom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode$Section\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n1869#3,2:158\n*S KotlinDebug\n*F\n+ 1 PromptTree.kt\ncom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode$Section\n*L\n92#1:158,2\n*E\n"})
        public static final class Section
        extends PromptNode {
            @NotNull
            private final Trim trim;
            @NotNull
            private final List<PromptNode> children;

            public Section(@NotNull Trim trim) {
                Intrinsics.checkNotNullParameter((Object)trim, (String)"trim");
                super(null);
                this.trim = trim;
                this.children = new ArrayList();
            }

            @Override
            @NotNull
            public Trim getTrim() {
                return this.trim;
            }

            @Override
            @NotNull
            public List<PromptNode> getChildren() {
                return this.children;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int getSize() {
                int n;
                if (this.getInclude()) {
                    Iterable iterable = this.getChildren();
                    int n2 = 0;
                    for (Object t : iterable) {
                        void it;
                        PromptNode promptNode = (PromptNode)t;
                        int n3 = n2;
                        boolean bl = false;
                        int n4 = it.getSize();
                        n2 = n3 + n4;
                    }
                    n = n2;
                } else {
                    n = 0;
                }
                return n;
            }

            @Override
            public void render(@NotNull ConcatenateBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                if (this.getInclude()) {
                    Iterable $this$forEach$iv = this.getChildren();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PromptNode it = (PromptNode)element$iv;
                        boolean bl = false;
                        it.render(builder);
                    }
                }
            }

            @NotNull
            public String toString() {
                return "Section: " + this.getTrim();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode$Text;", "Lcom/intellij/ml/llm/promptTree/PromptBuilder$PromptNode;", "owner", "Lcom/intellij/ml/llm/promptTree/PromptBuilder;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "trim", "Lcom/intellij/ml/llm/promptTree/Trim;", "<init>", "(Lcom/intellij/ml/llm/promptTree/PromptBuilder;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/promptTree/Trim;)V", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "getTrim", "()Lcom/intellij/ml/llm/promptTree/Trim;", "children", "", "getChildren", "()Ljava/util/List;", "render", "", "builder", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "size", "", "getSize", "()I", "toString", "", "intellij.ml.llm.core"})
        public static final class Text
        extends PromptNode {
            @NotNull
            private final PromptBuilder owner;
            @NotNull
            private final PSString text;
            @NotNull
            private final Trim trim;
            @NotNull
            private final List<PromptNode> children;

            public Text(@NotNull PromptBuilder owner, @NotNull PSString text, @NotNull Trim trim) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)trim, (String)"trim");
                super(null);
                this.owner = owner;
                this.text = text;
                this.trim = trim;
                this.children = CollectionsKt.emptyList();
            }

            @NotNull
            public final PSString getText() {
                return this.text;
            }

            @Override
            @NotNull
            public Trim getTrim() {
                return this.trim;
            }

            @Override
            @NotNull
            public List<PromptNode> getChildren() {
                return this.children;
            }

            @Override
            public void render(@NotNull ConcatenateBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                if (this.getInclude()) {
                    builder.append(this.text);
                }
            }

            @Override
            public int getSize() {
                return this.getInclude() ? this.owner.getTokenizer().count((String)this.text.unwrap()) : 0;
            }

            @NotNull
            public String toString() {
                return "Text " + this.getTrim() + ": " + this.text;
            }
        }
    }
}

