/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.notification;

import com.intellij.ml.llm.core.AIAContainerPanelFacade;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionHost;
import com.intellij.ml.llm.core.chat.session.ChatSessionVm;
import com.intellij.ml.llm.core.chat.ui.AIAssistantContainerPanel;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatPanel;
import com.intellij.ml.llm.core.chat.ui.chat.notification.AIAssistantNotification;
import com.intellij.ml.llm.core.chat.ui.chat.notification.ChatNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000f\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/core/chat/notification/ChatNotificationManagerImpl;", "Lcom/intellij/ml/llm/core/chat/ui/chat/notification/ChatNotificationManager;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "showNotification", "", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionVm;", "notification", "Lcom/intellij/ml/llm/core/chat/ui/chat/notification/AIAssistantNotification;", "showNotificationInCurrentChatSession", "hideNotificationInCurrentChatSession", "hideNotification", "getLatestChatSession", "intellij.ml.llm.content"})
@SourceDebugExtension(value={"SMAP\nChatNotificationManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatNotificationManagerImpl.kt\ncom/intellij/ml/llm/core/chat/notification/ChatNotificationManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1068#2:52\n*S KotlinDebug\n*F\n+ 1 ChatNotificationManagerImpl.kt\ncom/intellij/ml/llm/core/chat/notification/ChatNotificationManagerImpl\n*L\n49#1:52\n*E\n"})
public final class ChatNotificationManagerImpl
implements ChatNotificationManager {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;

    public ChatNotificationManagerImpl(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
    }

    @RequiresEdt
    public void showNotification(@NotNull ChatSessionVm chatSession, @NotNull AIAssistantNotification notification) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        AIAContainerPanelFacade aIAContainerPanelFacade = AIAContentFacade.Companion.getInstance(this.project).getPanel();
        Intrinsics.checkNotNull((Object)aIAContainerPanelFacade, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.ui.AIAssistantContainerPanel");
        AIAssistantChatPanel aIAssistantChatPanel = ((AIAssistantContainerPanel)aIAContainerPanelFacade).getChatPanel(chatSession);
        if (aIAssistantChatPanel == null) {
            return;
        }
        AIAssistantChatPanel chatPanel = aIAssistantChatPanel;
        if (notification.isCloseable()) {
            Function0 originalCloseAction = notification.getOnCloseAction();
            Field field = AIAssistantNotification.class.getDeclaredField("onCloseAction");
            field.setAccessible(true);
            field.set(notification, () -> ChatNotificationManagerImpl.showNotification$lambda$0(originalCloseAction, this, chatSession));
        }
        chatPanel.showNotification(notification);
    }

    @RequiresEdt
    public void showNotificationInCurrentChatSession(@NotNull AIAssistantNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        ChatSessionVm chatSessionVm = this.getLatestChatSession();
        if (chatSessionVm == null) {
            return;
        }
        ChatSessionVm chatSession = chatSessionVm;
        this.showNotification(chatSession, notification);
    }

    @RequiresEdt
    public void hideNotificationInCurrentChatSession() {
        ChatSessionVm chatSessionVm = this.getLatestChatSession();
        if (chatSessionVm == null) {
            return;
        }
        ChatSessionVm chatSession = chatSessionVm;
        this.hideNotification(chatSession);
    }

    @RequiresEdt
    public void hideNotification(@NotNull ChatSessionVm chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        AIAContainerPanelFacade aIAContainerPanelFacade = AIAContentFacade.Companion.getInstance(this.project).getPanel();
        Intrinsics.checkNotNull((Object)aIAContainerPanelFacade, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.ui.AIAssistantContainerPanel");
        AIAssistantChatPanel aIAssistantChatPanel = ((AIAssistantContainerPanel)aIAContainerPanelFacade).getChatPanel(chatSession);
        if (aIAssistantChatPanel == null) {
            return;
        }
        AIAssistantChatPanel chatPanel = aIAssistantChatPanel;
        chatPanel.hideNotification();
    }

    private final ChatSessionVm getLatestChatSession() {
        Iterable $this$sortedByDescending$iv = ChatSessionHost.Companion.getInstance(this.project).getAllChats();
        boolean $i$f$sortedByDescending = false;
        return (ChatSessionVm)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ChatSession it = (ChatSession)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTimestamp());
                it = (ChatSession)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
            }
        }));
    }

    private static final Unit showNotification$lambda$0(Function0 $originalCloseAction, ChatNotificationManagerImpl this$0, ChatSessionVm $chatSession) {
        Function0 function0 = $originalCloseAction;
        if (function0 != null) {
            function0.invoke();
        }
        this$0.hideNotification($chatSession);
        return Unit.INSTANCE;
    }
}

