/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.config.migration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.maddyhome.idea.vim.config.migration.ApplicationConfigurationMigratorKt;
import com.maddyhome.idea.vim.config.migration.ConfigMigrator;
import com.maddyhome.idea.vim.config.migration.MigrationComponents;
import com.maddyhome.idea.vim.config.migration.VersionDetector;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\tH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/config/migration/ApplicationConfigurationMigrator;", "", "migrationComponents", "Lcom/maddyhome/idea/vim/config/migration/MigrationComponents;", "<init>", "(Lcom/maddyhome/idea/vim/config/migration/MigrationComponents;)V", "()V", "migrators", "", "", "Lcom/maddyhome/idea/vim/config/migration/ConfigMigrator;", "versionDetectors", "", "Lcom/maddyhome/idea/vim/config/migration/VersionDetector;", "currentVersion", "migrate", "", "getCurrentVersion", "()Ljava/lang/Integer;", "performMigration", "startVersion", "Companion", "IdeaVIM"})
public final class ApplicationConfigurationMigrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Integer, ConfigMigrator> migrators;
    @NotNull
    private final List<VersionDetector> versionDetectors;
    private int currentVersion;

    public ApplicationConfigurationMigrator(@NotNull MigrationComponents migrationComponents) {
        Intrinsics.checkNotNullParameter((Object)migrationComponents, (String)"migrationComponents");
        this.migrators = migrationComponents.getGroupedMigrators();
        this.versionDetectors = migrationComponents.getVersionDetectors();
        this.currentVersion = migrationComponents.getCurrentVersion();
    }

    public ApplicationConfigurationMigrator() {
        this(ApplicationConfigurationMigratorKt.access$getProductionMigrationComponents$p());
    }

    public final void migrate() {
        Integer n = this.getCurrentVersion();
        if (n == null) {
            return;
        }
        int fileVersion = n;
        if (fileVersion >= this.currentVersion) {
            return;
        }
        this.performMigration(fileVersion);
    }

    private final Integer getCurrentVersion() {
        for (VersionDetector detector : this.versionDetectors) {
            Integer version = detector.extractVersion();
            if (version == null) continue;
            return version;
        }
        return null;
    }

    private final void performMigration(int startVersion) {
        int version = startVersion;
        while (version < this.currentVersion) {
            int n;
            ConfigMigrator configMigrator = this.migrators.get(version);
            if (configMigrator != null) {
                configMigrator.versionUp();
                n = configMigrator.getToVersion();
            } else {
                n = version + 1;
            }
            version = n;
        }
    }

    @NotNull
    public static final ApplicationConfigurationMigrator getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/config/migration/ApplicationConfigurationMigrator$Companion;", "", "<init>", "()V", "instance", "Lcom/maddyhome/idea/vim/config/migration/ApplicationConfigurationMigrator;", "getInstance$annotations", "getInstance", "()Lcom/maddyhome/idea/vim/config/migration/ApplicationConfigurationMigrator;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ApplicationConfigurationMigrator getInstance() {
            Object object = ApplicationManager.getApplication().getService(ApplicationConfigurationMigrator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ApplicationConfigurationMigrator)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

