/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.textobjindent;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.command.TextObjectVisualType;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.TextObjectActionHandler;
import com.maddyhome.idea.vim.helper.InlayHelperKt;
import com.maddyhome.idea.vim.listener.SelectionVimListenerSuppressor;
import com.maddyhome.idea.vim.listener.VimListenerSuppressor;
import com.maddyhome.idea.vim.newapi.IjVimCaret;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VimIndentObject
implements VimExtension {
    @Override
    @NotNull
    public String getName() {
        return "textobj-indent";
    }

    @Override
    public void init() {
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)MappingMode.XO, (List<? extends KeyStroke>)VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-indent-ai"), this.getOwner(), new IndentObject(true, false), false);
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)MappingMode.XO, (List<? extends KeyStroke>)VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-indent-aI"), this.getOwner(), new IndentObject(true, true), false);
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)MappingMode.XO, (List<? extends KeyStroke>)VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-indent-ii"), this.getOwner(), new IndentObject(false, false), false);
        VimExtensionFacade.putKeyMapping(MappingMode.XO, VimInjectorKt.getInjector().getParser().parseKeys("ai"), this.getOwner(), VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-indent-ai"), true);
        VimExtensionFacade.putKeyMapping(MappingMode.XO, VimInjectorKt.getInjector().getParser().parseKeys("aI"), this.getOwner(), VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-indent-aI"), true);
        VimExtensionFacade.putKeyMapping(MappingMode.XO, VimInjectorKt.getInjector().getParser().parseKeys("ii"), this.getOwner(), VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-indent-ii"), true);
    }

    static class IndentObject
    implements ExtensionHandler {
        final boolean includeAbove;
        final boolean includeBelow;

        IndentObject(boolean includeAbove, boolean includeBelow) {
            this.includeAbove = includeAbove;
            this.includeBelow = includeBelow;
        }

        public boolean isRepeatable() {
            return false;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            if (editor == null) {
                IndentObject.$$$reportNull$$$0(0);
            }
            if (context == null) {
                IndentObject.$$$reportNull$$$0(1);
            }
            if (operatorArguments == null) {
                IndentObject.$$$reportNull$$$0(2);
            }
            IjVimEditor vimEditor = (IjVimEditor)editor;
            @NotNull KeyHandlerState keyHandlerState = KeyHandler.getInstance().getKeyHandlerState();
            IndentObjectHandler textObjectHandler = new IndentObjectHandler(this.includeAbove, this.includeBelow);
            if (!(editor.getMode() instanceof Mode.OP_PENDING)) {
                int count0 = operatorArguments.getCount0();
                ((IjVimEditor)editor).getEditor().getCaretModel().runForEachCaret(caret -> {
                    TextRange range = textObjectHandler.getRange((VimEditor)vimEditor, (ImmutableVimCaret)new IjVimCaret(caret), context, Math.max(1, count0), count0);
                    if (range != null) {
                        try (VimListenerSuppressor.Locked ignored = SelectionVimListenerSuppressor.INSTANCE.lock();){
                            if (editor.getMode() instanceof Mode.VISUAL) {
                                EngineVisualGroupKt.vimSetSelection((VimCaret)new IjVimCaret(caret), (int)range.getStartOffset(), (int)(range.getEndOffset() - 1), (boolean)true);
                            } else {
                                InlayHelperKt.moveToInlayAwareOffset(caret, range.getStartOffset());
                            }
                        }
                    }
                });
            } else {
                keyHandlerState.getCommandBuilder().addAction((EditorActionHandlerBase)textObjectHandler);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operatorArguments";
                    break;
                }
            }
            objectArray[1] = "com/maddyhome/idea/vim/extension/textobjindent/VimIndentObject$IndentObject";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class IndentObjectHandler
        extends TextObjectActionHandler {
            final boolean includeAbove;
            final boolean includeBelow;

            IndentObjectHandler(boolean includeAbove, boolean includeBelow) {
                this.includeAbove = includeAbove;
                this.includeBelow = includeBelow;
            }

            @Nullable
            public TextRange getRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, int count, int rawCount) {
                Integer lowerBoundaryOffset;
                Integer upperBoundaryOffset;
                block23: {
                    char ch;
                    char ch2;
                    char ch3;
                    int caretOffset;
                    if (editor == null) {
                        IndentObjectHandler.$$$reportNull$$$0(0);
                    }
                    if (caret == null) {
                        IndentObjectHandler.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        IndentObjectHandler.$$$reportNull$$$0(2);
                    }
                    CharSequence charSequence = ((IjVimEditor)editor).getEditor().getDocument().getCharsSequence();
                    int caretLineStartOffset = caretOffset = ((IjVimCaret)caret).getCaret().getOffset();
                    int accumulatedWhitespace = 0;
                    while (--caretLineStartOffset >= 0) {
                        char ch4 = charSequence.charAt(caretLineStartOffset);
                        if (ch4 == ' ' || ch4 == '\t') {
                            ++accumulatedWhitespace;
                            continue;
                        }
                        if (ch4 == '\n') {
                            ++caretLineStartOffset;
                            break;
                        }
                        accumulatedWhitespace = 0;
                    }
                    if (caretLineStartOffset < 0) {
                        caretLineStartOffset = 0;
                    }
                    int indentSize = 0;
                    for (int offset = caretLineStartOffset; offset < charSequence.length() && ((ch3 = charSequence.charAt(offset)) == ' ' || ch3 == '\t'); ++offset) {
                        ++indentSize;
                    }
                    upperBoundaryOffset = null;
                    int pos1 = caretLineStartOffset - 1;
                    boolean isUpperBoundaryFound = false;
                    while (upperBoundaryOffset == null) {
                        while (--pos1 >= 0 && ((ch2 = charSequence.charAt(pos1)) == ' ' || ch2 == '\t' || ch2 == '\n')) {
                        }
                        accumulatedWhitespace = 0;
                        while (--pos1 >= 0) {
                            ch2 = charSequence.charAt(pos1);
                            if (ch2 == ' ' || ch2 == '\t') {
                                ++accumulatedWhitespace;
                                continue;
                            }
                            if (ch2 == '\n') {
                                if (accumulatedWhitespace >= indentSize) break;
                                upperBoundaryOffset = pos1 + 1;
                                isUpperBoundaryFound = true;
                                break;
                            }
                            accumulatedWhitespace = 0;
                        }
                        if (pos1 >= 0) continue;
                        upperBoundaryOffset = 0;
                        isUpperBoundaryFound = accumulatedWhitespace < indentSize;
                    }
                    if (isUpperBoundaryFound && !this.includeAbove) {
                        while ((upperBoundaryOffset = Integer.valueOf(upperBoundaryOffset + 1)) < charSequence.length()) {
                            ch2 = charSequence.charAt(upperBoundaryOffset);
                            if (ch2 != '\n') continue;
                            upperBoundaryOffset = upperBoundaryOffset + 1;
                            break;
                        }
                        while (charSequence.charAt(upperBoundaryOffset) == '\n') {
                            upperBoundaryOffset = upperBoundaryOffset + 1;
                        }
                    }
                    int caretLineEndOffset = caretOffset;
                    while (++caretLineEndOffset < charSequence.length()) {
                        char ch5 = charSequence.charAt(caretLineEndOffset);
                        if (ch5 != '\n') continue;
                        ++caretLineEndOffset;
                        break;
                    }
                    lowerBoundaryOffset = null;
                    int pos2 = caretLineEndOffset - 1;
                    boolean isLowerBoundaryFound = false;
                    while (lowerBoundaryOffset == null) {
                        int accumulatedWhitespace2 = 0;
                        int lastNewlinePos = caretLineEndOffset - 1;
                        boolean isInIndent = true;
                        while (++pos2 < charSequence.length()) {
                            char ch6 = charSequence.charAt(pos2);
                            if (this.isIndentChar(ch6) && isInIndent) {
                                ++accumulatedWhitespace2;
                                continue;
                            }
                            if (ch6 == '\n') {
                                accumulatedWhitespace2 = 0;
                                lastNewlinePos = pos2;
                                isInIndent = true;
                                continue;
                            }
                            if (isInIndent && accumulatedWhitespace2 < indentSize) {
                                lowerBoundaryOffset = lastNewlinePos;
                                isLowerBoundaryFound = true;
                                break;
                            }
                            isInIndent = false;
                        }
                        if (pos2 < charSequence.length()) continue;
                        lowerBoundaryOffset = charSequence.length() - 1;
                    }
                    if (!isLowerBoundaryFound || !this.includeBelow) break block23;
                    while ((lowerBoundaryOffset = Integer.valueOf(lowerBoundaryOffset + 1)) < charSequence.length() && (ch = charSequence.charAt(lowerBoundaryOffset)) != '\n') {
                    }
                }
                return new TextRange(upperBoundaryOffset.intValue(), lowerBoundaryOffset.intValue());
            }

            @NotNull
            public TextObjectVisualType getVisualType() {
                TextObjectVisualType textObjectVisualType = TextObjectVisualType.LINE_WISE;
                if (textObjectVisualType == null) {
                    IndentObjectHandler.$$$reportNull$$$0(3);
                }
                return textObjectVisualType;
            }

            private boolean isIndentChar(char ch) {
                return ch == ' ' || ch == '\t';
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caret";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/maddyhome/idea/vim/extension/textobjindent/VimIndentObject$IndentObject$IndentObjectHandler";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/maddyhome/idea/vim/extension/textobjindent/VimIndentObject$IndentObject$IndentObjectHandler";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVisualType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRange";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }
    }
}

