/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.NativeAction;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimFile;
import com.maddyhome.idea.vim.api.VimFileBase;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.group.LastTabService;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.newapi.ExecuteExtensionKt;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContext;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000bJ\u0018\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0005H\u0016J$\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020'H\u0016\u00a8\u0006)"}, d2={"Lcom/maddyhome/idea/vim/group/FileGroup;", "Lcom/maddyhome/idea/vim/api/VimFileBase;", "<init>", "()V", "openFile", "", "filename", "", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "findByNameInContentRoots", "closeFile", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "number", "", "saveFile", "saveFiles", "selectFile", "count", "selectNextFile", "selectPreviousTab", "getPreviousTab", "Lcom/intellij/openapi/actionSystem/DataContext;", "selectEditor", "Lcom/intellij/openapi/editor/Editor;", "file", "displayFileInfo", "vimEditor", "fullPath", "projectId", "documentPath", "protocol", "getProjectId", "", "Companion", "IdeaVIM"})
public final class FileGroup
extends VimFileBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public boolean openFile(@NotNull String filename, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (logger.isDebugEnabled()) {
            logger.debug("openFile(" + filename + ")");
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(((IjEditorExecutionContext)context).getContext());
        if (project == null) {
            return false;
        }
        Project project2 = project;
        VirtualFile found = this.findFile(filename, project2);
        if (found != null) {
            FileType type;
            if (logger.isDebugEnabled()) {
                logger.debug("found file: " + found);
            }
            if ((type = FileTypeManager.getInstance().getKnownFileTypeOrAssociate(found, project2)) != null) {
                FileEditorManager fem = FileEditorManager.getInstance((Project)project2);
                fem.openFile(found, true);
                return true;
            }
            return true;
        }
        Object[] objectArray = new Object[]{filename};
        VimPlugin.showMessage(MessageHelper.message("unable.to.find.0", objectArray));
        return false;
    }

    @Nullable
    public final VirtualFile findFile(@NotNull String filename, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile found = null;
        if (StringsKt.startsWith$default((String)filename, (String)"~/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)filename, (String)"~\\", (boolean)false, (int)2, null)) {
            String string = filename.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String relativePath = string;
            String dir = System.getProperty("user.home");
            if (logger.isDebugEnabled()) {
                logger.debug("home dir file");
                logger.debug("looking for " + relativePath + " in " + dir);
            }
            found = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(dir, relativePath));
        } else {
            found = LocalFileSystem.getInstance().findFileByIoFile(new File(filename));
            if (found == null && (found = this.findByNameInContentRoots(filename, project)) == null) {
                found = FileGroup.Companion.findByNameInProject(filename, project);
            }
        }
        return found;
    }

    private final VirtualFile findByNameInContentRoots(String filename, Project project) {
        VirtualFile found = null;
        ProjectRootManager prm = ProjectRootManager.getInstance((Project)project);
        VirtualFile[] virtualFileArray = prm.getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        VirtualFile[] roots = virtualFileArray;
        int n = roots.length;
        for (int i = 0; i < n; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug("root[" + i + "] = " + roots[i].getPath());
            }
            if ((found = roots[i].findFileByRelativePath(filename)) != null) break;
        }
        return found;
    }

    public void closeFile(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getContext();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DataContext");
        Project project = (Project)PlatformDataKeys.PROJECT.getData((DataContext)object);
        if (project != null) {
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.Companion.getInstanceEx(project);
            EditorWindow window = fileEditorManager.getCurrentWindow();
            VirtualFile virtualFile = fileEditorManager.getCurrentFile();
            if (virtualFile != null && window != null) {
                EditorWindow.closeFile$default((EditorWindow)window, (VirtualFile)virtualFile, (boolean)false, (int)2, null);
                window.requestFocus(true);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    EditorsSplitters.Companion.focusDefaultComponentInSplittersIfPresent(project);
                }
            }
        }
    }

    public void closeFile(int number, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = (Project)PlatformDataKeys.PROJECT.getData(((IjEditorExecutionContext)context).getContext());
        if (project == null) {
            return;
        }
        Project project2 = project;
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.Companion.getInstanceEx(project2);
        EditorWindow window = fileEditorManager.getCurrentWindow();
        VirtualFile[] virtualFileArray = fileEditorManager.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        VirtualFile[] editors = virtualFileArray;
        if (window != null && number >= 0 && number < editors.length) {
            VirtualFile virtualFile = editors[number];
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"get(...)");
            fileEditorManager.closeFile(virtualFile, window);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            EditorsSplitters.Companion.focusDefaultComponentInSplittersIfPresent(project2);
        }
    }

    public void saveFile(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NativeAction action = StringsKt.contains$default((CharSequence)IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getIdeawrite(), (CharSequence)"all", (boolean)false, (int)2, null) ? VimInjectorKt.getInjector().getNativeActionManager().getSaveAll() : VimInjectorKt.getInjector().getNativeActionManager().getSaveCurrent();
        ExecuteExtensionKt.execute(action, editor, context);
    }

    public void saveFiles(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ExecuteExtensionKt.execute(VimInjectorKt.getInjector().getNativeActionManager().getSaveAll(), editor, context);
    }

    public boolean selectFile(int count, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int count2 = count;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(((IjEditorExecutionContext)context).getContext());
        if (project == null) {
            return false;
        }
        Project project2 = project;
        FileEditorManager fem = FileEditorManager.getInstance((Project)project2);
        VirtualFile[] virtualFileArray = fem.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        VirtualFile[] editors = virtualFileArray;
        if (count2 == 99) {
            count2 = editors.length - 1;
        }
        if (count2 < 0 || count2 >= editors.length) {
            return false;
        }
        fem.openFile(editors[count2], true);
        return true;
    }

    public void selectNextFile(int count, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = (Project)PlatformDataKeys.PROJECT.getData(((IjEditorExecutionContext)context).getContext());
        if (project == null) {
            return;
        }
        Project project2 = project;
        FileEditorManager fem = FileEditorManager.getInstance((Project)project2);
        VirtualFile[] virtualFileArray = fem.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        VirtualFile[] editors = virtualFileArray;
        VirtualFile current = fem.getSelectedFiles()[0];
        int n = editors.length;
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)editors[i], (Object)current)) continue;
            int pos = (i + count % editors.length + editors.length) % editors.length;
            fem.openFile(editors[pos], true);
        }
    }

    public void selectPreviousTab(@NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getContext();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DataContext");
        Project project = (Project)PlatformDataKeys.PROJECT.getData((DataContext)object);
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile vf = LastTabService.Companion.getInstance(project2).getLastTab();
        if (vf != null && vf.isValid()) {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project2).openFile(vf, true);
            Intrinsics.checkNotNull((Object)fileEditorArray);
        } else {
            VimPlugin.indicateError();
        }
    }

    @Nullable
    public final VirtualFile getPreviousTab(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        VirtualFile vf = LastTabService.Companion.getInstance(project2).getLastTab();
        if (vf != null && vf.isValid()) {
            return vf;
        }
        return null;
    }

    @Nullable
    public final Editor selectEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditorManager fMgr = FileEditorManager.getInstance((Project)project);
        FileEditor[] fileEditorArray = fMgr.openFile(file, true);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        FileEditor[] feditors = fileEditorArray;
        if (feditors.length > 0 && feditors[0] instanceof TextEditor) {
            FileEditor fileEditor = feditors[0];
            Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
            Editor editor = ((TextEditor)fileEditor).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            if (!editor2.isDisposed()) {
                return editor2;
            }
        }
        return null;
    }

    public void displayFileInfo(@NotNull VimEditor vimEditor, boolean fullPath) {
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"vimEditor");
        Editor editor = ((IjVimEditor)vimEditor).getEditor();
        StringBuilder msg = new StringBuilder();
        VirtualFile vf = EditorHelper.getVirtualFile(editor);
        if (vf != null) {
            msg.append('\"');
            if (fullPath) {
                msg.append(vf.getPath());
            } else {
                Project project = editor.getProject();
                if (project != null) {
                    VirtualFile root = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(vf);
                    if (root != null) {
                        String string = vf.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        String string2 = string;
                        int n = root.getPath().length() + 1;
                        String string3 = string2.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        v2 = msg.append(string3);
                    } else {
                        v2 = msg.append(vf.getPath());
                    }
                }
            }
            v3 = msg.append("\" ");
        } else {
            v3 = msg.append("\"[No File]\" ");
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        if (!doc.isWritable()) {
            msg.append("[RO] ");
        } else if (FileDocumentManager.getInstance().isDocumentUnsaved(doc)) {
            msg.append("[+] ");
        }
        int lline = editor.getCaretModel().getLogicalPosition().line;
        int total = new IjVimEditor(editor).lineCount();
        int pct = (int)((double)((float)lline / (float)total * 100.0f) + 0.5);
        msg.append("line ").append(lline + 1).append(" of ").append(total);
        msg.append(" --").append(pct).append("%-- ");
        LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
        LogicalPosition lp = logicalPosition;
        int col = editor.getCaretModel().getOffset() - doc.getLineStartOffset(lline);
        msg.append("col ").append(col + 1);
        if (col != lp.column) {
            msg.append("-").append(lp.column + 1);
        }
        VimPlugin.showMessage(msg.toString());
    }

    @Nullable
    public VimEditor selectEditor(@NotNull String projectId, @NotNull String documentPath, @Nullable String protocol) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)documentPath, (String)"documentPath");
        VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(protocol);
        if (virtualFileSystem == null) {
            return null;
        }
        VirtualFileSystem fileSystem = virtualFileSystem;
        VirtualFile virtualFile = fileSystem.findFileByPath(documentPath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = (Project)Arrays.stream(ProjectManager.getInstance().getOpenProjects()).filter(arg_0 -> FileGroup.selectEditor$lambda$1(arg_0 -> FileGroup.selectEditor$lambda$0(projectId, arg_0), arg_0)).findFirst().orElseThrow();
        Intrinsics.checkNotNull((Object)project);
        Editor editor = this.selectEditor(project, virtualFile2);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        return (VimEditor)new IjVimEditor(editor2);
    }

    @NotNull
    public String getProjectId(@NotNull Object project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!(project instanceof Project)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return ((Project)project).getName() + "-" + ((Project)project).getLocationHash();
    }

    private static final boolean selectEditor$lambda$0(String $projectId, Project p) {
        VimFile vimFile = VimInjectorKt.getInjector().getFile();
        Project project = p;
        Intrinsics.checkNotNull((Object)project);
        return Intrinsics.areEqual((Object)vimFile.getProjectId((Object)project), (Object)$projectId);
    }

    private static final boolean selectEditor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance((String)FileGroup.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FileGroup.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/group/FileGroup$Companion;", "", "<init>", "()V", "findByNameInProject", "Lcom/intellij/openapi/vfs/VirtualFile;", "filename", "", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fileEditorManagerSelectionChangedCallback", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        private final VirtualFile findByNameInProject(String filename, Project project) {
            GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getProjectScope(...)");
            GlobalSearchScope projectScope = globalSearchScope;
            Collection collection = FilenameIndex.getVirtualFilesByName((String)filename, (GlobalSearchScope)projectScope);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            Collection names = collection;
            if (!names.isEmpty()) {
                return (VirtualFile)names.stream().findFirst().get();
            }
            return null;
        }

        public final void fileEditorManagerSelectionChangedCallback(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getOldFile() != null) {
                Project project = event.getManager().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                LastTabService.Companion.getInstance(project).setLastTab(event.getOldFile());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

