/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimJumpServiceBase;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.mark.Jump;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="VimJumpsSettings", storages={@Storage(value="$APP_CONFIG$/vim_settings_local.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00132\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/group/VimJumpServiceImpl;", "Lcom/maddyhome/idea/vim/api/VimJumpServiceBase;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "<init>", "()V", "lastJumpTimeStamp", "", "getLastJumpTimeStamp", "()J", "setLastJumpTimeStamp", "(J)V", "includeCurrentCommandAsNavigation", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getState", "loadState", "state", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nVimJumpServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimJumpServiceImpl.kt\ncom/maddyhome/idea/vim/group/VimJumpServiceImpl\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,135:1\n38#2:136\n*S KotlinDebug\n*F\n+ 1 VimJumpServiceImpl.kt\ncom/maddyhome/idea/vim/group/VimJumpServiceImpl\n*L\n37#1:136\n*E\n"})
public final class VimJumpServiceImpl
extends VimJumpServiceBase
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long lastJumpTimeStamp;
    @NotNull
    private static final VimLogger logger;

    public long getLastJumpTimeStamp() {
        return this.lastJumpTimeStamp;
    }

    public void setLastJumpTimeStamp(long l) {
        this.lastJumpTimeStamp = l;
    }

    public void includeCurrentCommandAsNavigation(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = ((IjVimEditor)editor).getEditor().getProject();
        if (project != null) {
            IdeDocumentHistory.getInstance((Project)project).includeCurrentCommandAsNavigation();
        }
    }

    @NotNull
    public Element getState() {
        Element projectsElem = new Element("projects");
        for (Map.Entry entry : this.getProjectToJumps().entrySet()) {
            String project = (String)entry.getKey();
            List jumps = (List)entry.getValue();
            Element projectElement = new Element("project").setAttribute("id", project);
            for (Jump jump : jumps) {
                Element jumpElem = new Element("jump");
                jumpElem.setAttribute("line", String.valueOf(jump.getLine()));
                jumpElem.setAttribute("column", String.valueOf(jump.getCol()));
                jumpElem.setAttribute("filename", StringUtil.notNullize((String)jump.getFilepath()));
                jumpElem.setAttribute("protocol", StringUtil.notNullize((String)jump.getProtocol()));
                projectElement.addContent(jumpElem);
                if (!logger.isDebug()) continue;
                logger.debug("saved jump = " + jump);
            }
            projectsElem.addContent(projectElement);
        }
        return projectsElem;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        IjVimInjectorKt.initInjector();
        List projectElements = state.getChildren("project");
        for (Element projectElement : projectElements) {
            List jumps = new ArrayList();
            List jumpElements = projectElement.getChildren("jump");
            for (Element jumpElement : jumpElements) {
                int n = Integer.parseInt(jumpElement.getAttributeValue("line"));
                int n2 = Integer.parseInt(jumpElement.getAttributeValue("column"));
                String string = jumpElement.getAttributeValue("filename");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                String string2 = jumpElement.getAttributeValue("protocol", "file");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
                Jump jump = new Jump(n, n2, string, string2);
                jumps.add(jump);
            }
            if (logger.isDebug()) {
                logger.debug("jumps=" + jumps);
            }
            String projectId = projectElement.getAttributeValue("id");
            this.getProjectToJumps().put(projectId, jumps);
        }
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimJumpServiceImpl.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/group/VimJumpServiceImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

