/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a9\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u00022\u0006\u0010\u0005\u001a\u0002H\u0002H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a3\u0010\u0007\u001a\u00020\b*\u00020\t2!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\b0\u000bH\u0080\b\u00f8\u0001\u0000\u001a\u0011\u0010\u0010\u001a\u00070\t\u00a2\u0006\u0002\b\u0011*\u00020\tH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\tH\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0013*\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0012\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010\u001e\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"sort", "Lkotlin/Pair;", "T", "", "a", "b", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)Lkotlin/Pair;", "vimForEachCaret", "", "Lcom/intellij/openapi/editor/Editor;", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Caret;", "Lkotlin/ParameterName;", "name", "caret", "getTopLevelEditor", "Lorg/jetbrains/annotations/NotNull;", "isTemplateActive", "", "checkTemplateByHighlighter", "project", "Lcom/intellij/openapi/project/Project;", "hasLiveTemplateHighlighter", "markup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "offset", "", "vimEnabled", "editor", "vimDisabled", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helper.kt\ncom/maddyhome/idea/vim/helper/HelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1869#2,2:91\n*S KotlinDebug\n*F\n+ 1 Helper.kt\ncom/maddyhome/idea/vim/helper/HelperKt\n*L\n33#1:91,2\n*E\n"})
public final class HelperKt {
    @NotNull
    public static final <T extends Comparable<? super T>> Pair<T, T> sort(@NotNull T a, @NotNull T b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return a.compareTo(b) > 0 ? TuplesKt.to(b, a) : TuplesKt.to(a, b);
    }

    public static final void vimForEachCaret(@NotNull Editor $this$vimForEachCaret, @NotNull Function1<? super Caret, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$vimForEachCaret, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$vimForEachCaret = false;
        if (EditorExtensionsKt.getInBlockSelection((VimEditor)IjVimEditorKt.getVim($this$vimForEachCaret))) {
            Caret caret = $this$vimForEachCaret.getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            action.invoke((Object)caret);
        } else {
            List list = $this$vimForEachCaret.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke(element$iv);
            }
        }
    }

    @NotNull
    public static final Editor getTopLevelEditor(@NotNull Editor $this$getTopLevelEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelEditor, (String)"<this>");
        Editor editor = $this$getTopLevelEditor instanceof EditorWindow ? ((EditorWindow)$this$getTopLevelEditor).getDelegate() : $this$getTopLevelEditor;
        Intrinsics.checkNotNull((Object)editor);
        return editor;
    }

    public static final boolean isTemplateActive(@NotNull Editor $this$isTemplateActive) {
        Intrinsics.checkNotNullParameter((Object)$this$isTemplateActive, (String)"<this>");
        Project project = $this$isTemplateActive.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (TemplateManager.getInstance((Project)project2).getActiveTemplate($this$isTemplateActive) != null) {
            return true;
        }
        return HelperKt.checkTemplateByHighlighter($this$isTemplateActive, project2);
    }

    private static final boolean checkTemplateByHighlighter(Editor $this$checkTemplateByHighlighter, Project project) {
        Object object = ApplicationKt.getApplication().runReadAction(() -> HelperKt.checkTemplateByHighlighter$lambda$0($this$checkTemplateByHighlighter, project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (Boolean)object;
    }

    private static final boolean hasLiveTemplateHighlighter(MarkupModelEx markup, int offset) {
        Ref.BooleanRef found = new Ref.BooleanRef();
        markup.processRangeHighlightersOverlappingWith(offset, offset, arg_0 -> HelperKt.hasLiveTemplateHighlighter$lambda$1(found, arg_0));
        return found.element;
    }

    private static final boolean vimEnabled(Editor editor) {
        if (VimPlugin.isNotEnabled()) {
            return false;
        }
        return editor == null || !EditorHelperRt.isIdeaVimDisabledHere(editor);
    }

    public static final boolean vimDisabled(@Nullable Editor editor) {
        return !HelperKt.vimEnabled(editor);
    }

    private static final Boolean checkTemplateByHighlighter$lambda$0(Editor $this_checkTemplateByHighlighter, Project $project) {
        int offset = $this_checkTemplateByHighlighter.getCaretModel().getPrimaryCaret().getOffset();
        MarkupModel markupModel = $this_checkTemplateByHighlighter.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel editorMarkup = markupModel;
        if (editorMarkup instanceof MarkupModelEx && HelperKt.hasLiveTemplateHighlighter((MarkupModelEx)editorMarkup, offset)) {
            return true;
        }
        MarkupModel documentMarkup = DocumentMarkupModel.forDocument((Document)$this_checkTemplateByHighlighter.getDocument(), (Project)$project, (boolean)true);
        return documentMarkup instanceof MarkupModelEx && HelperKt.hasLiveTemplateHighlighter((MarkupModelEx)documentMarkup, offset);
    }

    private static final boolean hasLiveTemplateHighlighter$lambda$1(Ref.BooleanRef $found, RangeHighlighterEx it) {
        $found.element = Intrinsics.areEqual((Object)it.getTextAttributesKey(), (Object)EditorColors.LIVE_TEMPLATE_ATTRIBUTES);
        return !$found.element;
    }
}

