/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.maddyhome.idea.vim.helper.EditorHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiHelper {
    public static int findMethodStart(@NotNull Editor editor, int offset, int count) {
        if (editor == null) {
            PsiHelper.$$$reportNull$$$0(0);
        }
        return PsiHelper.findMethodOrClass(editor, offset, count, true);
    }

    public static int findMethodEnd(@NotNull Editor editor, int offset, int count) {
        if (editor == null) {
            PsiHelper.$$$reportNull$$$0(1);
        }
        return PsiHelper.findMethodOrClass(editor, offset, count, false);
    }

    private static int findMethodOrClass(@NotNull Editor editor, int offset, int count, boolean isStart) {
        int resultIndex;
        PsiFile file;
        if (editor == null) {
            PsiHelper.$$$reportNull$$$0(2);
        }
        if ((file = PsiHelper.getFile(editor)) == null) {
            return -1;
        }
        StructureViewBuilder structureViewBuilder = LanguageStructureViewBuilder.getInstance().getStructureViewBuilder(file);
        if (!(structureViewBuilder instanceof TreeBasedStructureViewBuilder)) {
            return -1;
        }
        TreeBasedStructureViewBuilder builder = (TreeBasedStructureViewBuilder)structureViewBuilder;
        StructureViewModel model = builder.createStructureViewModel(editor);
        ArrayList<Integer> navigationOffsets = new ArrayList<Integer>();
        PsiHelper.addNavigationElements((TreeElement)model.getRoot(), navigationOffsets, isStart);
        if (navigationOffsets.isEmpty()) {
            return -1;
        }
        ContainerUtil.sort(navigationOffsets);
        int index = navigationOffsets.size();
        for (int i = 0; i < navigationOffsets.size(); ++i) {
            if ((Integer)navigationOffsets.get(i) > offset) {
                index = i;
                if (count <= 0) break;
                --count;
                break;
            }
            if ((Integer)navigationOffsets.get(i) != offset) continue;
            index = i;
            break;
        }
        if ((resultIndex = index + count) < 0) {
            resultIndex = 0;
        } else if (resultIndex >= navigationOffsets.size()) {
            resultIndex = navigationOffsets.size() - 1;
        }
        return (Integer)navigationOffsets.get(resultIndex);
    }

    private static void addNavigationElements(@NotNull TreeElement root, @NotNull List<Integer> navigationOffsets, boolean start2) {
        if (root == null) {
            PsiHelper.$$$reportNull$$$0(3);
        }
        if (navigationOffsets == null) {
            PsiHelper.$$$reportNull$$$0(4);
        }
        if (root instanceof PsiTreeElementBase) {
            int offset;
            PsiElement element = ((PsiTreeElementBase)root).getValue();
            if (start2) {
                offset = element.getTextRange().getStartOffset();
                if (element.getLanguage().getID().equals("JAVA")) {
                    int textOffset = element.getTextOffset();
                    int braceIndex = element.getText().indexOf(123, textOffset - offset);
                    if (braceIndex >= 0) {
                        offset += braceIndex;
                    }
                }
            } else {
                offset = element.getTextRange().getEndOffset() - 1;
            }
            if (!navigationOffsets.contains(offset)) {
                navigationOffsets.add(offset);
            }
        }
        for (TreeElement child : root.getChildren()) {
            PsiHelper.addNavigationElements(child, navigationOffsets, start2);
        }
    }

    @Nullable
    public static PsiFile getFile(@NotNull Editor editor) {
        Project proj;
        VirtualFile vf;
        if (editor == null) {
            PsiHelper.$$$reportNull$$$0(5);
        }
        if ((vf = EditorHelper.getVirtualFile(editor)) != null && (proj = editor.getProject()) != null) {
            PsiManager mgr = PsiManager.getInstance((Project)proj);
            return mgr.findFile(vf);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationOffsets";
                break;
            }
        }
        objectArray2[1] = "com/maddyhome/idea/vim/helper/PsiHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodStart";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodEnd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodOrClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addNavigationElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

