/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.helper.SearchHelperKtKt;
import com.maddyhome.idea.vim.helper.SearchOptions;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u001a*\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0000\u001a:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u001a \u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0000\u001aV\u0010\u0000\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u001a\"\u0010\u0018\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0005H\u0003\u001a\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\"\u0010\u001c\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0005H\u0003\u001a.\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0002\u001a.\u0010\"\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010#\u001a\u00020\tH\u0000\u001a0\u0010$\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0003H\u0002\u001a\"\u0010'\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\tH\u0003\u001a\u001a\u0010(\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\tH\u0003\u001a\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\tH\u0003\u00a8\u0006*"}, d2={"updateSearchHighlights", "", "pattern", "", "shouldIgnoreSmartCase", "", "showHighlights", "forceUpdate", "updateIncsearchHighlights", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "count1", "forwards", "caretOffset", "searchRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "addSubstitutionConfirmationHighlight", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "start", "end", "currentEditor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "initialOffset", "shouldRemoveSearchHighlights", "newPattern", "hlSearch", "removeSearchHighlights", "shouldAddAllSearchHighlights", "findClosestMatch", "results", "", "Lcom/maddyhome/idea/vim/common/TextRange;", "count", "highlightSearchResults", "currentMatchOffset", "highlightMatch", "current", "tooltip", "shouldAddCurrentMatchSearchHighlight", "shouldMaintainCurrentMatchOffset", "isIncrementalSearchHighlights", "IdeaVIM"})
@JvmName(name="SearchHighlightsHelper")
@SourceDebugExtension(value={"SMAP\nSearchHighlightsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchHighlightsHelper.kt\ncom/maddyhome/idea/vim/helper/SearchHighlightsHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n774#2:311\n865#2,2:312\n1869#2,2:314\n1056#2:316\n1068#2:317\n360#2,7:318\n360#2,7:325\n*S KotlinDebug\n*F\n+ 1 SearchHighlightsHelper.kt\ncom/maddyhome/idea/vim/helper/SearchHighlightsHelper\n*L\n105#1:311\n105#1:312,2\n110#1:314,2\n221#1:316\n223#1:317\n226#1:318,7\n228#1:325,7\n*E\n"})
public final class SearchHighlightsHelper {
    public static final void updateSearchHighlights(@Nullable String pattern, boolean shouldIgnoreSmartCase, boolean showHighlights, boolean forceUpdate) {
        SearchHighlightsHelper.updateSearchHighlights(null, pattern, 1, shouldIgnoreSmartCase, showHighlights, -1, null, true, forceUpdate);
    }

    public static final int updateIncsearchHighlights(@NotNull Editor editor, @NotNull String pattern, int count1, boolean forwards, int caretOffset, @Nullable LineRange searchRange) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        int searchStartOffset = searchRange != null && searchRange.startLine < editor.getDocument().getLineCount() ? IjVimEditorKt.getVim(editor).getLineStartOffset(searchRange.startLine) : caretOffset;
        boolean showHighlights = VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)IjVimEditorKt.getVim(editor)).getHlsearch();
        return SearchHighlightsHelper.updateSearchHighlights(IjVimEditorKt.getVim(editor), pattern, count1, false, showHighlights, searchStartOffset, searchRange, forwards, false);
    }

    @NotNull
    public static final RangeHighlighter addSubstitutionConfirmationHighlight(@NotNull Editor editor, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextAttributes color = new TextAttributes(editor.getColorsScheme().getColor(EditorColors.SELECTION_FOREGROUND_COLOR), editor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), editor.getColorsScheme().getColor(EditorColors.CARET_COLOR), EffectType.ROUNDED_BOX, 0);
        RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(start2, end, 6000, color, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        return rangeHighlighter;
    }

    /*
     * WARNING - void declaration
     */
    private static final int updateSearchHighlights(VimEditor currentEditor, String pattern, int count1, boolean shouldIgnoreSmartCase, boolean showHighlights, int initialOffset, LineRange searchRange, boolean forwards, boolean forceUpdate) {
        void $this$filterTo$iv$iv;
        int currentEditorCurrentMatchOffset = 0;
        currentEditorCurrentMatchOffset = -1;
        Iterable $this$filter$iv = VimInjectorKt.getInjector().getEditorGroup().getEditors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VimEditor it = (VimEditor)element$iv$iv;
            boolean bl = false;
            if (!(!(!VimInjectorKt.getInjector().getApplication().isUnitTest() && !IjVimEditorKt.getIj(it).getComponent().isShowing() || currentEditor != null && !Intrinsics.areEqual((Object)it.getProjectId(), (Object)currentEditor.getProjectId())))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List editors = (List)destination$iv$iv;
        Iterable $this$forEach$iv = editors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Integer offset;
            VimEditor it = (VimEditor)element$iv;
            boolean bl = false;
            Editor editor = IjVimEditorKt.getIj(it);
            int currentMatchOffset = -1;
            if (SearchHighlightsHelper.shouldRemoveSearchHighlights(editor, pattern, showHighlights) || forceUpdate) {
                SearchHighlightsHelper.removeSearchHighlights(editor);
            }
            if (pattern == null) continue;
            if (SearchHighlightsHelper.shouldAddAllSearchHighlights(editor, pattern, showHighlights)) {
                List results;
                VimEditor vimEditor = IjVimEditorKt.getVim(editor);
                int editorLastLine = vimEditor.lineCount() - 1;
                LineRange lineRange = searchRange;
                int searchStartLine = lineRange != null ? lineRange.startLine : 0;
                LineRange lineRange2 = searchRange;
                int searchEndLine = RangesKt.coerceAtMost((int)(lineRange2 != null ? lineRange2.endLine : -1), (int)editorLastLine);
                if (searchStartLine <= editorLastLine && !((Collection)(results = VimInjectorKt.getInjector().getSearchHelper().findAll(vimEditor, pattern, searchStartLine, searchEndLine, SearchHelperKtKt.shouldIgnoreCase(pattern, shouldIgnoreSmartCase)))).isEmpty()) {
                    VimEditor vimEditor2 = currentEditor;
                    if (editor == (vimEditor2 != null ? IjVimEditorKt.getIj(vimEditor2) : null)) {
                        currentMatchOffset = SearchHighlightsHelper.findClosestMatch(results, initialOffset, count1, forwards);
                    }
                    SearchHighlightsHelper.highlightSearchResults(editor, pattern, results, currentMatchOffset);
                }
                UserDataManager.setVimLastSearch(editor, pattern);
            } else if (SearchHighlightsHelper.shouldAddCurrentMatchSearchHighlight(pattern, showHighlights, initialOffset)) {
                VimEditor vimEditor = currentEditor;
                if (editor == (vimEditor != null ? IjVimEditorKt.getIj(vimEditor) : null)) {
                    TextRange result;
                    EnumSet<Enum> searchOptions = EnumSet.of((Enum)SearchOptions.WHOLE_FILE);
                    if (VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getWrapscan()) {
                        searchOptions.add((Enum)SearchOptions.WRAP);
                    }
                    if (shouldIgnoreSmartCase) {
                        searchOptions.add((Enum)SearchOptions.IGNORE_SMARTCASE);
                    }
                    if (!forwards) {
                        searchOptions.add((Enum)SearchOptions.BACKWARDS);
                    }
                    if ((result = VimInjectorKt.getInjector().getSearchHelper().findPattern(it, pattern, initialOffset, count1, searchOptions)) != null) {
                        if (!EditorExtensionsKt.getInVisualMode((VimEditor)it) && !EditorExtensionsKt.getInCommandLineModeWithVisual((VimEditor)it)) {
                            List results = CollectionsKt.listOf((Object)result);
                            SearchHighlightsHelper.highlightSearchResults(editor, pattern, results, result.getStartOffset());
                        }
                        currentMatchOffset = result.getStartOffset();
                    }
                }
            } else if (SearchHighlightsHelper.shouldMaintainCurrentMatchOffset(pattern, initialOffset) && (offset = UserDataManager.getVimIncsearchCurrentMatchOffset(editor)) != null) {
                VimEditor vimEditor = currentEditor;
                if (editor == (vimEditor != null ? IjVimEditorKt.getIj(vimEditor) : null)) {
                    currentMatchOffset = offset;
                }
            }
            VimEditor vimEditor = currentEditor;
            if (editor != (vimEditor != null ? IjVimEditorKt.getIj(vimEditor) : null)) continue;
            currentEditorCurrentMatchOffset = currentMatchOffset;
        }
        return currentEditorCurrentMatchOffset;
    }

    @Contract(value="_, _, false -> true; _, null, true -> false")
    private static final boolean shouldRemoveSearchHighlights(Editor editor, String newPattern, boolean hlSearch) {
        return !hlSearch || newPattern != null && !Intrinsics.areEqual((Object)newPattern, (Object)UserDataManager.getVimLastSearch(editor));
    }

    private static final void removeSearchHighlights(Editor editor) {
        UserDataManager.setVimLastSearch(editor, null);
        Collection<RangeHighlighter> collection = UserDataManager.getVimLastHighlighters(editor);
        if (collection == null) {
            return;
        }
        Collection<RangeHighlighter> ehl = collection;
        for (RangeHighlighter rh : ehl) {
            editor.getMarkupModel().removeHighlighter(rh);
        }
        UserDataManager.setVimLastHighlighters(editor, null);
    }

    @Contract(value="_, _, false -> false; _, null, true -> false")
    private static final boolean shouldAddAllSearchHighlights(Editor editor, String newPattern, boolean hlSearch) {
        return hlSearch && newPattern != null && !Intrinsics.areEqual((Object)newPattern, (Object)UserDataManager.getVimLastSearch(editor)) && !Intrinsics.areEqual((Object)newPattern, (Object)"");
    }

    private static final int findClosestMatch(List<TextRange> results, int initialOffset, int count, boolean forwards) {
        int closestIndex;
        List sortedResults;
        block11: {
            if (results.isEmpty() || initialOffset == -1) {
                return -1;
            }
            if (forwards) {
                Iterable $this$sortedBy$iv = results;
                boolean $i$f$sortedBy = false;
                v0 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        TextRange it = (TextRange)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStartOffset());
                        it = (TextRange)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
                    }
                });
            } else {
                Iterable $this$sortedByDescending$iv = results;
                boolean $i$f$sortedByDescending = false;
                v0 = sortedResults = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        TextRange it = (TextRange)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStartOffset());
                        it = (TextRange)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
                    }
                });
            }
            if (forwards) {
                $this$indexOfFirst$iv = sortedResults;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    it = (TextRange)item$iv;
                    boolean bl = false;
                    if (it.getStartOffset() > initialOffset) {
                        v1 = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                v1 = -1;
            } else {
                $this$indexOfFirst$iv = sortedResults;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    it = (TextRange)item$iv;
                    boolean bl = false;
                    if (it.getStartOffset() < initialOffset) {
                        v1 = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                v1 = closestIndex = -1;
            }
        }
        if (closestIndex == -1 && !VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getWrapscan()) {
            return -1;
        }
        int nextIndex = RangesKt.coerceAtLeast((int)closestIndex, (int)0) + (count - 1);
        if (nextIndex >= sortedResults.size() && !VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getWrapscan()) {
            return -1;
        }
        return ((TextRange)sortedResults.get(nextIndex % results.size())).getStartOffset();
    }

    public static final void highlightSearchResults(@NotNull Editor editor, @NotNull String pattern, @NotNull List<TextRange> results, int currentMatchOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Collection highlighters = UserDataManager.getVimLastHighlighters(editor);
        if (highlighters == null) {
            highlighters = new ArrayList();
            UserDataManager.setVimLastHighlighters(editor, highlighters);
        }
        for (TextRange range : results) {
            boolean current = range.getStartOffset() == currentMatchOffset;
            RangeHighlighter highlighter = SearchHighlightsHelper.highlightMatch(editor, range.getStartOffset(), range.getEndOffset(), current, pattern);
            highlighters.add(highlighter);
        }
        UserDataManager.setVimIncsearchCurrentMatchOffset(editor, currentMatchOffset);
    }

    private static final RangeHighlighter highlightMatch(Editor editor, int start2, int end, boolean current, String tooltip) {
        RangeHighlighter rangeHighlighter;
        TextAttributes textAttributes;
        int layer = 5999;
        HighlighterTargetArea targetArea = HighlighterTargetArea.EXACT_RANGE;
        if (!current) {
            RangeHighlighter rangeHighlighter2 = editor.getMarkupModel().addRangeHighlighter(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES, start2, end, layer, targetArea);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
            RangeHighlighter highlighter = rangeHighlighter2;
            highlighter.setErrorStripeTooltip((Object)tooltip);
            return highlighter;
        }
        TextAttributes $this$highlightMatch_u24lambda_u246 = textAttributes = editor.getColorsScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).clone();
        boolean bl = false;
        $this$highlightMatch_u24lambda_u246.setEffectType(EffectType.ROUNDED_BOX);
        $this$highlightMatch_u24lambda_u246.setEffectColor(editor.getColorsScheme().getColor(EditorColors.CARET_COLOR));
        TextAttributes textAttributes2 = textAttributes;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"apply(...)");
        TextAttributes attributes = textAttributes2;
        RangeHighlighter rangeHighlighter3 = editor.getMarkupModel().addRangeHighlighter(start2, end, layer, attributes, targetArea);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter3, (String)"addRangeHighlighter(...)");
        RangeHighlighter $this$highlightMatch_u24lambda_u247 = rangeHighlighter = rangeHighlighter3;
        boolean bl2 = false;
        $this$highlightMatch_u24lambda_u247.setErrorStripeTooltip((Object)tooltip);
        return rangeHighlighter;
    }

    @Contract(value="_, true, _ -> false")
    private static final boolean shouldAddCurrentMatchSearchHighlight(String pattern, boolean hlSearch, int initialOffset) {
        CharSequence charSequence;
        return !hlSearch && SearchHighlightsHelper.isIncrementalSearchHighlights(initialOffset) && !((charSequence = (CharSequence)pattern) == null || charSequence.length() == 0);
    }

    @Contract(value="null, _ -> false")
    private static final boolean shouldMaintainCurrentMatchOffset(String pattern, int initialOffset) {
        CharSequence charSequence = pattern;
        return !(charSequence == null || charSequence.length() == 0) && SearchHighlightsHelper.isIncrementalSearchHighlights(initialOffset);
    }

    @Contract(pure=true)
    private static final boolean isIncrementalSearchHighlights(int initialOffset) {
        return initialOffset != -1;
    }
}

