/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.PlatformUtils;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimScrollingModel;
import com.maddyhome.idea.vim.common.ChangesListener;
import com.maddyhome.idea.vim.common.InsertSequence;
import com.maddyhome.idea.vim.helper.UndoRedoHelper;
import com.maddyhome.idea.vim.newapi.IjVimCaret;
import com.maddyhome.idea.vim.newapi.IjVimCaretKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.undo.VimTimestampBasedUndoService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 .2\u00020\u0001:\u0002./B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u001aH\u0016J \u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0)H\u0002J%\u0010*\u001a\u00020\u000e*\u00020\u00072\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u000e0+\u00a2\u0006\u0002\b-H\u0002\u00a8\u00060"}, d2={"Lcom/maddyhome/idea/vim/helper/UndoRedoHelper;", "Lcom/maddyhome/idea/vim/undo/VimTimestampBasedUndoService;", "<init>", "()V", "undo", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "getTextEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "Lcom/intellij/openapi/editor/Editor;", "performUndo", "", "undoManager", "Lcom/intellij/openapi/command/undo/UndoManager;", "fileEditor", "hasSelection", "redo", "startInsertSequence", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "startOffset", "", "startNanoTime", "", "endInsertSequence", "endOffset", "endNanoTime", "abandonCurrentInsertSequence", "getInsertSequence", "Lcom/maddyhome/idea/vim/common/InsertSequence;", "nanoTime", "performRedo", "removeSelections", "runWithBooleanRegistryOption", "option", "", "value", "block", "Lkotlin/Function0;", "runWithChangeTracking", "Lkotlin/Function1;", "Lcom/maddyhome/idea/vim/helper/UndoRedoHelper$ChangeTracker;", "Lkotlin/ExtensionFunctionType;", "Companion", "ChangeTracker", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nUndoRedoHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UndoRedoHelper.kt\ncom/maddyhome/idea/vim/helper/UndoRedoHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,245:1\n1869#2,2:246\n1869#2,2:248\n15#3:250\n*S KotlinDebug\n*F\n+ 1 UndoRedoHelper.kt\ncom/maddyhome/idea/vim/helper/UndoRedoHelper\n*L\n201#1:246,2\n161#1:248,2\n40#1:250\n*E\n"})
public final class UndoRedoHelper
implements VimTimestampBasedUndoService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public boolean undo(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (PlatformUtils.isJetBrainsClient()) {
            return VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, VimInjectorKt.getInjector().getActionExecutor().getACTION_UNDO(), context);
        }
        Object object = context.getContext();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DataContext");
        DataContext ijContext = (DataContext)object;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(ijContext);
        if (project == null) {
            return false;
        }
        Project project2 = project;
        TextEditor textEditor = this.getTextEditor(IjVimEditorKt.getIj(editor));
        UndoManager undoManager = UndoManager.getInstance((Project)project2);
        if (undoManager.isUndoAvailable((FileEditor)textEditor)) {
            VimScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.accumulateViewportChanges();
            Intrinsics.checkNotNull((Object)undoManager);
            this.performUndo(editor, undoManager, textEditor);
            scrollingModel.flushViewportChanges();
            return true;
        }
        return false;
    }

    private final TextEditor getTextEditor(Editor editor) {
        TextEditor currentTextEditor = TextEditorProvider.Companion.getInstance().getTextEditor(editor);
        TextEditorWithPreview textEditorWithPreview = TextEditorWithPreview.Companion.getParentSplitEditor((FileEditor)currentTextEditor);
        TextEditor textEditor = textEditorWithPreview instanceof TextEditor ? (TextEditor)textEditorWithPreview : null;
        if (textEditor == null) {
            textEditor = currentTextEditor;
        }
        return textEditor;
    }

    private final void performUndo(VimEditor editor, UndoManager undoManager, TextEditor fileEditor) {
        if (IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getOldundo()) {
            this.runWithChangeTracking(editor, (Function1<? super ChangeTracker, Unit>)((Function1)arg_0 -> UndoRedoHelper.performUndo$lambda$0(undoManager, fileEditor, this, editor, arg_0)));
            CommandProcessor.getInstance().runUndoTransparentAction(() -> UndoRedoHelper.performUndo$lambda$1(this, editor));
        } else {
            this.runWithBooleanRegistryOption("ide.undo.transparent.caret.movement", true, (Function0<Unit>)((Function0)() -> UndoRedoHelper.performUndo$lambda$2(undoManager, fileEditor, editor)));
            CommandProcessor.getInstance().runUndoTransparentAction(() -> UndoRedoHelper.performUndo$lambda$3(this, editor));
        }
    }

    private final boolean hasSelection(VimEditor editor) {
        return IjVimCaretKt.getIj(editor.primaryCaret()).hasSelection();
    }

    public boolean redo(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (PlatformUtils.isJetBrainsClient()) {
            return VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, VimInjectorKt.getInjector().getActionExecutor().getACTION_REDO(), context);
        }
        Object object = context.getContext();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DataContext");
        DataContext ijContext = (DataContext)object;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(ijContext);
        if (project == null) {
            return false;
        }
        Project project2 = project;
        TextEditor textEditor = this.getTextEditor(IjVimEditorKt.getIj(editor));
        UndoManager undoManager = UndoManager.getInstance((Project)project2);
        if (undoManager.isRedoAvailable((FileEditor)textEditor)) {
            Intrinsics.checkNotNull((Object)undoManager);
            this.performRedo(undoManager, textEditor, editor);
            return true;
        }
        return false;
    }

    public void startInsertSequence(@NotNull VimCaret caret, int startOffset, long startNanoTime) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        ((IjVimCaret)caret).startInsertSequence$IdeaVIM(startOffset, startNanoTime);
    }

    public void endInsertSequence(@NotNull VimCaret caret, int endOffset, long endNanoTime) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        ((IjVimCaret)caret).endInsertSequence$IdeaVIM(endOffset, endNanoTime);
    }

    public void abandonCurrentInsertSequence(@NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        ((IjVimCaret)caret).abandonCurrentInsertSequece$IdeaVIM();
    }

    @Nullable
    public InsertSequence getInsertSequence(@NotNull VimCaret caret, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return ((IjVimCaret)caret).getInsertSequenceForTime$IdeaVIM(nanoTime);
    }

    private final void performRedo(UndoManager undoManager, TextEditor fileEditor, VimEditor editor) {
        if (IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getOldundo()) {
            undoManager.redo((FileEditor)fileEditor);
            CommandProcessor.getInstance().runUndoTransparentAction(() -> UndoRedoHelper.performRedo$lambda$5(editor));
            this.runWithChangeTracking(editor, (Function1<? super ChangeTracker, Unit>)((Function1)arg_0 -> UndoRedoHelper.performRedo$lambda$6(undoManager, fileEditor, this, editor, arg_0)));
            CommandProcessor.getInstance().runUndoTransparentAction(() -> UndoRedoHelper.performRedo$lambda$7(this, editor));
        } else {
            this.runWithBooleanRegistryOption("ide.undo.transparent.caret.movement", true, (Function0<Unit>)((Function0)() -> UndoRedoHelper.performRedo$lambda$8(undoManager, fileEditor, editor)));
            CommandProcessor.getInstance().runUndoTransparentAction(() -> UndoRedoHelper.performRedo$lambda$9(this, editor));
        }
    }

    private final void removeSelections(VimEditor editor) {
        Iterable $this$forEach$iv = editor.carets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimCaret it = (VimCaret)element$iv;
            boolean bl = false;
            Caret ijCaret = IjVimCaretKt.getIj(it);
            if (!ijCaret.hasSelection()) continue;
            int selectionStart = ijCaret.getSelectionStart();
            ijCaret.removeSelection();
            ijCaret.moveToOffset(selectionStart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runWithBooleanRegistryOption(String option, boolean value, Function0<Unit> block) {
        RegistryValue registry = Registry.Companion.get(option);
        boolean oldValue = registry.asBoolean();
        registry.setValue(value);
        try {
            block.invoke();
        }
        finally {
            registry.setValue(oldValue);
        }
    }

    private final void runWithChangeTracking(VimEditor $this$runWithChangeTracking, Function1<? super ChangeTracker, Unit> block) {
        ChangeTracker tracker = new ChangeTracker($this$runWithChangeTracking);
        block.invoke((Object)tracker);
    }

    private static final Unit performUndo$lambda$0(UndoManager $undoManager, TextEditor $fileEditor, UndoRedoHelper this$0, VimEditor $editor, ChangeTracker $this$runWithChangeTracking) {
        Intrinsics.checkNotNullParameter((Object)$this$runWithChangeTracking, (String)"$this$runWithChangeTracking");
        $undoManager.undo((FileEditor)$fileEditor);
        if (!$this$runWithChangeTracking.getHasChanges() && this$0.hasSelection($editor) && $undoManager.isUndoAvailable((FileEditor)$fileEditor)) {
            $undoManager.undo((FileEditor)$fileEditor);
        }
        return Unit.INSTANCE;
    }

    private static final void performUndo$lambda$1(UndoRedoHelper this$0, VimEditor $editor) {
        this$0.removeSelections($editor);
    }

    private static final Unit performUndo$lambda$2(UndoManager $undoManager, TextEditor $fileEditor, VimEditor $editor) {
        long nextUndoNanoTime = $undoManager.getNextUndoNanoTime((FileEditor)$fileEditor);
        VimCaret vimCaret = $editor.primaryCaret();
        Intrinsics.checkNotNull((Object)vimCaret, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.newapi.IjVimCaret");
        InsertSequence insertInfo = ((IjVimCaret)vimCaret).getInsertSequenceForTime$IdeaVIM(nextUndoNanoTime);
        if (insertInfo == null || $undoManager.isNextUndoAskConfirmation((FileEditor)$fileEditor)) {
            $undoManager.undo((FileEditor)$fileEditor);
        } else {
            while (insertInfo.contains(nextUndoNanoTime)) {
                $undoManager.undo((FileEditor)$fileEditor);
                nextUndoNanoTime = $undoManager.getNextUndoNanoTime((FileEditor)$fileEditor);
                if (!$undoManager.isNextUndoAskConfirmation((FileEditor)$fileEditor)) continue;
                break;
            }
        }
        return Unit.INSTANCE;
    }

    private static final void performUndo$lambda$3(UndoRedoHelper this$0, VimEditor $editor) {
        this$0.removeSelections($editor);
    }

    private static final void performRedo$lambda$5(VimEditor $editor) {
        Iterable $this$forEach$iv = $editor.carets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimCaret it = (VimCaret)element$iv;
            boolean bl = false;
            IjVimCaretKt.getIj(it).removeSelection();
        }
    }

    private static final Unit performRedo$lambda$6(UndoManager $undoManager, TextEditor $fileEditor, UndoRedoHelper this$0, VimEditor $editor, ChangeTracker $this$runWithChangeTracking) {
        Intrinsics.checkNotNullParameter((Object)$this$runWithChangeTracking, (String)"$this$runWithChangeTracking");
        $undoManager.redo((FileEditor)$fileEditor);
        if (!$this$runWithChangeTracking.getHasChanges() && this$0.hasSelection($editor) && $undoManager.isRedoAvailable((FileEditor)$fileEditor)) {
            $undoManager.redo((FileEditor)$fileEditor);
        }
        return Unit.INSTANCE;
    }

    private static final void performRedo$lambda$7(UndoRedoHelper this$0, VimEditor $editor) {
        this$0.removeSelections($editor);
    }

    private static final Unit performRedo$lambda$8(UndoManager $undoManager, TextEditor $fileEditor, VimEditor $editor) {
        long nextRedoNanoTime = $undoManager.getNextRedoNanoTime((FileEditor)$fileEditor);
        VimCaret vimCaret = $editor.primaryCaret();
        Intrinsics.checkNotNull((Object)vimCaret, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.newapi.IjVimCaret");
        InsertSequence insertInfo = ((IjVimCaret)vimCaret).getInsertSequenceForTime$IdeaVIM(nextRedoNanoTime);
        if (insertInfo == null || $undoManager.isNextRedoAskConfirmation((FileEditor)$fileEditor)) {
            $undoManager.redo((FileEditor)$fileEditor);
        } else {
            while (insertInfo.contains(nextRedoNanoTime)) {
                $undoManager.redo((FileEditor)$fileEditor);
                nextRedoNanoTime = $undoManager.getNextRedoNanoTime((FileEditor)$fileEditor);
                if (!$undoManager.isNextRedoAskConfirmation((FileEditor)$fileEditor)) continue;
                break;
            }
        }
        return Unit.INSTANCE;
    }

    private static final void performRedo$lambda$9(UndoRedoHelper this$0, VimEditor $editor) {
        this$0.removeSelections($editor);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UndoRedoHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UndoRedoHelper.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003*\u0001\t\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/helper/UndoRedoHelper$ChangeTracker;", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "<init>", "(Lcom/maddyhome/idea/vim/api/VimEditor;)V", "initialPath", "", "changeListener", "com/maddyhome/idea/vim/helper/UndoRedoHelper$ChangeTracker$changeListener$1", "Lcom/maddyhome/idea/vim/helper/UndoRedoHelper$ChangeTracker$changeListener$1;", "hasChanges", "", "getHasChanges", "()Z", "IdeaVIM"})
    private static final class ChangeTracker {
        @NotNull
        private final VimEditor editor;
        @Nullable
        private final String initialPath;
        @NotNull
        private final changeListener.1 changeListener;

        public ChangeTracker(@NotNull VimEditor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.initialPath = this.editor.getPath();
            this.changeListener = new ChangesListener(){
                private boolean hasChanged;

                public final boolean getHasChanged() {
                    return this.hasChanged;
                }

                public final void setHasChanged(boolean bl) {
                    this.hasChanged = bl;
                }

                public void documentChanged(ChangesListener.Change change) {
                    Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                    this.hasChanged = true;
                }
            };
            this.editor.getDocument().addChangeListener((ChangesListener)this.changeListener);
        }

        public final boolean getHasChanges() {
            return this.changeListener.getHasChanged() || !Intrinsics.areEqual((Object)this.initialPath, (Object)this.editor.getPath());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/helper/UndoRedoHelper$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

