/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.listener;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.LastUsedEditorInfo;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.EditorListener;
import com.maddyhome.idea.vim.helper.CommandStateHelper;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/listener/IJEditorFocusListener;", "Lcom/maddyhome/idea/vim/common/EditorListener;", "<init>", "()V", "focusGained", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "IdeaVIM"})
public final class IJEditorFocusListener
implements EditorListener {
    public void focusGained(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        LastUsedEditorInfo oldEditorInfo = KeyHandler.Companion.getInstance().getLastUsedEditorInfo();
        int currentEditorHashCode = IjVimEditorKt.getIj(editor).hashCode();
        if (oldEditorInfo.getHash() == currentEditorHashCode) {
            return;
        }
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        boolean isCurrentEditorTerminal = EditorHelperRt.isTerminalEditor(ijEditor);
        KeyHandler.Companion.getInstance().setLastUsedEditorInfo(new LastUsedEditorInfo(currentEditorHashCode, false));
        Runnable switchToInsertMode = () -> IJEditorFocusListener.focusGained$lambda$0(editor, currentEditorHashCode);
        if (isCurrentEditorTerminal && !CommandStateHelper.inInsertMode(ijEditor)) {
            switchToInsertMode.run();
        } else if (ijEditor.isInsertMode() && (oldEditorInfo.isInsertModeForced() || !ijEditor.getDocument().isWritable())) {
            ExecutionContext context = VimInjectorKt.getInjector().getExecutionContextManager().getEditorExecutionContext(editor);
            Mode mode2 = VimInjectorKt.getInjector().getVimState().getMode();
            if (mode2 instanceof Mode.INSERT) {
                editor.exitInsertMode(context);
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> IJEditorFocusListener.focusGained$lambda$1(ijEditor, switchToInsertMode, editor));
        KeyHandler.Companion.getInstance().reset(editor);
    }

    public void created(@NotNull VimEditor editor) {
        super.created(editor);
    }

    public void released(@NotNull VimEditor editor) {
        super.released(editor);
    }

    public void focusLost(@NotNull VimEditor editor) {
        super.focusLost(editor);
    }

    private static final void focusGained$lambda$0(VimEditor $editor, int $currentEditorHashCode) {
        ExecutionContext context = VimInjectorKt.getInjector().getExecutionContextManager().getEditorExecutionContext($editor);
        VimPlugin.getChange().insertBeforeCaret($editor, context);
        KeyHandler.Companion.getInstance().setLastUsedEditorInfo(new LastUsedEditorInfo($currentEditorHashCode, true));
    }

    private static final void focusGained$lambda$1(Editor $ijEditor, Runnable $switchToInsertMode, VimEditor $editor) {
        if ($ijEditor.isDisposed()) {
            return;
        }
        ConsoleViewImpl consoleView = (ConsoleViewImpl)$ijEditor.getUserData(ConsoleViewImpl.CONSOLE_VIEW_IN_EDITOR_VIEW);
        if (consoleView != null && consoleView.isRunning() && !CommandStateHelper.inInsertMode($ijEditor)) {
            $switchToInsertMode.run();
            KeyHandler.Companion.getInstance().reset($editor);
        }
    }
}

