/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.listener;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManagerListener;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.find.FindModelListener;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.VimShortcutKeyAction;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.group.ChangeGroup;
import com.maddyhome.idea.vim.group.NotificationService;
import com.maddyhome.idea.vim.group.RegisterGroup;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.undo.VimTimestampBasedUndoService;
import com.maddyhome.idea.vim.undo.VimUndoRedo;
import com.maddyhome.idea.vim.vimscript.model.options.helpers.IdeaRefactorModeHelper;
import com.maddyhome.idea.vim.vimscript.model.options.helpers.IdeaRefactorModeHelperKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics;", "", "<init>", "()V", "VimActionListener", "VimTemplateManagerListener", "LookupTopicListener", "VimFindModelListener", "IdeaVIM"})
public final class IdeaSpecifics {
    @NotNull
    public static final IdeaSpecifics INSTANCE = new IdeaSpecifics();

    private IdeaSpecifics() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$LookupTopicListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "<init>", "()V", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "IdeaVIM"})
    public static final class LookupTopicListener
    implements LookupManagerListener {
        public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            if (oldLookup == null && newLookup instanceof LookupImpl) {
                Editor editor = ((LookupImpl)newLookup).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                if (EditorHelperRt.isIdeaVimDisabledHere(editor)) {
                    return;
                }
                VimPlugin.getKey().registerShortcutsForLookup((LookupImpl)newLookup);
            }
            if (oldLookup != null && newLookup == null) {
                Editor editor = oldLookup.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                if (EditorHelperRt.isIdeaVimDisabledHere(editor2)) {
                    return;
                }
                KeyHandler.Companion.getInstance().partialReset(IjVimEditorKt.getVim(editor2));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$VimActionListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "<init>", "()V", "surrounderItems", "", "", "surrounderAction", "editor", "Lcom/intellij/openapi/editor/Editor;", "completionPrevDocumentLength", "", "Ljava/lang/Integer;", "completionPrevDocumentOffset", "beforeActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "afterActionPerformed", "result", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nIdeaSpecifics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaSpecifics.kt\ncom/maddyhome/idea/vim/listener/IdeaSpecifics$VimActionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,262:1\n1869#2,2:263\n1761#2,3:271\n10135#3:265\n10557#3,5:266\n*S KotlinDebug\n*F\n+ 1 IdeaSpecifics.kt\ncom/maddyhome/idea/vim/listener/IdeaSpecifics$VimActionListener\n*L\n79#1:263,2\n158#1:271,3\n94#1:265\n94#1:266,5\n*E\n"})
    public static final class VimActionListener
    implements AnActionListener {
        @NonNls
        @NotNull
        private final List<String> surrounderItems;
        @NotNull
        private final String surrounderAction;
        @Nullable
        private Editor editor;
        @Nullable
        private Integer completionPrevDocumentLength;
        @Nullable
        private Integer completionPrevDocumentOffset;

        public VimActionListener() {
            Object[] objectArray = new String[]{"if", "if / else", "for"};
            this.surrounderItems = CollectionsKt.listOf((Object[])objectArray);
            this.surrounderAction = "com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler$InvokeSurrounderAction";
        }

        /*
         * WARNING - void declaration
         */
        public void beforeActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event) {
            LookupEx lookup;
            VimCaret it;
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            Editor hostEditor = (Editor)event.getDataContext().getData(CommonDataKeys.HOST_EDITOR);
            if (hostEditor != null) {
                this.editor = hostEditor;
            }
            AnActionWrapper anActionWrapper = action instanceof AnActionWrapper ? (AnActionWrapper)action : null;
            boolean isVimAction = (anActionWrapper != null ? anActionWrapper.getDelegate() : null) instanceof VimShortcutKeyAction;
            if (!isVimAction && Intrinsics.areEqual((Object)VimInjectorKt.getInjector().getVimState().getMode(), (Object)Mode.INSERT.INSTANCE) && !(action instanceof EnterAction)) {
                VimUndoRedo vimUndoRedo = VimInjectorKt.getInjector().getUndo();
                Intrinsics.checkNotNull((Object)vimUndoRedo, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.undo.VimTimestampBasedUndoService");
                VimTimestampBasedUndoService undoService = (VimTimestampBasedUndoService)vimUndoRedo;
                long nanoTime = System.nanoTime();
                Object object = this.editor;
                if (object != null && (object = IjVimEditorKt.getVim(object)) != null && (object = object.nativeCarets()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (VimCaret)element$iv;
                        boolean bl = false;
                        undoService.endInsertSequence(it, it.getOffset(), nanoTime);
                    }
                }
            }
            if (!isVimAction && IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getTrackactionids() && !(action instanceof NotificationService.ActionIdNotifier.CopyActionId) && !(action instanceof NotificationService.ActionIdNotifier.StopTracking)) {
                List list;
                String id;
                String string = ActionManager.getInstance().getId(action);
                if (string == null) {
                    ShortcutSet shortcutSet = action.getShortcutSet();
                    ProxyShortcutSet proxyShortcutSet = shortcutSet instanceof ProxyShortcutSet ? (ProxyShortcutSet)shortcutSet : null;
                    string = proxyShortcutSet != null ? proxyShortcutSet.getActionId() : null;
                }
                if ((id = string) == null) {
                    void $this$flatMapTo$iv$iv;
                    Shortcut[] shortcutArray = action.getShortcutSet().getShortcuts();
                    Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
                    Object[] $this$flatMap$iv = shortcutArray;
                    boolean $i$f$flatMap = false;
                    Object[] objectArray = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (Shortcut)element$iv$iv;
                        boolean bl = false;
                        List list2 = KeymapManager.getInstance().getActiveKeymap().getActionIdList((Shortcut)it);
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getActionIdList(...)");
                        Iterable list$iv$iv = list2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List candidates = list;
                String intentionName = action instanceof ApplyIntentionAction ? ((ApplyIntentionAction)action).getName() : null;
                VimPlugin.getNotifications((Project)event.getDataContext().getData(CommonDataKeys.PROJECT)).notifyActionId(id, candidates, intentionName);
            }
            if (hostEditor != null && action instanceof ChooseItemAction && VimInjectorKt.getInjector().getRegisterGroup().isRecording() && (lookup = LookupManager.getActiveLookup((Editor)hostEditor)) != null) {
                int charsToRemove = hostEditor.getCaretModel().getPrimaryCaret().getOffset() - lookup.getLookupStart();
                RegisterGroup registerGroup = VimPlugin.getRegister();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)registerGroup), (String)"getRegister(...)");
                RegisterGroup register = registerGroup;
                KeyStroke backSpace = KeyStroke.getKeyStroke(8, 0);
                int n = 0;
                while (n < charsToRemove) {
                    int it2 = n++;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)backSpace);
                    register.recordKeyStroke(backSpace);
                }
                this.completionPrevDocumentLength = hostEditor.getDocument().getTextLength() - charsToRemove;
                this.completionPrevDocumentOffset = lookup.getLookupStart();
            }
        }

        public void afterActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event, @NotNull AnActionResult result) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            Editor editor = this.editor;
            if (editor != null && action instanceof ChooseItemAction && VimInjectorKt.getInjector().getRegisterGroup().isRecording()) {
                Integer prevDocumentLength = this.completionPrevDocumentLength;
                Integer prevDocumentOffset = this.completionPrevDocumentOffset;
                if (prevDocumentLength != null && prevDocumentOffset != null) {
                    RegisterGroup registerGroup = VimPlugin.getRegister();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)registerGroup), (String)"getRegister(...)");
                    RegisterGroup register = registerGroup;
                    int addedTextLength = editor.getDocument().getTextLength() - prevDocumentLength;
                    int caretShift = addedTextLength - (editor.getCaretModel().getPrimaryCaret().getOffset() - prevDocumentOffset);
                    KeyStroke leftArrow = KeyStroke.getKeyStroke(37, 0);
                    String string = editor.getDocument().getText(new TextRange(prevDocumentOffset.intValue(), prevDocumentOffset + addedTextLength));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    register.recordText(string);
                    int n = RangesKt.coerceAtLeast((int)caretShift, (int)0);
                    int n2 = 0;
                    while (n2 < n) {
                        int it = n2++;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)leftArrow);
                        register.recordKeyStroke(leftArrow);
                    }
                }
                this.completionPrevDocumentLength = null;
                this.completionPrevDocumentOffset = null;
            }
            if (Intrinsics.areEqual((Object)this.surrounderAction, (Object)action.getClass().getName())) {
                boolean bl;
                block10: {
                    Iterable $this$any$iv = this.surrounderItems;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            String string = action.getTemplatePresentation().getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            if (!StringsKt.endsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    Editor editor2 = editor;
                    if (editor2 != null) {
                        Editor it = editor2;
                        boolean bl3 = false;
                        IjVimEditorKt.getVim(it).setMode((Mode)new Mode.NORMAL(null, 1, null));
                        ChangeGroup changeGroup = VimPlugin.getChange();
                        VimEditor vimEditor = IjVimEditorKt.getVim(it);
                        DataContext dataContext = event.getDataContext();
                        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                        changeGroup.insertBeforeCaret(vimEditor, IjEditorExecutionContextKt.getVim(dataContext));
                        KeyHandler.Companion.getInstance().reset(IjVimEditorKt.getVim(it));
                    }
                }
            }
            this.editor = null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$VimFindModelListener;", "Lcom/intellij/find/FindModelListener;", "<init>", "()V", "findNextModelChanged", "", "IdeaVIM"})
    public static final class VimFindModelListener
    implements FindModelListener {
        public void findNextModelChanged() {
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            VimPlugin.getSearch().clearSearchHighlight();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$VimTemplateManagerListener;", "Lcom/intellij/codeInsight/template/TemplateManagerListener;", "<init>", "()V", "templateStarted", "", "state", "Lcom/intellij/codeInsight/template/impl/TemplateState;", "IdeaVIM"})
    public static final class VimTemplateManagerListener
    implements TemplateManagerListener {
        public void templateStarted(@NotNull TemplateState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            Editor editor = state.getEditor();
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            state.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

                public void currentVariableChanged(TemplateState templateState, Template template, int oldIndex, int newIndex) {
                    Intrinsics.checkNotNullParameter((Object)templateState, (String)"templateState");
                    Editor editor = templateState.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    if (IdeaRefactorModeHelperKt.isIdeaRefactorModeKeep(IjVimEditorKt.getVim(editor))) {
                        Editor editor2 = templateState.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                        IdeaRefactorModeHelper.INSTANCE.correctSelection(editor2);
                    }
                }
            });
            Editor editor3 = state.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
            if (IdeaRefactorModeHelperKt.isIdeaRefactorModeKeep(IjVimEditorKt.getVim(editor3))) {
                IdeaRefactorModeHelper.INSTANCE.correctSelection(editor2);
            } else if (!editor2.getSelectionModel().hasSelection() && EditorExtensionsKt.getInNormalMode((VimEditor)IjVimEditorKt.getVim(editor2))) {
                VimPlugin.getChange().insertBeforeCaret(IjVimEditorKt.getVim(editor2), VimInjectorKt.getInjector().getExecutionContextManager().getEditorExecutionContext(IjVimEditorKt.getVim(editor2)));
                KeyHandler.Companion.getInstance().reset(IjVimEditorKt.getVim(editor2));
            }
        }
    }
}

