/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.troubleshooting;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.PlatformUtils;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.icons.VimIcons;
import com.maddyhome.idea.vim.troubleshooting.AccidentalInstallDetectorKt;
import com.maddyhome.idea.vim.troubleshooting.CommandsCounter;
import com.maddyhome.idea.vim.vimscript.services.VimRcService;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/troubleshooting/AccidentalInstallDetectorEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getText", "", "IdeaVIM"})
public final class AccidentalInstallDetectorEditorNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CommandsCounter.INSTANCE.init();
        if (!PlatformUtils.isGoIde()) {
            return null;
        }
        if (AccidentalInstallDetectorKt.access$getWarningExplicitlyDisabled$p()) {
            return null;
        }
        if (VimPlugin.isNotEnabled()) {
            return null;
        }
        if (VimRcService.findIdeaVimRc() != null) {
            return null;
        }
        if (!VimInjectorKt.getInjector().getEnabler().isNewIdeaVimUser()) {
            return null;
        }
        return arg_0 -> AccidentalInstallDetectorEditorNotificationProvider.collectNotificationData$lambda$3(this, project, arg_0);
    }

    private final String getText() {
        return "<html>You\u2019re using the IdeaVim plugin. If you\u2019re not familiar with Vim, consider disabling it. This message will disappear after " + CommandsCounter.INSTANCE.getCommandsBeforeAutoDisable() + " commands.</html>";
    }

    private static final Unit collectNotificationData$lambda$3$lambda$0(Project $project, AccidentalInstallDetectorEditorNotificationProvider this$0, EditorNotificationPanel $panel) {
        if (CommandsCounter.INSTANCE.getCommandsBeforeAutoDisable() <= 0) {
            KeyHandler.Companion.getInstance().removeAllCommandListeners();
            EditorNotifications.getInstance((Project)$project).removeNotificationsForProvider((EditorNotificationProvider)this$0);
        }
        $panel.setText(this$0.getText());
        $panel.invalidate();
        $panel.repaint();
        return Unit.INSTANCE;
    }

    private static final void collectNotificationData$lambda$3$lambda$1(Project $project, AccidentalInstallDetectorEditorNotificationProvider this$0) {
        VimPlugin.setEnabled(false);
        VimPlugin.getNotifications($project).showReenableNotification($project);
        EditorNotifications.getInstance((Project)$project).removeNotificationsForProvider((EditorNotificationProvider)this$0);
        AccidentalInstallDetectorKt.access$setWarningExplicitlyDisabled$p(true);
    }

    private static final void collectNotificationData$lambda$3$lambda$2(Project $project, AccidentalInstallDetectorEditorNotificationProvider this$0) {
        EditorNotifications.getInstance((Project)$project).removeNotificationsForProvider((EditorNotificationProvider)this$0);
        AccidentalInstallDetectorKt.access$setWarningExplicitlyDisabled$p(true);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$3(AccidentalInstallDetectorEditorNotificationProvider this$0, Project $project, FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
        panel2.setText(this$0.getText());
        panel2.icon(VimIcons.IDEAVIM);
        KeyHandler.Companion.getInstance().addCommandListener(() -> AccidentalInstallDetectorEditorNotificationProvider.collectNotificationData$lambda$3$lambda$0($project, this$0, panel2));
        panel2.createActionLabel("Disable IdeaVim", () -> AccidentalInstallDetectorEditorNotificationProvider.collectNotificationData$lambda$3$lambda$1($project, this$0));
        panel2.createActionLabel("Dismiss", () -> AccidentalInstallDetectorEditorNotificationProvider.collectNotificationData$lambda$3$lambda$2($project, this$0));
        return panel2;
    }
}

