/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.EngineStringHelper;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0000X\u0081T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0000X\u0081T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/ui/ShowCmd;", "", "<init>", "()V", "SHOWCMD_COLS", "", "ID", "", "displayName", "update", "", "getWidgetText", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFullText", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nShowCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowCmd.kt\ncom/maddyhome/idea/vim/ui/ShowCmd\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,153:1\n13472#2,2:154\n*S KotlinDebug\n*F\n+ 1 ShowCmd.kt\ncom/maddyhome/idea/vim/ui/ShowCmd\n*L\n48#1:154,2\n*E\n"})
public final class ShowCmd {
    @NotNull
    public static final ShowCmd INSTANCE = new ShowCmd();
    private static final int SHOWCMD_COLS = 10;
    @NonNls
    @NotNull
    public static final String ID = "IdeaVimShowCmd";
    @NlsSafe
    @NotNull
    public static final String displayName = "IdeaVim showcmd";

    private ShowCmd() {
    }

    public final void update() {
        WindowManager windowManager = WindowManager.getInstance();
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            StatusBar statusBar = windowManager.getStatusBar(it);
            statusBar.updateWidget(ID);
        }
    }

    @NotNull
    public final String getWidgetText(@Nullable Editor editor) {
        return StringsKt.takeLast((String)this.getFullText(editor), (int)10);
    }

    @NotNull
    public final String getFullText(@Nullable Editor editor) {
        if (!VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getShowcmd() || editor == null || editor.isDisposed()) {
            return "";
        }
        KeyHandlerState keyState = KeyHandler.Companion.getInstance().getKeyHandlerState();
        return EngineStringHelper.INSTANCE.toPrintableCharacters(CollectionsKt.plus((Iterable)keyState.getCommandBuilder().getKeys(), (Iterable)keyState.getMappingState().getKeys()));
    }
}

