/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ui.JBUI;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimCommandLineCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.EngineStringHelper;
import com.maddyhome.idea.vim.helper.UiHelper;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContext;
import com.maddyhome.idea.vim.options.helpers.GuiCursorAttributes;
import com.maddyhome.idea.vim.options.helpers.GuiCursorMode;
import com.maddyhome.idea.vim.options.helpers.GuiCursorOptionHelper;
import com.maddyhome.idea.vim.options.helpers.GuiCursorType;
import com.maddyhome.idea.vim.ui.ex.ExDocument;
import com.maddyhome.idea.vim.ui.ex.ExEditorKit;
import com.maddyhome.idea.vim.ui.ex.ExEntryPanel;
import com.maddyhome.idea.vim.ui.ex.ExTextFieldUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.Objects;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ExTextField
extends JTextField {
    private final ExEntryPanel myParentPanel;
    private final CommandLineCaret caret;
    int currentActionPromptCharacterOffset = -1;
    private static final Logger logger = Logger.getInstance((String)ExTextField.class.getName());

    ExTextField(ExEntryPanel parentPanel) {
        this.myParentPanel = parentPanel;
        this.caret = new CommandLineCaret();
        this.caret.setBlinkRate(this.getCaret().getBlinkRate());
        this.setCaret(this.caret);
        this.setNormalModeCaret();
        Style defaultStyle = ((StyledDocument)this.getDocument()).getStyle("default");
        StyleConstants.setForeground(defaultStyle, this.getForeground());
        this.addCaretListener(e -> this.resetCaret());
    }

    void reset() {
        this.clearCurrentAction();
        this.setInsertMode();
    }

    void deactivate() {
        this.clearCurrentAction();
    }

    @Override
    public Insets getMargin() {
        return JBUI.emptyInsets();
    }

    @Override
    public Insets getInsets() {
        return JBUI.emptyInsets();
    }

    @Override
    public void updateUI() {
        this.setUI(new ExTextFieldUI(ExEditorKit.INSTANCE));
        this.invalidate();
        this.setBorder(null);
    }

    void saveLastEntry() {
        this.myParentPanel.setLastEntry(super.getText());
    }

    void updateText(String string) {
        super.setText(string);
        this.setFontToJField(string);
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.saveLastEntry();
        this.setFontToJField(string);
    }

    public void insertText(int offset, String text) {
        try {
            this.getDocument().insertString(offset, text, null);
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
        }
        this.saveLastEntry();
        this.setFontToJField(this.getText());
    }

    public void deleteText(int offset, int length) {
        try {
            this.getDocument().remove(offset, Math.min(length, this.getDocument().getLength() - offset));
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
        }
        this.saveLastEntry();
        this.setFontToJField(this.getText());
    }

    private void setFontToJField(String stringToDisplay) {
        this.setFont(UiHelper.selectEditorFont(this.myParentPanel.getIjEditor(), stringToDisplay));
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            StyledDocument styledDocument = (StyledDocument)document;
            Style defaultStyle = styledDocument.getStyle("default");
            if (!Objects.equals(StyleConstants.getFontFamily(defaultStyle), this.getFont().getFamily())) {
                StyleConstants.setFontFamily(defaultStyle, this.getFont().getFamily());
            }
            if (!Objects.equals(StyleConstants.getFontSize(defaultStyle), this.getFont().getSize())) {
                StyleConstants.setFontSize(defaultStyle, this.getFont().getSize());
            }
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            StyledDocument styledDocument = (StyledDocument)document;
            Style defaultStyle = styledDocument.getStyle("default");
            StyleConstants.setForeground(defaultStyle, fg);
        }
    }

    public void setSpecialKeyForeground(@NotNull Color fg) {
        Document document;
        if (fg == null) {
            ExTextField.$$$reportNull$$$0(0);
        }
        if ((document = this.getDocument()) instanceof ExDocument) {
            ExDocument exDocument = (ExDocument)document;
            exDocument.setSpecialKeyForeground(fg);
        }
    }

    public void handleKey(@NotNull KeyStroke stroke) {
        if (stroke == null) {
            ExTextField.$$$reportNull$$$0(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("stroke=" + String.valueOf(stroke));
        }
        if (stroke.getKeyChar() != '\uffff') {
            this.replaceSelection(String.valueOf(stroke.getKeyChar()));
        } else {
            KeyEvent event = new KeyEvent(this, stroke.getKeyEventType(), new Date().getTime(), stroke.getModifiers(), stroke.getKeyCode(), stroke.getKeyChar());
            super.processKeyEvent(event);
        }
        this.saveLastEntry();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug("key=" + String.valueOf(e));
        }
        if (this.isAllowedPressedEvent(e) || this.isAllowedTypedEvent(e)) {
            VimEditor editor = this.myParentPanel.getEditor();
            KeyHandler keyHandler = KeyHandler.getInstance();
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            keyHandler.handleKey(editor, keyStroke, (ExecutionContext)new IjEditorExecutionContext(this.myParentPanel.getContext()), keyHandler.getKeyHandlerState());
            e.consume();
        } else {
            super.processKeyEvent(e);
        }
    }

    private boolean isAllowedTypedEvent(KeyEvent event) {
        return event.getID() == 400 && !this.isKeyCharEnterOrEscape(event.getKeyChar());
    }

    private boolean isAllowedPressedEvent(KeyEvent event) {
        return event.getID() == 401 && this.isKeyCodeEnterOrEscape(event.getKeyCode());
    }

    private boolean isKeyCharEnterOrEscape(char keyChar) {
        return keyChar == '\n' || keyChar == '\u001b';
    }

    private boolean isKeyCodeEnterOrEscape(int keyCode) {
        return keyCode == 10 || keyCode == 27;
    }

    @Override
    @NotNull
    protected Document createDefaultModel() {
        return new ExDocument();
    }

    public void clearCurrentAction() {
        VimCommandLine commandLine = VimInjectorKt.injector.getCommandLine().getActiveCommandLine();
        if (commandLine != null) {
            commandLine.clearPromptCharacter();
        }
    }

    private void setInsertMode() {
        ExDocument doc = (ExDocument)this.getDocument();
        if (doc.isOverwrite()) {
            doc.toggleInsertReplace();
        }
        this.resetCaret();
    }

    void toggleInsertReplace() {
        ExDocument doc = (ExDocument)this.getDocument();
        doc.toggleInsertReplace();
        this.caret.setVisible(false);
        this.resetCaret();
        this.caret.setVisible(true);
    }

    private void resetCaret() {
        if (this.getCaretPosition() == super.getText().length() || this.currentActionPromptCharacterOffset == super.getText().length() - 1) {
            this.setNormalModeCaret();
        } else {
            ExDocument doc = (ExDocument)this.getDocument();
            if (doc.isOverwrite()) {
                this.setReplaceModeCaret();
            } else {
                this.setInsertModeCaret();
            }
        }
    }

    private void setNormalModeCaret() {
        this.caret.setAttributes(GuiCursorOptionHelper.INSTANCE.getAttributes(GuiCursorMode.CMD_LINE));
    }

    private void setInsertModeCaret() {
        this.caret.setAttributes(GuiCursorOptionHelper.INSTANCE.getAttributes(GuiCursorMode.CMD_LINE_INSERT));
    }

    private void setReplaceModeCaret() {
        this.caret.setAttributes(GuiCursorOptionHelper.INSTANCE.getAttributes(GuiCursorMode.CMD_LINE_REPLACE));
    }

    @TestOnly
    @NonNls
    public String getCaretShape() {
        CommandLineCaret caret = (CommandLineCaret)this.getCaret();
        return String.format("%s %d", caret.mode, caret.thickness);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stroke";
                break;
            }
        }
        objectArray2[1] = "com/maddyhome/idea/vim/ui/ex/ExTextField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSpecialKeyForeground";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommandLineCaret
    extends DefaultCaret
    implements VimCommandLineCaret {
        private GuiCursorType mode;
        private int thickness = 100;
        private int lastBlinkRate = 0;
        private boolean hasFocus;

        private CommandLineCaret() {
        }

        public void setAttributes(GuiCursorAttributes attributes) {
            this.mode = attributes.getType();
            this.thickness = this.mode == GuiCursorType.BLOCK ? 100 : attributes.getThickness();
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.lastBlinkRate != 0) {
                this.setBlinkRate(this.lastBlinkRate);
                this.lastBlinkRate = 0;
            }
            super.focusGained(e);
            this.repaint();
            this.hasFocus = true;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.hasFocus = false;
            this.lastBlinkRate = this.getBlinkRate();
            this.setBlinkRate(0);
            this.setVisible(true);
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            if (!this.isVisible()) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                JTextComponent component = this.getComponent();
                g2d.setColor(component.getBackground());
                g2d.setXORMode(component.getCaretColor());
                Rectangle2D r = this.modelToView(this.getDot());
                if (r == null) {
                    return;
                }
                if (this.width > 0 && this.height > 0 && !this.contains(r)) {
                    Rectangle clip = g2d.getClipBounds();
                    if (clip != null && !clip.contains(this)) {
                        this.repaint();
                    }
                    this.damage(r.getBounds());
                }
                FontMetrics fm = component.getFontMetrics(component.getFont());
                if (!this.hasFocus) {
                    float outlineThickness = (float)PaintUtil.alignToInt((double)1.0, (Graphics2D)g2d);
                    double caretWidth = this.getCaretWidth(fm, r.getX(), 100, false);
                    Area area = new Area(new Rectangle2D.Double(r.getX(), r.getY(), caretWidth, r.getHeight()));
                    area.subtract(new Area(new Rectangle2D.Double(r.getX() + (double)outlineThickness, r.getY() + (double)outlineThickness, caretWidth - (double)(2.0f * outlineThickness), r.getHeight() - (double)(2.0f * outlineThickness))));
                    g2d.fill(area);
                } else {
                    double caretHeight = this.getCaretHeight(r.getHeight());
                    double caretWidth = this.getCaretWidth(fm, r.getX(), this.thickness, true);
                    Rectangle2D.Double rect = new Rectangle2D.Double(r.getX(), r.getY() + r.getHeight() - caretHeight, caretWidth, caretHeight);
                    g2d.fill(rect);
                }
            }
            finally {
                g2d.dispose();
            }
        }

        @Override
        protected synchronized void damage(Rectangle r) {
            if (r != null) {
                FontMetrics fm = this.getComponent().getFontMetrics(this.getComponent().getFont());
                this.x = r.x;
                this.y = r.y;
                this.width = (int)Math.ceil(this.getCaretWidth(fm, r.x, 100, false)) + 1;
                this.height = r.height;
                this.repaint();
            }
        }

        @Nullable
        private Rectangle2D modelToView(int dot) {
            if (dot > this.getComponent().getDocument().getLength()) {
                return null;
            }
            try {
                return this.getComponent().getUI().modelToView2D(this.getComponent(), dot, this.getDotBias());
            }
            catch (BadLocationException e) {
                return null;
            }
        }

        private double getCaretWidth(FontMetrics fm, double dotX, int widthPercentage, boolean coerceCharacterWidth) {
            double width;
            Rectangle2D r = this.modelToView(this.getDot() + 1);
            if (r != null && !coerceCharacterWidth) {
                width = r.getX() - dotX;
            } else {
                char c = ' ';
                try {
                    char documentChar;
                    if (this.getDot() < this.getComponent().getDocument().getLength() && EngineStringHelper.INSTANCE.isPrintableCharacter(documentChar = this.getComponent().getText(this.getDot(), 1).charAt(0))) {
                        c = documentChar;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                width = fm.charWidth(c);
            }
            return this.mode == GuiCursorType.VER ? Math.max(1.0, width * (double)widthPercentage / 100.0) : width;
        }

        private double getCaretHeight(double fullHeight) {
            if (this.mode == GuiCursorType.HOR) {
                return Math.max(1.0, fullHeight * (double)this.thickness / 100.0);
            }
            return fullHeight;
        }

        public int getOffset() {
            return this.getDot();
        }

        public void setOffset(int i) {
            this.setDot(i);
        }
    }
}

