/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.LineDeleteShift;
import com.maddyhome.idea.vim.api.MutableVimEditor;
import com.maddyhome.idea.vim.api.NativeAction;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretKt;
import com.maddyhome.idea.vim.api.VimChangeGroup;
import com.maddyhome.idea.vim.api.VimDocument;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimIndentConfig;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimKeyGroup;
import com.maddyhome.idea.vim.api.VimMarkService;
import com.maddyhome.idea.vim.api.VimMarkServiceKt;
import com.maddyhome.idea.vim.api.VimMotionGroup;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.ChangesListener;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.common.VimEditorReplaceMask;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.Motion;
import com.maddyhome.idea.vim.handler.MotionActionHandler;
import com.maddyhome.idea.vim.helper.CharacterHelper;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.NumberType;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.listener.SelectionVimListenerSuppressor;
import com.maddyhome.idea.vim.listener.VimListenerSuppressor;
import com.maddyhome.idea.vim.regexp.VimRegex;
import com.maddyhome.idea.vim.regexp.match.VimMatchResult;
import com.maddyhome.idea.vim.register.VimRegisterGroup;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.undo.VimKeyBasedUndoService;
import com.maddyhome.idea.vim.undo.VimTimestampBasedUndoService;
import com.maddyhome.idea.vim.undo.VimUndoRedo;
import com.maddyhome.idea.vim.vimscript.model.commands.SortOption;
import java.io.Closeable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 \u00aa\u00012\u00020\u0001:\u0004\u00a9\u0001\u00aa\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\bH\u0016J8\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0016J<\u0010+\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u00100\u001a\u00020\bH\u0004J(\u00101\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0016J \u00101\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u00103\u001a\u000204H\u0016J(\u00101\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u00105\u001a\u0002062\u0006\u00103\u001a\u000204H\u0016J \u00107\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0005H\u0014J(\u00108\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00052\u0006\u00109\u001a\u00020\bH\u0016J\u0018\u0010:\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010;\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010<\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010=\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010>\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010?\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010C\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J(\u0010D\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010E\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0016J\u001a\u0010F\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010G\u001a\u00020\u001cH\u0002J\u0018\u0010H\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010I\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010J\u001a\u00020AH\u0016J\u0018\u0010K\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010L\u001a\u00020\u001aH\u0016J\u0010\u0010M\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J0\u0010N\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0016J0\u0010O\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010P\u001a\u00020\bH\u0016J \u0010Q\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0016J \u0010V\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0016J0\u0010W\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0016J \u0010X\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0005H\u0016J8\u0010Y\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010P\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0016J,\u0010Z\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020]0\\H\u0016JF\u0010^\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020/\u0018\u00010_2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020`2\u0006\u0010#\u001a\u00020$2\u0006\u0010a\u001a\u00020b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0016JB\u0010c\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010(\u001a\u00020\b2\u0006\u00100\u001a\u00020\bH\u0016J\"\u0010d\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J0\u0010e\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0016J(\u0010f\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0016J \u0010g\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u00105\u001a\u00020\u00052\u0006\u0010h\u001a\u00020\u0005H$J\u0010\u0010i\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0004J8\u0010j\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010k\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010P\u001a\u00020\bH\u0002J\u0010\u0010l\u001a\u00020\b2\u0006\u0010m\u001a\u00020nH\u0002J\u0018\u0010o\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010p\u001a\u00020SH\u0002J0\u0010q\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u00105\u001a\u00020\u00052\u0006\u0010h\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0016J \u0010r\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010s\u001a\u00020\u0005H\u0014J0\u0010t\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010a\u001a\u00020b2\u0006\u0010)\u001a\u00020*H\u0016J \u0010u\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010s\u001a\u00020\u0005H\u0002J0\u0010v\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010#\u001a\u00020$H\u0016J0\u0010w\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010a\u001a\u00020b2\u0006\u0010)\u001a\u00020*H\u0016J \u0010x\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020]H\u0016J \u0010y\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0002J0\u0010z\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010a\u001a\u00020b2\u0006\u0010)\u001a\u00020*H\u0016J8\u0010{\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010|\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0016J8\u0010}\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010a\u001a\u00020b2\u0006\u0010|\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0016J:\u0010~\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020\u007f2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u0002040\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0016J8\u0010\u0084\u0001\u001a\t\u0012\u0004\u0012\u0002040\u0085\u00012\u0006\u0010!\u001a\u00020\"2\r\u0010\u001d\u001a\t\u0012\u0004\u0012\u0002040\u0085\u00012\u0006\u0010k\u001a\u00020\u00052\u0007\u0010\u0086\u0001\u001a\u000204H\u0002J8\u0010\u0087\u0001\u001a\t\u0012\u0004\u0012\u0002040\u0085\u00012\u0006\u0010!\u001a\u00020\"2\r\u0010\u001d\u001a\t\u0012\u0004\u0012\u0002040\u0085\u00012\u0006\u0010k\u001a\u00020\u00052\u0007\u0010\u0086\u0001\u001a\u000204H\u0002J!\u0010\u0088\u0001\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0005H\u0016JK\u0010\u0089\u0001\u001a\u0004\u0018\u0001042\u0006\u0010!\u001a\u00020\"2\u0013\u0010,\u001a\u000f\u0012\u0004\u0012\u00020-\u0012\u0005\u0012\u00030\u008a\u00010_2\u0006\u0010'\u001a\u00020\u00052\u0007\u0010\u008b\u0001\u001a\u00020\b2\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020\bH\u0002J3\u0010\u008e\u0001\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0007\u0010\u008f\u0001\u001a\u00020-2\u0006\u0010'\u001a\u00020\u00052\u0007\u0010\u0090\u0001\u001a\u00020\bH\u0016JC\u0010\u0091\u0001\u001a\u0011\u0012\u0004\u0012\u00020-\u0012\u0005\u0012\u00030\u008a\u0001\u0018\u00010_2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0007\u0010\u008b\u0001\u001a\u00020\b2\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020\bH\u0002JG\u0010\u0092\u0001\u001a\u0016\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020-\u0012\u0005\u0012\u00030\u008a\u00010_0\u0085\u00012\u0006\u0010!\u001a\u00020\"2\u0007\u0010\u0093\u0001\u001a\u00020-2\u0007\u0010\u008b\u0001\u001a\u00020\b2\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020\bJE\u0010\u0094\u0001\u001a\u0011\u0012\u0004\u0012\u00020-\u0012\u0005\u0012\u00030\u008a\u0001\u0018\u00010_2\u0007\u0010\u0095\u0001\u001a\u0002042\u0007\u0010\u0096\u0001\u001a\u00020\u00052\u0007\u0010\u008b\u0001\u001a\u00020\b2\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020\bH\u0004JK\u0010\u0097\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050_2\u0007\u0010\u0098\u0001\u001a\u0002042\u0007\u0010\u0099\u0001\u001a\u00020\u00052\u0007\u0010\u008b\u0001\u001a\u00020\b2\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020\b2\u0007\u0010\u009a\u0001\u001a\u00020\bH\u0002J6\u0010\u009b\u0001\u001a\u00020\b2\u0007\u0010\u009c\u0001\u001a\u00020n2\u0007\u0010\u008b\u0001\u001a\u00020\b2\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020\b2\u0007\u0010\u009a\u0001\u001a\u00020\bH\u0002J*\u0010\u009d\u0001\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0007\u0010.\u001a\u00030\u009e\u0001H\u0016J=\u0010\u009f\u0001\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010$2\u0007\u0010.\u001a\u00030\u009e\u00012\u0007\u0010a\u001a\u00030\u00a0\u00012\u0006\u0010)\u001a\u00020*H\u0016J!\u0010\u00a1\u0001\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0005H\u0016J2\u0010\u00a2\u0001\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u00105\u001a\u00020\u00052\u0006\u0010h\u001a\u00020\u00052\u0007\u0010.\u001a\u00030\u009e\u0001H\u0002JA\u0010\u00a3\u0001\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010|\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0016J)\u0010\u00a4\u0001\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\t\u0010\u00a5\u0001\u001a\u00020\u001cH\u0016J\u0014\u0010\u00a6\u0001\u001a\u00020\u001c2\t\u0010\u00a7\u0001\u001a\u0004\u0018\u000104H\u0016J\t\u0010\u00a8\u0001\u001a\u00020\u001cH\u0017J\u001b\u0010\u00a2\u0001\u001a\u00020n2\u0007\u0010\u009c\u0001\u001a\u00020n2\u0007\u0010.\u001a\u00030\u009e\u0001H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00058\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u00058\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ab\u0001"}, d2={"Lcom/maddyhome/idea/vim/api/VimChangeGroupBase;", "Lcom/maddyhome/idea/vim/api/VimChangeGroup;", "<init>", "()V", "repeatLines", "", "repeatColumn", "repeatAppend", "", "strokes", "", "", "repeatCharsCount", "lastStrokes", "oldOffset", "tabAction", "getTabAction", "()Z", "setTabAction", "(Z)V", "vimDocumentListener", "Lcom/maddyhome/idea/vim/common/ChangesListener;", "lastLower", "vimDocument", "Lcom/maddyhome/idea/vim/api/VimDocument;", "lastInsert", "Lcom/maddyhome/idea/vim/command/Command;", "setInsertRepeat", "", "lines", "column", "append", "deleteCharacter", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "count", "isChange", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "deleteText", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "saveToRegister", "insertText", "offset", "str", "", "start", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "repeatInsertText", "repeatInsert", "started", "insertBeforeCaret", "insertAfterLineEnd", "insertAfterCaret", "insertLineStart", "insertBeforeFirstNonBlank", "initInsert", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "runEnterAction", "runEnterAboveAction", "insertPreviousInsert", "exit", "processEscape", "updateLastInsertedTextRegister", "processEnter", "processPostChangeModeSwitch", "toSwitch", "processCommand", "cmd", "processSingleCommand", "deleteEndOfLine", "deleteJoinLines", "spaces", "processKey", "key", "Ljavax/swing/KeyStroke;", "processResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "processKeyInSelectMode", "deleteLine", "joinViaIdeaByCount", "deleteJoinRange", "joinViaIdeaBySelections", "caretsAndSelections", "", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "getDeleteRangeAndType", "Lkotlin/Pair;", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "deleteRange", "removeLastNewLine", "changeEndOfLine", "changeCharacters", "reformatCode", "end", "clearStrokes", "deleteJoinNLines", "startLine", "isPrintableChar", "c", "", "activeTemplateWithLeftRightMotion", "keyStroke", "replaceText", "insertNewLineAbove", "col", "changeMotion", "insertNewLineBelow", "changeRange", "reformatCodeMotion", "reformatCodeSelection", "reformatCodeRange", "autoIndentMotion", "indentLines", "dir", "indentMotion", "sortRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "lineComparator", "Ljava/util/Comparator;", "sortOptions", "Lcom/maddyhome/idea/vim/vimscript/model/commands/SortOption;", "extractPatternFromLines", "", "pattern", "deletePatternFromLines", "changeNumber", "changeNumberInRange", "Lcom/maddyhome/idea/vim/helper/NumberType;", "alpha", "hex", "octal", "changeNumberVisualMode", "selectedRange", "avalanche", "findNumberUnderCursor", "findNumbersInRange", "textRange", "findNumberInText", "textInRange", "startPosOnLine", "findRange", "text", "pos", "decimal", "isNumberChar", "ch", "changeCaseRange", "Lcom/maddyhome/idea/vim/api/VimChangeGroup$ChangeCaseType;", "changeCaseMotion", "Lcom/maddyhome/idea/vim/command/Argument$Motion;", "changeCaseToggleCharacter", "changeCase", "indentRange", "initBlockInsert", "reset", "saveStrokes", "newStrokes", "resetRepeat", "VimChangesListener", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimChangeGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimChangeGroupBase.kt\ncom/maddyhome/idea/vim/api/VimChangeGroupBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,2115:1\n774#2:2116\n865#2,2:2117\n1869#2,2:2119\n1761#2,3:2125\n1869#2,2:2130\n1563#2:2133\n1634#2,3:2134\n1573#2:2137\n1604#2,4:2138\n1573#2:2142\n1604#2,4:2143\n739#2,9:2147\n33#3,4:2121\n38#3:2160\n216#4,2:2128\n1#5:2132\n37#6:2156\n36#6,3:2157\n*S KotlinDebug\n*F\n+ 1 VimChangeGroupBase.kt\ncom/maddyhome/idea/vim/api/VimChangeGroupBase\n*L\n681#1:2116\n681#1:2117,2\n682#1:2119,2\n821#1:2125,3\n878#1:2130,2\n1423#1:2133\n1423#1:2134,3\n1452#1:2137\n1452#1:2138,4\n1468#1:2142\n1468#1:2143,4\n1654#1:2147,9\n735#1:2121,4\n2065#1:2160\n866#1:2128,2\n1654#1:2156\n1654#1:2157,3\n*E\n"})
public abstract class VimChangeGroupBase
implements VimChangeGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int repeatLines;
    private int repeatColumn;
    private boolean repeatAppend;
    @JvmField
    @NotNull
    protected final List<Object> strokes = new ArrayList();
    @JvmField
    protected int repeatCharsCount;
    @JvmField
    @Nullable
    protected List<Object> lastStrokes;
    @JvmField
    protected int oldOffset = -1;
    private boolean tabAction;
    @JvmField
    @Nullable
    protected ChangesListener vimDocumentListener;
    @JvmField
    protected boolean lastLower = true;
    @JvmField
    @Nullable
    protected VimDocument vimDocument;
    @JvmField
    @Nullable
    protected Command lastInsert;
    private static final int MAX_REPEAT_CHARS_COUNT = 10000;
    @NotNull
    private static final VimLogger logger;
    @NotNull
    public static final String HEX_START = "0x";
    @NotNull
    public static final String VIM_MOTION_BIG_WORD_RIGHT = "VimMotionBigWordRightAction";
    @NotNull
    public static final String VIM_MOTION_WORD_RIGHT = "VimMotionWordRightAction";
    @NotNull
    public static final String VIM_MOTION_CAMEL_RIGHT = "VimMotionCamelRightAction";
    @NotNull
    public static final String VIM_MOTION_WORD_END_RIGHT = "VimMotionWordEndRightAction";
    @NotNull
    public static final String VIM_MOTION_BIG_WORD_END_RIGHT = "VimMotionBigWordEndRightAction";
    @NotNull
    public static final String VIM_MOTION_CAMEL_END_RIGHT = "VimMotionCamelEndRightAction";
    @NotNull
    public static final String MAX_HEX_INTEGER = "ffffffffffffffff";
    @NotNull
    private static final Set<String> wordMotions;

    public final boolean getTabAction() {
        return this.tabAction;
    }

    public final void setTabAction(boolean bl) {
        this.tabAction = bl;
    }

    @Override
    public void setInsertRepeat(int lines, int column, boolean append) {
        this.repeatLines = lines;
        this.repeatColumn = column;
        this.repeatAppend = append;
    }

    @Override
    public boolean deleteCharacter(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, int count, boolean isChange, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Motion endOffset = VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, caret, count, true, false, 16, null);
        if (endOffset instanceof Motion.AbsoluteOffset) {
            boolean res = VimChangeGroupBase.deleteText$default(this, editor, context, new TextRange(caret.getOffset(), ((Motion.AbsoluteOffset)endOffset).getOffset()), SelectionType.CHARACTER_WISE, caret, false, 32, null);
            int pos = Math.min(caret.getOffset(), ((Motion.AbsoluteOffset)endOffset).getOffset());
            int norm = EngineEditorHelperKt.normalizeOffset(editor, editor.offsetToBufferPosition(pos).getLine(), pos, isChange);
            VimCaret newCaret = norm != pos || editor.offsetToVisualPosition(norm) != VimInjectorKt.getInjector().getEngineEditorHelper().inlayAwareOffsetToVisualPosition(editor, norm) ? caret.moveToOffset(norm) : caret;
            int offset = EngineEditorHelperKt.normalizeOffset(editor, newCaret.getBufferPosition().getLine(), newCaret.getOffset(), isChange);
            newCaret.moveToOffset(offset);
            return res;
        }
        return false;
    }

    protected final boolean deleteText(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull TextRange range, @Nullable SelectionType type, @NotNull VimCaret caret, boolean saveToRegister) {
        boolean shouldYank;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        TextRange updatedRange = range;
        if (!range.normalize((int)editor.fileSize())) {
            if (range.getStartOffset() != range.getEndOffset() || range.getStartOffset() != (int)editor.fileSize() || range.getStartOffset() == 0) {
                return false;
            }
            updatedRange = new TextRange(range.getStartOffset() - 1, range.getEndOffset());
        }
        boolean isInsertMode = Intrinsics.areEqual((Object)editor.getMode(), (Object)Mode.INSERT.INSTANCE) || Intrinsics.areEqual((Object)editor.getMode(), (Object)Mode.REPLACE.INSTANCE);
        boolean bl = shouldYank = type != null && !isInsertMode && saveToRegister;
        if (shouldYank && !caret.getRegisterStorage().storeText(editor, context, updatedRange, type, true)) {
            return false;
        }
        int[] startOffsets = updatedRange.getStartOffsets();
        int[] endOffsets = updatedRange.getEndOffsets();
        for (int i = updatedRange.size() - 1; -1 < i; --i) {
            Pair<Pair<Integer, Integer>, LineDeleteShift> pair = editor.search((Pair<Integer, Integer>)TuplesKt.to((Object)startOffsets[i], (Object)endOffsets[i]), editor, LineDeleteShift.NL_ON_END);
            if (pair == null) continue;
            Pair newRange = (Pair)pair.component1();
            VimInjectorKt.getInjector().getApplication().runWriteAction(() -> VimChangeGroupBase.deleteText$lambda$0(editor, newRange));
        }
        if (type != null) {
            int start = updatedRange.getStartOffset();
            VimInjectorKt.getInjector().getMarkService().setMark(caret, '.', start);
            VimMarkServiceKt.setChangeMarks(VimInjectorKt.getInjector().getMarkService(), caret, new TextRange(start, start + 1));
        }
        return true;
    }

    public static /* synthetic */ boolean deleteText$default(VimChangeGroupBase vimChangeGroupBase, VimEditor vimEditor, ExecutionContext executionContext, TextRange textRange, SelectionType selectionType, VimCaret vimCaret, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deleteText");
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return vimChangeGroupBase.deleteText(vimEditor, executionContext, textRange, selectionType, vimCaret, bl);
    }

    @Override
    @NotNull
    public VimCaret insertText(@NotNull VimEditor editor, @NotNull VimCaret caret, int offset, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        VimInjectorKt.getInjector().getApplication().runWriteAction(() -> VimChangeGroupBase.insertText$lambda$1(editor, caret, offset, str));
        VimCaret newCaret = caret.moveToInlayAwareOffset(offset + str.length());
        VimInjectorKt.getInjector().getMarkService().setMark(newCaret, '.', offset);
        return newCaret;
    }

    @Override
    @NotNull
    public VimCaret insertText(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.insertText(editor, caret, caret.getOffset(), str);
    }

    public void insertText(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull BufferPosition start, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.insertText(editor, caret, editor.bufferPositionToOffset(start), str);
    }

    protected void repeatInsertText(@NotNull VimEditor editor, @NotNull ExecutionContext context, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<Object> list = this.lastStrokes;
        if (list == null) {
            return;
        }
        List<Object> myLastStrokes = list;
        for (VimCaret caret : editor.nativeCarets()) {
            for (int i = 0; i < count; ++i) {
                int it = i;
                boolean bl = false;
                for (Object lastStroke : myLastStrokes) {
                    Object object;
                    Object object2 = lastStroke;
                    if (object2 instanceof NativeAction) {
                        VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, (NativeAction)lastStroke, context);
                        object = this.strokes.add(lastStroke);
                        continue;
                    }
                    if (object2 instanceof EditorActionHandlerBase) {
                        VimInjectorKt.getInjector().getActionExecutor().executeVimAction(editor, (EditorActionHandlerBase)lastStroke, context, new OperatorArguments(0, editor.getMode()));
                        object = this.strokes.add(lastStroke);
                        continue;
                    }
                    if (object2 instanceof char[]) {
                        object = this.insertText(editor, caret, new String((char[])lastStroke));
                        continue;
                    }
                    throw new RuntimeException("Unexpected stroke type: " + lastStroke.getClass() + " " + lastStroke);
                }
            }
        }
    }

    @Override
    public void repeatInsert(@NotNull VimEditor editor, @NotNull ExecutionContext context, int count, boolean started) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (VimCaret caret : editor.nativeCarets()) {
            VimCaret vimCaret;
            if (this.repeatLines > 0) {
                int visualLine = caret.getVisualPosition().getLine();
                int bufferLine = caret.getBufferPosition().getLine();
                int position = editor.bufferPositionToOffset(new BufferPosition(bufferLine, this.repeatColumn, false));
                int n = this.repeatLines;
                for (int i = 0; i < n; ++i) {
                    int updatedCount;
                    String pad;
                    if (this.repeatAppend && this.repeatColumn < 9999 && EngineEditorHelperKt.getVisualLineLength(editor, visualLine + i) < this.repeatColumn && ((CharSequence)(pad = VimInjectorKt.getInjector().getEngineEditorHelper().pad(editor, bufferLine + i, this.repeatColumn))).length() > 0) {
                        int offset = editor.getLineEndOffset(bufferLine + i);
                        this.insertText(editor, caret, offset, pad);
                    }
                    int n2 = started ? (i == 0 ? count : count + 1) : (updatedCount = count);
                    if (this.repeatColumn >= 9999) {
                        caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineEnd(editor, bufferLine + i, true));
                        this.repeatInsertText(editor, context, updatedCount);
                        continue;
                    }
                    if (EngineEditorHelperKt.getVisualLineLength(editor, visualLine + i) < this.repeatColumn) continue;
                    VimVisualPosition visualPosition = new VimVisualPosition(visualLine + i, this.repeatColumn, false);
                    int inlaysCount = VimInjectorKt.getInjector().getEngineEditorHelper().amountOfInlaysBeforeVisualPosition(editor, visualPosition);
                    caret.moveToVisualPosition(new VimVisualPosition(visualLine + i, this.repeatColumn + inlaysCount, false));
                    this.repeatInsertText(editor, context, updatedCount);
                }
                vimCaret = caret.moveToOffset(position);
                continue;
            }
            this.repeatInsertText(editor, context, count);
            Motion position = VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, caret, -1, false, false, 16, null);
            vimCaret = VimCaretKt.moveToMotion(caret, position);
        }
        this.repeatLines = 0;
        this.repeatColumn = 0;
        this.repeatAppend = false;
    }

    @Override
    public void insertBeforeCaret(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void insertAfterLineEnd(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (VimCaret caret : editor.nativeCarets()) {
            caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineEnd(editor, caret));
        }
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void insertAfterCaret(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (VimCaret caret : editor.nativeCarets()) {
            VimCaretKt.moveToMotion(caret, VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, caret, 1, true, false, 16, null));
        }
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void insertLineStart(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (VimCaret caret : editor.nativeCarets()) {
            caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret));
        }
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void insertBeforeFirstNonBlank(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (VimCaret caret : editor.nativeCarets()) {
            caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStartSkipLeading(editor, caret));
        }
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void initInsert(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        VimStateMachine state = VimInjectorKt.getInjector().getVimState();
        for (VimCaret caret : editor.nativeCarets()) {
            caret.setVimInsertStart(editor.createLiveMarker(caret.getOffset(), caret.getOffset()));
            VimInjectorKt.getInjector().getMarkService().setMark(caret, '[', caret.getOffset());
        }
        Command cmd = state.getExecutingCommand();
        if (cmd != null && state.isDotRepeatInProgress()) {
            editor.setMode(mode);
            if (Intrinsics.areEqual((Object)mode, (Object)Mode.REPLACE.INSTANCE)) {
                editor.setInsertMode(false);
            }
            int count = cmd.getFlags().contains((Object)CommandFlags.FLAG_NO_REPEAT_INSERT) ? 1 : cmd.getCount();
            this.repeatInsert(editor, context, count, false);
            if (Intrinsics.areEqual((Object)mode, (Object)Mode.REPLACE.INSTANCE)) {
                editor.setInsertMode(true);
            }
            editor.setMode(new Mode.NORMAL(null, 1, null));
        } else {
            this.lastInsert = cmd;
            this.strokes.clear();
            this.repeatCharsCount = 0;
            VimDocument myVimDocument = this.vimDocument;
            if (myVimDocument != null && this.vimDocumentListener != null) {
                ChangesListener changesListener = this.vimDocumentListener;
                Intrinsics.checkNotNull((Object)changesListener);
                myVimDocument.removeChangeListener(changesListener);
            }
            this.vimDocument = editor.getDocument();
            VimChangesListener myChangeListener = new VimChangesListener();
            this.vimDocumentListener = myChangeListener;
            VimDocument vimDocument = this.vimDocument;
            Intrinsics.checkNotNull((Object)vimDocument);
            vimDocument.addChangeListener(myChangeListener);
            this.oldOffset = editor.currentCaret().getOffset();
            editor.setInsertMode(Intrinsics.areEqual((Object)mode, (Object)Mode.INSERT.INSTANCE));
            editor.setMode(mode);
        }
    }

    @Override
    public void runEnterAction(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        NativeAction action;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VimStateMachine state = VimInjectorKt.getInjector().getVimState();
        if (!state.isDotRepeatInProgress() && (action = VimInjectorKt.getInjector().getNativeActionManager().getEnterAction()) != null) {
            if (Intrinsics.areEqual((Object)editor.getMode(), (Object)Mode.INSERT.INSTANCE)) {
                VimUndoRedo undo = VimInjectorKt.getInjector().getUndo();
                VimUndoRedo vimUndoRedo = undo;
                if (vimUndoRedo instanceof VimKeyBasedUndoService) {
                    VimKeyBasedUndoService.setInsertNonMergeUndoKey$default((VimKeyBasedUndoService)undo, false, 1, null);
                } else if (vimUndoRedo instanceof VimTimestampBasedUndoService) {
                    long nanoTime = System.nanoTime();
                    editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)arg_0 -> VimChangeGroupBase.runEnterAction$lambda$3(undo, nanoTime, arg_0)));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.strokes.add(action);
            VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, action, context);
        }
    }

    @Override
    public void runEnterAboveAction(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        NativeAction action;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VimStateMachine state = VimInjectorKt.getInjector().getVimState();
        if (!state.isDotRepeatInProgress() && (action = VimInjectorKt.getInjector().getNativeActionManager().getCreateLineAboveCaret()) != null) {
            this.strokes.add(action);
            VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, action, context);
        }
    }

    @Override
    public void insertPreviousInsert(@NotNull VimEditor editor, @NotNull ExecutionContext context, boolean exit, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        this.repeatInsertText(editor, context, 1);
        if (exit) {
            editor.exitInsertMode(context);
        }
    }

    @Override
    public void processEscape(@NotNull VimEditor editor, @Nullable ExecutionContext context) {
        int repeatCount0;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimMarkService markGroup = VimInjectorKt.getInjector().getMarkService();
        markGroup.setMark(editor, '^');
        markGroup.setMark(editor, ']');
        if (editor.getMode() instanceof Mode.REPLACE) {
            editor.setInsertMode(true);
        }
        Command command = this.lastInsert;
        if (command != null) {
            Command it = command;
            boolean bl = false;
            v1 = it.getFlags().contains((Object)CommandFlags.FLAG_NO_REPEAT_INSERT) || it.getAction().getArgumentType() == Argument.Type.MOTION ? 0 : it.getCount() - 1;
        } else {
            v1 = repeatCount0 = 0;
        }
        if (this.vimDocument != null && this.vimDocumentListener != null) {
            VimDocument vimDocument = this.vimDocument;
            Intrinsics.checkNotNull((Object)vimDocument);
            ChangesListener changesListener = this.vimDocumentListener;
            Intrinsics.checkNotNull((Object)changesListener);
            vimDocument.removeChangeListener(changesListener);
            this.vimDocumentListener = null;
        }
        this.lastStrokes = new ArrayList(this.strokes);
        if (context != null) {
            VimInjectorKt.getInjector().getChangeGroup().repeatInsert(editor, context, repeatCount0, true);
        }
        if (editor.getMode() instanceof Mode.INSERT) {
            this.updateLastInsertedTextRegister();
        }
        markGroup.setMark(editor, '.');
        editor.setMode(new Mode.NORMAL(null, 1, null));
    }

    private final void updateLastInsertedTextRegister() {
        StringBuilder textToPutRegister = new StringBuilder();
        if (this.lastStrokes != null) {
            List<Object> list = this.lastStrokes;
            Intrinsics.checkNotNull(list);
            for (Object lastStroke : list) {
                if (!(lastStroke instanceof char[])) continue;
                textToPutRegister.append(new String((char[])lastStroke));
            }
        }
        VimRegisterGroup vimRegisterGroup = VimInjectorKt.getInjector().getRegisterGroup();
        String string = textToPutRegister.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        vimRegisterGroup.storeTextSpecial('.', string);
    }

    @Override
    public void processEnter(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (editor.getMode() instanceof Mode.REPLACE) {
            editor.setInsertMode(true);
        }
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        VimKeyGroup vimKeyGroup = VimInjectorKt.getInjector().getKeyGroup();
        Intrinsics.checkNotNull((Object)enterKeyStroke);
        List<NativeAction> actions = vimKeyGroup.getActions(editor, enterKeyStroke);
        for (NativeAction action : actions) {
            if (!VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, action, context)) continue;
        }
        if (editor.getMode() instanceof Mode.REPLACE) {
            editor.setInsertMode(false);
        }
    }

    @Override
    public void processPostChangeModeSwitch(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Mode toSwitch) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)toSwitch, (String)"toSwitch");
        if (Intrinsics.areEqual((Object)toSwitch, (Object)Mode.INSERT.INSTANCE)) {
            this.initInsert(editor, context, Mode.INSERT.INSTANCE);
        }
    }

    @Override
    public void processCommand(@NotNull VimEditor editor, @NotNull Command cmd) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        if (cmd.getFlags().contains((Object)CommandFlags.FLAG_SAVE_STROKE)) {
            this.strokes.add(cmd.getAction());
        } else if (cmd.getFlags().contains((Object)CommandFlags.FLAG_CLEAR_STROKES)) {
            this.clearStrokes(editor);
        }
    }

    @Override
    public void processSingleCommand(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.setMode(new Mode.NORMAL(editor.getMode()));
        this.clearStrokes(editor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean deleteEndOfLine(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, int count, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int initialOffset = caret.getOffset();
        int offset = VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineEnd(editor, caret, count - 1, true);
        int lineStart = VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret);
        int startOffset = initialOffset;
        if (offset == initialOffset && offset != lineStart) {
            --startOffset;
        }
        if (offset != -1) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            TextRange rangeToDelete = new TextRange(startOffset, offset);
            Iterable $this$filter$iv = editor.nativeCarets();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VimCaret it = (VimCaret)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)caret) && rangeToDelete.contains(it.getOffset()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl = false;
                editor.removeCaret(it);
            }
            boolean res = VimChangeGroupBase.deleteText$default(this, editor, context, rangeToDelete, SelectionType.CHARACTER_WISE, caret, false, 32, null);
            if (EngineHelperKt.getUsesVirtualSpace(editor)) {
                v0 = caret.moveToOffset(startOffset);
            } else {
                Motion pos = VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, caret, -1, false, false, 16, null);
                v0 = VimCaretKt.moveToMotion(caret, pos);
            }
            return res;
        }
        return false;
    }

    @Override
    public boolean deleteJoinLines(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, int count, boolean spaces) {
        int total;
        int lline;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int myCount = count;
        if (myCount < 2) {
            myCount = 2;
        }
        return (lline = caret.getBufferPosition().getLine()) + myCount > (total = editor.lineCount()) ? false : this.deleteJoinNLines(editor, context, caret, lline, myCount, spaces);
    }

    @Override
    public boolean processKey(@NotNull VimEditor editor, @NotNull KeyStroke key, @NotNull KeyProcessResult.KeyProcessResultBuilder processResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)processResultBuilder, (String)"processResultBuilder");
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("processKey(" + key + ")");
        }
        if (key.getKeyChar() != '\uffff') {
            VimEditorReplaceMask vimEditorReplaceMask = editor.getReplaceMask();
            if (vimEditorReplaceMask != null) {
                vimEditorReplaceMask.recordChangeAtCaret(editor);
            }
            processResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> VimChangeGroupBase.processKey$lambda$8(this, key, arg_0, arg_1, arg_2)));
            return true;
        }
        if (key.getKeyCode() == VimInjectorKt.getInjector().getParser().getPlugKeyStroke().getKeyCode() || key.getKeyCode() == VimInjectorKt.getInjector().getParser().getActionKeyStroke().getKeyCode()) {
            processResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> VimChangeGroupBase.processKey$lambda$9(this, key, arg_0, arg_1, arg_2)));
            return true;
        }
        if (key.getKeyCode() == 32 && (key.getModifiers() & 0x40) != 0) {
            VimEditorReplaceMask vimEditorReplaceMask = editor.getReplaceMask();
            if (vimEditorReplaceMask != null) {
                vimEditorReplaceMask.recordChangeAtCaret(editor);
            }
            processResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> VimChangeGroupBase.processKey$lambda$10(this, arg_0, arg_1, arg_2)));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeyInSelectMode(@NotNull VimEditor editor, @NotNull KeyStroke key, @NotNull KeyProcessResult.KeyProcessResultBuilder processResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)processResultBuilder, (String)"processResultBuilder");
        boolean res = false;
        Closeable closeable = SelectionVimListenerSuppressor.INSTANCE.lock();
        Throwable throwable = null;
        try {
            VimListenerSuppressor.Locked it = (VimListenerSuppressor.Locked)closeable;
            boolean bl = false;
            res = this.processKey(editor, key, processResultBuilder);
            processResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> VimChangeGroupBase.processKeyInSelectMode$lambda$12$lambda$11(this, key, arg_0, arg_1, arg_2)));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return res;
    }

    @Override
    public boolean deleteLine(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, int count, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int start = VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret);
        int offset = Math.min(VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineEnd(editor, caret, count - 1, true) + 1, (int)editor.fileSize());
        if (logger.isDebug()) {
            logger.debug("start=" + start);
            logger.debug("offset=" + offset);
        }
        if (offset != -1) {
            boolean res = VimChangeGroupBase.deleteText$default(this, editor, context, new TextRange(start, offset), SelectionType.LINE_WISE, caret, false, 32, null);
            if (res && (long)caret.getOffset() >= editor.fileSize() && caret.getOffset() != 0) {
                caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineStartSkipLeading(editor, caret, -1));
            }
            return res;
        }
        return false;
    }

    @Override
    public boolean joinViaIdeaByCount(@NotNull VimEditor editor, @NotNull ExecutionContext context, int count) {
        boolean allowedExecution;
        int executions;
        block5: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            executions = count > 1 ? count - 1 : 1;
            Iterable $this$any$iv = editor.nativeCarets();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int total;
                    ImmutableVimCaret caret = (ImmutableVimCaret)element$iv;
                    boolean bl = false;
                    int lline = caret.getBufferPosition().getLine();
                    if (!(lline + count <= (total = editor.lineCount()))) continue;
                    v0 = true;
                    break block5;
                }
                v0 = allowedExecution = false;
            }
        }
        if (!allowedExecution) {
            return false;
        }
        for (int i = 0; i < executions; ++i) {
            int it = i;
            boolean bl = false;
            NativeAction joinLinesAction = VimInjectorKt.getInjector().getNativeActionManager().getJoinLines();
            if (joinLinesAction == null) continue;
            VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, joinLinesAction, context);
        }
        return true;
    }

    @Override
    public boolean deleteJoinRange(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, @NotNull TextRange range, boolean spaces, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int startLine = editor.offsetToBufferPosition(range.getStartOffset()).getLine();
        int endLine = editor.offsetToBufferPosition(range.getEndOffset()).getLine();
        int count = endLine - startLine + 1;
        if (count < 2) {
            count = 2;
        }
        return this.deleteJoinNLines(editor, context, caret, startLine, count, spaces);
    }

    @Override
    public void joinViaIdeaBySelections(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Map<VimCaret, ? extends VimSelection> caretsAndSelections) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(caretsAndSelections, (String)"caretsAndSelections");
        Map<VimCaret, ? extends VimSelection> $this$forEach$iv = caretsAndSelections;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VimCaret, ? extends VimSelection>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VimCaret, ? extends VimSelection> element$iv;
            Map.Entry<VimCaret, ? extends VimSelection> entry = element$iv = iterator.next();
            boolean bl = false;
            VimCaret caret = entry.getKey();
            VimSelection range = entry.getValue();
            if (!caret.isValid()) continue;
            Pair<Integer, Integer> pair = range.getNativeStartAndEnd();
            int first = ((Number)pair.component1()).intValue();
            int second = ((Number)pair.component2()).intValue();
            caret.setSelection(first, second);
        }
        NativeAction joinLinesAction = VimInjectorKt.getInjector().getNativeActionManager().getJoinLines();
        if (joinLinesAction != null) {
            VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, joinLinesAction, context);
        }
        Iterable $this$forEach$iv2 = editor.nativeCarets();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            VimCaret caret = (VimCaret)element$iv;
            boolean bl = false;
            caret.removeSelection();
            VimVisualPosition vimVisualPosition = caret.getVisualPosition();
            int line = vimVisualPosition.component1();
            int column = vimVisualPosition.component2();
            if (line < 1) continue;
            VimVisualPosition newVisualPosition = new VimVisualPosition(line - 1, column, false);
            caret.moveToVisualPosition(newVisualPosition);
        }
    }

    @Override
    @Nullable
    public Pair<TextRange, SelectionType> getDeleteRangeAndType(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, @NotNull Argument argument, boolean isChange, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (!(argument instanceof Argument.Motion)) {
            boolean $i$a$-check-VimChangeGroupBase$getDeleteRangeAndType$22 = false;
            String $i$a$-check-VimChangeGroupBase$getDeleteRangeAndType$22 = "Unexpected argument: " + argument;
            throw new IllegalStateException($i$a$-check-VimChangeGroupBase$getDeleteRangeAndType$22.toString());
        }
        TextRange textRange = VimInjectorKt.getInjector().getMotion().getMotionRange(editor, caret, context, argument, operatorArguments);
        if (textRange == null) {
            return null;
        }
        TextRange range = textRange;
        SelectionType motionType = ((Argument.Motion)argument).getMotionType();
        if (!isChange && motionType != SelectionType.LINE_WISE) {
            BufferPosition start = editor.offsetToBufferPosition(range.getStartOffset());
            BufferPosition end = editor.offsetToBufferPosition(range.getEndOffset());
            if (start.getLine() != end.getLine() && !EngineEditorHelperKt.anyNonWhitespace(editor, range.getStartOffset(), -1) && !EngineEditorHelperKt.anyNonWhitespace(editor, range.getEndOffset(), 1)) {
                motionType = SelectionType.LINE_WISE;
            }
        }
        return new Pair((Object)range, (Object)motionType);
    }

    @Override
    public boolean deleteRange(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, @NotNull TextRange range, @Nullable SelectionType type, boolean isChange, boolean saveToRegister) {
        VimCaret processedCaret;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int intendedColumn = caret.getVimLastColumn();
        boolean removeLastNewLine = this.removeLastNewLine(editor, range, type);
        boolean res = this.deleteText(editor, context, range, type, caret, saveToRegister);
        VimCaret vimCaret = (VimCaret)editor.findLastVersionOfCaret((ImmutableVimCaret)caret);
        if (vimCaret == null) {
            vimCaret = processedCaret = caret;
        }
        if (removeLastNewLine) {
            int textLength = (int)editor.fileSize();
            VimInjectorKt.getInjector().getApplication().runWriteAction(() -> VimChangeGroupBase.deleteRange$lambda$18(editor, textLength));
            VimCaret vimCaret2 = (VimCaret)editor.findLastVersionOfCaret((ImmutableVimCaret)caret);
            if (vimCaret2 == null) {
                vimCaret2 = processedCaret = caret;
            }
        }
        if (res) {
            VimCaret vimCaret3;
            int pos = EngineEditorHelperKt.normalizeOffset(editor, range.getStartOffset(), isChange);
            if (type == SelectionType.LINE_WISE) {
                VimCaret updated = processedCaret.setVimLastColumnAndGetCaret(intendedColumn);
                pos = VimInjectorKt.getInjector().getMotion().moveCaretToLineWithStartOfLineOption(editor, editor.offsetToBufferPosition(pos).getLine(), caret);
                vimCaret3 = updated;
            } else {
                vimCaret3 = caret;
            }
            processedCaret = vimCaret3;
            processedCaret = processedCaret.moveToOffset(pos);
            processedCaret.resetLastColumn();
        }
        return res;
    }

    private final boolean removeLastNewLine(VimEditor editor, TextRange range, SelectionType type) {
        int fileSize;
        int endOffset = range.getEndOffset();
        if (endOffset > (fileSize = (int)editor.fileSize())) {
            StrictMode.INSTANCE.fail("Incorrect offset. File size: " + fileSize + ", offset: " + endOffset);
            endOffset = fileSize;
        }
        return type == SelectionType.LINE_WISE && range.getStartOffset() != 0 && editor.text().charAt(endOffset - 1) != '\n' && endOffset == fileSize;
    }

    @Override
    public boolean changeEndOfLine(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, int count, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        boolean res = this.deleteEndOfLine(editor, context, caret, count, operatorArguments);
        if (res) {
            caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineEnd(editor, caret));
            editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
        }
        return res;
    }

    @Override
    public boolean changeCharacters(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int count = operatorArguments.getCount1();
        int len = EngineEditorHelperKt.lineLength(editor, editor.primaryCaret().getBufferPosition().getLine());
        int col = caret.getBufferPosition().getColumn();
        if (col + count >= len) {
            return this.changeEndOfLine(editor, context, caret, 1, operatorArguments);
        }
        boolean res = this.deleteCharacter(editor, context, caret, count, true, operatorArguments);
        if (res) {
            editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
        }
        return res;
    }

    protected abstract void reformatCode(@NotNull VimEditor var1, int var2, int var3);

    protected final void clearStrokes(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.strokes.clear();
        this.repeatCharsCount = 0;
        for (VimCaret caret : editor.nativeCarets()) {
            caret.setVimInsertStart(editor.createLiveMarker(caret.getOffset(), caret.getOffset()));
        }
    }

    private final boolean deleteJoinNLines(VimEditor editor, ExecutionContext context, VimCaret caret, int startLine, int count, boolean spaces) {
        for (int i = 1; i < count; ++i) {
            int endOffset;
            int trailingWhitespaceStart;
            int startOffset = VimInjectorKt.getInjector().getMotion().moveCaretToLineEnd(editor, startLine, true);
            boolean hasTrailingWhitespace = startOffset > (trailingWhitespaceStart = VimInjectorKt.getInjector().getMotion().moveCaretToLineEndSkipTrailing(editor, startLine)) + 1;
            int n = endOffset = spaces ? EngineEditorHelperKt.getLeadingCharacterOffset$default(editor, EngineEditorHelperKt.normalizeLine(editor, startLine + 1), 0, 2, null) : editor.getLineStartOffset(EngineEditorHelperKt.normalizeLine(editor, startLine + 1));
            if (endOffset <= startOffset) {
                return i > 1;
            }
            VimChangeGroupBase.deleteText$default(this, editor, context, new TextRange(startOffset, endOffset), null, caret, false, 32, null);
            if (spaces && !hasTrailingWhitespace) {
                this.insertText(editor, caret, startOffset, " ");
            }
            caret.moveToOffset(startOffset);
        }
        return true;
    }

    private final boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    private final boolean activeTemplateWithLeftRightMotion(VimEditor editor, KeyStroke keyStroke) {
        return VimInjectorKt.getInjector().getTemplateManager().getTemplateState(editor) != null && (keyStroke.getKeyCode() == 37 || keyStroke.getKeyCode() == 39);
    }

    @Override
    public void replaceText(@NotNull VimEditor editor, @NotNull VimCaret caret, int start, int end, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        VimInjectorKt.getInjector().getApplication().runWriteAction(() -> VimChangeGroupBase.replaceText$lambda$19(editor, start, end, str));
        int newEnd = start + str.length();
        VimMarkServiceKt.setChangeMarks(VimInjectorKt.getInjector().getMarkService(), caret, new TextRange(start, newEnd));
        VimInjectorKt.getInjector().getMarkService().setMark(caret, '.', newEnd);
    }

    protected void insertNewLineAbove(@NotNull VimEditor editor, @NotNull VimCaret caret, int col) {
        Motion motion;
        VimCaret vimCaret;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (editor.isOneLineMode()) {
            return;
        }
        boolean firstLiner = false;
        if (caret.getVisualPosition().getLine() == 0) {
            VimCaret newCaret = caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret));
            firstLiner = true;
            vimCaret = newCaret;
        } else {
            motion = VimInjectorKt.getInjector().getMotion().getVerticalMotionOffset(editor, caret, -1);
            Intrinsics.checkNotNull((Object)motion, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.Motion.AbsoluteOffset");
            VimCaret updated = caret.moveToOffset(((Motion.AbsoluteOffset)motion).getOffset());
            vimCaret = updated.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineEnd(editor, updated));
        }
        VimCaret newCaret = vimCaret;
        editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
        newCaret = this.insertText(editor, newCaret, "\n" + editor.createIndentBySize(col));
        if (firstLiner) {
            motion = VimInjectorKt.getInjector().getMotion().getVerticalMotionOffset(editor, newCaret, -1);
            Intrinsics.checkNotNull((Object)motion, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.Motion.AbsoluteOffset");
            newCaret.moveToOffset(((Motion.AbsoluteOffset)motion).getOffset());
        }
    }

    @Override
    public boolean changeMotion(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Argument argument, @NotNull OperatorArguments operatorArguments) {
        int offset;
        boolean bigWord;
        boolean kludge;
        Argument.Motion motionArgument;
        int count0;
        block20: {
            boolean lastWordChar;
            CharacterHelper.CharacterType charType;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            count0 = operatorArguments.getCount0();
            Argument.Motion motion = argument instanceof Argument.Motion ? (Argument.Motion)argument : null;
            if (motion == null) {
                return false;
            }
            motionArgument = motion;
            String id = motionArgument.getMotion().getId();
            kludge = false;
            bigWord = Intrinsics.areEqual((Object)id, (Object)VIM_MOTION_BIG_WORD_RIGHT);
            CharSequence chars = editor.text();
            offset = caret.getOffset();
            int fileSize = (int)editor.fileSize();
            if (fileSize <= 0 || offset >= fileSize || (charType = CharacterHelper.charType(editor, chars.charAt(offset), bigWord)) == CharacterHelper.CharacterType.WHITESPACE) break block20;
            boolean bl = lastWordChar = offset >= fileSize - 1 || CharacterHelper.charType(editor, chars.charAt(offset + 1), bigWord) != charType;
            if (wordMotions.contains(id) && lastWordChar && operatorArguments.getCount1() == 1) {
                boolean res = this.deleteCharacter(editor, context, caret, 1, true, operatorArguments);
                if (res) {
                    editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
                }
                return res;
            }
            switch (id) {
                case "VimMotionWordRightAction": {
                    kludge = true;
                    EditorActionHandlerBase editorActionHandlerBase = VimInjectorKt.getInjector().getActionExecutor().findVimActionOrDie(VIM_MOTION_WORD_END_RIGHT);
                    Intrinsics.checkNotNull((Object)editorActionHandlerBase, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.MotionActionHandler");
                    motionArgument = new Argument.Motion((MotionActionHandler)editorActionHandlerBase, motionArgument.getArgument());
                    break;
                }
                case "VimMotionBigWordRightAction": {
                    kludge = true;
                    EditorActionHandlerBase editorActionHandlerBase = VimInjectorKt.getInjector().getActionExecutor().findVimActionOrDie(VIM_MOTION_BIG_WORD_END_RIGHT);
                    Intrinsics.checkNotNull((Object)editorActionHandlerBase, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.MotionActionHandler");
                    motionArgument = new Argument.Motion((MotionActionHandler)editorActionHandlerBase, motionArgument.getArgument());
                    break;
                }
                case "VimMotionCamelRightAction": {
                    kludge = true;
                    EditorActionHandlerBase editorActionHandlerBase = VimInjectorKt.getInjector().getActionExecutor().findVimActionOrDie(VIM_MOTION_CAMEL_END_RIGHT);
                    Intrinsics.checkNotNull((Object)editorActionHandlerBase, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.MotionActionHandler");
                    motionArgument = new Argument.Motion((MotionActionHandler)editorActionHandlerBase, motionArgument.getArgument());
                }
            }
        }
        if (kludge) {
            int pos1 = VimInjectorKt.getInjector().getSearchHelper().findNextWordEnd(editor, offset, operatorArguments.getCount1(), bigWord, false);
            int pos2 = VimInjectorKt.getInjector().getSearchHelper().findNextWordEnd(editor, pos1, -operatorArguments.getCount1(), bigWord, false);
            if (logger.isDebug()) {
                logger.debug("pos=" + offset);
                logger.debug("pos1=" + pos1);
                logger.debug("pos2=" + pos2);
                logger.debug("count=" + operatorArguments.getCount1());
            }
            if (pos2 == offset && operatorArguments.getCount1() > 1) {
                --count0;
            }
        }
        Pair<TextRange, SelectionType> pair = this.getDeleteRangeAndType(editor, caret, context, motionArgument, true, OperatorArguments.copy$default(operatorArguments, false, count0, null, 5, null));
        if (pair == null) {
            return false;
        }
        Pair<TextRange, SelectionType> pair2 = pair;
        TextRange first = (TextRange)pair2.component1();
        SelectionType second = (SelectionType)((Object)pair2.component2());
        return this.changeRange(editor, caret, first, second, context);
    }

    private final void insertNewLineBelow(VimEditor editor, VimCaret caret, int col) {
        if (editor.isOneLineMode()) {
            return;
        }
        VimCaret newCaret = caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineEnd(editor, caret));
        editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
        this.insertText(editor, newCaret, "\n" + editor.createIndentBySize(col));
    }

    @Override
    public boolean changeRange(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull TextRange range, @NotNull SelectionType type, @NotNull ExecutionContext context) {
        VimCaret updatedCaret;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int col = 0;
        int lines = 0;
        if (type == SelectionType.BLOCK_WISE) {
            lines = Companion.getLinesCountInVisualBlock(editor, range);
            col = editor.offsetToBufferPosition(range.getStartOffset()).getColumn();
            if (caret.getVimLastColumn() == 9999) {
                col = 9999;
            }
        }
        boolean after = (long)range.getEndOffset() >= editor.fileSize();
        BufferPosition lp = editor.offsetToBufferPosition(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStartSkipLeading(editor, caret));
        boolean res = VimChangeGroup.deleteRange$default(this, editor, context, caret, range, type, true, false, 64, null);
        VimCaret vimCaret = (VimCaret)editor.findLastVersionOfCaret((ImmutableVimCaret)caret);
        if (vimCaret == null) {
            vimCaret = updatedCaret = caret;
        }
        if (res) {
            if (type == SelectionType.LINE_WISE) {
                if (editor.fileSize() == 0L) {
                    this.insertBeforeCaret(editor, context);
                } else if (after && !EngineEditorHelperKt.endsWithNewLine(editor)) {
                    this.insertNewLineBelow(editor, updatedCaret, lp.getColumn());
                } else {
                    this.insertNewLineAbove(editor, updatedCaret, lp.getColumn());
                }
            } else {
                if (type == SelectionType.BLOCK_WISE) {
                    this.setInsertRepeat(lines, col, false);
                }
                editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
            }
        } else {
            this.insertBeforeCaret(editor, context);
        }
        return true;
    }

    @Override
    public boolean reformatCodeMotion(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Argument argument, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        TextRange range = VimInjectorKt.getInjector().getMotion().getMotionRange(editor, caret, context, argument, operatorArguments);
        return range != null && this.reformatCodeRange(editor, caret, range);
    }

    @Override
    public void reformatCodeSelection(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull VimSelection range) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        TextRange textRange = range.toVimTextRange(true);
        this.reformatCodeRange(editor, caret, textRange);
    }

    private final boolean reformatCodeRange(VimEditor editor, VimCaret caret, TextRange range) {
        int[] starts = range.getStartOffsets();
        int[] ends = range.getEndOffsets();
        int firstLine = editor.offsetToBufferPosition(range.getStartOffset()).getLine();
        int n = ends.length + -1;
        if (0 <= n) {
            do {
                int i = n--;
                int startOffset = EngineEditorHelperKt.getLineStartForOffset(editor, starts[i]);
                int offset = ends[i] - (startOffset == ends[i] ? 0 : 1);
                int endOffset = EngineEditorHelperKt.getLineEndForOffset(editor, offset);
                this.reformatCode(editor, startOffset, endOffset);
            } while (0 <= n);
        }
        int newOffset = VimInjectorKt.getInjector().getMotion().moveCaretToLineStartSkipLeading(editor, firstLine);
        caret.moveToOffset(newOffset);
        return true;
    }

    @Override
    public void autoIndentMotion(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Argument argument, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        TextRange range = VimInjectorKt.getInjector().getMotion().getMotionRange(editor, caret, context, argument, operatorArguments);
        if (range != null) {
            this.autoIndentRange(editor, caret, context, new TextRange(range.getStartOffset(), EngineHelperKt.getEndOffsetInclusive(range)));
        }
    }

    @Override
    public void indentLines(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, int lines, int dir, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int start = caret.getOffset();
        int end = VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineEnd(editor, caret, lines - 1, true);
        this.indentRange(editor, caret, context, new TextRange(start, end), 1, dir, operatorArguments);
    }

    @Override
    public void indentMotion(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Argument argument, int dir, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        TextRange range = VimInjectorKt.getInjector().getMotion().getMotionRange(editor, caret, context, argument, operatorArguments);
        if (range != null) {
            this.indentRange(editor, caret, context, range, 1, dir, operatorArguments);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean sortRange(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull LineRange range, @NotNull Comparator<String> lineComparator, @NotNull SortOption sortOptions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        Object object;
        List lines;
        int endOffset;
        int startOffset;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                Intrinsics.checkNotNullParameter(lineComparator, (String)"lineComparator");
                Intrinsics.checkNotNullParameter((Object)sortOptions, (String)"sortOptions");
                int startLine = range.startLine;
                int endLine = range.endLine;
                int count = range.getSize();
                if (count < 2) {
                    return false;
                }
                startOffset = editor.getLineStartOffset(startLine);
                endOffset = editor.getLineEndOffset(endLine);
                String selectedText = EngineEditorHelperKt.getText(editor, startOffset, endOffset);
                String[] stringArray = new String[]{"\n"};
                lines = StringsKt.split$default((CharSequence)selectedText, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                object = sortOptions.getPattern();
                if (object == null) break block9;
                it = object;
                boolean bl = false;
                List<String> list = sortOptions.getSortOnPattern() ? this.extractPatternFromLines(editor, lines, startLine, it) : this.deletePatternFromLines(editor, lines, startLine, it);
                object = list;
                if (list != null) break block10;
            }
            object = lines;
        }
        List<String> modifiedLines = object;
        Iterable iterable = CollectionsKt.sortedWith((Iterable)CollectionsKt.zip((Iterable)lines, (Iterable)modifiedLines), (arg_0, arg_1) -> VimChangeGroupBase.sortRange$lambda$22((arg_0, arg_1) -> VimChangeGroupBase.sortRange$lambda$21(lineComparator, arg_0, arg_1), arg_0, arg_1));
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it2.getFirst());
        }
        List sortedLines = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (sortOptions.getUnique()) {
            Iterator iterator = sortedLines.iterator();
            String previous = null;
            while (iterator.hasNext()) {
                String current = (String)iterator.next();
                if (Intrinsics.areEqual((Object)current, previous) || sortOptions.getIgnoreCase() && StringsKt.equals((String)current, (String)previous, (boolean)true)) {
                    iterator.remove();
                    continue;
                }
                previous = current;
            }
        }
        if (sortedLines.isEmpty()) {
            return false;
        }
        this.replaceText(editor, caret, startOffset, endOffset, CollectionsKt.joinToString$default((Iterable)sortedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> extractPatternFromLines(VimEditor editor, List<String> lines, int startLine, String pattern) {
        void $this$mapIndexedTo$iv$iv;
        VimRegex regex = new VimRegex(pattern);
        Iterable $this$mapIndexed$iv = lines;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            String string;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VimMatchResult result = VimRegex.findInLine$default(regex, editor, startLine + i, 0, null, 8, null);
            VimMatchResult vimMatchResult = result;
            if (vimMatchResult instanceof VimMatchResult.Success) {
                string = ((VimMatchResult.Success)result).getValue();
            } else if (vimMatchResult instanceof VimMatchResult.Failure) {
                void line;
                string = line;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> deletePatternFromLines(VimEditor editor, List<String> lines, int startLine, String pattern) {
        void $this$mapIndexedTo$iv$iv;
        VimRegex regex = new VimRegex(pattern);
        Iterable $this$mapIndexed$iv = lines;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            String string;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VimMatchResult result = VimRegex.findInLine$default(regex, editor, startLine + i, 0, null, 8, null);
            VimMatchResult vimMatchResult = result;
            if (vimMatchResult instanceof VimMatchResult.Success) {
                String string3 = line.substring(((VimMatchResult.Success)result).getValue().length(), line.length());
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else if (vimMatchResult instanceof VimMatchResult.Failure) {
                string = line;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean changeNumber(@NotNull VimEditor editor, @NotNull VimCaret caret, int count) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        List nf = (List)((Object)VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getNrformats());
        boolean alpha = nf.contains("alpha");
        boolean hex = nf.contains("hex");
        boolean octal = nf.contains("octal");
        Pair<TextRange, NumberType> range = this.findNumberUnderCursor(editor, caret, alpha, hex, octal);
        if (range == null) {
            logger.debug("no number on line");
            return false;
        }
        String newNumber = this.changeNumberInRange(editor, range, count, alpha, hex, octal);
        if (newNumber == null) {
            bl = false;
        } else {
            this.replaceText(editor, caret, ((TextRange)range.getFirst()).getStartOffset(), ((TextRange)range.getFirst()).getEndOffset(), newNumber);
            caret.moveToInlayAwareOffset(((TextRange)range.getFirst()).getStartOffset() + newNumber.length() - 1);
            bl = true;
        }
        return bl;
    }

    private final String changeNumberInRange(VimEditor editor, Pair<TextRange, ? extends NumberType> range, int count, boolean alpha, boolean hex, boolean octal) {
        String text = EngineEditorHelperKt.getText(editor, (TextRange)range.getFirst());
        NumberType numberType = (NumberType)((Object)range.getSecond());
        if (logger.isDebug()) {
            logger.debug("found range " + range);
            logger.debug("text=" + text);
        }
        Object number = text;
        if (((CharSequence)text).length() == 0) {
            return null;
        }
        char ch = text.charAt(0);
        if (hex && NumberType.HEX == numberType) {
            String string = text;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!StringsKt.startsWith$default((String)string2, (String)HEX_START, (boolean)false, (int)2, null)) {
                throw new RuntimeException("Hex number should start with 0x: " + text);
            }
            for (int i = text.length() - 1; 1 < i; --i) {
                int index = StringsKt.indexOf$default((CharSequence)"abcdefABCDEF", (char)text.charAt(i), (int)0, (boolean)false, (int)6, null);
                if (index < 0) continue;
                this.lastLower = index < 6;
                break;
            }
            String string3 = text.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            BigInteger num = new BigInteger(string3, 16);
            BigInteger bigInteger = num.add(BigInteger.valueOf(count));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
            num = bigInteger;
            if (num.compareTo(BigInteger.ZERO) < 0) {
                BigInteger bigInteger2 = new BigInteger(MAX_HEX_INTEGER, 16).add(BigInteger.ONE).add(num);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                num = bigInteger2;
            }
            String string4 = num.toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            number = string4;
            number = StringsKt.padStart((String)number, (int)(text.length() - 2), (char)'0');
            if (!this.lastLower) {
                Object index = number;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string5 = ((String)index).toUpperCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                number = string5;
            }
            String string6 = text.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            number = string6 + (String)number;
        } else if (octal && NumberType.OCT == numberType && text.length() > 1) {
            if (!StringsKt.startsWith$default((String)text, (String)"0", (boolean)false, (int)2, null)) {
                throw new RuntimeException("Oct number should start with 0: " + text);
            }
            BigInteger num = new BigInteger(text, 8).add(BigInteger.valueOf(count));
            if (num.compareTo(BigInteger.ZERO) < 0) {
                num = new BigInteger("1777777777777777777777", 8).add(BigInteger.ONE).add(num);
            }
            String string = num.toString(8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            number = string;
            number = "0" + StringsKt.padStart((String)number, (int)(text.length() - 1), (char)'0');
        } else if (alpha && NumberType.ALPHA == numberType) {
            if (!Character.isLetter(ch)) {
                throw new RuntimeException("Not alpha number : " + text);
            }
            if (Character.isLetter(ch = (char)(ch + (char)count))) {
                number = String.valueOf(ch);
            }
        } else if (NumberType.DEC == numberType) {
            if (ch != '-' && !Character.isDigit(ch)) {
                throw new RuntimeException("Not dec number : " + text);
            }
            boolean pad = ch == '0';
            int len = text.length();
            if (ch == '-' && text.charAt(1) == '0') {
                pad = true;
                --len;
            }
            BigInteger num = new BigInteger(text);
            BigInteger bigInteger = num.add(BigInteger.valueOf(count));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
            num = bigInteger;
            String string = num.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            number = string;
            if (!octal && pad) {
                boolean neg = false;
                if (((String)number).charAt(0) == '-') {
                    neg = true;
                    String string7 = ((String)number).substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                    number = string7;
                }
                number = StringsKt.padStart((String)number, (int)len, (char)'0');
                if (neg) {
                    number = "-" + (String)number;
                }
            }
        }
        return number;
    }

    @Override
    public boolean changeNumberVisualMode(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull TextRange selectedRange, int count, boolean avalanche) {
        String newNumber;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)selectedRange, (String)"selectedRange");
        List nf = (List)((Object)VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getNrformats());
        boolean alpha = nf.contains("alpha");
        boolean hex = nf.contains("hex");
        boolean octal = nf.contains("octal");
        List<Pair<TextRange, NumberType>> numberRanges = this.findNumbersInRange(editor, selectedRange, alpha, hex, octal);
        List newNumbers = new ArrayList();
        int n = ((Collection)numberRanges).size();
        for (int i = 0; i < n; ++i) {
            Pair<TextRange, NumberType> numberRange = numberRanges.get(i);
            int iCount = avalanche ? (i + 1) * count : count;
            newNumber = this.changeNumberInRange(editor, numberRange, iCount, alpha, hex, octal);
            newNumbers.add(newNumber);
        }
        int n2 = ((Collection)newNumbers).size() + -1;
        if (0 <= n2) {
            do {
                int i = n2--;
                TextRange first = (TextRange)numberRanges.get(i).component1();
                newNumber = (String)newNumbers.get(i);
                int n3 = first.getStartOffset();
                int n4 = first.getEndOffset();
                String string = newNumber;
                Intrinsics.checkNotNull((Object)string);
                this.replaceText(editor, caret, n3, n4, string);
            } while (0 <= n2);
        }
        caret.moveToInlayAwareOffset(selectedRange.getStartOffset());
        return true;
    }

    private final Pair<TextRange, NumberType> findNumberUnderCursor(VimEditor editor, VimCaret caret, boolean alpha, boolean hex, boolean octal) {
        int lline = caret.getBufferPosition().getLine();
        String string = editor.getLineText(lline);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String text = string2;
        int startLineOffset = editor.getLineStartOffset(lline);
        int posOnLine = caret.getOffset() - startLineOffset;
        Pair<TextRange, NumberType> pair = this.findNumberInText(text, posOnLine, alpha, hex, octal);
        if (pair == null) {
            return null;
        }
        Pair<TextRange, NumberType> numberTextRange = pair;
        return new Pair((Object)new TextRange(((TextRange)numberTextRange.getFirst()).getStartOffset() + startLineOffset, ((TextRange)numberTextRange.getFirst()).getEndOffset() + startLineOffset), numberTextRange.getSecond());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<TextRange, NumberType>> findNumbersInRange(@NotNull VimEditor editor, @NotNull TextRange textRange, boolean alpha, boolean hex, boolean octal) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        List result = new ArrayList();
        int n = textRange.size();
        for (int i = 0; i < n; ++i) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            int startOffset = textRange.getStartOffsets()[i];
            int end = textRange.getEndOffsets()[i];
            String text = EngineEditorHelperKt.getText(editor, startOffset, end);
            Object object = text;
            Regex regex = new Regex("\\n");
            int n2 = 0;
            object = regex.split((CharSequence)object, n2);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] textChunks = thisCollection$iv.toArray(new String[0]);
            int chunkStart = 0;
            for (String chunk : textChunks) {
                Pair<TextRange, NumberType> number = this.findNumberInText(chunk, 0, alpha, hex, octal);
                if (number != null) {
                    result.add(new Pair((Object)new TextRange(((TextRange)number.getFirst()).getStartOffset() + startOffset + chunkStart, ((TextRange)number.getFirst()).getEndOffset() + startOffset + chunkStart), number.getSecond()));
                }
                chunkStart += 1 + chunk.length();
            }
        }
        return result;
    }

    @Nullable
    protected final Pair<TextRange, NumberType> findNumberInText(@NotNull String textInRange, int startPosOnLine, boolean alpha, boolean hex, boolean octal) {
        int end;
        Intrinsics.checkNotNullParameter((Object)textInRange, (String)"textInRange");
        if (logger.isDebug()) {
            logger.debug("text=" + textInRange);
        }
        int pos = startPosOnLine;
        int lineEndOffset = textInRange.length();
        while (true) {
            boolean isHexChar;
            if (pos < lineEndOffset && !this.isNumberChar(textInRange.charAt(pos), alpha, hex, octal, true)) {
                ++pos;
                continue;
            }
            if (logger.isDebug()) {
                logger.debug("pos=" + pos);
            }
            if (pos >= lineEndOffset) {
                logger.debug("no number char on line");
                return null;
            }
            boolean bl = isHexChar = StringsKt.indexOf$default((CharSequence)"abcdefABCDEF", (char)textInRange.charAt(pos), (int)0, (boolean)false, (int)6, null) >= 0;
            if (!hex) break;
            if (textInRange.charAt(pos) == '0' && pos < lineEndOffset - 1 && StringsKt.indexOf$default((CharSequence)"xX", (char)textInRange.charAt(pos + 1), (int)0, (boolean)false, (int)6, null) >= 0) {
                pos += 2;
            } else if (StringsKt.indexOf$default((CharSequence)"xX", (char)textInRange.charAt(pos), (int)0, (boolean)false, (int)6, null) >= 0 && pos > 0 && textInRange.charAt(pos - 1) == '0') {
                ++pos;
            }
            logger.debug("checking hex");
            Pair<Integer, Integer> range = this.findRange(textInRange, pos, false, true, false, false);
            int start = ((Number)range.getFirst()).intValue();
            int end2 = ((Number)range.getSecond()).intValue();
            if (start >= 2) {
                String string = textInRange.substring(start - 2, start);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                if (StringsKt.equals((String)string, (String)HEX_START, (boolean)true)) {
                    logger.debug("found hex");
                    return new Pair((Object)new TextRange(start - 2, end2), (Object)NumberType.HEX);
                }
            }
            if (!isHexChar || alpha) break;
            ++pos;
        }
        if (octal) {
            logger.debug("checking octal");
            Pair<Integer, Integer> range = this.findRange(textInRange, pos, false, false, true, false);
            int start = ((Number)range.getFirst()).intValue();
            end = ((Number)range.getSecond()).intValue();
            if (end - start == 1 && textInRange.charAt(start) == '0') {
                return new Pair((Object)new TextRange(start, end), (Object)NumberType.DEC);
            }
            if (!(textInRange.charAt(start) != '0' || end <= start || start > 0 && this.isNumberChar(textInRange.charAt(start - 1), false, false, false, true))) {
                logger.debug("found octal");
                return new Pair((Object)new TextRange(start, end), (Object)NumberType.OCT);
            }
        }
        if (alpha) {
            if (logger.isDebug()) {
                logger.debug("checking alpha for " + textInRange.charAt(pos));
            }
            if (this.isNumberChar(textInRange.charAt(pos), true, false, false, false)) {
                if (logger.isDebug()) {
                    logger.debug("found alpha at " + pos);
                }
                return new Pair((Object)new TextRange(pos, pos + 1), (Object)NumberType.ALPHA);
            }
        }
        Pair<Integer, Integer> range = this.findRange(textInRange, pos, false, false, false, true);
        int start = ((Number)range.getFirst()).intValue();
        end = ((Number)range.getSecond()).intValue();
        if (start > 0 && textInRange.charAt(start - 1) == '-') {
            --start;
        }
        return new Pair((Object)new TextRange(start, end), (Object)NumberType.DEC);
    }

    private final Pair<Integer, Integer> findRange(String text, int pos, boolean alpha, boolean hex, boolean octal, boolean decimal) {
        int start;
        int end;
        for (end = pos; end < text.length() && this.isNumberChar(text.charAt(end), alpha, hex, octal, decimal || octal); ++end) {
        }
        for (start = pos; start >= 0 && this.isNumberChar(text.charAt(start), alpha, hex, octal, decimal || octal); --start) {
        }
        if (start < end && (start == -1 || 0 <= start && start < text.length() && !this.isNumberChar(text.charAt(start), alpha, hex, octal, decimal || octal))) {
            ++start;
        }
        if (octal) {
            int n = end;
            for (int i = start; i < n; ++i) {
                if (this.isNumberChar(text.charAt(i), false, false, true, false)) continue;
                return new Pair((Object)0, (Object)0);
            }
        }
        return new Pair((Object)start, (Object)end);
    }

    private final boolean isNumberChar(char ch, boolean alpha, boolean hex, boolean octal, boolean decimal) {
        return alpha && (Intrinsics.compare((int)ch, (int)97) >= 0 && Intrinsics.compare((int)ch, (int)122) <= 0 || Intrinsics.compare((int)ch, (int)65) >= 0 && Intrinsics.compare((int)ch, (int)90) <= 0) ? true : (octal && Intrinsics.compare((int)ch, (int)48) >= 0 && Intrinsics.compare((int)ch, (int)55) <= 0 ? true : (hex && (Intrinsics.compare((int)ch, (int)48) >= 0 && Intrinsics.compare((int)ch, (int)57) <= 0 || StringsKt.indexOf$default((CharSequence)"abcdefABCDEF", (char)ch, (int)0, (boolean)false, (int)6, null) >= 0) ? true : decimal && Intrinsics.compare((int)ch, (int)48) >= 0 && Intrinsics.compare((int)ch, (int)57) <= 0));
    }

    @Override
    public boolean changeCaseRange(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull TextRange range, @NotNull VimChangeGroup.ChangeCaseType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int[] starts = range.getStartOffsets();
        int[] ends = range.getEndOffsets();
        int n = ends.length + -1;
        if (0 <= n) {
            do {
                int i = n--;
                this.changeCase(editor, caret, starts[i], ends[i], type);
            } while (0 <= n);
        }
        caret.moveToOffset(range.getStartOffset());
        return true;
    }

    @Override
    public boolean changeCaseMotion(@NotNull VimEditor editor, @NotNull VimCaret caret, @Nullable ExecutionContext context, @NotNull VimChangeGroup.ChangeCaseType type, @NotNull Argument.Motion argument, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        VimMotionGroup vimMotionGroup = VimInjectorKt.getInjector().getMotion();
        ImmutableVimCaret immutableVimCaret = caret;
        ExecutionContext executionContext = context;
        Intrinsics.checkNotNull((Object)executionContext);
        TextRange range = vimMotionGroup.getMotionRange(editor, immutableVimCaret, executionContext, argument, operatorArguments);
        if (range == null) {
            return false;
        }
        if (argument.isLinewiseMotion()) {
            BufferPosition pos = editor.offsetToBufferPosition(range.getStartOffset());
            int start = RangesKt.coerceAtMost((int)EngineEditorHelperKt.getLeadingCharacterOffset$default(editor, pos.getLine(), 0, 2, null), (int)caret.getOffset());
            range = new TextRange(start, range.getEndOffset());
        }
        return this.changeCaseRange(editor, caret, range, type);
    }

    @Override
    public boolean changeCaseToggleCharacter(@NotNull VimEditor editor, @NotNull VimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        boolean allowWrap = VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getWhichwrap().contains((Object)"~");
        Motion motion = VimInjectorKt.getInjector().getMotion().getHorizontalMotion(editor, caret, count, true, allowWrap);
        if (motion instanceof Motion.Error) {
            return false;
        }
        int n = caret.getOffset();
        Motion motion2 = motion;
        Intrinsics.checkNotNull((Object)motion2, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.Motion.AbsoluteOffset");
        this.changeCase(editor, caret, n, ((Motion.AbsoluteOffset)motion2).getOffset(), VimChangeGroup.ChangeCaseType.TOGGLE);
        motion = VimInjectorKt.getInjector().getMotion().getHorizontalMotion(editor, caret, count, false, allowWrap);
        if (motion instanceof Motion.AbsoluteOffset) {
            caret.moveToOffset(EngineEditorHelperKt.normalizeOffset(editor, ((Motion.AbsoluteOffset)motion).getOffset(), false));
        }
        return true;
    }

    private final void changeCase(VimEditor editor, VimCaret caret, int start, int end, VimChangeGroup.ChangeCaseType type) {
        StringBuilder stringBuilder;
        Pair pair = start > end ? TuplesKt.to((Object)end, (Object)start) : TuplesKt.to((Object)start, (Object)end);
        int newStart = 0;
        newStart = ((Number)pair.component1()).intValue();
        int newEnd = 0;
        newEnd = ((Number)pair.component2()).intValue();
        newEnd = EngineEditorHelperKt.normalizeOffset(editor, newEnd, true);
        StringBuilder $this$changeCase_u24lambda_u2427 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = newEnd;
        for (int i = newStart; i < n; ++i) {
            $this$changeCase_u24lambda_u2427.append(this.changeCase(editor.text().charAt(i), type));
        }
        String changedText = stringBuilder.toString();
        this.replaceText(editor, caret, newStart, newEnd, changedText);
    }

    @Override
    public void indentRange(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull TextRange range, int count, int dir, @NotNull OperatorArguments operatorArguments) {
        int eline;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (logger.isDebug()) {
            logger.debug("count=" + count);
        }
        int intendedColumn = caret.getVimLastColumn();
        VimIndentConfig indentConfig = editor.getIndentConfig();
        int sline = editor.offsetToBufferPosition(range.getStartOffset()).getLine();
        BufferPosition endLogicalPosition = editor.offsetToBufferPosition(range.getEndOffset());
        int n = endLogicalPosition.getColumn() == 0 ? (int)Math.max((double)(endLogicalPosition.getLine() - 1), 0.0) : (eline = endLogicalPosition.getLine());
        if (range.isMultiple()) {
            int from = editor.offsetToBufferPosition(range.getStartOffset()).getColumn();
            if (dir == 1) {
                String indent = indentConfig.createIndentByDepth(count);
                int l = sline;
                if (l <= eline) {
                    while (true) {
                        int len;
                        if ((len = EngineEditorHelperKt.lineLength(editor, l)) > from) {
                            BufferPosition spos = new BufferPosition(l, from, false);
                            this.insertText(editor, caret, spos, indent);
                        }
                        if (l != eline) {
                            ++l;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                CharSequence chars = editor.text();
                int l = sline;
                if (l <= eline) {
                    while (true) {
                        int len;
                        if ((len = EngineEditorHelperKt.lineLength(editor, l)) > from) {
                            BufferPosition spos = new BufferPosition(l, from, false);
                            BufferPosition epos = new BufferPosition(l, from + indentConfig.getIndentSize(count) - 1, false);
                            int wsoff = editor.bufferPositionToOffset(spos);
                            int weoff = editor.bufferPositionToOffset(epos);
                            int pos = 0;
                            for (pos = wsoff; pos <= weoff && CharacterHelper.charType(editor, chars.charAt(pos), false) == CharacterHelper.CharacterType.WHITESPACE; ++pos) {
                            }
                            if (pos > wsoff) {
                                this.deleteText(editor, context, new TextRange(wsoff, pos), null, caret, true);
                            }
                        }
                        if (l != eline) {
                            ++l;
                            continue;
                        }
                        break;
                    }
                }
            }
        } else {
            int l = sline;
            if (l <= eline) {
                while (true) {
                    int soff = editor.getLineStartOffset(l);
                    int eoff = EngineEditorHelperKt.getLineEndOffset(editor, l, true);
                    int woff = VimInjectorKt.getInjector().getMotion().moveCaretToLineStartSkipLeading(editor, l);
                    int col = editor.offsetToBufferPosition(woff).getColumn();
                    int limit = (int)Math.max(0.0, (double)(col + dir * indentConfig.getIndentSize(count)));
                    if (col > 0 || soff != eoff) {
                        String indent = indentConfig.createIndentBySize(limit);
                        this.replaceText(editor, caret, soff, woff, indent);
                    }
                    if (l == eline) break;
                    ++l;
                }
            }
        }
        if (!Intrinsics.areEqual((Object)editor.getMode(), (Object)Mode.INSERT.INSTANCE)) {
            if (!range.isMultiple()) {
                VimCaret newCaret = caret.setVimLastColumnAndGetCaret(intendedColumn);
                int offset = VimInjectorKt.getInjector().getMotion().moveCaretToLineWithStartOfLineOption(editor, sline, caret);
                v1 = newCaret.moveToOffset(offset);
            } else {
                v1 = caret.moveToOffset(range.getStartOffset());
            }
        }
    }

    @Override
    public boolean initBlockInsert(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull TextRange range, boolean append) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int lines = Companion.getLinesCountInVisualBlock(editor, range);
        BufferPosition startPosition = editor.offsetToBufferPosition(range.getStartOffset());
        for (VimCaret caret : editor.carets()) {
            int line = startPosition.getLine();
            int column = startPosition.getColumn();
            if (append) {
                column += range.getMaxLength();
                if (caret.getVimLastColumn() == 9999) {
                    column = 9999;
                }
            }
            int lineLength = EngineEditorHelperKt.lineLength(editor, line);
            if (column < 9999 && lineLength < column) {
                String pad = VimInjectorKt.getInjector().getEngineEditorHelper().pad(editor, line, column);
                int offset = editor.getLineEndOffset(line);
                this.insertText(editor, caret, offset, pad);
            }
            caret.moveToInlayAwareOffset(editor.bufferPositionToOffset(new BufferPosition(line, column, false, 4, null)));
            this.setInsertRepeat(lines, column, append);
        }
        this.insertBeforeCaret(editor, context);
        return true;
    }

    @Override
    public void reset() {
        this.strokes.clear();
        this.repeatCharsCount = 0;
        if (this.lastStrokes != null) {
            List<Object> list = this.lastStrokes;
            Intrinsics.checkNotNull(list);
            list.clear();
        }
    }

    @Override
    public void saveStrokes(@Nullable String newStrokes) {
        String string = newStrokes;
        Intrinsics.checkNotNull((Object)string);
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        this.strokes.add(chars);
    }

    @Override
    @TestOnly
    public void resetRepeat() {
        this.setInsertRepeat(0, 0, false);
    }

    private final char changeCase(char ch, VimChangeGroup.ChangeCaseType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                if (Character.isLowerCase(ch)) {
                    yield Character.toUpperCase(ch);
                }
                if (Character.isUpperCase(ch)) {
                    yield Character.toLowerCase(ch);
                }
                yield ch;
            }
            case 2 -> Character.toLowerCase(ch);
            case 3 -> Character.toUpperCase(ch);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit deleteText$lambda$0(VimEditor $editor, Pair $newRange) {
        $editor.deleteString(new TextRange(((Number)$newRange.getFirst()).intValue(), ((Number)$newRange.getSecond()).intValue()));
        return Unit.INSTANCE;
    }

    private static final Unit insertText$lambda$1(VimEditor $editor, VimCaret $caret, int $offset, String $str) {
        Intrinsics.checkNotNull((Object)$editor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
        ((MutableVimEditor)$editor).insertText($caret, $offset, $str);
        return Unit.INSTANCE;
    }

    private static final Unit runEnterAction$lambda$3(VimUndoRedo $undo, long $nanoTime, VimCaret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((VimTimestampBasedUndoService)$undo).startInsertSequence(it, it.getOffset(), $nanoTime);
        return Unit.INSTANCE;
    }

    private static final Unit processKey$lambda$8(VimChangeGroupBase this$0, KeyStroke $key, KeyHandlerState keyHandlerState, VimEditor e, ExecutionContext c) {
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this$0.type(e, c, $key.getKeyChar());
        return Unit.INSTANCE;
    }

    private static final Unit processKey$lambda$9(VimChangeGroupBase this$0, KeyStroke $key, KeyHandlerState keyHandlerState, VimEditor e, ExecutionContext c) {
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this$0.type(e, c, VimInjectorKt.getInjector().getParser().toKeyNotation($key));
        return Unit.INSTANCE;
    }

    private static final Unit processKey$lambda$10(VimChangeGroupBase this$0, KeyHandlerState keyHandlerState, VimEditor e, ExecutionContext c) {
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this$0.type(e, c, ' ');
        return Unit.INSTANCE;
    }

    private static final Unit processKeyInSelectMode$lambda$12$lambda$11(VimChangeGroupBase this$0, KeyStroke $key, KeyHandlerState keyHandlerState, VimEditor lambdaEditor, ExecutionContext lambdaContext) {
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
        lambdaEditor.exitSelectModeNative(false);
        KeyHandler.Companion.getInstance().reset(lambdaEditor);
        if (this$0.isPrintableChar($key.getKeyChar()) || this$0.activeTemplateWithLeftRightMotion(lambdaEditor, $key)) {
            VimInjectorKt.getInjector().getChangeGroup().insertBeforeCaret(lambdaEditor, lambdaContext);
        }
        return Unit.INSTANCE;
    }

    private static final Unit deleteRange$lambda$18(VimEditor $editor, int $textLength) {
        $editor.deleteString(new TextRange($textLength - 1, $textLength));
        return Unit.INSTANCE;
    }

    private static final Unit replaceText$lambda$19(VimEditor $editor, int $start, int $end, String $str) {
        Intrinsics.checkNotNull((Object)$editor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
        ((MutableVimEditor)$editor).replaceString($start, $end, $str);
        return Unit.INSTANCE;
    }

    private static final int sortRange$lambda$21(Comparator $lineComparator, Pair l1, Pair l2) {
        return $lineComparator.compare(l1.getSecond(), l2.getSecond());
    }

    private static final int sortRange$lambda$22(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimChangeGroupBase.class);
        Object[] objectArray = new String[]{VIM_MOTION_WORD_RIGHT, VIM_MOTION_BIG_WORD_RIGHT, VIM_MOTION_CAMEL_RIGHT};
        wordMotions = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/maddyhome/idea/vim/api/VimChangeGroupBase$Companion;", "", "<init>", "()V", "MAX_REPEAT_CHARS_COUNT", "", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLinesCountInVisualBlock", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "HEX_START", "", "Lorg/jetbrains/annotations/NonNls;", "VIM_MOTION_BIG_WORD_RIGHT", "VIM_MOTION_WORD_RIGHT", "VIM_MOTION_CAMEL_RIGHT", "VIM_MOTION_WORD_END_RIGHT", "VIM_MOTION_BIG_WORD_END_RIGHT", "VIM_MOTION_CAMEL_END_RIGHT", "MAX_HEX_INTEGER", "wordMotions", "", "getWordMotions", "()Ljava/util/Set;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public final int getLinesCountInVisualBlock(@NotNull VimEditor editor, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            int[] startOffsets = range.getStartOffsets();
            if (startOffsets.length == 0) {
                return 0;
            }
            BufferPosition firstStart = editor.offsetToBufferPosition(startOffsets[0]);
            BufferPosition lastStart = editor.offsetToBufferPosition(startOffsets[range.size() - 1]);
            return lastStart.getLine() - firstStart.getLine() + 1;
        }

        @NotNull
        public final Set<String> getWordMotions() {
            return wordMotions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/maddyhome/idea/vim/api/VimChangeGroupBase$VimChangesListener;", "Lcom/maddyhome/idea/vim/common/ChangesListener;", "<init>", "(Lcom/maddyhome/idea/vim/api/VimChangeGroupBase;)V", "documentChanged", "", "change", "Lcom/maddyhome/idea/vim/common/ChangesListener$Change;", "getAdjustCaretActions", "", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "vim-engine"})
    @SourceDebugExtension(value={"SMAP\nVimChangeGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimChangeGroupBase.kt\ncom/maddyhome/idea/vim/api/VimChangeGroupBase$VimChangesListener\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,2115:1\n106#2:2116\n78#2,22:2117\n106#2:2139\n78#2,22:2140\n*S KotlinDebug\n*F\n+ 1 VimChangeGroupBase.kt\ncom/maddyhome/idea/vim/api/VimChangeGroupBase$VimChangesListener\n*L\n346#1:2116\n346#1:2117,22\n353#1:2139\n353#1:2140,22\n*E\n"})
    protected final class VimChangesListener
    implements ChangesListener {
        @Override
        public void documentChanged(@NotNull ChangesListener.Change change) {
            NativeAction editorDelete;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            boolean $i$f$trim;
            CharSequence $this$trim$iv$iv;
            boolean $i$f$trim2;
            String $this$trim$iv;
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            String newFragment = change.getNewFragment();
            String oldFragment = change.getOldFragment();
            int newFragmentLength = newFragment.length();
            int oldFragmentLength = oldFragment.length();
            if (VimChangeGroupBase.this.repeatCharsCount > 10000) {
                return;
            }
            if (StringsKt.startsWith$default((String)newFragment, (String)"\n", (boolean)false, (int)2, null)) {
                $this$trim$iv = newFragment;
                $i$f$trim2 = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
                    VimChangeGroupBase.this.strokes.addAll((Collection<Object>)this.getAdjustCaretActions(change));
                    VimChangeGroupBase.this.oldOffset = -1;
                    return;
                }
            }
            if (!VimChangeGroupBase.this.getTabAction() && newFragmentLength > 1) {
                $this$trim$iv = newFragment;
                $i$f$trim2 = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
                    return;
                }
            }
            VimChangeGroupBase.this.setTabAction(false);
            VimChangeGroupBase.this.strokes.addAll((Collection<Object>)this.getAdjustCaretActions(change));
            if (oldFragmentLength > 0 && (editorDelete = VimInjectorKt.getInjector().getNativeActionManager().getDeleteAction()) != null) {
                VimChangeGroupBase vimChangeGroupBase = VimChangeGroupBase.this;
                int n = 0;
                while (n < oldFragmentLength) {
                    int it2 = n++;
                    boolean bl = false;
                    vimChangeGroupBase.strokes.add(editorDelete);
                }
            }
            if (newFragmentLength > 0) {
                List<Object> list = VimChangeGroupBase.this.strokes;
                char[] cArray = newFragment.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                list.add(cArray);
            }
            VimChangeGroupBase.this.repeatCharsCount += newFragmentLength;
            VimChangeGroupBase.this.oldOffset = change.getOffset() + newFragmentLength;
        }

        private final List<EditorActionHandlerBase> getAdjustCaretActions(ChangesListener.Change change) {
            int delta = change.getOffset() - VimChangeGroupBase.this.oldOffset;
            if (VimChangeGroupBase.this.oldOffset >= 0 && delta != 0) {
                List positionCaretActions = new ArrayList();
                String motionName = delta < 0 ? "VimMotionLeftAction" : "VimMotionRightAction";
                EditorActionHandlerBase editorActionHandlerBase = VimInjectorKt.getInjector().getActionExecutor().findVimAction(motionName);
                Intrinsics.checkNotNull((Object)editorActionHandlerBase);
                EditorActionHandlerBase action = editorActionHandlerBase;
                int count = Math.abs(delta);
                int n = 0;
                while (n < count) {
                    int it = n++;
                    boolean bl = false;
                    positionCaretActions.add(action);
                }
                return positionCaretActions;
            }
            return CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VimChangeGroup.ChangeCaseType.values().length];
            try {
                nArray[VimChangeGroup.ChangeCaseType.TOGGLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VimChangeGroup.ChangeCaseType.LOWER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VimChangeGroup.ChangeCaseType.UPPER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

