/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimscriptParser;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.parser.generated.VimscriptLexer;
import com.maddyhome.idea.vim.parser.generated.VimscriptParser;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.EngineExCommandProvider;
import com.maddyhome.idea.vim.vimscript.model.commands.ExCommandProvider;
import com.maddyhome.idea.vim.vimscript.model.commands.ExCommandTree;
import com.maddyhome.idea.vim.vimscript.model.commands.LazyExCommandInstance;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.parser.DeletionInfo;
import com.maddyhome.idea.vim.vimscript.parser.errors.IdeavimErrorListener;
import com.maddyhome.idea.vim.vimscript.parser.visitors.CommandVisitor;
import com.maddyhome.idea.vim.vimscript.parser.visitors.ExpressionVisitor;
import com.maddyhome.idea.vim.vimscript.parser.visitors.ScriptVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 02\u00020\u0001:\u00010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001bH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020\u001bH\u0016J\u001a\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u001b2\b\b\u0002\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001bH\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001bH\u0002J\"\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0-0\u000f2\u0006\u0010#\u001a\u00020\u001bH\u0002J\b\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00061"}, d2={"Lcom/maddyhome/idea/vim/api/VimscriptParserBase;", "Lcom/maddyhome/idea/vim/api/VimscriptParser;", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "linesWithErrors", "", "", "getLinesWithErrors", "()Ljava/util/List;", "tries", "deletionInfo", "Lcom/maddyhome/idea/vim/vimscript/parser/DeletionInfo;", "commandProviders", "", "Lcom/maddyhome/idea/vim/vimscript/model/commands/ExCommandProvider;", "getCommandProviders", "exCommands", "Lcom/maddyhome/idea/vim/vimscript/model/commands/ExCommandTree;", "getExCommands", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/ExCommandTree;", "exCommands$delegate", "Lkotlin/Lazy;", "parse", "Lcom/maddyhome/idea/vim/vimscript/model/Script;", "script", "", "parseExpression", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "expression", "parseCommand", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command;", "command", "addNewlineIfMissing", "text", "parseLetCommand", "getParser", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser;", "addListener", "", "getTextWithoutErrors", "uncommentIdeaVimIgnore", "configuration", "splitToLines", "Lkotlin/Pair;", "resetParser", "", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimscriptParserBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimscriptParserBase.kt\ncom/maddyhome/idea/vim/api/VimscriptParserBase\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,185:1\n38#2:186\n1869#3,2:187\n1869#3:189\n1870#3:192\n216#4,2:190\n*S KotlinDebug\n*F\n+ 1 VimscriptParserBase.kt\ncom/maddyhome/idea/vim/api/VimscriptParserBase\n*L\n35#1:186\n64#1:187,2\n42#1:189\n42#1:192\n42#1:190,2\n*E\n"})
public abstract class VimscriptParserBase
implements VimscriptParser {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final VimLogger logger;
    @NotNull
    private final List<Integer> linesWithErrors;
    private int tries;
    @NotNull
    private DeletionInfo deletionInfo;
    @NotNull
    private final List<ExCommandProvider> commandProviders;
    @NotNull
    private final Lazy exCommands$delegate;
    private static final int MAX_NUMBER_OF_TRIES = 5;

    public VimscriptParserBase() {
        boolean $i$f$vimLogger = false;
        this.logger = VimInjectorKt.getInjector().getLogger(com.maddyhome.idea.vim.parser.generated.VimscriptParser.class);
        this.linesWithErrors = new ArrayList();
        this.deletionInfo = new DeletionInfo();
        this.commandProviders = CollectionsKt.listOf((Object)EngineExCommandProvider.INSTANCE);
        this.exCommands$delegate = LazyKt.lazy(() -> VimscriptParserBase.exCommands_delegate$lambda$2(this));
    }

    @Override
    @NotNull
    public List<Integer> getLinesWithErrors() {
        return this.linesWithErrors;
    }

    @NotNull
    protected List<ExCommandProvider> getCommandProviders() {
        return this.commandProviders;
    }

    @Override
    @NotNull
    public ExCommandTree getExCommands() {
        Lazy lazy = this.exCommands$delegate;
        return (ExCommandTree)lazy.getValue();
    }

    @Override
    @NotNull
    public Script parse(@NotNull String script) {
        Script script2;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String preprocessedText = this.uncommentIdeaVimIgnore(this.getTextWithoutErrors(script));
        this.getLinesWithErrors().clear();
        com.maddyhome.idea.vim.parser.generated.VimscriptParser parser2 = this.getParser(this.addNewlineIfMissing(preprocessedText), true);
        VimscriptParser.ScriptContext scriptContext = parser2.script();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)scriptContext), (String)"script(...)");
        ParseTree AST = (ParseTree)scriptContext;
        if (!((Collection)this.getLinesWithErrors()).isEmpty()) {
            if (this.tries > 5) {
                this.logger.warn("Reached the maximum number of tries to fix a script. Parsing is stopped.");
                this.resetParser();
                return new Script(CollectionsKt.emptyList());
            }
            ++this.tries;
            script2 = this.parse(preprocessedText);
        } else {
            script2 = (Script)ScriptVisitor.INSTANCE.visit(AST);
        }
        Script script3 = script2;
        Iterable $this$forEach$iv = script3.getUnits();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Executable it = (Executable)element$iv;
            boolean bl = false;
            it.restoreOriginalRange(this.deletionInfo);
        }
        this.resetParser();
        Intrinsics.checkNotNull((Object)script3);
        return script3;
    }

    @Override
    @Nullable
    public Expression parseExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        com.maddyhome.idea.vim.parser.generated.VimscriptParser parser2 = this.getParser(expression, true);
        VimscriptParser.ExprContext exprContext = parser2.expr();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)exprContext), (String)"expr(...)");
        ParseTree AST = (ParseTree)exprContext;
        if (!((Collection)this.getLinesWithErrors()).isEmpty()) {
            this.resetParser();
            return null;
        }
        return (Expression)ExpressionVisitor.INSTANCE.visit(AST);
    }

    @Override
    @Nullable
    public Command parseCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        com.maddyhome.idea.vim.parser.generated.VimscriptParser parser2 = this.getParser(this.addNewlineIfMissing(command), true);
        VimscriptParser.CommandContext commandContext = parser2.command();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)commandContext), (String)"command(...)");
        ParseTree AST = (ParseTree)commandContext;
        if (!((Collection)this.getLinesWithErrors()).isEmpty()) {
            this.resetParser();
            return null;
        }
        return (Command)CommandVisitor.INSTANCE.visit(AST);
    }

    private final String addNewlineIfMissing(String text) {
        if (((CharSequence)text).length() == 0) {
            return "\n";
        }
        return StringsKt.last((CharSequence)text) == '\n' ? text : (StringsKt.last((CharSequence)text) == '\r' ? text + "\r\n" : text + "\n");
    }

    @Override
    @Nullable
    public Command parseLetCommand(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        com.maddyhome.idea.vim.parser.generated.VimscriptParser parser2 = this.getParser(this.addNewlineIfMissing(text), true);
        VimscriptParser.LetCommandsContext letCommandsContext = parser2.letCommands();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)letCommandsContext), (String)"letCommands(...)");
        ParseTree AST = (ParseTree)letCommandsContext;
        if (!((Collection)this.getLinesWithErrors()).isEmpty()) {
            this.resetParser();
            return null;
        }
        return (Command)CommandVisitor.INSTANCE.visit(AST);
    }

    private final com.maddyhome.idea.vim.parser.generated.VimscriptParser getParser(String text, boolean addListener) {
        CodePointCharStream codePointCharStream = CharStreams.fromString((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)codePointCharStream, (String)"fromString(...)");
        CharStream input = (CharStream)codePointCharStream;
        VimscriptLexer lexer = new VimscriptLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        com.maddyhome.idea.vim.parser.generated.VimscriptParser parser2 = new com.maddyhome.idea.vim.parser.generated.VimscriptParser((TokenStream)tokens);
        parser2.getErrorListeners().clear();
        if (addListener) {
            parser2.addErrorListener((ANTLRErrorListener)new IdeavimErrorListener());
        }
        return parser2;
    }

    static /* synthetic */ com.maddyhome.idea.vim.parser.generated.VimscriptParser getParser$default(VimscriptParserBase vimscriptParserBase, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getParser");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return vimscriptParserBase.getParser(string, bl);
    }

    private final String getTextWithoutErrors(String text) {
        List lineNumbersToDelete = CollectionsKt.sortedDescending((Iterable)this.getLinesWithErrors());
        List lines = CollectionsKt.toMutableList((Collection)this.splitToLines(text));
        Iterator iterator = lineNumbersToDelete.iterator();
        while (iterator.hasNext()) {
            int lineNumber = ((Number)iterator.next()).intValue();
            if (lines.size() <= lineNumber) {
                this.logger.warn("Parsing error affects lines till EOF");
                continue;
            }
            this.deletionInfo.registerDeletion(((Number)((Pair)lines.get(lineNumber - 1)).getFirst()).intValue(), ((String)((Pair)lines.get(lineNumber - 1)).getSecond()).length());
            lines.remove(lineNumber - 1);
        }
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"", null, null, (int)0, null, VimscriptParserBase::getTextWithoutErrors$lambda$4, (int)30, null);
    }

    private final String uncommentIdeaVimIgnore(String configuration) {
        String ideavimIgnore = "ideavim ignore";
        Regex ideavimIgnorePattern = new Regex("\"( )*ideavim ignore", RegexOption.IGNORE_CASE);
        StringBuilder result = new StringBuilder();
        int startIndex = 0;
        Sequence matches = ideavimIgnorePattern.findAll((CharSequence)configuration, startIndex);
        for (MatchResult match : matches) {
            String string = configuration.substring(startIndex, match.getRange().getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.append(string);
            result.append(ideavimIgnore);
            startIndex = match.getRange().getLast() + 1;
            int delta = match.getRange().getLast() - match.getRange().getFirst() + 1 - ideavimIgnore.length();
            if (delta <= 0) continue;
            this.deletionInfo.registerDeletion(match.getRange().getFirst(), delta);
        }
        String string = configuration.substring(startIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        result.append(string);
        String string2 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final List<Pair<Integer, String>> splitToLines(String text) {
        List result = new ArrayList();
        StringBuilder currentLine = new StringBuilder();
        int currentLineStartOffset = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            char c = text.charAt(i);
            currentLine.append(c);
            if (c != '\n') continue;
            result.add(new Pair((Object)currentLineStartOffset, (Object)currentLine.toString()));
            currentLineStartOffset = i2 + 1;
            StringsKt.clear((StringBuilder)currentLine);
        }
        if (((CharSequence)currentLine).length() > 0) {
            result.add(new Pair((Object)currentLineStartOffset, (Object)currentLine.toString()));
        }
        return result;
    }

    private final void resetParser() {
        this.tries = 0;
        this.getLinesWithErrors().clear();
        this.deletionInfo.reset();
    }

    private static final ExCommandTree exCommands_delegate$lambda$2(VimscriptParserBase this$0) {
        ExCommandTree commandTree = new ExCommandTree();
        Iterable $this$forEach$iv = this$0.getCommandProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExCommandProvider provider = (ExCommandProvider)element$iv;
            boolean bl = false;
            Map<String, LazyExCommandInstance> $this$forEach$iv2 = provider.getCommands();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, LazyExCommandInstance>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, LazyExCommandInstance> element$iv2;
                Map.Entry<String, LazyExCommandInstance> it = element$iv2 = iterator.next();
                boolean bl2 = false;
                commandTree.addCommand(it.getKey(), it.getValue());
            }
        }
        return commandTree;
    }

    private static final CharSequence getTextWithoutErrors$lambda$4(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)it.getSecond();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/api/VimscriptParserBase$Companion;", "", "<init>", "()V", "MAX_NUMBER_OF_TRIES", "", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

