/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.ranges;

import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.ranges.Address;
import com.maddyhome.idea.vim.mark.Mark;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0013\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/MarkAddress;", "Lcom/maddyhome/idea/vim/ex/ranges/Address;", "mark", "", "offset", "", "move", "", "<init>", "(CIZ)V", "calculateLine1", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "equals", "other", "", "hashCode", "toString", "", "vim-engine"})
@TestOnly
public final class MarkAddress
extends Address {
    private final char mark;

    public MarkAddress(char mark, int offset, boolean move) {
        super(offset, move, null);
        this.mark = mark;
    }

    @Override
    protected int calculateLine1(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Mark mark = VimInjectorKt.getInjector().getMarkService().getMark(caret, this.mark);
        if (mark == null) {
            throw ExExceptionsKt.exExceptionMessage("E20", new Object[0]);
        }
        Mark mark2 = mark;
        return mark2.getLine() + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!super.equals(other)) return false;
        if (!(other instanceof MarkAddress)) return false;
        MarkAddress markAddress = (MarkAddress)other;
        if (markAddress == null) return false;
        if (markAddress.mark != this.mark) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * Character.hashCode(this.mark);
    }

    @Override
    @NotNull
    public String toString() {
        return "MarkAddress[mark=" + this.mark + ", " + super.toString() + "]";
    }
}

