/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.key.Frame;
import java.util.Collection;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/key/KeyStack;", "", "<init>", "()V", "stack", "Lkotlin/collections/ArrayDeque;", "Lcom/maddyhome/idea/vim/key/Frame;", "hasStroke", "", "isEmpty", "feedSomeStroke", "Ljavax/swing/KeyStroke;", "feedStroke", "addKeys", "", "keyStrokes", "", "removeFirst", "resetFirst", "dump", "", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nKeyStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyStack.kt\ncom/maddyhome/idea/vim/key/KeyStack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,107:1\n2746#2,3:108\n1869#2,2:111\n1878#2,3:117\n27#3,4:113\n38#3:120\n*S KotlinDebug\n*F\n+ 1 KeyStack.kt\ncom/maddyhome/idea/vim/key/KeyStack\n*L\n32#1:108,3\n36#1:111,2\n71#1:117,3\n51#1:113,4\n81#1:120\n*E\n"})
public final class KeyStack {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayDeque<Frame> stack = new ArrayDeque();
    @NotNull
    private static final VimLogger LOG;

    public final boolean hasStroke() {
        return !((Collection)this.stack).isEmpty() && ((Frame)this.stack.first()).hasStroke();
    }

    public final boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$none$iv = (Iterable)this.stack;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Frame it = (Frame)element$iv;
                    boolean bl2 = false;
                    if (!it.hasStroke()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Nullable
    public final KeyStroke feedSomeStroke() {
        Iterable $this$forEach$iv = (Iterable)this.stack;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Frame it = (Frame)element$iv;
            boolean bl = false;
            if (!it.hasStroke()) continue;
            return it.feed();
        }
        return null;
    }

    @NotNull
    public final KeyStroke feedStroke() {
        Frame frame = (Frame)this.stack.first();
        KeyStroke key = frame.feed();
        return key;
    }

    public final void addKeys(@NotNull List<? extends KeyStroke> keyStrokes) {
        Intrinsics.checkNotNullParameter(keyStrokes, (String)"keyStrokes");
        VimLogger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Got new keys to key stack: " + keyStrokes);
        }
        this.stack.addFirst((Object)new Frame(keyStrokes, 0, 2, null));
    }

    public final void removeFirst() {
        if (!((Collection)this.stack).isEmpty()) {
            this.stack.removeFirst();
        }
    }

    public final void resetFirst() {
        if (!((Collection)this.stack).isEmpty()) {
            ((Frame)this.stack.first()).resetPointer();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump() {
        StringBuilder stringBuilder;
        StringBuilder $this$dump_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$dump_u24lambda_u244.append("KeyStack:").append('\n');
        $this$dump_u24lambda_u244.append("Stack size: " + this.stack.size()).append('\n');
        Iterable $this$forEachIndexed$iv = (Iterable)this.stack;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void frame;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Frame frame2 = (Frame)item$iv;
            int index = n;
            boolean bl2 = false;
            $this$dump_u24lambda_u244.append("Frame " + index + ":").append('\n');
            $this$dump_u24lambda_u244.append("Keys: " + frame.getKeys()).append('\n');
            $this$dump_u24lambda_u244.append("Pointer: " + frame.getPointer()).append('\n');
            $this$dump_u24lambda_u244.append('\n');
        }
        return stringBuilder.toString();
    }

    static {
        boolean $i$f$vimLogger = false;
        LOG = VimInjectorKt.getInjector().getLogger(KeyStack.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/key/KeyStack$Companion;", "", "<init>", "()V", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

