/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.history.HistoryEntry;
import com.maddyhome.idea.vim.history.VimHistory;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J&\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0002J0\u0010\"\u001a\u00020#*\u00060$j\u0002`%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010!\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001eH\u0002J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J'\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u00020\u001eH\u00d6\u0001J\t\u00103\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00065"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/HistoryCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "modifier", "Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getModifier", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "parseType", "Lkotlin/Pair;", "", "arg", "parseTypePrefix", "type", "outputHistory", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "name", "Lcom/maddyhome/idea/vim/history/VimHistory$Type;", "start", "end", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nHistoryCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistoryCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/HistoryCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1869#2,2:141\n*S KotlinDebug\n*F\n+ 1 HistoryCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/HistoryCommand\n*L\n125#1:141,2\n*E\n"})
public final class HistoryCommand
extends Command.SingleExecution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range range;
    @NotNull
    private final CommandModifier modifier;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;
    @NotNull
    private static final String CMD = "cmd";
    @NotNull
    private static final String SEARCH = "search";
    @NotNull
    private static final String EXPRESSION = "expr";
    @NotNull
    private static final String INPUT = "input";
    @NotNull
    private static final String ALL = "all";

    public HistoryCommand(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, modifier, argument);
        this.range = range;
        this.modifier = modifier;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final CommandModifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        StringBuilder stringBuilder;
        Object trailing;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (this.modifier == CommandModifier.BANG) {
            throw ExExceptionsKt.exExceptionMessage("E477", new Object[0]);
        }
        if (VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getHistory() == 0) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("message.history.option.is.zero", new Object[0]));
            return ExecutionResult.Success.INSTANCE;
        }
        String arg = ((Object)StringsKt.trim((CharSequence)this.argument)).toString();
        Pair<String, Integer> pair = this.parseType(arg);
        String type = (String)pair.component1();
        int offset = ((Number)pair.component2()).intValue();
        int first = 0;
        int last = 0;
        String string = arg.substring(offset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String rest = string;
        Regex regex = new Regex("^\\s*((?<first>-?\\d+)(\\s*,\\s*(?<last>-?\\d+))?)(?<trailing>.*)");
        MatchResult match = regex.matchEntire((CharSequence)rest);
        if (match == null && ((CharSequence)rest).length() > 0 && !StringsKt.isBlank((CharSequence)rest)) {
            Object[] objectArray = new Object[]{((Object)StringsKt.trim((CharSequence)rest)).toString()};
            throw ExExceptionsKt.exExceptionMessage("E488", objectArray);
        }
        Object object = match;
        if (object == null || (object = object.getGroups()) == null || (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)object, (String)"trailing")) == null || (object = object.getValue()) == null) {
            object = "";
        }
        if (!StringsKt.isBlank((CharSequence)((CharSequence)(trailing = object)))) {
            Object[] objectArray = new Object[]{((Object)StringsKt.trim((CharSequence)((CharSequence)trailing))).toString()};
            throw ExExceptionsKt.exExceptionMessage("E488", objectArray);
        }
        Object object2 = match;
        first = object2 != null && (object2 = object2.getGroups()) != null && (object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)object2, (String)"first")) != null && (object2 = object2.getValue()) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
        Object object3 = match;
        last = object3 != null && (object3 = object3.getGroups()) != null && (object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)object3, (String)"last")) != null && (object3 = object3.getValue()) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 0;
        StringBuilder $this$processCommand_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (Intrinsics.areEqual((Object)type, (Object)CMD) || Intrinsics.areEqual((Object)type, (Object)ALL)) {
            this.outputHistory($this$processCommand_u24lambda_u240, CMD, VimHistory.Type.Command.INSTANCE, first, last);
        }
        if (Intrinsics.areEqual((Object)type, (Object)ALL)) {
            $this$processCommand_u24lambda_u240.append('\n');
        }
        if (Intrinsics.areEqual((Object)type, (Object)SEARCH) || Intrinsics.areEqual((Object)type, (Object)ALL)) {
            this.outputHistory($this$processCommand_u24lambda_u240, SEARCH, VimHistory.Type.Search.INSTANCE, first, last);
        }
        if (Intrinsics.areEqual((Object)type, (Object)ALL)) {
            $this$processCommand_u24lambda_u240.append('\n');
        }
        if (Intrinsics.areEqual((Object)type, (Object)EXPRESSION) || Intrinsics.areEqual((Object)type, (Object)ALL)) {
            this.outputHistory($this$processCommand_u24lambda_u240, EXPRESSION, VimHistory.Type.Expression.INSTANCE, first, last);
        }
        if (Intrinsics.areEqual((Object)type, (Object)ALL)) {
            $this$processCommand_u24lambda_u240.append('\n');
        }
        if (Intrinsics.areEqual((Object)type, (Object)INPUT) || Intrinsics.areEqual((Object)type, (Object)ALL)) {
            this.outputHistory($this$processCommand_u24lambda_u240, INPUT, VimHistory.Type.Input.INSTANCE, first, last);
        }
        if (Intrinsics.areEqual((Object)type, (Object)ALL)) {
            $this$processCommand_u24lambda_u240.append('\n');
        }
        String text = stringBuilder.toString();
        VimInjectorKt.getInjector().getOutputPanel().output(editor, context, text);
        return ExecutionResult.Success.INSTANCE;
    }

    private final Pair<String, Integer> parseType(String arg) {
        if (((CharSequence)arg).length() == 0 || Character.isDigit(arg.charAt(0))) {
            return new Pair((Object)CMD, (Object)0);
        }
        switch (arg.charAt(0)) {
            case ':': {
                return new Pair((Object)CMD, (Object)1);
            }
            case '/': 
            case '?': {
                return new Pair((Object)SEARCH, (Object)1);
            }
            case '=': {
                return new Pair((Object)EXPRESSION, (Object)1);
            }
            case '@': {
                return new Pair((Object)INPUT, (Object)1);
            }
        }
        Pair<String, Integer> pair = this.parseTypePrefix(arg, CMD);
        if (pair == null && (pair = this.parseTypePrefix(arg, SEARCH)) == null && (pair = this.parseTypePrefix(arg, EXPRESSION)) == null && (pair = this.parseTypePrefix(arg, INPUT)) == null && (pair = this.parseTypePrefix(arg, ALL)) == null) {
            Object[] objectArray = new Object[]{arg};
            throw ExExceptionsKt.exExceptionMessage("E488", objectArray);
        }
        return pair;
    }

    private final Pair<String, Integer> parseTypePrefix(String arg, String type) {
        String prefix = StringsKt.commonPrefixWith$default((CharSequence)arg, (CharSequence)type, (boolean)false, (int)2, null);
        if (((CharSequence)prefix).length() > 0) {
            return new Pair((Object)type, (Object)prefix.length());
        }
        return null;
    }

    private final void outputHistory(StringBuilder $this$outputHistory, String name, VimHistory.Type type, int start, int end) {
        $this$outputHistory.append("      #  " + name + " history");
        Iterable $this$forEach$iv = VimInjectorKt.getInjector().getHistoryGroup().getEntries(type, start, end);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HistoryEntry it = (HistoryEntry)element$iv;
            boolean bl = false;
            String num = StringsKt.padStart$default((String)String.valueOf(it.getNumber()), (int)7, (char)'\u0000', (int)2, null);
            $this$outputHistory.append('\n');
            $this$outputHistory.append(num + "  " + it.getEntry());
        }
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final CommandModifier component2() {
        return this.modifier;
    }

    @NotNull
    public final String component3() {
        return this.argument;
    }

    @NotNull
    public final HistoryCommand copy(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new HistoryCommand(range, modifier, argument);
    }

    public static /* synthetic */ HistoryCommand copy$default(HistoryCommand historyCommand, Range range, CommandModifier commandModifier, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = historyCommand.range;
        }
        if ((n & 2) != 0) {
            commandModifier = historyCommand.modifier;
        }
        if ((n & 4) != 0) {
            string = historyCommand.argument;
        }
        return historyCommand.copy(range, commandModifier, string);
    }

    @NotNull
    public String toString() {
        return "HistoryCommand(range=" + this.range + ", modifier=" + this.modifier + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.modifier.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HistoryCommand)) {
            return false;
        }
        HistoryCommand historyCommand = (HistoryCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)historyCommand.range)) {
            return false;
        }
        if (this.modifier != historyCommand.modifier) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)historyCommand.argument);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/HistoryCommand$Companion;", "", "<init>", "()V", "CMD", "", "SEARCH", "EXPRESSION", "INPUT", "ALL", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

