/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.SelectionInfo;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVirtualFile;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.InvalidRangeException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.LineRangeKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.mark.VimMark;
import com.maddyhome.idea.vim.put.PutData;
import com.maddyhome.idea.vim.put.VimPut;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J,\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\"\u001a\u00020!H\u0002J \u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020 2\u0006\u0010\"\u001a\u00020!H\u0002JA\u0010'\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010!2\b\u0010*\u001a\u0004\u0018\u00010!2\u0006\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020-H\u0002\u00a2\u0006\u0002\u0010.J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u0010\"\u001a\u00020!H\u0002J\u0018\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020!2\u0006\u00104\u001a\u000205H\u0002J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0005H\u00c6\u0003J\t\u00108\u001a\u00020\u0007H\u00c6\u0003J'\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010=H\u00d6\u0003J\t\u0010>\u001a\u00020!H\u00d6\u0001J\t\u0010?\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006@"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/MoveTextCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "modifier", "Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getModifier", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "shiftGlobalMark", "", "markAndLine", "Lkotlin/Pair;", "Lcom/maddyhome/idea/vim/mark/Mark;", "", "shift", "shiftLocalMark", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "mark", "shiftSelectionInfo", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "startOffset", "endOffset", "selectionInfo", "Lcom/maddyhome/idea/vim/api/SelectionInfo;", "Lcom/maddyhome/idea/vim/common/TextRange;", "(Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;Ljava/lang/Integer;Ljava/lang/Integer;Lcom/maddyhome/idea/vim/api/SelectionInfo;ILcom/maddyhome/idea/vim/common/TextRange;)V", "shiftBufferPosition", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "bufferPosition", "normalizeAddress", "address0", "lineRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMoveTextCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveTextCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/MoveTextCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n774#2:206\n865#2,2:207\n774#2:209\n865#2,2:210\n774#2:212\n865#2,2:213\n1563#2:215\n1634#2,3:216\n1869#2,2:220\n1869#2,2:222\n1#3:219\n*S KotlinDebug\n*F\n+ 1 MoveTextCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/MoveTextCommand\n*L\n81#1:206\n81#1:207,2\n82#1:209\n82#1:210,2\n85#1:212\n85#1:213,2\n86#1:215\n86#1:216,3\n130#1:220,2\n131#1:222,2\n*E\n"})
public final class MoveTextCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final CommandModifier modifier;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public MoveTextCommand(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, modifier, argument);
        this.range = range;
        this.modifier = modifier;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_REQUIRED, Command.Access.WRITABLE, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final CommandModifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        int n;
        int caretLine;
        Object it;
        PutData putData;
        Integer n2;
        Integer n3;
        boolean bl;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Mark it2;
        Iterable $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int caretCount = editor.nativeCarets().size();
        if (caretCount > 1) {
            throw new ExException("Move command supported only for one caret at the moment");
        }
        VimCaret caret = editor.primaryCaret();
        LineRange sourceLineRange = this.getLineRange(editor, caret);
        TextRange sourceRange = LineRangeKt.toTextRange(sourceLineRange, editor);
        int targetAddressLine1 = this.getAddressFromArgument(editor);
        int targetLineAfterDeletion = Math.min((int)editor.fileSize(), this.normalizeAddress(targetAddressLine1 - 1, sourceLineRange));
        int linesMoved = sourceLineRange.getSize();
        if (targetLineAfterDeletion < -1 || targetLineAfterDeletion + linesMoved >= editor.lineCount()) {
            throw ExExceptionsKt.exExceptionMessage("e_invrange", new Object[0]);
        }
        int shift = targetLineAfterDeletion - editor.offsetToBufferPosition(sourceRange.getStartOffset()).getLine() + 1;
        Iterable iterable = VimInjectorKt.getInjector().getMarkService().getAllLocalMarks(caret);
        boolean $i$f$filter = false;
        void var15_15 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (Mark)element$iv$iv;
            boolean bl2 = false;
            if (!sourceRange.contains(it2.offset(editor))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (Mark)element$iv$iv;
            boolean bl3 = false;
            if (!(it2.getKey() != '<' && it2.getKey() != '>')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set localMarks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$filter2 = VimInjectorKt.getInjector().getMarkService().getGlobalMarks(editor);
        boolean $i$f$filter3 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mark it3 = (Mark)element$iv$iv;
            boolean bl4 = false;
            if (!sourceRange.contains(it3.offset(editor))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Mark it3 = (Mark)item$iv$iv;
            Collection collection = destination$iv$iv2;
            bl = false;
            collection.add(new Pair((Object)it3, (Object)it3.getLine()));
        }
        Set globalMarks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        SelectionInfo lastSelectionInfo = caret.getLastSelectionInfo();
        BufferPosition bufferPosition = lastSelectionInfo.getStart();
        if (bufferPosition != null) {
            BufferPosition it4 = bufferPosition;
            boolean bl5 = false;
            n3 = editor.bufferPositionToOffset(it4);
        } else {
            n3 = null;
        }
        Integer selectionStartOffset = n3;
        BufferPosition bufferPosition2 = lastSelectionInfo.getEnd();
        if (bufferPosition2 != null) {
            BufferPosition it5 = bufferPosition2;
            boolean bl6 = false;
            n2 = editor.bufferPositionToOffset(it5);
        } else {
            n2 = null;
        }
        Integer selectionEndOffset = n2;
        String text = EngineEditorHelperKt.getText(editor, sourceRange);
        PutData.TextData textData = new PutData.TextData(null, VimInjectorKt.getInjector().getClipboardManager().dumbCopiedText(text), SelectionType.LINE_WISE);
        boolean dropNewLineInEnd = targetLineAfterDeletion + linesMoved == editor.lineCount() - 1 && StringsKt.last((CharSequence)text) == '\n' || sourceLineRange.endLine == editor.lineCount() - 1;
        int caretColumn = caret.getBufferPosition().getColumn();
        VimInjectorKt.getInjector().getApplication().runWriteAction(() -> MoveTextCommand.processCommand$lambda$6(editor, sourceRange));
        if (targetLineAfterDeletion == -1) {
            caret.moveToOffset(0);
            putData = new PutData(textData, null, 1, true, true, false, 0, 64, null);
        } else {
            putData = new PutData(textData, null, 1, false, true, false, targetLineAfterDeletion);
        }
        PutData putData2 = putData;
        VimPut.putTextForCaret$default(VimInjectorKt.getInjector().getPut(), editor, caret, context, putData2, false, false, 48, null);
        if (dropNewLineInEnd) {
            boolean bl7 = bl = StringsKt.last((CharSequence)editor.text()) == '\n';
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            VimInjectorKt.getInjector().getApplication().runWriteAction(() -> MoveTextCommand.processCommand$lambda$7(editor));
        }
        Iterable $this$forEach$iv = globalMarks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl8 = false;
            this.shiftGlobalMark(editor, (Pair<? extends Mark, Integer>)it, shift);
        }
        $this$forEach$iv = localMarks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Mark)element$iv;
            boolean bl9 = false;
            this.shiftLocalMark(caret, (Mark)it, shift);
        }
        this.shiftSelectionInfo(caret, selectionStartOffset, selectionEndOffset, lastSelectionInfo, shift, sourceRange);
        int n4 = caretLine = targetAddressLine1 >= sourceLineRange.getStartLine1() ? targetAddressLine1 - 1 : targetAddressLine1 + sourceLineRange.getSize() - 1;
        if (!VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getStartofline()) {
            int column = EngineEditorHelperKt.normalizeColumn(editor, caretLine, caretColumn, false);
            n = editor.bufferPositionToOffset(new BufferPosition(caretLine, column, false, 4, null));
        } else {
            n = VimInjectorKt.getInjector().getMotion().moveCaretToLineStartSkipLeading(editor, caretLine);
        }
        int caretOffset = n;
        caret.moveToOffset(caretOffset);
        return ExecutionResult.Success.INSTANCE;
    }

    private final void shiftGlobalMark(VimEditor editor, Pair<? extends Mark, Integer> markAndLine, int shift) {
        int newOffset = editor.bufferPositionToOffset(new BufferPosition(((Number)markAndLine.getSecond()).intValue() + shift, ((Mark)markAndLine.getFirst()).getCol(), false, 4, null));
        VimInjectorKt.getInjector().getMarkService().setGlobalMark(editor, ((Mark)markAndLine.getFirst()).getKey(), newOffset);
    }

    private final void shiftLocalMark(VimCaret caret, Mark mark, int shift) {
        VimVirtualFile vimVirtualFile = caret.getEditor().getVirtualFile();
        if (vimVirtualFile == null) {
            return;
        }
        VimVirtualFile virtualFile = vimVirtualFile;
        String path = virtualFile.getPath();
        String protocol = virtualFile.getProtocol();
        VimMark mark2 = new VimMark(mark.getKey(), mark.getLine() + shift, mark.getCol(), path, protocol);
        VimInjectorKt.getInjector().getMarkService().setMark(caret, mark2);
    }

    private final void shiftSelectionInfo(ImmutableVimCaret caret, Integer startOffset, Integer endOffset, SelectionInfo selectionInfo, int shift, TextRange range) {
        BufferPosition newStartPosition = selectionInfo.getStart();
        if (startOffset != null && selectionInfo.getStart() != null && range.contains(startOffset)) {
            BufferPosition bufferPosition = selectionInfo.getStart();
            Intrinsics.checkNotNull((Object)bufferPosition);
            newStartPosition = this.shiftBufferPosition(bufferPosition, shift);
        }
        BufferPosition newEndPosition = selectionInfo.getEnd();
        if (endOffset != null && selectionInfo.getEnd() != null && range.contains(endOffset)) {
            BufferPosition bufferPosition = selectionInfo.getEnd();
            Intrinsics.checkNotNull((Object)bufferPosition);
            newEndPosition = this.shiftBufferPosition(bufferPosition, shift);
        }
        if (!Intrinsics.areEqual((Object)newStartPosition, (Object)selectionInfo.getStart()) || !Intrinsics.areEqual((Object)newEndPosition, (Object)selectionInfo.getEnd())) {
            caret.setLastSelectionInfo(new SelectionInfo(newStartPosition, newEndPosition, selectionInfo.getSelectionType()));
        }
    }

    private final BufferPosition shiftBufferPosition(BufferPosition bufferPosition, int shift) {
        return new BufferPosition(bufferPosition.getLine() + shift, bufferPosition.getColumn(), bufferPosition.getLeansForward());
    }

    private final int normalizeAddress(int address0, LineRange lineRange) {
        if (address0 >= lineRange.endLine) {
            return address0 - lineRange.getSize();
        }
        if (address0 >= lineRange.startLine) {
            throw new InvalidRangeException(VimInjectorKt.getInjector().getMessages().message("e_backrange", new Object[0]));
        }
        return address0;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final CommandModifier component2() {
        return this.modifier;
    }

    @NotNull
    public final String component3() {
        return this.argument;
    }

    @NotNull
    public final MoveTextCommand copy(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new MoveTextCommand(range, modifier, argument);
    }

    public static /* synthetic */ MoveTextCommand copy$default(MoveTextCommand moveTextCommand, Range range, CommandModifier commandModifier, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = moveTextCommand.range;
        }
        if ((n & 2) != 0) {
            commandModifier = moveTextCommand.modifier;
        }
        if ((n & 4) != 0) {
            string = moveTextCommand.argument;
        }
        return moveTextCommand.copy(range, commandModifier, string);
    }

    @NotNull
    public String toString() {
        return "MoveTextCommand(range=" + this.range + ", modifier=" + this.modifier + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.modifier.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MoveTextCommand)) {
            return false;
        }
        MoveTextCommand moveTextCommand = (MoveTextCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)moveTextCommand.range)) {
            return false;
        }
        if (this.modifier != moveTextCommand.modifier) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)moveTextCommand.argument);
    }

    private static final Unit processCommand$lambda$6(VimEditor $editor, TextRange $sourceRange) {
        $editor.deleteString($sourceRange);
        return Unit.INSTANCE;
    }

    private static final Unit processCommand$lambda$7(VimEditor $editor) {
        $editor.deleteString(new TextRange($editor.text().length() - 1, $editor.text().length()));
        return Unit.INSTANCE;
    }
}

