/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.php;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import ru.adelf.idea.dotenv.models.KeyUsagePsiElement;
import ru.adelf.idea.dotenv.php.PhpPsiHelper;

class PhpEnvironmentCallsVisitor
extends PsiRecursiveElementVisitor {
    private final Collection<KeyUsagePsiElement> collectedItems = new HashSet<KeyUsagePsiElement>();

    PhpEnvironmentCallsVisitor() {
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpEnvironmentCallsVisitor.$$$reportNull$$$0(0);
        }
        if (element instanceof FunctionReference) {
            this.visitFunction((FunctionReference)element);
        }
        if (element instanceof ArrayAccessExpression) {
            this.visitArrayAccess((ArrayAccessExpression)element);
        }
        super.visitElement(element);
    }

    private void visitFunction(FunctionReference expression) {
        if (!PhpPsiHelper.isEnvFunction(expression)) {
            return;
        }
        PsiElement[] parameters = expression.getParameters();
        if (parameters.length == 0) {
            return;
        }
        if (!(parameters[0] instanceof StringLiteralExpression)) {
            return;
        }
        String key = ((StringLiteralExpression)parameters[0]).getContents();
        this.collectedItems.add(new KeyUsagePsiElement(key, (PsiElement)expression));
    }

    private void visitArrayAccess(ArrayAccessExpression expression) {
        if (!PhpPsiHelper.isEnvArrayCall(expression)) {
            return;
        }
        if (expression.getIndex() == null) {
            return;
        }
        PhpPsiElement indexLiteral = expression.getIndex().getValue();
        if (!(indexLiteral instanceof StringLiteralExpression)) {
            return;
        }
        String key = ((StringLiteralExpression)indexLiteral).getContents();
        this.collectedItems.add(new KeyUsagePsiElement(key, (PsiElement)indexLiteral));
    }

    @NotNull
    Collection<KeyUsagePsiElement> getCollectedItems() {
        Collection<KeyUsagePsiElement> collection = this.collectedItems;
        if (collection == null) {
            PhpEnvironmentCallsVisitor.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ru/adelf/idea/dotenv/php/PhpEnvironmentCallsVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ru/adelf/idea/dotenv/php/PhpEnvironmentCallsVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

