/*
 * Decompiled with CFR 0.152.
 */
package com.carbonblack.intellij.rpmspec.shell.psi;

import com.carbonblack.intellij.rpmspec.shell.RpmSpecShellLexerAdapter;
import com.carbonblack.intellij.rpmspec.shell.psi.RpmSpecShellTypes;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0012\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/carbonblack/intellij/rpmspec/shell/psi/RpmSpecTemplateDataElementType;", "Lcom/intellij/psi/templateLanguages/TemplateDataElementType;", "debugName", "", "language", "Lcom/intellij/lang/Language;", "templateElementTypes", "Lcom/intellij/psi/tree/TokenSet;", "outerElementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/Language;Lcom/intellij/psi/tree/TokenSet;Lcom/intellij/psi/tree/IElementType;)V", "createTemplateText", "", "sourceCode", "baseLexer", "Lcom/intellij/lexer/Lexer;", "rangeCollector", "Lcom/intellij/psi/templateLanguages/TemplateDataElementType$RangeCollector;", "getRangeDump", "range", "Lcom/intellij/openapi/util/TextRange;", "sequence", "createBaseLexer", "viewProvider", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "intellij-rpmspec"})
public final class RpmSpecTemplateDataElementType
extends TemplateDataElementType {
    @NotNull
    private final TokenSet templateElementTypes;

    public RpmSpecTemplateDataElementType(@NotNull String debugName, @Nullable Language language, @NotNull TokenSet templateElementTypes, @NotNull IElementType outerElementType) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter((Object)templateElementTypes, (String)"templateElementTypes");
        Intrinsics.checkNotNullParameter((Object)outerElementType, (String)"outerElementType");
        IElementType[] iElementTypeArray = templateElementTypes.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        super(debugName, language, (IElementType)ArraysKt.first((Object[])iElementTypeArray), outerElementType);
        this.templateElementTypes = templateElementTypes;
    }

    @NotNull
    protected CharSequence createTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull TemplateDataElementType.RangeCollector rangeCollector) {
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        Intrinsics.checkNotNullParameter((Object)rangeCollector, (String)"rangeCollector");
        StringBuilder result = new StringBuilder(sourceCode.length());
        baseLexer.start(sourceCode);
        TextRange currentRange = null;
        currentRange = TextRange.EMPTY_RANGE;
        while (baseLexer.getTokenType() != null) {
            TextRange newRange;
            boolean bl;
            Intrinsics.checkNotNullExpressionValue((Object)TextRange.create((int)baseLexer.getTokenStart(), (int)baseLexer.getTokenEnd()), (String)"create(...)");
            boolean bl2 = bl = currentRange.getEndOffset() == newRange.getStartOffset();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                TextRange textRange = currentRange;
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element");
                String string = "Inconsistent tokens stream from " + baseLexer + ": " + this.getRangeDump(textRange, sourceCode) + " followed by " + this.getRangeDump(newRange, sourceCode);
                throw new AssertionError((Object)string);
            }
            currentRange = newRange;
            if (this.templateElementTypes.contains(baseLexer.getTokenType())) {
                v2 = result.append(sourceCode, baseLexer.getTokenStart(), baseLexer.getTokenEnd());
            } else if (Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)RpmSpecShellTypes.SPEC_FILE_MACRO_SHELL) && baseLexer.getTokenText().length() > 1) {
                rangeCollector.addOuterRange(TextRange.create((int)baseLexer.getTokenStart(), (int)(baseLexer.getTokenStart() + 1)));
                v2 = result.append(sourceCode, baseLexer.getTokenStart() + 1, baseLexer.getTokenEnd());
            } else {
                rangeCollector.addOuterRange(currentRange);
                v2 = Unit.INSTANCE;
            }
            baseLexer.advance();
        }
        return result;
    }

    private final String getRangeDump(TextRange range, CharSequence sequence) {
        return "'" + StringUtil.escapeLineBreak((String)((Object)range.subSequence(sequence)).toString()) + "' " + range;
    }

    @NotNull
    protected Lexer createBaseLexer(@Nullable TemplateLanguageFileViewProvider viewProvider) {
        return (Lexer)new RpmSpecShellLexerAdapter();
    }
}

