/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.agents.ideformer.daemon;

import ai.grazie.code.agents.ideformer.executable.IdeFormerExecutableIdentifier;
import ai.grazie.code.exec.jvm.JVMDeviceMetadataProvider;
import ai.grazie.code.exec.model.DeviceArchitecture;
import ai.grazie.code.exec.model.DeviceOS;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0012\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lai/grazie/code/agents/ideformer/daemon/IdeFormerDaemonConfig;", "", "version", "", "workingDir", "Ljava/nio/file/Path;", "cacheDir", "resourcesDir", "healthCheckIntervalMillis", "", "startTimeoutMillis", "startCheckDelayMillis", "logFile", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;JJJLjava/nio/file/Path;)V", "getVersion", "()Ljava/lang/String;", "getWorkingDir", "()Ljava/nio/file/Path;", "getCacheDir", "getResourcesDir", "getHealthCheckIntervalMillis", "()J", "getStartTimeoutMillis", "getStartCheckDelayMillis", "getLogFile", "Companion", "code-agents-ideformer-daemon"})
@SourceDebugExtension(value={"SMAP\nIdeFormerDaemonManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeFormerDaemonManager.kt\nai/grazie/code/agents/ideformer/daemon/IdeFormerDaemonConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,452:1\n1#2:453\n*E\n"})
public final class IdeFormerDaemonConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String version;
    @NotNull
    private final Path workingDir;
    @Nullable
    private final Path cacheDir;
    @Nullable
    private final Path resourcesDir;
    private final long healthCheckIntervalMillis;
    private final long startTimeoutMillis;
    private final long startCheckDelayMillis;
    @Nullable
    private final Path logFile;

    public IdeFormerDaemonConfig(@NotNull String version, @NotNull Path workingDir, @Nullable Path cacheDir, @Nullable Path resourcesDir, long healthCheckIntervalMillis, long startTimeoutMillis, long startCheckDelayMillis, @Nullable Path logFile) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        this.version = version;
        this.workingDir = workingDir;
        this.cacheDir = cacheDir;
        this.resourcesDir = resourcesDir;
        this.healthCheckIntervalMillis = healthCheckIntervalMillis;
        this.startTimeoutMillis = startTimeoutMillis;
        this.startCheckDelayMillis = startCheckDelayMillis;
        this.logFile = logFile;
        if (!(this.healthCheckIntervalMillis >= 0L)) {
            boolean $i$a$-require-IdeFormerDaemonConfig$42 = false;
            String $i$a$-require-IdeFormerDaemonConfig$42 = "Health check interval can't be negative!";
            throw new IllegalArgumentException($i$a$-require-IdeFormerDaemonConfig$42.toString());
        }
        if (!(this.startTimeoutMillis > 0L)) {
            boolean $i$a$-require-IdeFormerDaemonConfig$52 = false;
            String $i$a$-require-IdeFormerDaemonConfig$52 = "Start timeout must be positive!";
            throw new IllegalArgumentException($i$a$-require-IdeFormerDaemonConfig$52.toString());
        }
        if (!(this.startCheckDelayMillis >= 0L)) {
            boolean bl = false;
            String string = "Start check delay can't be negative!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ IdeFormerDaemonConfig(String string, Path path, Path path2, Path path3, long l, long l2, long l3, Path path4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = Files.createTempDirectory("ideformer-workdir", new FileAttribute[0]);
        }
        if ((n & 4) != 0) {
            path2 = null;
        }
        if ((n & 8) != 0) {
            path3 = null;
        }
        if ((n & 0x10) != 0) {
            l = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES));
        }
        if ((n & 0x20) != 0) {
            l2 = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES));
        }
        if ((n & 0x40) != 0) {
            l3 = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS));
        }
        if ((n & 0x80) != 0) {
            path4 = null;
        }
        this(string, path, path2, path3, l, l2, l3, path4);
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final Path getWorkingDir() {
        return this.workingDir;
    }

    @Nullable
    public final Path getCacheDir() {
        return this.cacheDir;
    }

    @Nullable
    public final Path getResourcesDir() {
        return this.resourcesDir;
    }

    public final long getHealthCheckIntervalMillis() {
        return this.healthCheckIntervalMillis;
    }

    public final long getStartTimeoutMillis() {
        return this.startTimeoutMillis;
    }

    public final long getStartCheckDelayMillis() {
        return this.startCheckDelayMillis;
    }

    @Nullable
    public final Path getLogFile() {
        return this.logFile;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lai/grazie/code/agents/ideformer/daemon/IdeFormerDaemonConfig$Companion;", "", "<init>", "()V", "os", "Lai/grazie/code/exec/model/DeviceOS;", "getOs", "()Lai/grazie/code/exec/model/DeviceOS;", "architecture", "Lai/grazie/code/exec/model/DeviceArchitecture;", "getArchitecture", "()Lai/grazie/code/exec/model/DeviceArchitecture;", "ideFormerIdentifier", "Lai/grazie/code/agents/ideformer/executable/IdeFormerExecutableIdentifier;", "version", "", "code-agents-ideformer-daemon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeviceOS getOs() {
            return JVMDeviceMetadataProvider.INSTANCE.os();
        }

        @NotNull
        public final DeviceArchitecture getArchitecture() {
            return JVMDeviceMetadataProvider.INSTANCE.architecture();
        }

        @NotNull
        public final IdeFormerExecutableIdentifier ideFormerIdentifier(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new IdeFormerExecutableIdentifier(version, this.getOs(), this.getArchitecture());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

