/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.patterns;

import ai.grazie.nlp.patterns.MatchPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.utils.CharUtils;
import ai.grazie.nlp.utils.RangesKt;
import ai.grazie.nlp.utils.Symbols;
import ai.grazie.text.ExtensionsKt;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000  2\u00020\u0001:\u0005\u001c\u001d\u001e\u001f J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0000H\u0016J.\u0010\u0018\u001a\u00020\u00002$\u0010\u0019\u001a \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u001aH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006!\u00c0\u0006\u0001"}, d2={"Lai/grazie/nlp/patterns/Pattern;", "Lai/grazie/nlp/patterns/MatchPattern;", "find", "", "Lai/grazie/text/TextRange;", "text", "", "contains", "", "matches", "exclude", "other", "before", "pattern", "Lkotlin/text/Regex;", "beforeWordBoundary", "after", "afterReversed", "reversedRegex", "expandBack", "expandForward", "regex", "afterWordBoundary", "withWordBoundariesAround", "traceFind", "wrapper", "Lkotlin/Function1;", "Lkotlin/Function0;", "Exclusion", "Before", "After", "AfterReversed", "Companion", "nlp-patterns"})
@SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1755#2,3:194\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern\n*L\n15#1:194,3\n*E\n"})
public interface Pattern
extends MatchPattern {
    @NotNull
    public static final Companion Companion = ai.grazie.nlp.patterns.Pattern$Companion.$$INSTANCE;

    @NotNull
    public List<TextRange> find(@NotNull CharSequence var1);

    default public boolean contains(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return !((Collection)this.find(text2)).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public boolean matches(@NotNull CharSequence text2) {
        TextRange it;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<TextRange> ranges = this.find(text2);
        if (((Collection)ranges).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$any$iv = ranges;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (TextRange)element$iv;
            boolean bl2 = false;
        } while (!it.covers(ExtensionsKt.getRange(text2)));
        return true;
    }

    @NotNull
    default public Pattern exclude(@NotNull Pattern other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Exclusion(this, other);
    }

    @NotNull
    default public Pattern before(@NotNull Regex pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new Before(this, pattern){
            final /* synthetic */ Regex $pattern;
            {
                this.$pattern = $pattern;
                super($receiver);
            }

            public boolean suffixMatches(CharSequence text2, int at) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return this.$pattern.matchesAt(text2, at);
            }
        };
    }

    @NotNull
    default public Pattern beforeWordBoundary() {
        return new Before(this){

            public boolean suffixMatches(CharSequence text2, int at) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return Pattern.Companion.isWordBoundaryBefore(text2, at);
            }
        };
    }

    @Deprecated(message="use afterReversed")
    @NotNull
    default public Pattern after(@NotNull Regex pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new After(this, pattern);
    }

    @NotNull
    default public Pattern afterReversed(@NotNull Regex reversedRegex) {
        Intrinsics.checkNotNullParameter((Object)reversedRegex, (String)"reversedRegex");
        return new AfterReversed(this, reversedRegex, false);
    }

    @NotNull
    default public Pattern expandBack(@NotNull Regex reversedRegex) {
        Intrinsics.checkNotNullParameter((Object)reversedRegex, (String)"reversedRegex");
        return new AfterReversed(this, reversedRegex, true);
    }

    @NotNull
    default public Pattern expandForward(@NotNull Regex regex2) {
        Intrinsics.checkNotNullParameter((Object)regex2, (String)"regex");
        return new Pattern(this, regex2){
            final /* synthetic */ Pattern this$0;
            final /* synthetic */ Regex $regex;
            {
                this.this$0 = $receiver;
                this.$regex = $regex;
            }

            /*
             * WARNING - void declaration
             */
            public List<TextRange> find(CharSequence text2) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable iterable = this.this$0.find(text2);
                Regex regex2 = this.$regex;
                boolean $i$f$mapNotNull = false;
                void var5_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TextRange it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    TextRange range = (TextRange)element$iv$iv;
                    boolean bl2 = false;
                    MatchResult match = regex2.matchAt(text2.subSequence(range.getEndExclusive(), text2.length()), 0);
                    if ((match != null ? new TextRange(range.getStart(), range.getEndExclusive() + RangesKt.getLength(match.getRange())) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        };
    }

    @NotNull
    default public Pattern afterWordBoundary() {
        return new Pattern(this){
            final /* synthetic */ Pattern this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public List<TextRange> find(CharSequence text2) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = this.this$0.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!Pattern.Companion.isWordBoundaryBefore(text2, it.getStart())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public boolean matches(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return this.this$0.matches(text2);
            }
        };
    }

    @NotNull
    default public Pattern withWordBoundariesAround() {
        return this.beforeWordBoundary().afterWordBoundary();
    }

    @NotNull
    default public Pattern traceFind(@NotNull Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>> wrapper) {
        Intrinsics.checkNotNullParameter(wrapper, (String)"wrapper");
        return new Pattern(wrapper, this){
            final /* synthetic */ Function1<Function0<? extends List<TextRange>>, List<TextRange>> $wrapper;
            final /* synthetic */ Pattern this$0;
            {
                this.$wrapper = $wrapper;
                this.this$0 = $receiver;
            }

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return (List)this.$wrapper.invoke(() -> traceFind.1.find$lambda$0(this.this$0, text2));
            }

            private static final List find$lambda$0(Pattern this$0, CharSequence $text) {
                return this$0.find($text);
            }
        };
    }

    @JvmStatic
    public static boolean isWordBoundaryBefore(@NotNull CharSequence text2, int offset) {
        return Companion.isWordBoundaryBefore(text2, offset);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lai/grazie/nlp/patterns/Pattern$After;", "Lai/grazie/nlp/patterns/Pattern;", "pattern", "prev", "Lkotlin/text/Regex;", "<init>", "(Lai/grazie/nlp/patterns/Pattern;Lkotlin/text/Regex;)V", "getPattern", "()Lai/grazie/nlp/patterns/Pattern;", "getPrev", "()Lkotlin/text/Regex;", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "nlp-patterns"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$After\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n774#2:194\n865#2,2:195\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$After\n*L\n125#1:194\n125#1:195,2\n*E\n"})
    private static final class After
    implements Pattern {
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final Regex prev;

        public After(@NotNull Pattern pattern, @NotNull Regex prev) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            this.pattern = pattern;
            this.prev = prev;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @NotNull
        public final Regex getPrev() {
            return this.prev;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> ranges = this.pattern.find(text2);
            if (ranges.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Set prefixMatchEnds = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.prev, (CharSequence)text2, (int)0, (int)2, null), After::find$lambda$0));
            Iterable $this$filter$iv = ranges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TextRange range = (TextRange)element$iv$iv;
                boolean bl = false;
                if (!prefixMatchEnds.contains(range.getStart())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (!this.pattern.matches(text2)) return false;
            MatchResult matchResult = this.prev.matchAt(text2, 0);
            MatchResult matchResult2 = matchResult;
            if (matchResult == null) return false;
            IntRange intRange = matchResult2.getRange();
            matchResult2 = intRange;
            if (intRange == null) return false;
            if (RangesKt.getLength((IntRange)matchResult2) != 0) return false;
            return true;
        }

        private static final int find$lambda$0(MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getRange().getLast() + 1;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lai/grazie/nlp/patterns/Pattern$AfterReversed;", "Lai/grazie/nlp/patterns/Pattern;", "pattern", "prev", "Lkotlin/text/Regex;", "including", "", "<init>", "(Lai/grazie/nlp/patterns/Pattern;Lkotlin/text/Regex;Z)V", "getPattern", "()Lai/grazie/nlp/patterns/Pattern;", "getPrev", "()Lkotlin/text/Regex;", "getIncluding", "()Z", "find", "", "Lai/grazie/text/TextRange;", "text", "", "reversedPrefix", "prefixLen", "", "matches", "nlp-patterns"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$AfterReversed\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1611#2,9:194\n1863#2:203\n1864#2:205\n1620#2:206\n1#3:204\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$AfterReversed\n*L\n136#1:194,9\n136#1:203\n136#1:205\n136#1:206\n136#1:204\n*E\n"})
    private static final class AfterReversed
    implements Pattern {
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final Regex prev;
        private final boolean including;

        public AfterReversed(@NotNull Pattern pattern, @NotNull Regex prev, boolean including) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            this.pattern = pattern;
            this.prev = prev;
            this.including = including;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @NotNull
        public final Regex getPrev() {
            return this.prev;
        }

        public final boolean getIncluding() {
            return this.including;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> ranges = this.pattern.find(text2);
            Iterable $this$mapNotNull$iv = ranges;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                TextRange it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                TextRange range = (TextRange)element$iv$iv;
                boolean bl2 = false;
                MatchResult match = this.prev.matchAt(this.reversedPrefix(text2, range.getStart()), 0);
                if ((match != null ? (this.including ? new TextRange(range.getStart() - RangesKt.getLength(match.getRange()), range.getEndExclusive()) : range) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final CharSequence reversedPrefix(CharSequence text2, int prefixLen) {
            return new CharSequence(text2, prefixLen){
                final /* synthetic */ CharSequence $text;
                final /* synthetic */ int $prefixLen;
                {
                    this.$text = $text;
                    this.$prefixLen = $prefixLen;
                }

                public char get(int index) {
                    return this.$text.charAt(this.$prefixLen - index - 1);
                }

                public CharSequence subSequence(int startIndex, int endIndex) {
                    return this.toString().subSequence(startIndex, endIndex);
                }

                public String toString() {
                    return ((Object)StringsKt.reversed((CharSequence)((Object)this.$text.subSequence(0, this.$prefixLen)).toString())).toString();
                }

                public int getLength() {
                    return this.$prefixLen;
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (!this.pattern.matches(text2)) return false;
            MatchResult matchResult = this.prev.matchAt((CharSequence)"", 0);
            MatchResult matchResult2 = matchResult;
            if (matchResult == null) return false;
            IntRange intRange = matchResult2.getRange();
            matchResult2 = intRange;
            if (intRange == null) return false;
            if (RangesKt.getLength((IntRange)matchResult2) != 0) return false;
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H&R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lai/grazie/nlp/patterns/Pattern$Before;", "Lai/grazie/nlp/patterns/Pattern;", "pattern", "<init>", "(Lai/grazie/nlp/patterns/Pattern;)V", "getPattern", "()Lai/grazie/nlp/patterns/Pattern;", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "suffixMatches", "at", "", "nlp-patterns"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$Before\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n774#2:194\n865#2,2:195\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$Before\n*L\n109#1:194\n109#1:195,2\n*E\n"})
    private static abstract class Before
    implements Pattern {
        @NotNull
        private final Pattern pattern;

        public Before(@NotNull Pattern pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> ranges = this.pattern.find(text2);
            if (ranges.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$filter$iv = ranges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TextRange range = (TextRange)element$iv$iv;
                boolean bl = false;
                if (!this.suffixMatches(text2, range.getEndExclusive())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return this.pattern.matches(text2) && this.suffixMatches(text2, text2.length());
        }

        public abstract boolean suffixMatches(@NotNull CharSequence var1, int var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001d\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lai/grazie/nlp/patterns/Pattern$Companion;", "", "<init>", "()V", "isWordBoundaryBefore", "", "text", "", "offset", "", "isInnerApostrophe", "isWordBoundaryOrApostrophe", "isWordBoundaryOrApostrophe$nlp_patterns", "nlp-patterns"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        public final boolean isWordBoundaryBefore(@NotNull CharSequence text2, int offset) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (offset == 0 || offset == text2.length()) {
                return true;
            }
            char c1 = text2.charAt(offset - 1);
            char c2 = text2.charAt(offset);
            if (this.isInnerApostrophe(text2, offset) || this.isInnerApostrophe(text2, offset - 1)) {
                return false;
            }
            return Character.isLetterOrDigit(c1) != Character.isLetterOrDigit(c2) || CharsKt.isWhitespace((char)c1) != CharsKt.isWhitespace((char)c2) || c1 != c2 && CharUtils.INSTANCE.isPunctuation(c1) && CharUtils.INSTANCE.isPunctuation(c2);
        }

        private final boolean isInnerApostrophe(CharSequence text2, int offset) {
            return Symbols.INSTANCE.getApostrophes().contains(Character.valueOf(text2.charAt(offset))) && text2.length() > offset + 1 && Character.isLetter(text2.charAt(offset + 1)) && offset > 0 && Character.isLetter(text2.charAt(offset - 1));
        }

        public final boolean isWordBoundaryOrApostrophe$nlp_patterns(@NotNull CharSequence text2, int offset) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return this.isWordBoundaryBefore(text2, offset) || this.isInnerApostrophe(text2, offset);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/grazie/nlp/patterns/Pattern$Exclusion;", "Lai/grazie/nlp/patterns/Pattern;", "main", "exclude", "<init>", "(Lai/grazie/nlp/patterns/Pattern;Lai/grazie/nlp/patterns/Pattern;)V", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "nlp-patterns"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$Exclusion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n774#2:194\n865#2,2:195\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$Exclusion\n*L\n23#1:194\n23#1:195,2\n*E\n"})
    public static final class Exclusion
    implements Pattern {
        @NotNull
        private final Pattern main;
        @NotNull
        private final Pattern exclude;

        public Exclusion(@NotNull Pattern main, @NotNull Pattern exclude) {
            Intrinsics.checkNotNullParameter((Object)main, (String)"main");
            Intrinsics.checkNotNullParameter((Object)exclude, (String)"exclude");
            this.main = main;
            this.exclude = exclude;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> matches = this.main.find(text2);
            Iterable $this$filter$iv = matches;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TextRange it = (TextRange)element$iv$iv;
                boolean bl = false;
                if (!(!this.exclude.matches(text2.subSequence(it.getStart(), it.getEndExclusive())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return this.main.matches(text2) && !this.exclude.matches(text2);
        }
    }
}

