/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer.spacy;

import ai.grazie.nlp.tokenizer.SpacyDefaults;
import ai.grazie.nlp.tokenizer.spacy.SpacyTokenInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B;\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0004JD\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000e2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000e2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR-\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lai/grazie/nlp/tokenizer/spacy/SpacyTokenizerSpecialCases;", "", "baseExceptions", "", "", "", "Lai/grazie/nlp/tokenizer/spacy/SpacyTokenInfo;", "tokenizerExceptions", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getBaseExceptions", "()Ljava/util/Map;", "getTokenizerExceptions", "specialCases", "", "getSpecialCases", "specialCases$delegate", "Lkotlin/Lazy;", "get", "token", "urlMatch", "", "expandExceptions", "exceptions", "search", "replace", "nlp-tokenizer"})
@SourceDebugExtension(value={"SMAP\nSpacyTokenizerSpecialCases.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpacyTokenizerSpecialCases.kt\nai/grazie/nlp/tokenizer/spacy/SpacyTokenizerSpecialCases\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1557#2:60\n1628#2,3:61\n*S KotlinDebug\n*F\n+ 1 SpacyTokenizerSpecialCases.kt\nai/grazie/nlp/tokenizer/spacy/SpacyTokenizerSpecialCases\n*L\n50#1:60\n50#1:61,3\n*E\n"})
public final class SpacyTokenizerSpecialCases {
    @NotNull
    private final Map<String, List<SpacyTokenInfo>> baseExceptions;
    @NotNull
    private final Map<String, List<SpacyTokenInfo>> tokenizerExceptions;
    @NotNull
    private final Lazy specialCases$delegate;

    public SpacyTokenizerSpecialCases(@NotNull Map<String, ? extends List<SpacyTokenInfo>> baseExceptions, @NotNull Map<String, ? extends List<SpacyTokenInfo>> tokenizerExceptions) {
        Intrinsics.checkNotNullParameter(baseExceptions, (String)"baseExceptions");
        Intrinsics.checkNotNullParameter(tokenizerExceptions, (String)"tokenizerExceptions");
        this.baseExceptions = baseExceptions;
        this.tokenizerExceptions = tokenizerExceptions;
        this.specialCases$delegate = LazyKt.lazy(() -> SpacyTokenizerSpecialCases.specialCases_delegate$lambda$0(this));
    }

    @NotNull
    public final Map<String, List<SpacyTokenInfo>> getBaseExceptions() {
        return this.baseExceptions;
    }

    @NotNull
    public final Map<String, List<SpacyTokenInfo>> getTokenizerExceptions() {
        return this.tokenizerExceptions;
    }

    @NotNull
    public final Map<String, List<SpacyTokenInfo>> getSpecialCases() {
        Lazy lazy = this.specialCases$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final List<SpacyTokenInfo> get(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return this.getSpecialCases().containsKey(token) ? this.getSpecialCases().get(token) : null;
    }

    public final boolean urlMatch(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return SpacyDefaults.INSTANCE.getUrlMatch().matches((CharSequence)token);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<SpacyTokenInfo>> expandExceptions(Map<String, List<SpacyTokenInfo>> exceptions, String search2, String replace2) {
        HashMap newItems = new HashMap();
        for (Map.Entry<String, List<SpacyTokenInfo>> entry2 : exceptions.entrySet()) {
            void $this$mapTo$iv$iv;
            String tokenString = entry2.getKey();
            List<SpacyTokenInfo> tokens2 = entry2.getValue();
            if (!StringsKt.contains$default((CharSequence)tokenString, (CharSequence)search2, (boolean)false, (int)2, null)) continue;
            String newKey = StringsKt.replace$default((String)tokenString, (String)search2, (String)replace2, (boolean)false, (int)4, null);
            Iterable $this$map$iv = tokens2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SpacyTokenInfo spacyTokenInfo = (SpacyTokenInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SpacyTokenizerSpecialCases.expandExceptions$fixToken((SpacyTokenInfo)it, search2, replace2));
            }
            List newValue = (List)destination$iv$iv;
            ((Map)newItems).put(newKey, newValue);
        }
        exceptions.putAll(newItems);
        return exceptions;
    }

    private static final Map specialCases_delegate$lambda$0(SpacyTokenizerSpecialCases this$0) {
        Map cases = MapsKt.toMutableMap((Map)MapsKt.plus(this$0.tokenizerExceptions, this$0.baseExceptions));
        return this$0.expandExceptions(cases, "'", "\u2019");
    }

    private static final SpacyTokenInfo expandExceptions$fixToken(SpacyTokenInfo token, String search2, String replace2) {
        String string = StringsKt.replace$default((String)token.getOrth(), (String)search2, (String)replace2, (boolean)false, (int)4, null);
        String string2 = token.getNorm();
        String string3 = token.getTag();
        String string4 = token.getLemma();
        return new SpacyTokenInfo(string, string4, string3, string2);
    }
}

