/*
 * Decompiled with CFR 0.152.
 */
package ai.jetbrains.code.features.repomap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 \u0015*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001\u0015BO\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lai/jetbrains/code/features/repomap/PersonalizedPageRank;", "V", "E", "", "graph", "Lorg/jgrapht/Graph;", "personalization", "", "", "dampingFactor", "maxIterations", "", "tolerance", "<init>", "(Lorg/jgrapht/Graph;Ljava/util/Map;DID)V", "scores", "getScores", "()Ljava/util/Map;", "scores$delegate", "Lkotlin/Lazy;", "computeScores", "Companion", "code-features-repomap-model"})
@SourceDebugExtension(value={"SMAP\nPersonalizedPageRank.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersonalizedPageRank.kt\nai/jetbrains/code/features/repomap/PersonalizedPageRank\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1#2:184\n1869#3,2:185\n1193#3,2:187\n1267#3,4:189\n1193#3,2:193\n1267#3,4:195\n1563#3:199\n1634#3,3:200\n1878#3,3:203\n1193#3,2:206\n1267#3,4:208\n*S KotlinDebug\n*F\n+ 1 PersonalizedPageRank.kt\nai/jetbrains/code/features/repomap/PersonalizedPageRank\n*L\n24#1:185,2\n43#1:187,2\n43#1:189,4\n44#1:193,2\n44#1:195,4\n59#1:199\n59#1:200,3\n84#1:203,3\n161#1:206,2\n161#1:208,4\n*E\n"})
public final class PersonalizedPageRank<V, E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Graph<V, E> graph;
    @NotNull
    private final Map<V, Double> personalization;
    private final double dampingFactor;
    private final int maxIterations;
    private final double tolerance;
    @NotNull
    private final Lazy scores$delegate;
    public static final int MAX_ITERATIONS_DEFAULT = 100;
    public static final double TOLERANCE_DEFAULT = 1.0E-4;
    public static final double DAMPING_FACTOR_DEFAULT = 0.85;

    public PersonalizedPageRank(@NotNull Graph<V, E> graph, @NotNull Map<V, Double> personalization, double dampingFactor, int maxIterations, double tolerance) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        Intrinsics.checkNotNullParameter(personalization, (String)"personalization");
        this.graph = graph;
        this.personalization = personalization;
        this.dampingFactor = dampingFactor;
        this.maxIterations = maxIterations;
        this.tolerance = tolerance;
        if (!(this.maxIterations > 0)) {
            boolean $i$a$-require-PersonalizedPageRank$52 = false;
            String $i$a$-require-PersonalizedPageRank$52 = "Maximum iterations must be positive";
            throw new IllegalArgumentException($i$a$-require-PersonalizedPageRank$52.toString());
        }
        double d = this.dampingFactor;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean $i$a$-require-PersonalizedPageRank$62 = false;
            String $i$a$-require-PersonalizedPageRank$62 = "Damping factor must be between 0.0 and 1.0";
            throw new IllegalArgumentException($i$a$-require-PersonalizedPageRank$62.toString());
        }
        if (!(this.tolerance > 0.0)) {
            boolean bl = false;
            String string = "Tolerance must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.personalization.isEmpty()) {
            double sum = CollectionsKt.sumOfDouble((Iterable)this.personalization.values());
            if (!(Math.abs(sum - 1.0) <= 1.0E-6)) {
                boolean $i$a$-require-PersonalizedPageRank$72 = false;
                String $i$a$-require-PersonalizedPageRank$72 = "Personalization vector must sum to 1, but sum is " + sum;
                throw new IllegalArgumentException($i$a$-require-PersonalizedPageRank$72.toString());
            }
            Iterable $this$forEach$iv = this.personalization.keySet();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object vertex = element$iv = iterator.next();
                boolean bl = false;
                if (this.graph.containsVertex(vertex)) continue;
                boolean bl2 = false;
                String string = "Personalization vector contains unknown vertex: " + vertex;
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.scores$delegate = LazyKt.lazy(() -> PersonalizedPageRank.scores_delegate$lambda$6(this));
    }

    public /* synthetic */ PersonalizedPageRank(Graph graph, Map map2, double d, int n, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 4) != 0) {
            d = 0.85;
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        if ((n2 & 0x10) != 0) {
            d2 = 1.0E-4;
        }
        this(graph, map2, d, n, d2);
    }

    @NotNull
    public final Map<V, Double> getScores() {
        Lazy lazy = this.scores$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<V, Double> computeScores() {
        void $this$associateTo$iv$iv;
        Object tempArray;
        List list2;
        double[] weightSums;
        double[] dArray;
        int n3;
        Object object;
        int element$iv$iv3;
        void $this$associateTo$iv$iv22;
        Object vertex;
        Object object2;
        Object element$iv$iv22;
        void $this$associateTo$iv$iv3;
        int totalVertices = this.graph.vertexSet().size();
        boolean isWeighted = this.graph.getType().isWeighted();
        Set set2 = this.graph.vertexSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"vertexSet(...)");
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)set2);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv22 : $this$associateTo$iv$iv3) {
            Map map2 = destination$iv$iv;
            object2 = (IndexedValue)element$iv$iv22;
            boolean bl = false;
            int idx = object2.component1();
            vertex = object2.component2();
            object2 = TuplesKt.to((Object)vertex, (Object)idx);
            map2.put(object2.getFirst(), object2.getSecond());
        }
        Map vertexToIndex = destination$iv$iv;
        Iterable $this$associate$iv2 = vertexToIndex.entrySet();
        boolean $i$f$associate2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv2;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        int $i$f$associateTo2 = 0;
        for (Object element$iv$iv3 : $this$associateTo$iv$iv22) {
            object2 = destination$iv$iv2;
            Map.Entry bl = (Map.Entry)element$iv$iv3;
            boolean bl2 = false;
            vertex = bl.getKey();
            int idx = ((Number)bl.getValue()).intValue();
            bl = TuplesKt.to((Object)idx, (Object)vertex);
            object2.put(bl.getFirst(), bl.getSecond());
        }
        Map indexToVertex = destination$iv$iv2;
        double initialScore = 1.0 / (double)totalVertices;
        Object curScore = null;
        int $this$associateTo$iv$iv22 = 0;
        destination$iv$iv2 = new double[totalVertices];
        while ($this$associateTo$iv$iv22 < totalVertices) {
            $i$f$associateTo2 = $this$associateTo$iv$iv22++;
            destination$iv$iv2[$i$f$associateTo2] = initialScore;
        }
        curScore = destination$iv$iv2;
        Object nextScore = new double[totalVertices];
        $i$f$associateTo2 = 0;
        element$iv$iv22 = new int[totalVertices];
        while ($i$f$associateTo2 < totalVertices) {
            int element$iv$iv3 = $i$f$associateTo2++;
            Object v = indexToVertex.get(element$iv$iv3);
            Intrinsics.checkNotNull(v);
            element$iv$iv22[element$iv$iv3] = this.graph.outDegreeOf(v);
        }
        Object outDegree = element$iv$iv22;
        element$iv$iv22 = new ArrayList(totalVertices);
        for (element$iv$iv3 = 0; element$iv$iv3 < totalVertices; ++element$iv$iv3) {
            void $this$mapTo$iv$iv;
            void i;
            int n2;
            int bl = n2 = element$iv$iv3;
            object = element$iv$iv22;
            boolean bl3 = false;
            Intrinsics.checkNotNull(indexToVertex.get((int)i));
            Set set3 = this.graph.incomingEdgesOf(vertex);
            Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"incomingEdgesOf(...)");
            Iterable $this$map$iv = set3;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Iterator edge;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv3;
                n3 = 0;
                Object v = vertexToIndex.get(Graphs.getOppositeVertex(this.graph, (Object)edge, (Object)vertex));
                Intrinsics.checkNotNull(v);
                collection.add(((Number)v).intValue());
            }
            ((ArrayList)object).add((int[])CollectionsKt.toIntArray((Collection)((List)destination$iv$iv3)));
        }
        List adjacencyLists = (List)element$iv$iv22;
        if (this.personalization.isEmpty()) {
            element$iv$iv3 = 0;
            var13_27 = new double[totalVertices];
            while (element$iv$iv3 < totalVertices) {
                int i = element$iv$iv3++;
                var13_27[i] = 1.0 / (double)totalVertices;
            }
            dArray = var13_27;
        } else {
            element$iv$iv3 = 0;
            var13_27 = new double[totalVertices];
            while (element$iv$iv3 < totalVertices) {
                int i = element$iv$iv3++;
                var13_27[i] = ((Number)this.personalization.getOrDefault(indexToVertex.get(i), 0.0)).doubleValue();
            }
            dArray = var13_27;
        }
        double[] personalizationVector = dArray;
        double[] dArray2 = weightSums = isWeighted ? new double[totalVertices] : null;
        if (isWeighted) {
            ArrayList i = new ArrayList(totalVertices);
            for (int j = 0; j < totalVertices; ++j) {
                Object vertex2;
                void i2;
                int vertex3;
                int $this$map$iv = vertex3 = j;
                object = i;
                boolean bl = false;
                Intrinsics.checkNotNull(indexToVertex.get((int)i2));
                double[] weights = new double[this.graph.inDegreeOf(vertex2)];
                Set set4 = this.graph.incomingEdgesOf(vertex2);
                Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"incomingEdgesOf(...)");
                Iterable $this$forEachIndexed$iv = set4;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    double weight;
                    void edge;
                    if ((n3 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv;
                    int j2 = n3;
                    boolean bl4 = false;
                    Object source2 = Graphs.getOppositeVertex(this.graph, (Object)edge, vertex2);
                    Object v = vertexToIndex.get(source2);
                    Intrinsics.checkNotNull(v);
                    int sourceIdx = ((Number)v).intValue();
                    weights[j2] = weight = this.graph.getEdgeWeight((Object)edge);
                    Intrinsics.checkNotNull((Object)weightSums);
                    double[] dArray3 = weightSums;
                    dArray3[sourceIdx] = dArray3[sourceIdx] + weight;
                }
                ((ArrayList)object).add(weights);
            }
            list2 = i;
        } else {
            list2 = null;
        }
        List edgeWeights = list2;
        double maxChange = this.tolerance;
        for (int iterations = this.maxIterations; iterations > 0 && maxChange >= this.tolerance; --iterations) {
            double danglingWeight = 0.0;
            for (int i = 0; i < totalVertices; ++i) {
                if (outDegree[i] != false) continue;
                danglingWeight += curScore[i];
            }
            int weights = 0;
            double[] $this$forEachIndexed$iv = new double[totalVertices];
            while (weights < totalVertices) {
                int $i$f$forEachIndexed = weights++;
                $this$forEachIndexed$iv[$i$f$forEachIndexed] = this.dampingFactor * danglingWeight * personalizationVector[$i$f$forEachIndexed];
            }
            double[] danglingContribution = $this$forEachIndexed$iv;
            maxChange = 0.0;
            for (int i = 0; i < totalVertices; ++i) {
                double contribution = 0.0;
                int[] neighbors = (int[])adjacencyLists.get(i);
                if (isWeighted) {
                    List list3 = edgeWeights;
                    Intrinsics.checkNotNull((Object)list3);
                    double[] weights2 = (double[])list3.get(i);
                    int n3 = neighbors.length;
                    for (int j = 0; j < n3; ++j) {
                        int w = neighbors[j];
                        if (outDegree[w] <= 0) continue;
                        double d = this.dampingFactor * curScore[w] * weights2[j];
                        Intrinsics.checkNotNull((Object)weightSums);
                        contribution += d / weightSums[w];
                    }
                } else {
                    for (int w : neighbors) {
                        if (outDegree[w] <= 0) continue;
                        contribution += this.dampingFactor * curScore[w] / (double)outDegree[w];
                    }
                }
                Object oldValue = curScore[i];
                double newValue = (1.0 - this.dampingFactor) * personalizationVector[i] + contribution + danglingContribution[i];
                maxChange = Math.max(maxChange, Math.abs(newValue - oldValue));
                nextScore[i] = newValue;
            }
            tempArray = curScore;
            curScore = nextScore;
            nextScore = tempArray;
            double sum = ArraysKt.sum((double[])curScore);
            if (!(Math.abs(sum - 1.0) > 1.0E-10)) continue;
            int i = 0;
            while (i < totalVertices) {
                Object oldValue = curScore;
                int n4 = i++;
                oldValue[n4] = oldValue[n4] / sum;
            }
        }
        Iterable $this$associate$iv3 = indexToVertex.entrySet();
        boolean $i$f$associate3 = false;
        int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv3, (int)10)), (int)16);
        tempArray = $this$associate$iv3;
        Map destination$iv$iv4 = new LinkedHashMap(capacity$iv3);
        boolean $i$f$associateTo3 = false;
        for (Object element$iv$iv4 : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv4;
            Map.Entry entry2 = (Map.Entry)element$iv$iv4;
            boolean bl = false;
            int idx = ((Number)entry2.getKey()).intValue();
            Object vertex4 = entry2.getValue();
            entry2 = TuplesKt.to(vertex4, (Object)((double)curScore[idx]));
            map3.put(entry2.getFirst(), entry2.getSecond());
        }
        return destination$iv$iv4;
    }

    private static final Map scores_delegate$lambda$6(PersonalizedPageRank this$0) {
        return this$0.computeScores();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/jetbrains/code/features/repomap/PersonalizedPageRank$Companion;", "", "<init>", "()V", "MAX_ITERATIONS_DEFAULT", "", "TOLERANCE_DEFAULT", "", "DAMPING_FACTOR_DEFAULT", "code-features-repomap-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

