/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.memory.prompts;

import ai.koog.agents.core.annotation.InternalAgentsApi;
import ai.koog.agents.memory.model.Concept;
import ai.koog.agents.memory.model.MemorySubject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@InternalAgentsApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u000f"}, d2={"Lai/koog/agents/memory/prompts/MemoryPrompts;", "", "<init>", "()V", "historyWrapperTag", "", "getHistoryWrapperTag$annotations", "singleFactPrompt", "concept", "Lai/koog/agents/memory/model/Concept;", "multipleFactsPrompt", "autoDetectFacts", "subjects", "", "Lai/koog/agents/memory/model/MemorySubject;", "agents-features-memory"})
public final class MemoryPrompts {
    @NotNull
    public static final MemoryPrompts INSTANCE = new MemoryPrompts();
    @NotNull
    public static final String historyWrapperTag = "conversation_to_extract_facts";

    private MemoryPrompts() {
    }

    public static /* synthetic */ void getHistoryWrapperTag$annotations() {
    }

    @NotNull
    public final String singleFactPrompt(@NotNull Concept concept) {
        Intrinsics.checkNotNullParameter((Object)concept, (String)"concept");
        return StringsKt.trimIndent((String)("You are a specialized information extractor for compressing agent conversation histories.\n\n        You will receive a conversation history enclosed in <conversation_to_extract_facts> tags. Your task is to extract THE SINGLE MOST IMPORTANT fact about \"" + concept.getKeyword() + "\" (" + concept.getDescription() + ").\n        \n        Critical extraction rules:\n        1. Focus on THE MOST ESSENTIAL OUTCOME or ESTABLISHED INFORMATION\n        2. When you see tool calls/observations, extract only the most crucial discovered fact\n        3. The fact must be self-contained - assume it will be the only available context later\n        4. Choose the fact with the broadest impact on understanding this concept\n        \n        Output constraints:\n        - Exactly one fact\n        - No explanations, formatting, or preamble\n        - Must be a complete, self-contained statement\n        \n        Output only the fact.\n        "));
    }

    @NotNull
    public final String multipleFactsPrompt(@NotNull Concept concept) {
        Intrinsics.checkNotNullParameter((Object)concept, (String)"concept");
        return StringsKt.trimIndent((String)("You are a specialized information extractor for compressing agent conversation histories.\n        \n        You will receive a conversation history enclosed in <conversation_to_extract_facts> tags. Your task is to extract ONLY the essential facts about \"" + concept.getKeyword() + "\" (" + concept.getDescription() + ").\n        \n        Critical extraction rules:\n        1. Focus on OUTCOMES and ESTABLISHED INFORMATION, not actions taken\n        2. When you see tool calls/observations, extract only the discovered facts, not the process\n        3. Each fact must be self-contained - assume it will be the only available context later\n        4. Combine related information into single, comprehensive facts when possible\n        \n        Output constraints:\n        - One fact per line\n        - No explanations, headers, numbering, or formatting\n        - Facts must be complete statements that stand alone\n        - Skip any fact that just describes what was attempted or checked\n        \n        Output only the facts, nothing else.\n        "));
    }

    @NotNull
    public final String autoDetectFacts(@NotNull List<? extends MemorySubject> subjects) {
        Intrinsics.checkNotNullParameter(subjects, (String)"subjects");
        return StringsKt.trimIndent((String)("\n        Analyze the conversation history and identify important facts about:\n        " + CollectionsKt.joinToString$default((Iterable)subjects, (CharSequence)"\n", null, null, (int)0, null, MemoryPrompts::autoDetectFacts$lambda$0, (int)30, null) + "\n\n        For each fact:\n        1. Provide a relevant subject (USE SAME SUBJECTS AS DESCRIBED ABOVE!)\n        2. Provide a keyword (e.g., 'user-preference', 'project-requirement')\n        3. Write a description that helps identify similar information\n        4. Provide the actual fact value\n\n        Format your response as a JSON objects:\n        [\n            {\n                \"subject\": \"string\",\n                \"keyword\": \"string\",\n                \"description\": \"string\",\n                \"value\": \"string\"\n            }\n        ]\n    "));
    }

    private static final CharSequence autoDetectFacts$lambda$0(MemorySubject subject) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        return "        - [subject: \"" + subject.getName() + "\"] " + subject.getPromptDescription();
    }
}

