/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.memory.storage;

import ai.koog.agents.memory.storage.Encryption;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\f\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/koog/agents/memory/storage/Aes256GCMEncryptor;", "Lai/koog/agents/memory/storage/Encryption;", "secretKey", "", "<init>", "(Ljava/lang/String;)V", "key", "Ljavax/crypto/SecretKey;", "getKey$agents_features_memory", "()Ljavax/crypto/SecretKey;", "random", "Ljava/security/SecureRandom;", "cipher", "Ljavax/crypto/Cipher;", "kotlin.jvm.PlatformType", "encryptImpl", "Lkotlin/Pair;", "", "plaintext", "encryptImpl$agents_features_memory", "decryptImpl", "nonce", "ciphertext", "decryptImpl$agents_features_memory", "encrypt", "text", "decrypt", "value", "Companion", "agents-features-memory"})
public final class Aes256GCMEncryptor
implements Encryption {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SecretKey key;
    @NotNull
    private final SecureRandom random;
    private final Cipher cipher;
    private static final KeyGenerator keyGenerator;

    public Aes256GCMEncryptor(@NotNull String secretKey) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        this.key = Companion.keyFromString(secretKey);
        this.random = new SecureRandom();
        this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
    }

    @NotNull
    public final SecretKey getKey$agents_features_memory() {
        return this.key;
    }

    @NotNull
    public final Pair<byte[], byte[]> encryptImpl$agents_features_memory(@NotNull String plaintext) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        byte[] $this$encryptImpl_u24lambda_u240 = byArray = new byte[12];
        boolean bl = false;
        this.random.nextBytes($this$encryptImpl_u24lambda_u240);
        byte[] nonce = byArray;
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, nonce);
        this.cipher.init(1, (Key)this.key, gcmParameterSpec);
        String string = plaintext;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] ciphertext = this.cipher.doFinal(byArray2);
        return new Pair((Object)nonce, (Object)ciphertext);
    }

    @NotNull
    public final String decryptImpl$agents_features_memory(@NotNull byte[] nonce, @NotNull byte[] ciphertext) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, nonce);
        this.cipher.init(2, (Key)this.key, gcmParameterSpec);
        byte[] plaintext = this.cipher.doFinal(ciphertext);
        Intrinsics.checkNotNull((Object)plaintext);
        return new String(plaintext, Charsets.UTF_8);
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Pair<byte[], byte[]> pair = this.encryptImpl$agents_features_memory(text2);
        byte[] nonce = (byte[])pair.component1();
        byte[] ciphertext = (byte[])pair.component2();
        String string = Base64.getEncoder().encodeToString(ArraysKt.plus((byte[])nonce, (byte[])ciphertext));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] valueBytes = Base64.getDecoder().decode(value);
        Intrinsics.checkNotNull((Object)valueBytes);
        byte[] nonce = CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])valueBytes, (int)12));
        byte[] ciphertext = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])valueBytes, (int)12));
        return this.decryptImpl$agents_features_memory(nonce, ciphertext);
    }

    static {
        KeyGenerator keyGenerator;
        Companion = new Companion(null);
        KeyGenerator $this$keyGenerator_u24lambda_u241 = keyGenerator = KeyGenerator.getInstance("AES");
        boolean bl = false;
        $this$keyGenerator_u24lambda_u241.init(256, new SecureRandom());
        Aes256GCMEncryptor.keyGenerator = keyGenerator;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/koog/agents/memory/storage/Aes256GCMEncryptor$Companion;", "", "<init>", "()V", "keyGenerator", "Ljavax/crypto/KeyGenerator;", "kotlin.jvm.PlatformType", "generateRandomKey", "Ljavax/crypto/SecretKey;", "keyFromString", "keyString", "", "keyToString", "key", "agents-features-memory"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecretKey generateRandomKey() {
            SecretKey secretKey = keyGenerator.generateKey();
            Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateKey(...)");
            return secretKey;
        }

        @NotNull
        public final SecretKey keyFromString(@NotNull String keyString) {
            Intrinsics.checkNotNullParameter((Object)keyString, (String)"keyString");
            byte[] base64Key = Base64.getDecoder().decode(keyString);
            if (base64Key.length != 32) {
                throw new IllegalStateException(("Secret key must be 32 bytes long but is " + base64Key.length).toString());
            }
            return new SecretKeySpec(base64Key, 0, 32, "AES");
        }

        @NotNull
        public final String keyToString(@NotNull SecretKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = Base64.getEncoder().encodeToString(key.getEncoded());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

