/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.activation.ij.config;

import com.intellij.ml.llm.activation.ij.config.AiaConfigGrazieTokenOverrideUtilKt;
import com.intellij.util.SystemProperties;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/activation/ij/config/AiaConfigGrazieTokenOverrideUtil;", "", "<init>", "()V", "ENVIRONMENT_VARIABLE_KEY", "", "TOKEN_FILE_NAME", "MIN_TOKEN_SIZE", "", "MAX_TOKEN_SIZE", "userHome", "getUserHome", "()Ljava/lang/String;", "userHome$delegate", "Lkotlin/Lazy;", "getTokenFile", "Ljava/io/File;", "getOverriddenGrazieToken", "intellij.ml.llm.activation.ij"})
public final class AiaConfigGrazieTokenOverrideUtil {
    @NotNull
    public static final AiaConfigGrazieTokenOverrideUtil INSTANCE = new AiaConfigGrazieTokenOverrideUtil();
    @NotNull
    private static final String ENVIRONMENT_VARIABLE_KEY = "AI_ASSISTANT_GRAZIE_TOKEN";
    @NotNull
    private static final String TOKEN_FILE_NAME = ".ai-assistant-staging-test-token";
    private static final long MIN_TOKEN_SIZE = 580L;
    private static final long MAX_TOKEN_SIZE = 8192L;
    @NotNull
    private static final Lazy userHome$delegate = LazyKt.lazy(AiaConfigGrazieTokenOverrideUtil::userHome_delegate$lambda$0);

    private AiaConfigGrazieTokenOverrideUtil() {
    }

    private final String getUserHome() {
        Lazy lazy = userHome$delegate;
        return (String)lazy.getValue();
    }

    private final File getTokenFile() {
        return new File(this.getUserHome(), TOKEN_FILE_NAME);
    }

    @Nullable
    public final String getOverriddenGrazieToken() {
        String tokenFromEnvironmentVariable = System.getenv(ENVIRONMENT_VARIABLE_KEY);
        if (tokenFromEnvironmentVariable != null) {
            String it = tokenFromEnvironmentVariable;
            boolean bl = false;
            AiaConfigGrazieTokenOverrideUtilKt.access$getLOG$p().warn("Environment variable AI_ASSISTANT_GRAZIE_TOKEN was found. This will be used as the Grazie token.");
            return ((Object)StringsKt.trim((CharSequence)it)).toString();
        }
        File tokenFile = this.getTokenFile();
        try {
            if (!tokenFile.exists()) {
                AiaConfigGrazieTokenOverrideUtilKt.access$getLOG$p().warn("Grazie token override is enabled, but environment variable AI_ASSISTANT_GRAZIE_TOKEN and file .ai-assistant-staging-test-token in " + this.getUserHome() + " do not exist.");
                return null;
            }
            long tokenFileLength = tokenFile.length();
            if (tokenFile.length() < 580L) {
                AiaConfigGrazieTokenOverrideUtilKt.access$getLOG$p().warn(".ai-assistant-staging-test-token in " + this.getUserHome() + " was found, but it has " + tokenFileLength + " bytes and it should be at least 580. It's fine if the token has leading or trailing whitespaces.");
                return null;
            }
            if (tokenFile.length() > 8192L) {
                AiaConfigGrazieTokenOverrideUtilKt.access$getLOG$p().warn(".ai-assistant-staging-test-token in " + this.getUserHome() + " was found, but it has " + tokenFileLength + " bytes and it should be a maximum of 8192. It's fine if the token has leading or trailing whitespaces.");
                return null;
            }
            AiaConfigGrazieTokenOverrideUtilKt.access$getLOG$p().warn(".ai-assistant-staging-test-token in " + this.getUserHome() + " was found. This will be used as the Grazie token.");
            return ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)tokenFile, null, (int)1, null))).toString();
        }
        catch (SecurityException e) {
            AiaConfigGrazieTokenOverrideUtilKt.access$getLOG$p().warn("Grazie token override is enabled, but reading .ai-assistant-staging-test-token in " + this.getUserHome() + " led to this exception: ", (Throwable)e);
            return null;
        }
    }

    private static final String userHome_delegate$lambda$0() {
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        return string;
    }
}

