/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.activation.ij.data;

import com.intellij.ml.llm.activation.data.model.AipLicense;
import com.intellij.ml.llm.activation.data.model.AipLicenseId;
import com.intellij.ml.llm.activation.data.model.AipLicenseProductType;
import com.intellij.ml.llm.activation.data.model.JbaUserId;
import com.intellij.ml.llm.activation.data.model.result.AipLicenseRequestFailure;
import com.intellij.ml.llm.activation.data.model.result.AipLicenseResult;
import com.intellij.ml.llm.activation.ij.data.KnownRequestDeclinedReason;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBAccountInfoService;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"toAipLicenseResult", "Lcom/intellij/ml/llm/activation/data/model/result/AipLicenseResult;", "Lcom/intellij/ui/JBAccountInfoService$LicenseListResult;", "productType", "Lcom/intellij/ml/llm/activation/data/model/AipLicenseProductType;", "toAipLicense", "Lcom/intellij/ml/llm/activation/data/model/AipLicense;", "Lcom/intellij/ui/JBAccountInfoService$JbaLicense;", "jetbrainsAccountUrl", "", "plansAndPricingLandingUrl", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.activation.ij"})
@SourceDebugExtension(value={"SMAP\nIjAipLicenseRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjAipLicenseRepository.kt\ncom/intellij/ml/llm/activation/ij/data/IjAipLicenseRepositoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,149:1\n1563#2:150\n1634#2,3:151\n58#3:154\n36#3,2:155\n*S KotlinDebug\n*F\n+ 1 IjAipLicenseRepository.kt\ncom/intellij/ml/llm/activation/ij/data/IjAipLicenseRepositoryKt\n*L\n87#1:150\n87#1:151,3\n148#1:154\n148#1:155,2\n*E\n"})
public final class IjAipLicenseRepositoryKt {
    @NotNull
    private static final String jetbrainsAccountUrl = "https://account.jetbrains.com/";
    @NotNull
    private static final String plansAndPricingLandingUrl = "https://www.jetbrains.com/ai-ides/buy/";
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    private static final AipLicenseResult toAipLicenseResult(JBAccountInfoService.LicenseListResult $this$toAipLicenseResult, AipLicenseProductType productType) {
        AipLicenseResult aipLicenseResult;
        JBAccountInfoService.LicenseListResult licenseListResult = $this$toAipLicenseResult;
        if (licenseListResult instanceof JBAccountInfoService.LicenseListResult.LicenseList) {
            void $this$mapTo$iv$iv;
            List list = ((JBAccountInfoService.LicenseListResult.LicenseList)$this$toAipLicenseResult).licenses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"licenses(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JBAccountInfoService.JbaLicense jbaLicense = (JBAccountInfoService.JbaLicense)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(IjAipLicenseRepositoryKt.toAipLicense((JBAccountInfoService.JbaLicense)it, productType));
            }
            List list2 = (List)destination$iv$iv;
            aipLicenseResult = new AipLicenseResult.Success(list2);
        } else if (licenseListResult instanceof JBAccountInfoService.LicenseListResult.RequestDeclined) {
            String string = ((JBAccountInfoService.LicenseListResult.RequestDeclined)$this$toAipLicenseResult).errorCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorCode(...)");
            KnownRequestDeclinedReason knownRequestDeclinedReason = KnownRequestDeclinedReason.Companion.fromErrorCode(string);
            String string2 = ((JBAccountInfoService.LicenseListResult.RequestDeclined)$this$toAipLicenseResult).message();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            aipLicenseResult = knownRequestDeclinedReason.toAipLicenseDenied(string2);
        } else if (licenseListResult instanceof JBAccountInfoService.LicenseListResult.RequestFailed) {
            String string = ((JBAccountInfoService.LicenseListResult.RequestFailed)$this$toAipLicenseResult).errorMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorMessage(...)");
            aipLicenseResult = new AipLicenseRequestFailure.ErrorResponse(string);
        } else if (licenseListResult instanceof JBAccountInfoService.AuthRequired) {
            aipLicenseResult = AipLicenseRequestFailure.AuthRequired.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return aipLicenseResult;
    }

    private static final AipLicense toAipLicense(JBAccountInfoService.JbaLicense $this$toAipLicense, AipLicenseProductType productType) {
        String string = $this$toAipLicense.licenseId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"licenseId(...)");
        String string2 = AipLicenseId.constructor-impl(string);
        String string3 = $this$toAipLicense.jbaUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jbaUserId(...)");
        String string4 = JbaUserId.constructor-impl(string3);
        boolean bl = $this$toAipLicense.licensePack() != JBAccountInfoService.LicensePack.NONE;
        boolean bl2 = $this$toAipLicense.licenseKind() == JBAccountInfoService.LicenseKind.TRIAL;
        boolean bl3 = $this$toAipLicense.licenseeType() == JBAccountInfoService.LicenseeType.INDIVIDUAL;
        String string5 = $this$toAipLicense.licensedTo();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"licensedTo(...)");
        String string6 = string5;
        Instant instant = $this$toAipLicense.expiresOn();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"expiresOn(...)");
        kotlinx.datetime.Instant instant2 = ConvertersKt.toKotlinInstant((Instant)instant);
        return new AipLicense(string2, string4, bl, bl2, bl3, productType, string6, instant2, null, null, 768, null);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ AipLicenseResult access$toAipLicenseResult(JBAccountInfoService.LicenseListResult $receiver, AipLicenseProductType productType) {
        return IjAipLicenseRepositoryKt.toAipLicenseResult($receiver, productType);
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

