/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.impl.chat.mcp;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\b\u000b\f\r\u000e\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H&R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u0082\u0001\u0006\u0013\u0014\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription;", "", "<init>", "()V", "textDescription", "", "getTextDescription", "()Ljava/lang/String;", "collectionId", "getCollectionId", "toChatDumpEntry", "TextDescription", "PlanDescription", "PlanUpdate", "PlanItem", "PlanItemStatus", "FileAccessDescription", "FileEditDescription", "BashDescription", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$BashDescription;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$FileAccessDescription;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$FileEditDescription;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanDescription;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanUpdate;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$TextDescription;", "intellij.ml.llm.agents.impl"})
public abstract class McpToolUseDescription {
    @Nullable
    private final String collectionId;

    private McpToolUseDescription() {
    }

    @Nullable
    public abstract String getTextDescription();

    @Nullable
    public String getCollectionId() {
        return this.collectionId;
    }

    @NotNull
    public abstract String toChatDumpEntry();

    public /* synthetic */ McpToolUseDescription(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$BashDescription;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription;", "command", "", "<init>", "(Ljava/lang/String;)V", "getCommand", "()Ljava/lang/String;", "textDescription", "getTextDescription", "toChatDumpEntry", "intellij.ml.llm.agents.impl"})
    public static final class BashDescription
    extends McpToolUseDescription {
        @NotNull
        private final String command;
        @NotNull
        private final String textDescription;

        public BashDescription(@NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            super(null);
            this.command = command;
            this.textDescription = "Bash command: " + this.command;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @Override
        @NotNull
        public String getTextDescription() {
            return this.textDescription;
        }

        @Override
        @NotNull
        public String toChatDumpEntry() {
            return this.getTextDescription();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$FileAccessDescription;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "textDescription", "getTextDescription", "()Ljava/lang/String;", "toChatDumpEntry", "intellij.ml.llm.agents.impl"})
    public static final class FileAccessDescription
    extends McpToolUseDescription {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final String text;

        public FileAccessDescription(@NotNull VirtualFile file, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(null);
            this.file = file;
            this.text = text2;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @Override
        @NotNull
        public String getTextDescription() {
            return this.text + " <a href=\"#\"><code>" + this.file.getName() + "</code></a>";
        }

        @Override
        @NotNull
        public String toChatDumpEntry() {
            String string = this.file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$FileEditDescription;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription;", "filePath", "", "defaultTextDescription", "approvalRequestDescription", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFilePath", "()Ljava/lang/String;", "getDefaultTextDescription", "getApprovalRequestDescription", "textDescription", "getTextDescription", "collectionId", "getCollectionId", "toChatDumpEntry", "intellij.ml.llm.agents.impl"})
    public static final class FileEditDescription
    extends McpToolUseDescription {
        @NotNull
        private final String filePath;
        @Nullable
        private final String defaultTextDescription;
        @Nullable
        private final String approvalRequestDescription;
        @NotNull
        private final String textDescription;

        public FileEditDescription(@NotNull String filePath, @Nullable String defaultTextDescription, @Nullable String approvalRequestDescription) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            super(null);
            this.filePath = filePath;
            this.defaultTextDescription = defaultTextDescription;
            this.approvalRequestDescription = approvalRequestDescription;
            Object object = this.defaultTextDescription;
            if (object == null) {
                object = "Diff for " + this.filePath;
            }
            this.textDescription = object;
        }

        public /* synthetic */ FileEditDescription(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @Nullable
        public final String getDefaultTextDescription() {
            return this.defaultTextDescription;
        }

        @Nullable
        public final String getApprovalRequestDescription() {
            return this.approvalRequestDescription;
        }

        @Override
        @NotNull
        public String getTextDescription() {
            return this.textDescription;
        }

        @Override
        @NotNull
        public String getCollectionId() {
            return this.filePath;
        }

        @Override
        @NotNull
        public String toChatDumpEntry() {
            return this.getTextDescription();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B%\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanDescription;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription;", "textDescription", "", "textPlan", "markdownPlan", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTextDescription", "()Ljava/lang/String;", "getTextPlan", "getMarkdownPlan", "toChatDumpEntry", "intellij.ml.llm.agents.impl"})
    public static final class PlanDescription
    extends McpToolUseDescription {
        @Nullable
        private final String textDescription;
        @NotNull
        private final String textPlan;
        @NotNull
        private final String markdownPlan;

        public PlanDescription(@Nls @Nullable String textDescription, @NotNull String textPlan, @Nls @NotNull String markdownPlan) {
            Intrinsics.checkNotNullParameter((Object)textPlan, (String)"textPlan");
            Intrinsics.checkNotNullParameter((Object)markdownPlan, (String)"markdownPlan");
            super(null);
            this.textDescription = textDescription;
            this.textPlan = textPlan;
            this.markdownPlan = markdownPlan;
        }

        @Override
        @Nullable
        public String getTextDescription() {
            return this.textDescription;
        }

        @NotNull
        public final String getTextPlan() {
            return this.textPlan;
        }

        @NotNull
        public final String getMarkdownPlan() {
            return this.markdownPlan;
        }

        @Override
        @NotNull
        public String toChatDumpEntry() {
            String plan = CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)this.textPlan), (CharSequence)"\n", null, null, (int)0, null, PlanDescription::toChatDumpEntry$lambda$0, (int)30, null);
            return this.getTextDescription() + "\nPlan:\n" + plan + "\n";
        }

        private static final CharSequence toChatDumpEntry$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "  " + it;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanItem;", "", "content", "", "status", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanItemStatus;", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanItemStatus;)V", "getContent", "()Ljava/lang/String;", "getStatus", "()Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanItemStatus;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.agents.impl"})
    public static final class PlanItem {
        @NotNull
        private final String content;
        @NotNull
        private final PlanItemStatus status;

        public PlanItem(@NotNull String content2, @NotNull PlanItemStatus status) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.content = content2;
            this.status = status;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @NotNull
        public final PlanItemStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final String component1() {
            return this.content;
        }

        @NotNull
        public final PlanItemStatus component2() {
            return this.status;
        }

        @NotNull
        public final PlanItem copy(@NotNull String content2, @NotNull PlanItemStatus status) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return new PlanItem(content2, status);
        }

        public static /* synthetic */ PlanItem copy$default(PlanItem planItem, String string, PlanItemStatus planItemStatus, int n, Object object) {
            if ((n & 1) != 0) {
                string = planItem.content;
            }
            if ((n & 2) != 0) {
                planItemStatus = planItem.status;
            }
            return planItem.copy(string, planItemStatus);
        }

        @NotNull
        public String toString() {
            return "PlanItem(content=" + this.content + ", status=" + this.status + ")";
        }

        public int hashCode() {
            int result2 = this.content.hashCode();
            result2 = result2 * 31 + this.status.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlanItem)) {
                return false;
            }
            PlanItem planItem = (PlanItem)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)planItem.content)) {
                return false;
            }
            return this.status == planItem.status;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanItemStatus;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_STARTED", "IN_PROGRESS", "COMPLETED", "intellij.ml.llm.agents.impl"})
    public static final class PlanItemStatus
    extends Enum<PlanItemStatus> {
        public static final /* enum */ PlanItemStatus NOT_STARTED = new PlanItemStatus();
        public static final /* enum */ PlanItemStatus IN_PROGRESS = new PlanItemStatus();
        public static final /* enum */ PlanItemStatus COMPLETED = new PlanItemStatus();
        private static final /* synthetic */ PlanItemStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PlanItemStatus[] values() {
            return (PlanItemStatus[])$VALUES.clone();
        }

        public static PlanItemStatus valueOf(String value2) {
            return Enum.valueOf(PlanItemStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<PlanItemStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = planItemStatusArray = new PlanItemStatus[]{PlanItemStatus.NOT_STARTED, PlanItemStatus.IN_PROGRESS, PlanItemStatus.COMPLETED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanUpdate;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription;", "textDescription", "", "items", "", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$PlanItem;", "<init>", "(Ljava/lang/String;Ljava/util/Collection;)V", "getTextDescription", "()Ljava/lang/String;", "getItems", "()Ljava/util/Collection;", "collectionId", "getCollectionId", "toChatDumpEntry", "intellij.ml.llm.agents.impl"})
    public static final class PlanUpdate
    extends McpToolUseDescription {
        @Nullable
        private final String textDescription;
        @NotNull
        private final Collection<PlanItem> items;

        public PlanUpdate(@Nullable String textDescription, @NotNull Collection<PlanItem> items2) {
            Intrinsics.checkNotNullParameter(items2, (String)"items");
            super(null);
            this.textDescription = textDescription;
            this.items = items2;
        }

        @Override
        @Nullable
        public String getTextDescription() {
            return this.textDescription;
        }

        @NotNull
        public final Collection<PlanItem> getItems() {
            return this.items;
        }

        @Override
        @NotNull
        public String getCollectionId() {
            return String.valueOf(CollectionsKt.joinToString$default((Iterable)this.items, null, null, null, (int)0, null, PlanUpdate::_get_collectionId_$lambda$0, (int)31, null).hashCode());
        }

        @Override
        @NotNull
        public String toChatDumpEntry() {
            String itemsString = CollectionsKt.joinToString$default((Iterable)this.items, (CharSequence)"\n", null, null, (int)0, null, PlanUpdate::toChatDumpEntry$lambda$1, (int)30, null);
            return this.getTextDescription() + "\n" + itemsString + "\n";
        }

        private static final CharSequence _get_collectionId_$lambda$0(PlanItem it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getContent();
        }

        private static final CharSequence toChatDumpEntry$lambda$1(PlanItem it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "  " + it;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription$TextDescription;", "Lcom/intellij/ml/llm/agents/impl/chat/mcp/McpToolUseDescription;", "textDescription", "", "<init>", "(Ljava/lang/String;)V", "getTextDescription", "()Ljava/lang/String;", "toChatDumpEntry", "intellij.ml.llm.agents.impl"})
    public static final class TextDescription
    extends McpToolUseDescription {
        @Nullable
        private final String textDescription;

        public TextDescription(@Nullable String textDescription) {
            super(null);
            this.textDescription = textDescription;
        }

        @Override
        @Nullable
        public String getTextDescription() {
            return this.textDescription;
        }

        @Override
        @NotNull
        public String toChatDumpEntry() {
            String string = this.getTextDescription();
            if (string == null) {
                string = "";
            }
            return string;
        }
    }
}

