/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage;

import com.intellij.ml.llm.chatInputLanguage.extensions.ChatInputFileReferenceKt;
import com.intellij.ml.llm.chatInputLanguage.extensions.ChatInputFolderReferenceKt;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.ui.chat.input.ChatReferenceBasedInputDropHandler;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ&\u0010\u001d\u001a\u00020\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0016H\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputFileDropHandler;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/ChatReferenceBasedInputDropHandler;", "Ljava/io/File;", "<init>", "()V", "canHandleDrop", "", "transferFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "([Ljava/awt/datatransfer/DataFlavor;)Z", "extractData", "", "transferable", "Ljava/awt/datatransfer/Transferable;", "composeReference", "", "obj", "insertReference", "", "targetFile", "targetVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "inputFile", "Lcom/intellij/psi/PsiFile;", "inputEditor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "processData", "objects", "canBeInserted", "file", "intellij.ml.llm.chatInputLanguage"})
@SourceDebugExtension(value={"SMAP\nChatInputFileDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInputFileDropHandler.kt\ncom/intellij/ml/llm/chatInputLanguage/ChatInputFileDropHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,89:1\n1#2:90\n808#3,11:91\n1088#4,2:102\n68#5,6:104\n*S KotlinDebug\n*F\n+ 1 ChatInputFileDropHandler.kt\ncom/intellij/ml/llm/chatInputLanguage/ChatInputFileDropHandler\n*L\n35#1:91,11\n40#1:102,2\n58#1:104,6\n*E\n"})
public final class ChatInputFileDropHandler
extends ChatReferenceBasedInputDropHandler<File> {
    public boolean canHandleDrop(@NotNull DataFlavor[] transferFlavors) {
        DataFlavor dataFlavor;
        block2: {
            Intrinsics.checkNotNullParameter((Object)transferFlavors, (String)"transferFlavors");
            if (Registry.Companion.is("llm.chat.input.drop.files.as.attachments.enabled")) {
                return false;
            }
            DataFlavor[] dataFlavorArray = transferFlavors;
            int n = dataFlavorArray.length;
            for (int i = 0; i < n; ++i) {
                DataFlavor dataFlavor2;
                DataFlavor it = dataFlavor2 = dataFlavorArray[i];
                boolean bl = false;
                if (!it.isFlavorJavaFileListType()) continue;
                dataFlavor = dataFlavor2;
                break block2;
            }
            dataFlavor = null;
        }
        return dataFlavor != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<File> extractData(@NotNull Transferable transferable) {
        List list;
        Object object;
        block5: {
            Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
            for (Object object2 : (Object[])dataFlavorArray) {
                DataFlavor it = (DataFlavor)object2;
                boolean bl = false;
                if (!it.isFlavorJavaFileListType()) continue;
                object = object2;
                break block5;
            }
            object = null;
        }
        DataFlavor dataFlavor = (DataFlavor)object;
        if (dataFlavor == null) {
            return CollectionsKt.emptyList();
        }
        DataFlavor fileFlavor = dataFlavor;
        Object object3 = transferable.getTransferData(fileFlavor);
        List list2 = object3 instanceof List ? (List)object3 : null;
        if (list2 != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = list2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof File)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    protected String composeReference(@NotNull File obj) {
        boolean bl;
        String type2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            type2 = obj.isDirectory() && Registry.Companion.is("llm.chat.folder.attachments.enabled") ? "folder" : "file";
            String string = obj.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            CharSequence $this$any$iv = string;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!CharsKt.isWhitespace((char)it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        Object wrappedName = bl ? "`" + obj.getName() + "`" : obj.getName();
        return "@" + type2 + ":" + (String)wrappedName;
    }

    /*
     * WARNING - void declaration
     */
    public final void insertReference(@NotNull File targetFile, @NotNull VirtualFile targetVirtualFile, @NotNull PsiFile inputFile, @NotNull Editor inputEditor, @NotNull Project project2) {
        void $this$getOrCreateUserDataUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)targetVirtualFile, (String)"targetVirtualFile");
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)inputEditor, (String)"inputEditor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.insertReference(this.composeReference(targetFile), inputEditor, project2);
        Key<Map<String, VirtualFile>> typeKey = targetFile.isDirectory() && Registry.Companion.is("llm.chat.folder.attachments.enabled") ? ChatInputFolderReferenceKt.getREFERENCED_FOLDERS_KEY() : ChatInputFileReferenceKt.getREFERENCED_FILES_KEY();
        UserDataHolder userDataHolder = (UserDataHolder)inputFile;
        Key<Map<String, VirtualFile>> key$iv = typeKey;
        boolean $i$f$getOrCreateUserDataUnsafe = false;
        Object existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
        Object object = existing$iv;
        if (object == null) {
            boolean bl = false;
            Map value$iv = new LinkedHashMap();
            $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
            object = value$iv;
        }
        Map referencedFileMap = (Map)object;
        referencedFileMap.put(targetVirtualFile.getName(), targetVirtualFile);
    }

    protected void processData(@NotNull List<? extends File> objects, @NotNull Editor inputEditor, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)inputEditor, (String)"inputEditor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Document document2 = inputEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document inputDocument = document2;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(inputDocument);
        if (psiFile == null) {
            return;
        }
        PsiFile inputFile = psiFile;
        boolean hasAiIgnoredFiles = false;
        for (File file : objects) {
            VirtualFile virtualFile2;
            if (VfsUtil.findFileByIoFile((File)file, (boolean)false) == null) continue;
            if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, virtualFile2)) {
                hasAiIgnoredFiles = true;
                continue;
            }
            if (!this.canBeInserted(virtualFile2)) continue;
            this.insertReference(file, virtualFile2, inputFile, inputEditor, project2);
        }
        if (hasAiIgnoredFiles) {
            BuildersKt.launch$default((CoroutineScope)AIAssistantServiceScope.Companion.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, null){
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                                int label;
                                final /* synthetic */ Project $project;
                                {
                                    this.$project = $project;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            PrivacyPathCheckerKt.notifyFileIsIgnored(this.$project);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final boolean canBeInserted(VirtualFile file) {
        return !file.isDirectory() ? true : Registry.Companion.is("llm.chat.folder.attachments.enabled");
    }
}

