/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.ml.llm.chatInputLanguage.completion.AiIgnoreCheckerKt;
import com.intellij.ml.llm.chatInputLanguage.extensions.ChatInputFileReferenceKt;
import com.intellij.ml.llm.completion.chat.ChatInputFileFilter;
import com.intellij.ml.llm.completion.chat.ChatReferenceCompletionProvider;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/completion/ChatInputFileCompletionProvider;", "Lcom/intellij/ml/llm/completion/chat/ChatReferenceCompletionProvider;", "<init>", "()V", "referenceType", "", "getReferenceType", "()Ljava/lang/String;", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "Companion", "FileInsertHandler", "intellij.ml.llm.chatInputLanguage"})
@SourceDebugExtension(value={"SMAP\nChatInputFileCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInputFileCompletionProvider.kt\ncom/intellij/ml/llm/chatInputLanguage/completion/ChatInputFileCompletionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1#2:122\n1878#3,3:123\n*S KotlinDebug\n*F\n+ 1 ChatInputFileCompletionProvider.kt\ncom/intellij/ml/llm/chatInputLanguage/completion/ChatInputFileCompletionProvider\n*L\n57#1:123,3\n*E\n"})
public final class ChatInputFileCompletionProvider
extends ChatReferenceCompletionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String referenceType;
    @NotNull
    public static final String FILE_SEPARATOR = "/";

    public ChatInputFileCompletionProvider() {
        this.referenceType = "file";
    }

    @NotNull
    public String getReferenceType() {
        return this.referenceType;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Project project2 = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        String string = project3.getBasePath();
        if (string == null) {
            string = "";
        }
        String projectBasePath = string;
        List addedFilePaths = new ArrayList();
        VirtualFileFilter fileFilter = ChatInputFileFilter.Companion.createFileFilter(project3);
        ChatInputFileCompletionProvider.addCompletions$addRecentFiles(project3, fileFilter, result2, addedFilePaths, projectBasePath, this);
        ChatInputFileCompletionProvider.addCompletions$addProjectFiles(project3, fileFilter, addedFilePaths, result2, projectBasePath, this);
    }

    private static final LookupElementBuilder addCompletions$createFileLookupElement(String projectBasePath, ChatInputFileCompletionProvider this$0, VirtualFile file) {
        String string;
        String it;
        StringBuilder stringBuilder;
        String string2;
        Object object = file.getParent();
        if (object != null && (object = object.getPath()) != null && (object = StringsKt.removePrefix((String)object, (CharSequence)projectBasePath)) != null) {
            char[] cArray = new char[]{'/'};
            string2 = StringsKt.trimStart((String)object, (char[])cArray);
        } else {
            string2 = null;
        }
        String relativeParentPath = string2;
        StringBuilder $this$addCompletions_u24createFileLookupElement_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$addCompletions_u24createFileLookupElement_u24lambda_u241.append(this$0.getReferenceType() + ":");
        String string3 = relativeParentPath;
        if (string3 != null) {
            it = string3;
            boolean bl2 = false;
            $this$addCompletions_u24createFileLookupElement_u24lambda_u241.append(it);
            $this$addCompletions_u24createFileLookupElement_u24lambda_u241.append(FILE_SEPARATOR);
        }
        $this$addCompletions_u24createFileLookupElement_u24lambda_u241.append(file.getName());
        String lookupString = stringBuilder.toString();
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)file, (String)file.getName());
        String string4 = StringKt.nullize$default((String)relativeParentPath, (boolean)false, (int)1, null);
        if (string4 != null) {
            it = string4;
            LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder;
            boolean bl3 = false;
            string = " " + it;
            lookupElementBuilder = lookupElementBuilder2;
        } else {
            string = null;
        }
        LookupElementBuilder lookupElementBuilder3 = lookupElementBuilder.withTailText(string).withIcon(VirtualFilePresentation.getIcon((VirtualFile)file)).withInsertHandler((InsertHandler)new FileInsertHandler(file)).withLookupString("#" + lookupString).withLookupString("@" + lookupString);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder3, (String)"withLookupString(...)");
        return lookupElementBuilder3;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addCompletions$addRecentFiles(Project project2, VirtualFileFilter fileFilter, CompletionResultSet $result, List<String> addedFilePaths, String projectBasePath, ChatInputFileCompletionProvider this$0) {
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.Companion.getInstance(project2);
        Iterable $this$forEachIndexed$iv = editorHistoryManager.getFileList();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void file;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualFile virtualFile2 = (VirtualFile)item$iv;
            int idx = n;
            boolean bl = false;
            if (fileFilter != null && !fileFilter.accept((VirtualFile)file)) continue;
            $result.caseInsensitive().addElement(PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)ChatInputFileCompletionProvider.addCompletions$createFileLookupElement(projectBasePath, this$0, (VirtualFile)file)), (double)idx));
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            addedFilePaths.add(string);
        }
    }

    private static final boolean addCompletions$addProjectFiles$canResolveToDocument(VirtualFile file) {
        if (!file.isValid() || file.isDirectory()) {
            return false;
        }
        FileType fileType2 = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        FileType fileType3 = fileType2;
        if (fileType3.isBinary()) {
            if (BinaryFileTypeDecompilers.getInstance().forFileType(fileType3) == null) {
                return false;
            }
            if (VirtualFileUtil.isTooLarge((VirtualFile)file)) {
                return false;
            }
        }
        return true;
    }

    private static final boolean addCompletions$addProjectFiles$lambda$4(List $addedFilePaths, CompletionResultSet $result, CompletionSorter $sorter, String $projectBasePath, ChatInputFileCompletionProvider this$0, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!$addedFilePaths.contains(file.getPath()) && ChatInputFileCompletionProvider.addCompletions$addProjectFiles$canResolveToDocument(file)) {
            $result.withRelevanceSorter($sorter).caseInsensitive().addElement((LookupElement)ChatInputFileCompletionProvider.addCompletions$createFileLookupElement($projectBasePath, this$0, file));
        }
        return true;
    }

    private static final void addCompletions$addProjectFiles(Project project2, VirtualFileFilter fileFilter, List<String> addedFilePaths, CompletionResultSet $result, String projectBasePath, ChatInputFileCompletionProvider this$0) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        CompletionSorter sorter = CompletionSorter.emptySorter();
        projectFileIndex2.iterateContent(arg_0 -> ChatInputFileCompletionProvider.addCompletions$addProjectFiles$lambda$4(addedFilePaths, $result, sorter, projectBasePath, this$0, arg_0), fileFilter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/completion/ChatInputFileCompletionProvider$Companion;", "", "<init>", "()V", "FILE_SEPARATOR", "", "intellij.ml.llm.chatInputLanguage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/completion/ChatInputFileCompletionProvider$FileInsertHandler;", "Lcom/intellij/ml/llm/completion/chat/ChatReferenceCompletionProvider$ChatReferenceInsertionHandler;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "referenceType", "", "getReferenceType", "()Ljava/lang/String;", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "intellij.ml.llm.chatInputLanguage"})
    @SourceDebugExtension(value={"SMAP\nChatInputFileCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInputFileCompletionProvider.kt\ncom/intellij/ml/llm/chatInputLanguage/completion/ChatInputFileCompletionProvider$FileInsertHandler\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,121:1\n68#2,6:122\n*S KotlinDebug\n*F\n+ 1 ChatInputFileCompletionProvider.kt\ncom/intellij/ml/llm/chatInputLanguage/completion/ChatInputFileCompletionProvider$FileInsertHandler\n*L\n116#1:122,6\n*E\n"})
    private static final class FileInsertHandler
    implements ChatReferenceCompletionProvider.ChatReferenceInsertionHandler {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final String referenceType;

        public FileInsertHandler(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.referenceType = "file";
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public String getReferenceType() {
            return this.referenceType;
        }

        /*
         * WARNING - void declaration
         */
        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            void $this$getOrCreateUserDataUnsafe$iv;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            super.handleInsert(context2, item);
            PsiFile psiFile = context2.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            UserDataHolder userDataHolder = (UserDataHolder)psiFile;
            Key<Map<String, VirtualFile>> key$iv = ChatInputFileReferenceKt.getREFERENCED_FILES_KEY();
            boolean $i$f$getOrCreateUserDataUnsafe = false;
            Object existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
            Object object = existing$iv;
            if (object == null) {
                boolean bl = false;
                Map value$iv = new LinkedHashMap();
                $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
                object = value$iv;
            }
            Map referencedFileMap = (Map)object;
            Intrinsics.checkNotNull((Object)referencedFileMap);
            referencedFileMap.put(this.file.getName(), this.file);
            AiIgnoreCheckerKt.checkAiIgnore(context2, item);
        }
    }
}

