/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeEngine;

import com.intellij.ml.llm.codeEngine.IJVirtualPath;
import com.intellij.ml.llm.codeEngine.IJVirtualPathKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.io.PathKt;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u000234J\b\u0010\u001d\u001a\u00020\u001eH'J\b\u0010\u001f\u001a\u00020 H'J\b\u0010!\u001a\u00020\u000fH'J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H'J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H'J\b\u0010$\u001a\u00020%H'J\u0015\u0010&\u001a\u00020\u00002\u000b\u0010\u0018\u001a\u00070\u0003\u00a2\u0006\u0002\b'H'J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u001eH'J!\u0010*\u001a\u00020+2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.H&\u00a2\u0006\u0002\u0010/J!\u00100\u001a\u0002012\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.H'\u00a2\u0006\u0002\u00102R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0005R\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u0082\u0001\u000256\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00067\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/codeEngine/IJVirtualPath;", "", "pathString", "", "getPathString", "()Ljava/lang/String;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "isFile", "", "()Z", "isDirectory", "extension", "getExtension", "children", "Lkotlin/sequences/Sequence;", "getChildren", "()Lkotlin/sequences/Sequence;", "name", "getName", "parent", "getParent", "()Lcom/intellij/ml/llm/codeEngine/IJVirtualPath;", "contentsToByteArray", "", "size", "", "exists", "createChildFile", "createChildDirectory", "delete", "", "findChild", "Lorg/jetbrains/annotations/SystemIndependent;", "writeBytes", "content", "getInputStream", "Ljava/io/InputStream;", "options", "", "Ljava/nio/file/OpenOption;", "([Ljava/nio/file/OpenOption;)Ljava/io/InputStream;", "getOutputStream", "Ljava/io/OutputStream;", "([Ljava/nio/file/OpenOption;)Ljava/io/OutputStream;", "Real", "Ephemeral", "Lcom/intellij/ml/llm/codeEngine/IJVirtualPath$Ephemeral;", "Lcom/intellij/ml/llm/codeEngine/IJVirtualPath$Real;", "intellij.ml.llm.codeEngine"})
public interface IJVirtualPath {
    @NotNull
    public String getPathString();

    @NotNull
    public Path getPath();

    @Nullable
    public VirtualFile getFile();

    public boolean isFile();

    public boolean isDirectory();

    @Nullable
    public String getExtension();

    @NotNull
    public Sequence<IJVirtualPath> getChildren();

    @NotNull
    public String getName();

    @Nullable
    public IJVirtualPath getParent();

    @RequiresReadLockAbsence
    @NotNull
    public byte[] contentsToByteArray();

    @RequiresReadLockAbsence
    public long size();

    @RequiresReadLockAbsence
    public boolean exists();

    @RequiresWriteLock
    @NotNull
    public IJVirtualPath createChildFile(@NotNull String var1);

    @RequiresWriteLock
    @NotNull
    public IJVirtualPath createChildDirectory(@NotNull String var1);

    @RequiresWriteLock
    public void delete();

    @RequiresReadLock
    @NotNull
    public IJVirtualPath findChild(@NotNull String var1);

    @RequiresWriteLock
    public void writeBytes(@NotNull byte[] var1);

    @NotNull
    public InputStream getInputStream(OpenOption ... var1);

    @RequiresWriteLock
    @NotNull
    public OutputStream getOutputStream(OpenOption ... var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087@\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010&\u001a\u00020'H\u0016\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020+H\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b/\u0010\u0018J\u0017\u00100\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b1\u00102J\u0017\u00103\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b4\u00102J\u000f\u00105\u001a\u000206H\u0016\u00a2\u0006\u0004\b7\u00108J\u001c\u00109\u001a\u00020\u00012\u000b\u0010!\u001a\u00070\r\u00a2\u0006\u0002\b:H\u0016\u00a2\u0006\u0004\b;\u00102J\u0017\u0010<\u001a\u0002062\u0006\u0010=\u001a\u00020'H\u0016\u00a2\u0006\u0004\b>\u0010?J#\u0010@\u001a\u00020A2\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020D0C\"\u00020DH\u0016\u00a2\u0006\u0004\bE\u0010FJ#\u0010G\u001a\u00020H2\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020D0C\"\u00020DH\u0016\u00a2\u0006\u0004\bI\u0010JJ\u001a\u0010K\u001a\u00020\u00162\b\u0010L\u001a\u0004\u0018\u00010MH\u00d6\u0003\u00a2\u0006\u0004\bN\u0010OJ\u0010\u0010P\u001a\u00020QH\u00d6\u0001\u00a2\u0006\u0004\bR\u0010SJ\u0010\u0010T\u001a\u00020\rH\u00d6\u0001\u00a2\u0006\u0004\bU\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000fR\u0016\u0010#\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u0088\u0001\u0002\u00a8\u0006V"}, d2={"Lcom/intellij/ml/llm/codeEngine/IJVirtualPath$Ephemeral;", "Lcom/intellij/ml/llm/codeEngine/IJVirtualPath;", "ephemeralPath", "Ljava/nio/file/Path;", "constructor-impl", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "getEphemeralPath", "()Ljava/nio/file/Path;", "delegated", "Lcom/intellij/ml/llm/codeEngine/IJVirtualPath$Real;", "getDelegated-3MsjmnY", "(Ljava/nio/file/Path;)Lcom/intellij/openapi/vfs/VirtualFile;", "pathString", "", "getPathString-impl", "(Ljava/nio/file/Path;)Ljava/lang/String;", "path", "getPath-impl", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile-impl", "isFile", "", "isFile-impl", "(Ljava/nio/file/Path;)Z", "isDirectory", "isDirectory-impl", "extension", "getExtension-impl", "children", "Lkotlin/sequences/Sequence;", "getChildren-impl", "(Ljava/nio/file/Path;)Lkotlin/sequences/Sequence;", "name", "getName-impl", "parent", "getParent-impl", "(Ljava/nio/file/Path;)Lcom/intellij/ml/llm/codeEngine/IJVirtualPath;", "contentsToByteArray", "", "contentsToByteArray-impl", "(Ljava/nio/file/Path;)[B", "size", "", "size-impl", "(Ljava/nio/file/Path;)J", "exists", "exists-impl", "createChildFile", "createChildFile-impl", "(Ljava/nio/file/Path;Ljava/lang/String;)Lcom/intellij/ml/llm/codeEngine/IJVirtualPath;", "createChildDirectory", "createChildDirectory-impl", "delete", "", "delete-impl", "(Ljava/nio/file/Path;)V", "findChild", "Lorg/jetbrains/annotations/SystemIndependent;", "findChild-impl", "writeBytes", "content", "writeBytes-impl", "(Ljava/nio/file/Path;[B)V", "getInputStream", "Ljava/io/InputStream;", "options", "", "Ljava/nio/file/OpenOption;", "getInputStream-impl", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;", "getOutputStream", "Ljava/io/OutputStream;", "getOutputStream-impl", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStream;", "equals", "other", "", "equals-impl", "(Ljava/nio/file/Path;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/nio/file/Path;)I", "toString", "toString-impl", "intellij.ml.llm.codeEngine"})
    public static final class Ephemeral
    implements IJVirtualPath {
        @NotNull
        private final Path ephemeralPath;

        @NotNull
        public final Path getEphemeralPath() {
            return this.ephemeralPath;
        }

        private static final VirtualFile getDelegated-3MsjmnY(Path arg0) {
            VirtualFile virtualFile2 = IJVirtualPathKt.access$findByPath(arg0);
            IJVirtualPath iJVirtualPath = virtualFile2 != null ? IJVirtualPathKt.toVirtualPath(virtualFile2) : null;
            return iJVirtualPath instanceof Real ? ((Real)iJVirtualPath).unbox-impl() : null;
        }

        @NotNull
        public static String getPathString-impl(Path arg0) {
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.getPathString-impl(object)) == null) {
                object = ((Object)arg0).toString();
            }
            return object;
        }

        @Override
        @NotNull
        public String getPathString() {
            return Ephemeral.getPathString-impl(this.ephemeralPath);
        }

        @NotNull
        public static Path getPath-impl(Path arg0) {
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.getPath-impl(object)) == null) {
                object = arg0;
            }
            return object;
        }

        @Override
        @NotNull
        public Path getPath() {
            return Ephemeral.getPath-impl(this.ephemeralPath);
        }

        @Nullable
        public static VirtualFile getFile-impl(Path arg0) {
            VirtualFile virtualFile2 = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (virtualFile2 == null || (virtualFile2 = Real.getFile-impl(virtualFile2)) == null) {
                virtualFile2 = IJVirtualPathKt.access$findByPath(arg0);
            }
            return virtualFile2;
        }

        @Override
        @Nullable
        public VirtualFile getFile() {
            return Ephemeral.getFile-impl(this.ephemeralPath);
        }

        public static boolean isFile-impl(Path arg0) {
            boolean bl;
            VirtualFile virtualFile2 = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (virtualFile2 != null) {
                bl = Real.isFile-impl(virtualFile2);
            } else {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl = Files.isRegularFile(arg0, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            }
            return bl;
        }

        @Override
        public boolean isFile() {
            return Ephemeral.isFile-impl(this.ephemeralPath);
        }

        public static boolean isDirectory-impl(Path arg0) {
            boolean bl;
            VirtualFile virtualFile2 = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (virtualFile2 != null) {
                bl = Real.isDirectory-impl(virtualFile2);
            } else {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl = Files.isDirectory(arg0, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            }
            return bl;
        }

        @Override
        public boolean isDirectory() {
            return Ephemeral.isDirectory-impl(this.ephemeralPath);
        }

        @Nullable
        public static String getExtension-impl(Path arg0) {
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.getExtension-impl(object)) == null) {
                object = PathsKt.getExtension((Path)arg0);
            }
            return object;
        }

        @Override
        @Nullable
        public String getExtension() {
            return Ephemeral.getExtension-impl(this.ephemeralPath);
        }

        @NotNull
        public static Sequence<IJVirtualPath> getChildren-impl(Path arg0) {
            Sequence sequence = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (sequence == null || (sequence = Real.getChildren-impl((VirtualFile)sequence)) == null) {
                sequence = SequencesKt.map((Sequence)PathsKt.walk((Path)arg0, (PathWalkOption[])new PathWalkOption[0]), Ephemeral::getChildren_impl$lambda$0);
            }
            return sequence;
        }

        @Override
        @NotNull
        public Sequence<IJVirtualPath> getChildren() {
            return Ephemeral.getChildren-impl(this.ephemeralPath);
        }

        @NotNull
        public static String getName-impl(Path arg0) {
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.getName-impl(object)) == null) {
                object = PathsKt.getName((Path)arg0);
            }
            return object;
        }

        @Override
        @NotNull
        public String getName() {
            return Ephemeral.getName-impl(this.ephemeralPath);
        }

        @Nullable
        public static IJVirtualPath getParent-impl(Path arg0) {
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.getParent-impl(object)) == null) {
                Path path = arg0.getParent();
                object = path != null ? IJVirtualPathKt.toVirtualPath(path) : null;
            }
            return object;
        }

        @Override
        @Nullable
        public IJVirtualPath getParent() {
            return Ephemeral.getParent-impl(this.ephemeralPath);
        }

        @NotNull
        public static byte[] contentsToByteArray-impl(Path arg0) {
            Object object;
            block3: {
                block2: {
                    object = Ephemeral.getDelegated-3MsjmnY(arg0);
                    if (object == null) break block2;
                    byte[] byArray = Real.contentsToByteArray-impl(object);
                    object = byArray;
                    if (byArray != null) break block3;
                }
                byte[] byArray = Files.readAllBytes(arg0);
                object = byArray;
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            }
            return object;
        }

        @Override
        @NotNull
        public byte[] contentsToByteArray() {
            return Ephemeral.contentsToByteArray-impl(this.ephemeralPath);
        }

        public static long size-impl(Path arg0) {
            VirtualFile virtualFile2 = Ephemeral.getDelegated-3MsjmnY(arg0);
            return virtualFile2 != null ? Real.size-impl(virtualFile2) : Files.size(arg0);
        }

        @Override
        public long size() {
            return Ephemeral.size-impl(this.ephemeralPath);
        }

        public static boolean exists-impl(Path arg0) {
            boolean bl;
            VirtualFile virtualFile2 = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (virtualFile2 != null) {
                bl = Real.exists-impl(virtualFile2);
            } else {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl = Files.exists(arg0, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            }
            return bl;
        }

        @Override
        public boolean exists() {
            return Ephemeral.exists-impl(this.ephemeralPath);
        }

        @NotNull
        public static IJVirtualPath createChildFile-impl(Path arg0, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.createChildFile-impl(object, name)) == null) {
                Path path = arg0.resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path2 = Files.createFile(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createFile(...)");
                object = IJVirtualPathKt.toVirtualPath(path2);
            }
            return object;
        }

        @Override
        @NotNull
        public IJVirtualPath createChildFile(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Ephemeral.createChildFile-impl(this.ephemeralPath, name);
        }

        @NotNull
        public static IJVirtualPath createChildDirectory-impl(Path arg0, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.createChildDirectory-impl(object, name)) == null) {
                Path path = arg0.resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path2 = Files.createDirectory(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectory(...)");
                object = IJVirtualPathKt.toVirtualPath(path2);
            }
            return object;
        }

        @Override
        @NotNull
        public IJVirtualPath createChildDirectory(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Ephemeral.createChildDirectory-impl(this.ephemeralPath, name);
        }

        public static void delete-impl(Path arg0) {
            VirtualFile virtualFile2 = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (virtualFile2 != null) {
                Real.delete-impl(virtualFile2);
            } else {
                Path $this$delete_impl_u24lambda_u241 = arg0;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists($this$delete_impl_u24lambda_u241, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    throw new FileNotFoundException("Does not exist: " + $this$delete_impl_u24lambda_u241);
                }
                PathKt.delete$default((Path)$this$delete_impl_u24lambda_u241, (boolean)false, (int)1, null);
            }
        }

        @Override
        public void delete() {
            Ephemeral.delete-impl(this.ephemeralPath);
        }

        @NotNull
        public static IJVirtualPath findChild-impl(Path arg0, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.findChild-impl(object, name)) == null) {
                Path path = Ephemeral.getPath-impl(arg0).resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                object = Ephemeral.box-impl(Ephemeral.constructor-impl(path));
            }
            return object;
        }

        @Override
        @NotNull
        public IJVirtualPath findChild(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Ephemeral.findChild-impl(this.ephemeralPath, name);
        }

        public static void writeBytes-impl(Path arg0, @NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            VirtualFile virtualFile2 = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (virtualFile2 != null) {
                Real.writeBytes-impl(virtualFile2, content2);
            } else {
                OpenOption[] openOptionArray = new OpenOption[]{};
                Files.write(arg0, content2, Arrays.copyOf(openOptionArray, openOptionArray.length));
            }
        }

        @Override
        public void writeBytes(@NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Ephemeral.writeBytes-impl(this.ephemeralPath, content2);
        }

        @NotNull
        public static InputStream getInputStream-impl(Path arg0, OpenOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.getInputStream-impl(object, Arrays.copyOf(options, options.length))) == null) {
                OpenOption[] openOptionArray = Arrays.copyOf(options, options.length);
                InputStream inputStream = Files.newInputStream(arg0, Arrays.copyOf(openOptionArray, openOptionArray.length));
                object = inputStream;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            }
            return object;
        }

        @Override
        @NotNull
        public InputStream getInputStream(OpenOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return Ephemeral.getInputStream-impl(this.ephemeralPath, options);
        }

        @NotNull
        public static OutputStream getOutputStream-impl(Path arg0, OpenOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Object object = Ephemeral.getDelegated-3MsjmnY(arg0);
            if (object == null || (object = Real.getOutputStream-impl(object, Arrays.copyOf(options, options.length))) == null) {
                OpenOption[] openOptionArray = Arrays.copyOf(options, options.length);
                OutputStream outputStream = Files.newOutputStream(arg0, Arrays.copyOf(openOptionArray, openOptionArray.length));
                object = outputStream;
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            }
            return object;
        }

        @Override
        @NotNull
        public OutputStream getOutputStream(OpenOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return Ephemeral.getOutputStream-impl(this.ephemeralPath, options);
        }

        public static String toString-impl(Path arg0) {
            return "Ephemeral(ephemeralPath=" + arg0 + ")";
        }

        public String toString() {
            return Ephemeral.toString-impl(this.ephemeralPath);
        }

        public static int hashCode-impl(Path arg0) {
            return ((Object)arg0).hashCode();
        }

        public int hashCode() {
            return Ephemeral.hashCode-impl(this.ephemeralPath);
        }

        public static boolean equals-impl(Path arg0, Object other) {
            if (!(other instanceof Ephemeral)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((Ephemeral)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return Ephemeral.equals-impl(this.ephemeralPath, other);
        }

        private /* synthetic */ Ephemeral(Path ephemeralPath) {
            this.ephemeralPath = ephemeralPath;
        }

        @NotNull
        public static Path constructor-impl(@NotNull Path ephemeralPath) {
            Intrinsics.checkNotNullParameter((Object)ephemeralPath, (String)"ephemeralPath");
            return ephemeralPath;
        }

        public static final /* synthetic */ Ephemeral box-impl(Path v) {
            return new Ephemeral(v);
        }

        public final /* synthetic */ Path unbox-impl() {
            return this.ephemeralPath;
        }

        public static final boolean equals-impl0(Path p1, Path p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }

        private static final IJVirtualPath getChildren_impl$lambda$0(Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return IJVirtualPathKt.toVirtualPath(it);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087@\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020(H\u0016\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b,\u0010\u0015J\u0017\u0010-\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00100\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b1\u0010/J\u000f\u00102\u001a\u000203H\u0016\u00a2\u0006\u0004\b4\u00105J\u001c\u00106\u001a\u00020\u00012\u000b\u0010\u001e\u001a\u00070\t\u00a2\u0006\u0002\b7H\u0016\u00a2\u0006\u0004\b8\u0010/J\u0017\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020$H\u0016\u00a2\u0006\u0004\b;\u0010<J#\u0010=\u001a\u00020>2\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0@\"\u00020AH\u0016\u00a2\u0006\u0004\bB\u0010CJ#\u0010D\u001a\u00020E2\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0@\"\u00020AH\u0016\u00a2\u0006\u0004\bF\u0010GJ\u001a\u0010H\u001a\u00020\u00132\b\u0010I\u001a\u0004\u0018\u00010JH\u00d6\u0003\u00a2\u0006\u0004\bK\u0010LJ\u0010\u0010M\u001a\u00020NH\u00d6\u0001\u00a2\u0006\u0004\bO\u0010PJ\u0010\u0010Q\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\bR\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000bR\u0016\u0010 \u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u0088\u0001\u0002\u00a8\u0006S"}, d2={"Lcom/intellij/ml/llm/codeEngine/IJVirtualPath$Real;", "Lcom/intellij/ml/llm/codeEngine/IJVirtualPath;", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "constructor-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/openapi/vfs/VirtualFile;", "getVFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "pathString", "", "getPathString-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "path", "Ljava/nio/file/Path;", "getPath-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/nio/file/Path;", "file", "getFile-impl", "isFile", "", "isFile-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isDirectory", "isDirectory-impl", "extension", "getExtension-impl", "children", "Lkotlin/sequences/Sequence;", "getChildren-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lkotlin/sequences/Sequence;", "name", "getName-impl", "parent", "getParent-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/ml/llm/codeEngine/IJVirtualPath;", "contentsToByteArray", "", "contentsToByteArray-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)[B", "size", "", "size-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)J", "exists", "exists-impl", "createChildFile", "createChildFile-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)Lcom/intellij/ml/llm/codeEngine/IJVirtualPath;", "createChildDirectory", "createChildDirectory-impl", "delete", "", "delete-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "findChild", "Lorg/jetbrains/annotations/SystemIndependent;", "findChild-impl", "writeBytes", "content", "writeBytes-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;[B)V", "getInputStream", "Ljava/io/InputStream;", "options", "", "Ljava/nio/file/OpenOption;", "getInputStream-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;", "getOutputStream", "Ljava/io/OutputStream;", "getOutputStream-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStream;", "equals", "other", "", "equals-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)I", "toString", "toString-impl", "intellij.ml.llm.codeEngine"})
    @SourceDebugExtension(value={"SMAP\nIJVirtualPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IJVirtualPath.kt\ncom/intellij/ml/llm/codeEngine/IJVirtualPath$Real\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,195:1\n18#2:196\n*S KotlinDebug\n*F\n+ 1 IJVirtualPath.kt\ncom/intellij/ml/llm/codeEngine/IJVirtualPath$Real\n*L\n85#1:196\n*E\n"})
    public static final class Real
    implements IJVirtualPath {
        @NotNull
        private final VirtualFile vFile;

        @NotNull
        public final VirtualFile getVFile() {
            return this.vFile;
        }

        @NotNull
        public static String getPathString-impl(VirtualFile arg0) {
            String string = arg0.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }

        @Override
        @NotNull
        public String getPathString() {
            return Real.getPathString-impl(this.vFile);
        }

        @NotNull
        public static Path getPath-impl(VirtualFile arg0) {
            Path path = arg0.getFileSystem().getNioPath(arg0);
            if (path == null) {
                Path path2 = Path.of(arg0.getPath(), new String[0]);
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            }
            return path;
        }

        @Override
        @NotNull
        public Path getPath() {
            return Real.getPath-impl(this.vFile);
        }

        @NotNull
        public static VirtualFile getFile-impl(VirtualFile arg0) {
            return arg0;
        }

        @Override
        @NotNull
        public VirtualFile getFile() {
            return Real.getFile-impl(this.vFile);
        }

        public static boolean isFile-impl(VirtualFile arg0) {
            return VirtualFileUtil.isFile((VirtualFile)arg0);
        }

        @Override
        public boolean isFile() {
            return Real.isFile-impl(this.vFile);
        }

        public static boolean isDirectory-impl(VirtualFile arg0) {
            return arg0.isDirectory();
        }

        @Override
        public boolean isDirectory() {
            return Real.isDirectory-impl(this.vFile);
        }

        @Nullable
        public static String getExtension-impl(VirtualFile arg0) {
            return arg0.getExtension();
        }

        @Override
        @Nullable
        public String getExtension() {
            return Real.getExtension-impl(this.vFile);
        }

        @NotNull
        public static Sequence<IJVirtualPath> getChildren-impl(VirtualFile arg0) {
            Object[] $this$orEmpty$iv = arg0.getChildren();
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                objectArray = new VirtualFile[]{};
            }
            return SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)children.1.INSTANCE);
        }

        @Override
        @NotNull
        public Sequence<IJVirtualPath> getChildren() {
            return Real.getChildren-impl(this.vFile);
        }

        @NotNull
        public static String getName-impl(VirtualFile arg0) {
            String string = arg0.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            return Real.getName-impl(this.vFile);
        }

        @Nullable
        public static IJVirtualPath getParent-impl(VirtualFile arg0) {
            VirtualFile virtualFile2 = arg0.getParent();
            return virtualFile2 != null ? IJVirtualPathKt.toVirtualPath(virtualFile2) : null;
        }

        @Override
        @Nullable
        public IJVirtualPath getParent() {
            return Real.getParent-impl(this.vFile);
        }

        @NotNull
        public static byte[] contentsToByteArray-impl(VirtualFile arg0) {
            byte[] byArray = arg0.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            return byArray;
        }

        @Override
        @NotNull
        public byte[] contentsToByteArray() {
            return Real.contentsToByteArray-impl(this.vFile);
        }

        public static long size-impl(VirtualFile arg0) {
            return arg0.getLength();
        }

        @Override
        public long size() {
            return Real.size-impl(this.vFile);
        }

        public static boolean exists-impl(VirtualFile arg0) {
            return arg0.exists();
        }

        @Override
        public boolean exists() {
            return Real.exists-impl(this.vFile);
        }

        @NotNull
        public static IJVirtualPath createChildFile-impl(VirtualFile arg0, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            VirtualFile virtualFile2 = arg0.createChildData((Object)arg0.getFileSystem(), name);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(...)");
            return IJVirtualPathKt.toVirtualPath(virtualFile2);
        }

        @Override
        @NotNull
        public IJVirtualPath createChildFile(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Real.createChildFile-impl(this.vFile, name);
        }

        @NotNull
        public static IJVirtualPath createChildDirectory-impl(VirtualFile arg0, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            VirtualFile virtualFile2 = arg0.createChildDirectory((Object)arg0.getFileSystem(), name);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildDirectory(...)");
            return IJVirtualPathKt.toVirtualPath(virtualFile2);
        }

        @Override
        @NotNull
        public IJVirtualPath createChildDirectory(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Real.createChildDirectory-impl(this.vFile, name);
        }

        public static void delete-impl(VirtualFile arg0) {
            arg0.delete((Object)Real.box-impl(arg0));
        }

        @Override
        public void delete() {
            Real.delete-impl(this.vFile);
        }

        @NotNull
        public static IJVirtualPath findChild-impl(VirtualFile arg0, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object object = VirtualFileUtil.findFileOrDirectory((VirtualFile)arg0, (String)name);
            if (object == null || (object = IJVirtualPathKt.toVirtualPath(object)) == null) {
                Path path = Real.getPath-impl(arg0).resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                object = Ephemeral.box-impl(Ephemeral.constructor-impl(path));
            }
            return object;
        }

        @Override
        @NotNull
        public IJVirtualPath findChild(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Real.findChild-impl(this.vFile, name);
        }

        public static void writeBytes-impl(VirtualFile arg0, @NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            VirtualFileUtil.writeBytes((VirtualFile)arg0, (byte[])content2);
        }

        @Override
        public void writeBytes(@NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Real.writeBytes-impl(this.vFile, content2);
        }

        @NotNull
        public static InputStream getInputStream-impl(VirtualFile arg0, OpenOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (!(options.length == 0)) {
                IJVirtualPathKt.access$getLOG$p().warn("Input stream options are not supported for " + arg0);
            }
            InputStream inputStream = arg0.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            return inputStream;
        }

        @Override
        @NotNull
        public InputStream getInputStream(OpenOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return Real.getInputStream-impl(this.vFile, options);
        }

        @NotNull
        public static OutputStream getOutputStream-impl(VirtualFile arg0, OpenOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (!(options.length == 0)) {
                IJVirtualPathKt.access$getLOG$p().warn("Output stream options are not supported for " + arg0);
            }
            OutputStream outputStream = arg0.getOutputStream((Object)Real.box-impl(arg0));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            return outputStream;
        }

        @Override
        @NotNull
        public OutputStream getOutputStream(OpenOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return Real.getOutputStream-impl(this.vFile, options);
        }

        public static String toString-impl(VirtualFile arg0) {
            return "Real(vFile=" + arg0 + ")";
        }

        public String toString() {
            return Real.toString-impl(this.vFile);
        }

        public static int hashCode-impl(VirtualFile arg0) {
            return arg0.hashCode();
        }

        public int hashCode() {
            return Real.hashCode-impl(this.vFile);
        }

        public static boolean equals-impl(VirtualFile arg0, Object other) {
            if (!(other instanceof Real)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((Real)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return Real.equals-impl(this.vFile, other);
        }

        private /* synthetic */ Real(VirtualFile vFile) {
            this.vFile = vFile;
        }

        @NotNull
        public static VirtualFile constructor-impl(@NotNull VirtualFile vFile) {
            Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
            return vFile;
        }

        public static final /* synthetic */ Real box-impl(VirtualFile v) {
            return new Real(v);
        }

        public final /* synthetic */ VirtualFile unbox-impl() {
            return this.vFile;
        }

        public static final boolean equals-impl0(VirtualFile p1, VirtualFile p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }
    }
}

