/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.diff.ineditor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.idea.AppMode;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationFeatures;
import com.intellij.ml.llm.codeGeneration.diff.AIResponseApplierChange;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIDeletedCodeEditorTextField;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIDeletedCodeInlayRenderer;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIDiffGutterRenderer;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffGutterHandler;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffRendererKt;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.CodeGenerationDiffRenderer;
import com.intellij.ml.llm.codeGeneration.inplace.AIDiffBasedCodeGenerationInteraction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.ComponentInlayKt;
import com.intellij.openapi.editor.ComponentInlayRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u0000 V2\u00020\u0001:\u0002VWB+\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u001e\u00105\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u00106\u001a\b\u0012\u0004\u0012\u00020.0\"H\u0016J\u0010\u00107\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\b\u00108\u001a\u000202H\u0004J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u000204H\u0016J\b\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u0002022\u0006\u0010>\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0004J\u0018\u0010?\u001a\u0002022\u0006\u0010>\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0004J6\u0010@\u001a\u0002022\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010>\u001a\u00020#2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020B\u0018\u00010\"2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010DH\u0002J\u0010\u0010E\u001a\u0002022\u0006\u0010>\u001a\u00020#H\u0014J \u0010F\u001a\u0002022\u0006\u0010>\u001a\u00020#2\u0006\u00103\u001a\u0002042\u0006\u0010G\u001a\u000204H\u0014J\u0018\u0010H\u001a\u0002022\u0006\u0010>\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0004J \u0010I\u001a\u00020J2\u0006\u0010>\u001a\u00020#2\u0006\u00103\u001a\u0002042\u0006\u0010G\u001a\u000204H\u0002J\u0010\u0010K\u001a\u00020 2\u0006\u0010L\u001a\u00020MH\u0002J\"\u0010R\u001a\u0002022\u0006\u0010S\u001a\u00020J2\u0006\u0010>\u001a\u00020#2\b\b\u0002\u0010T\u001a\u000204H\u0014J\u0010\u0010U\u001a\u0002042\u0006\u0010>\u001a\u00020#H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0018\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R \u0010-\u001a\b\u0012\u0004\u0012\u00020.0\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0018\"\u0004\b0\u0010&R\u0018\u0010N\u001a\u00020O*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q\u00a8\u0006X"}, d2={"Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffRenderer;", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/CodeGenerationDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "initialDocument", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileTypes/FileType;Lcom/intellij/openapi/editor/Document;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "getInitialDocument", "()Lcom/intellij/openapi/editor/Document;", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getHighlighters", "()Ljava/util/List;", "inlays", "Lcom/intellij/openapi/editor/Inlay;", "getInlays", "gutterOperations", "Lcom/intellij/diff/util/DiffGutterOperation;", "getGutterOperations", "textFieldCache", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIDeletedCodeEditorTextField;", "renderedChanges", "", "Lcom/intellij/diff/fragments/LineFragment;", "getRenderedChanges", "setRenderedChanges", "(Ljava/util/List;)V", "gutterHandler", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffGutterHandler;", "getGutterHandler", "()Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffGutterHandler;", "setGutterHandler", "(Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffGutterHandler;)V", "responseApplierChanges", "Lcom/intellij/ml/llm/codeGeneration/diff/AIResponseApplierChange;", "getResponseApplierChanges", "setResponseApplierChanges", "render", "", "withGutter", "", "renderWithCompletion", "changes", "doRender", "clear", "dispose", "isAnythingRendered", "getRenderingStartOffset", "", "renderTransparentModifiedCodeRange", "change", "renderSimpleModifiedCodeRange", "drawInLineHighlighter", "innerFragments", "Lcom/intellij/diff/fragments/DiffFragment;", "textDiffType", "Lcom/intellij/diff/util/TextDiffType;", "addGutterIcons", "renderInsertedCodeRange", "isModifiedCode", "renderDeletedCodeInlay", "addDeletedCodeInlay", "Lcom/intellij/ui/EditorTextField;", "getAIDeletedCodeEditorTextField", "deletedText", "", "lineIndexes", "Lkotlin/ranges/IntRange;", "getLineIndexes", "(Lcom/intellij/openapi/editor/Document;)Lkotlin/ranges/IntRange;", "setupDeletedCodeInlay", "inlay", "modifiedCode", "checkChangeCompleteness", "Companion", "AIInEditorDiffRendererFactory", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAIInEditorDiffRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIInEditorDiffRenderer.kt\ncom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,355:1\n1869#2,2:356\n1869#2,2:358\n1869#2,2:360\n1563#2:362\n1634#2,3:363\n774#2:367\n865#2,2:368\n1761#2,3:370\n1#3:366\n*S KotlinDebug\n*F\n+ 1 AIInEditorDiffRenderer.kt\ncom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffRenderer\n*L\n88#1:356,2\n90#1:358,2\n92#1:360,2\n103#1:362\n103#1:363,3\n258#1:367\n258#1:368,2\n260#1:370,3\n*E\n"})
public class AIInEditorDiffRenderer
implements CodeGenerationDiffRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @Nullable
    private final FileType fileType;
    @NotNull
    private final Document initialDocument;
    @NotNull
    private final List<RangeHighlighter> highlighters;
    @NotNull
    private final List<Inlay<?>> inlays;
    @NotNull
    private final List<DiffGutterOperation> gutterOperations;
    @NotNull
    private final List<AIDeletedCodeEditorTextField> textFieldCache;
    @NotNull
    private List<? extends LineFragment> renderedChanges;
    @Nullable
    private AIInEditorDiffGutterHandler gutterHandler;
    @NotNull
    private List<AIResponseApplierChange> responseApplierChanges;
    public static final int $stable = 8;

    protected AIInEditorDiffRenderer(@NotNull Editor editor2, @NotNull Project project2, @Nullable FileType fileType2, @NotNull Document initialDocument) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)initialDocument, (String)"initialDocument");
        this.editor = editor2;
        this.project = project2;
        this.fileType = fileType2;
        this.initialDocument = initialDocument;
        this.highlighters = new ArrayList();
        this.inlays = new ArrayList();
        this.gutterOperations = new ArrayList();
        this.textFieldCache = new ArrayList();
        this.renderedChanges = CollectionsKt.emptyList();
        this.responseApplierChanges = CollectionsKt.emptyList();
    }

    @NotNull
    protected final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    protected final FileType getFileType() {
        return this.fileType;
    }

    @Override
    @NotNull
    public Document getInitialDocument() {
        return this.initialDocument;
    }

    @NotNull
    protected final List<RangeHighlighter> getHighlighters() {
        return this.highlighters;
    }

    @NotNull
    protected final List<Inlay<?>> getInlays() {
        return this.inlays;
    }

    @NotNull
    protected final List<DiffGutterOperation> getGutterOperations() {
        return this.gutterOperations;
    }

    @Override
    @NotNull
    public List<LineFragment> getRenderedChanges() {
        return this.renderedChanges;
    }

    @Override
    public void setRenderedChanges(@NotNull List<? extends LineFragment> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.renderedChanges = list;
    }

    @Override
    @Nullable
    public AIInEditorDiffGutterHandler getGutterHandler() {
        return this.gutterHandler;
    }

    @Override
    public void setGutterHandler(@Nullable AIInEditorDiffGutterHandler aIInEditorDiffGutterHandler) {
        this.gutterHandler = aIInEditorDiffGutterHandler;
    }

    @NotNull
    public final List<AIResponseApplierChange> getResponseApplierChanges() {
        return this.responseApplierChanges;
    }

    public final void setResponseApplierChanges(@NotNull List<AIResponseApplierChange> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.responseApplierChanges = list;
    }

    @Override
    public void render(boolean withGutter) {
        this.responseApplierChanges = CollectionsKt.emptyList();
        this.clear();
        this.doRender(withGutter);
    }

    @Override
    public void renderWithCompletion(boolean withGutter, @NotNull List<AIResponseApplierChange> changes2) {
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        this.responseApplierChanges = changes2;
        this.clear();
        this.doRender(withGutter);
    }

    private final void doRender(boolean withGutter) {
        String string = this.getInitialDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this.editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        this.setRenderedChanges(AIInEditorDiffRendererKt.calculateChanges(string, string2));
        for (LineFragment change : this.getRenderedChanges()) {
            boolean insertedRangeIsEmpty;
            boolean deletedRangeIsEmpty = change.getEndLine1() - change.getStartLine1() == 0;
            boolean bl = insertedRangeIsEmpty = change.getEndLine2() - change.getStartLine2() == 0;
            if (!insertedRangeIsEmpty && !deletedRangeIsEmpty) {
                if (AICodeGenerationFeatures.INSTANCE.showComparisonsForModifiedCode()) {
                    this.renderTransparentModifiedCodeRange(change, withGutter);
                    continue;
                }
                this.renderSimpleModifiedCodeRange(change, withGutter);
                continue;
            }
            if (!insertedRangeIsEmpty) {
                this.renderInsertedCodeRange(change, withGutter, false);
                continue;
            }
            if (!deletedRangeIsEmpty) {
                this.renderDeletedCodeInlay(change, withGutter);
                continue;
            }
            throw new IllegalStateException("Unexpected change, both deleted and inserted ranges are empty");
        }
    }

    protected final void clear() {
        RangeHighlighter it;
        Iterable $this$forEach$iv = this.highlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (RangeHighlighter)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.highlighters.clear();
        $this$forEach$iv = this.inlays;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Inlay)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.inlays.clear();
        $this$forEach$iv = this.gutterOperations;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (DiffGutterOperation)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.gutterOperations.clear();
    }

    public void dispose() {
        this.clear();
        this.textFieldCache.clear();
    }

    @Override
    public boolean isAnythingRendered() {
        return !((Collection)this.highlighters).isEmpty() || !((Collection)this.inlays).isEmpty();
    }

    @Override
    public int getRenderingStartOffset() {
        Inlay it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.highlighters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RangeHighlighter rangeHighlighter = (RangeHighlighter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStartOffset());
        }
        $this$map$iv = this.inlays;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Inlay)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getOffset());
        }
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)));
        return n != null ? n : -1;
    }

    protected final void renderTransparentModifiedCodeRange(@NotNull LineFragment change, boolean withGutter) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        this.renderInsertedCodeRange(change, withGutter, true);
        this.drawInLineHighlighter(this.editor, change, change.getInnerFragments(), TextDiffType.INSERTED);
        if (ApplicationManager.getApplication().isUnitTestMode() || AppMode.isRemoteDevHost()) {
            return;
        }
        EditorTextField editorTextField = this.addDeletedCodeInlay(change, false, true);
        this.drawInLineHighlighter(editorTextField.getEditor(), change, change.getInnerFragments(), TextDiffType.DELETED);
        this.setupDeletedCodeInlay(editorTextField, change, true);
    }

    protected final void renderSimpleModifiedCodeRange(@NotNull LineFragment change, boolean withGutter) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        List innerFragments = change.getInnerFragments();
        List it = new DiffDrawUtil.LineHighlighterBuilder(this.editor, change.getStartLine2(), change.getEndLine2(), TextDiffType.MODIFIED).withIgnored(innerFragments != null).withGutterMode(new DiffDrawUtil.PaintMode(DiffDrawUtil.BackgroundType.NONE, DiffDrawUtil.BorderType.NONE)).withClearThinLineBetweenGutterAndEditor(true).done();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        this.highlighters.addAll(it);
        AIInEditorDiffRenderer.drawInLineHighlighter$default(this, this.editor, change, innerFragments, null, 8, null);
        if (withGutter) {
            this.addGutterIcons(change);
        }
    }

    private final void drawInLineHighlighter(Editor editor2, LineFragment change, List<? extends DiffFragment> innerFragments, TextDiffType textDiffType) {
        if (innerFragments == null || editor2 == null || editor2.getDocument().getTextLength() <= 1) {
            return;
        }
        int startLineOffset = Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.DELETED) ? 0 : change.getStartOffset2();
        for (DiffFragment diffFragment : innerFragments) {
            TextDiffType textDiffType2 = textDiffType;
            if (textDiffType2 == null) {
                TextDiffType textDiffType3 = DiffUtil.getDiffType((DiffFragment)diffFragment);
                textDiffType2 = textDiffType3;
                Intrinsics.checkNotNullExpressionValue((Object)textDiffType3, (String)"getDiffType(...)");
            }
            TextDiffType innerDiffType = textDiffType2;
            int startOffset = Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.DELETED) ? diffFragment.getStartOffset1() : diffFragment.getStartOffset2();
            int endOffset = Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.DELETED) ? diffFragment.getEndOffset1() : diffFragment.getEndOffset2();
            int coercedStartOffset = RangesKt.coerceIn((int)(startOffset + startLineOffset), (ClosedRange)((ClosedRange)new IntRange(0, editor2.getDocument().getTextLength() - 1)));
            int coercedEndOffset = RangesKt.coerceIn((int)(startLineOffset + endOffset), (ClosedRange)((ClosedRange)new IntRange(coercedStartOffset, editor2.getDocument().getTextLength() - 1)));
            List it = DiffDrawUtil.createInlineHighlighter((Editor)editor2, (int)coercedStartOffset, (int)coercedEndOffset, (TextDiffType)innerDiffType);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.highlighters.addAll(it);
        }
    }

    static /* synthetic */ void drawInLineHighlighter$default(AIInEditorDiffRenderer aIInEditorDiffRenderer, Editor editor2, LineFragment lineFragment, List list, TextDiffType textDiffType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: drawInLineHighlighter");
        }
        if ((n & 8) != 0) {
            textDiffType = null;
        }
        aIInEditorDiffRenderer.drawInLineHighlighter(editor2, lineFragment, list, textDiffType);
    }

    protected void addGutterIcons(@NotNull LineFragment change) {
        DiffGutterOperation.Simple simple;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        DiffGutterOperation.Simple it = simple = new DiffGutterOperation.Simple(this.editor, change.getStartOffset2(), () -> AIInEditorDiffRenderer.addGutterIcons$lambda$7(change, this));
        boolean bl = false;
        this.gutterOperations.add((DiffGutterOperation)it);
        simple.update(true);
    }

    protected void renderInsertedCodeRange(@NotNull LineFragment change, boolean withGutter, boolean isModifiedCode) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (withGutter) {
            this.addGutterIcons(change);
        }
        List it = new DiffDrawUtil.LineHighlighterBuilder(this.editor, change.getStartLine2(), change.getEndLine2(), TextDiffType.INSERTED).withIgnored(change.getInnerFragments() != null && isModifiedCode).withGutterMode(new DiffDrawUtil.PaintMode(DiffDrawUtil.BackgroundType.NONE, DiffDrawUtil.BorderType.NONE)).withClearThinLineBetweenGutterAndEditor(true).done();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        this.highlighters.addAll(it);
    }

    protected final void renderDeletedCodeInlay(@NotNull LineFragment change, boolean withGutter) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        EditorTextField editorTextField = this.addDeletedCodeInlay(change, withGutter, false);
        if (ApplicationManager.getApplication().isUnitTestMode() || AppMode.isRemoteDevHost()) {
            return;
        }
        AIInEditorDiffRenderer.setupDeletedCodeInlay$default(this, editorTextField, change, false, 4, null);
    }

    private final EditorTextField addDeletedCodeInlay(LineFragment change, boolean withGutter, boolean isModifiedCode) {
        boolean useFullEndLine = this.checkChangeCompleteness(change) || !isModifiedCode;
        int finalOffset = useFullEndLine ? change.getEndLine1() : RangesKt.coerceAtMost((int)(change.getStartLine1() + change.getEndLine2() - change.getStartLine2()), (int)change.getEndLine1());
        String deletedText = ((Object)DiffUtil.getLinesContent((Document)this.getInitialDocument(), (int)change.getStartLine1(), (int)finalOffset)).toString();
        AIDeletedCodeEditorTextField editorTextField = this.getAIDeletedCodeEditorTextField(deletedText);
        int endLine = isModifiedCode ? change.getStartLine2() : change.getEndLine2();
        Pair pair = change.getEndLine2() != this.editor.getDocument().getLineCount() ? TuplesKt.to((Object)endLine, (Object)true) : (change.getEndLine2() != 0 ? TuplesKt.to((Object)(endLine - 1), (Object)false) : TuplesKt.to((Object)0, (Object)false));
        int inlayLine = ((Number)pair.component1()).intValue();
        boolean isAbove = (Boolean)pair.component2();
        Document document2 = this.editor.getDocument();
        Document document3 = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
        int n = document2.getLineStartOffset(RangesKt.coerceIn((int)inlayLine, (ClosedRange)((ClosedRange)this.getLineIndexes(document3))));
        InlayProperties inlayProperties = new InlayProperties().showAbove(isAbove);
        Intrinsics.checkNotNullExpressionValue((Object)inlayProperties, (String)"showAbove(...)");
        Inlay inlay = ComponentInlayKt.addComponentInlay((Editor)this.editor, (int)n, (InlayProperties)inlayProperties, (ComponentInlayRenderer)new AIDeletedCodeInlayRenderer(editorTextField, change, withGutter, this));
        if (inlay == null) {
            throw new IllegalStateException("Cannot create inlay");
        }
        this.inlays.add(inlay);
        DisposerUtilKt.whenDisposed((Disposable)((Disposable)inlay), () -> AIInEditorDiffRenderer.addDeletedCodeInlay$lambda$10(this, editorTextField));
        return editorTextField;
    }

    private final AIDeletedCodeEditorTextField getAIDeletedCodeEditorTextField(String deletedText) {
        AIDeletedCodeEditorTextField cachedTextField = (AIDeletedCodeEditorTextField)((Object)CollectionsKt.removeLastOrNull(this.textFieldCache));
        if (cachedTextField == null) {
            AIDeletedCodeEditorTextField result2 = AIDeletedCodeEditorTextField.Companion.create(this.editor, deletedText, this.project, this.fileType);
            result2.setDisposedWith(this);
            return result2;
        }
        UndoUtil.disableUndoIn((Document)cachedTextField.getDocument(), () -> AIInEditorDiffRenderer.getAIDeletedCodeEditorTextField$lambda$11(cachedTextField, deletedText));
        return cachedTextField;
    }

    private final IntRange getLineIndexes(Document $this$lineIndexes) {
        return new IntRange(0, Math.max(0, $this$lineIndexes.getLineCount() - 1));
    }

    protected void setupDeletedCodeInlay(@NotNull EditorTextField inlay, @NotNull LineFragment change, boolean modifiedCode) {
        Intrinsics.checkNotNullParameter((Object)inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Editor inlayEditor = inlay.getEditor();
        if (inlayEditor == null) {
            throw new IllegalStateException("Cannot create inlay editor");
        }
        String string = inlay.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int inlayLinesCount = StringsKt.lines((CharSequence)string).size();
        List it = new DiffDrawUtil.LineHighlighterBuilder(inlayEditor, 0, inlayLinesCount, TextDiffType.DELETED).withIgnored(change.getInnerFragments() != null && modifiedCode).done();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        this.highlighters.addAll(it);
    }

    public static /* synthetic */ void setupDeletedCodeInlay$default(AIInEditorDiffRenderer aIInEditorDiffRenderer, EditorTextField editorTextField, LineFragment lineFragment, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setupDeletedCodeInlay");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        aIInEditorDiffRenderer.setupDeletedCodeInlay(editorTextField, lineFragment, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkChangeCompleteness(LineFragment change) {
        boolean bl;
        block6: {
            void $this$filterTo$iv$iv;
            if (this.responseApplierChanges.isEmpty()) {
                return true;
            }
            Iterable $this$filter$iv = this.responseApplierChanges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AIResponseApplierChange it = (AIResponseApplierChange)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getRange().getStartOffset() <= change.getStartOffset2() && it.getRange().getEndOffset() >= change.getEndOffset2())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredRanges = (List)destination$iv$iv;
            if (filteredRanges.isEmpty()) {
                return true;
            }
            Iterable $this$any$iv = filteredRanges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AIResponseApplierChange p0 = (AIResponseApplierChange)element$iv;
                    boolean bl3 = false;
                    if (!p0.isComplete()) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final GutterIconRenderer addGutterIcons$lambda$7(LineFragment $change, AIInEditorDiffRenderer this$0) {
        return (GutterIconRenderer)new AIDiffGutterRenderer($change, this$0);
    }

    private static final Unit addDeletedCodeInlay$lambda$10(AIInEditorDiffRenderer this$0, AIDeletedCodeEditorTextField $editorTextField) {
        ((Collection)this$0.textFieldCache).add($editorTextField);
        return Unit.INSTANCE;
    }

    private static final void getAIDeletedCodeEditorTextField$lambda$11(AIDeletedCodeEditorTextField $cachedTextField, String $deletedText) {
        $cachedTextField.setText($deletedText);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffRenderer$AIInEditorDiffRendererFactory;", "Lcom/intellij/ml/llm/codeGeneration/inplace/AIDiffBasedCodeGenerationInteraction$RendererFactory;", "<init>", "()V", "create", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/CodeGenerationDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "initialText", "", "intellij.ml.llm.codeGeneration"})
    @StabilityInferred(parameters=1)
    public static final class AIInEditorDiffRendererFactory
    implements AIDiffBasedCodeGenerationInteraction.RendererFactory {
        @NotNull
        public static final AIInEditorDiffRendererFactory INSTANCE = new AIInEditorDiffRendererFactory();
        public static final int $stable;

        private AIInEditorDiffRendererFactory() {
        }

        @Override
        @NotNull
        public CodeGenerationDiffRenderer create(@NotNull Editor editor2, @NotNull Project project2, @Nullable FileType fileType2, @Nullable CharSequence initialText) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return Companion.create(editor2, project2, fileType2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffRenderer$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "initialContent", "", "intellij.ml.llm.codeGeneration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AIInEditorDiffRenderer create(@NotNull Editor editor2, @NotNull Project project2, @Nullable FileType fileType2, @Nullable CharSequence initialContent) {
            Document initialDocument;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            VirtualFile virtualFile2 = editor2.getVirtualFile();
            Intrinsics.checkNotNull((Object)virtualFile2);
            String string = "initial-" + virtualFile2.getName();
            CharSequence charSequence = initialContent;
            if (charSequence == null) {
                String string2 = editor2.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                charSequence = string2;
            }
            if ((initialDocument = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)new LightVirtualFile(string, fileType2, charSequence)))) == null) {
                throw new IllegalStateException("Cannot create in memory document for comparison");
            }
            initialDocument.setReadOnly(true);
            return new AIInEditorDiffRenderer(editor2, project2, fileType2, initialDocument);
        }

        public static /* synthetic */ AIInEditorDiffRenderer create$default(Companion companion, Editor editor2, Project project2, FileType fileType2, CharSequence charSequence, int n, Object object) {
            if ((n & 8) != 0) {
                charSequence = null;
            }
            return companion.create(editor2, project2, fileType2, charSequence);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

