/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.popup;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.lang.Language;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationFeatures;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationProgressListener;
import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationPopup;
import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationPopupActionKt;
import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationPopupInputTextField;
import com.intellij.ml.llm.codeGeneration.popup.HistoryController;
import com.intellij.ml.llm.codeGeneration.popup.StopAction;
import com.intellij.ml.llm.codeGeneration.popup.SubmitAction;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.chat.ui.AIAssistantChatUtil;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.TextAccessor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0014H\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u0004\u0018\u00010&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopupPromptWithEditorTextField;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "codeGenerationPopup", "Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopup;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopup;)V", "editorTextField", "Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopupInputTextField;", "getEditorTextField", "()Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopupInputTextField;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "submitAction", "Lcom/intellij/ml/llm/codeGeneration/popup/SubmitAction;", "getSubmitAction", "()Lcom/intellij/ml/llm/codeGeneration/popup/SubmitAction;", "updateSubmitActionShortcut", "", "enterAllowed", "", "setupDocument", "setupCustomKeyboardShortcuts", "editor", "Lcom/intellij/openapi/editor/Editor;", "setFieldText", "text", "", "getFieldText", "setupSubmitButton", "addNotify", "removeNotify", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getText", "Lcom/intellij/ml/llm/privacy/PSString;", "Companion", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAICodeGenerationPopupPromptWithEditorTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AICodeGenerationPopupPromptWithEditorTextField.kt\ncom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopupPromptWithEditorTextField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class AICodeGenerationPopupPromptWithEditorTextField
extends BorderLayoutPanel
implements UiDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AICodeGenerationPopup codeGenerationPopup;
    @NotNull
    private final AICodeGenerationPopupInputTextField editorTextField;
    @Nullable
    private MessageBusConnection messageBusConnection;
    @NotNull
    private final SubmitAction submitAction;
    public static final int $stable = 8;
    @NotNull
    private static final KeyboardShortcut PREVIOUS_HISTORY_SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
    @NotNull
    private static final KeyboardShortcut NEXT_HISTORY_SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);

    public AICodeGenerationPopupPromptWithEditorTextField(@NotNull Project project2, @NotNull AICodeGenerationPopup codeGenerationPopup) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)codeGenerationPopup), (String)"codeGenerationPopup");
        this.project = project2;
        this.codeGenerationPopup = codeGenerationPopup;
        this.editorTextField = new AICodeGenerationPopupInputTextField(this.project);
        this.submitAction = new SubmitAction();
        this.addToCenter((Component)((Object)this.editorTextField));
        if (!AICodeGenerationFeatures.INSTANCE.isCodeGenerationBlock()) {
            this.setupSubmitButton();
        }
        this.editorTextField.addEditorAddedListener(arg_0 -> AICodeGenerationPopupPromptWithEditorTextField._init_$lambda$0(this, arg_0));
        this.setupDocument();
        this.setOpaque(false);
    }

    @NotNull
    public final AICodeGenerationPopupInputTextField getEditorTextField() {
        return this.editorTextField;
    }

    @NotNull
    public final SubmitAction getSubmitAction() {
        return this.submitAction;
    }

    public final void updateSubmitActionShortcut(boolean enterAllowed) {
        Object object = this.editorTextField.getEditor();
        if (object == null || (object = object.getContentComponent()) == null) {
            return;
        }
        Object content2 = object;
        this.submitAction.unregisterCustomShortcutSet((JComponent)content2);
        if (enterAllowed) {
            Shortcut[] shortcutArray = new Shortcut[]{AICodeGenerationPopup.Companion.getENTER_SHORTCUT$intellij_ml_llm_codeGeneration()};
            this.submitAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)content2);
        } else {
            this.submitAction.setShortcutSet((ShortcutSet)CustomShortcutSet.EMPTY);
        }
    }

    private final void setupDocument() {
        boolean chatInputLanguageEnabled = Registry.Companion.is("llm.chat.input.language.in.inlay");
        String fileExtension = chatInputLanguageEnabled ? "chatInput" : "txt";
        String fileName = "AIAssistantInput-" + UUID.randomUUID() + "." + fileExtension;
        String languageName = chatInputLanguageEnabled ? "ChatInput" : "TEXT";
        Language language = AIAssistantChatUtil.INSTANCE.findLanguage(languageName);
        ActionsKt.runReadAction(() -> AICodeGenerationPopupPromptWithEditorTextField.setupDocument$lambda$2(this, fileName, language));
    }

    private final void setupCustomKeyboardShortcuts(Editor editor2) {
        Shortcut[] shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(10, 64), null)};
        DumbAwareAction.create(arg_0 -> AICodeGenerationPopupPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$6(arg_0 -> AICodeGenerationPopupPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$5(this, editor2, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), editor2.getContentComponent());
        HistoryController historyController2 = HistoryController.Companion.createCodeGenerationHistory((Function0<String>)((Function0)new Function0<String>((Object)this){

            public final String invoke() {
                return AICodeGenerationPopupPromptWithEditorTextField.access$getFieldText((AICodeGenerationPopupPromptWithEditorTextField)((Object)this.receiver));
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AICodeGenerationPopupPromptWithEditorTextField.access$setFieldText((AICodeGenerationPopupPromptWithEditorTextField)((Object)this.receiver), p0);
            }
        }));
        Shortcut[] shortcutArray2 = new Shortcut[]{PREVIOUS_HISTORY_SHORTCUT};
        DumbAwareAction.create(arg_0 -> AICodeGenerationPopupPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$8(arg_0 -> AICodeGenerationPopupPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$7(historyController2, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray2), editor2.getContentComponent());
        shortcutArray2 = new Shortcut[]{NEXT_HISTORY_SHORTCUT};
        DumbAwareAction.create(arg_0 -> AICodeGenerationPopupPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$10(arg_0 -> AICodeGenerationPopupPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$9(historyController2, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray2), editor2.getContentComponent());
    }

    private final void setFieldText(String text2) {
        this.editorTextField.setText(text2);
        Editor editor2 = this.editorTextField.getEditor();
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        editor3.getCaretModel().moveToOffset(editor3.getDocument().getTextLength() + 100);
        editor3.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        editor3.getSelectionModel().removeSelection();
    }

    private final String getFieldText() {
        String string = this.editorTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupSubmitButton() {
        void $this$setupSubmitButton_u24lambda_u2413;
        AnAction[] anActionArray = new AnAction[]{this.submitAction, new StopAction(this.editorTextField)};
        DefaultActionGroup group = new DefaultActionGroup(anActionArray);
        Object object = new ActionToolbarImpl("AICodeGeneration.InEditorGenerationPopup", (ActionGroup)group, true, false, false, 24, null);
        ActionToolbarImpl $this$setupSubmitButton_u24lambda_u2411 = object;
        boolean bl = false;
        $this$setupSubmitButton_u24lambda_u2411.setTargetComponent((JComponent)$this$setupSubmitButton_u24lambda_u2411);
        Object $this$setupSubmitButton_u24lambda_u2412 = object = object.getComponent();
        boolean bl2 = false;
        ((JComponent)$this$setupSubmitButton_u24lambda_u2412).setBorder((Border)JBUI.Borders.empty());
        ((JComponent)$this$setupSubmitButton_u24lambda_u2412).setOpaque(false);
        Object component2 = object;
        $this$setupSubmitButton_u24lambda_u2412 = object = new BorderLayoutPanel();
        AICodeGenerationPopupPromptWithEditorTextField aICodeGenerationPopupPromptWithEditorTextField = this;
        boolean bl3 = false;
        $this$setupSubmitButton_u24lambda_u2413.setOpaque(false);
        $this$setupSubmitButton_u24lambda_u2413.addToBottom((Component)component2);
        aICodeGenerationPopupPromptWithEditorTextField.addToRight((Component)object);
    }

    public void addNotify() {
        block0: {
            super.addNotify();
            this.messageBusConnection = this.project.getMessageBus().connect();
            AnActionListener enterToSubmitActionListener2 = new AnActionListener(this){
                final /* synthetic */ AICodeGenerationPopupPromptWithEditorTextField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void afterActionPerformed(AnAction action2, AnActionEvent event, AnActionResult result2) {
                    Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    if (event.getDataContext().getData(CommonDataKeys.EDITOR) != this.this$0.getEditorTextField().getEditor()) {
                        return;
                    }
                    if (!(action2 instanceof EnterAction)) {
                        return;
                    }
                    String string = this.this$0.getEditorTextField().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (((CharSequence)string).length() > 0) {
                        Editor editor2 = AICodeGenerationPopupActionKt.getEditor(event);
                        if (editor2 == null) {
                            return;
                        }
                        Editor editor3 = editor2;
                        AICodeGenerationProgressListener.Companion.submit$default(AICodeGenerationProgressListener.Companion, editor3, ChatSourceAction.GENERATE_CODE_INPLACE, false, 4, null);
                    }
                }
            };
            MessageBusConnection messageBusConnection = this.messageBusConnection;
            if (messageBusConnection == null) break block0;
            Topic topic = AnActionListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)enterToSubmitActionListener2);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        MessageBusConnection messageBusConnection = this.messageBusConnection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.messageBusConnection = null;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
        sink.set(dataKey, (Object)this.editorTextField.getEditor());
    }

    @Nullable
    public final PSString getText() {
        return SharedExtensionsKtKt.getPrivacySafe((TextAccessor)((TextAccessor)this.editorTextField)).getText();
    }

    private static final void _init_$lambda$0(AICodeGenerationPopupPromptWithEditorTextField this$0, Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this$0.setupCustomKeyboardShortcuts(editor2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit setupDocument$lambda$2(AICodeGenerationPopupPromptWithEditorTextField this$0, String $fileName, Language $language) {
        void $this$setupDocument_u24lambda_u242_u24lambda_u241;
        LightVirtualFile lightVirtualFile;
        LightVirtualFile lightVirtualFile2 = lightVirtualFile = new LightVirtualFile($fileName, $language, (CharSequence)"");
        AICodeGenerationPopupInputTextField aICodeGenerationPopupInputTextField = this$0.editorTextField;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)$this$setupDocument_u24lambda_u242_u24lambda_u241.getFileType(), (Object)UnknownFileType.INSTANCE)) {
            $this$setupDocument_u24lambda_u242_u24lambda_u241.setFileType((FileType)PlainTextFileType.INSTANCE);
        }
        Document document2 = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)lightVirtualFile));
        if (document2 == null) {
            throw new IllegalStateException("Can't create inmemory document".toString());
        }
        aICodeGenerationPopupInputTextField.setDocument(document2);
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$5$lambda$4$lambda$3(Editor $editor) {
        String eol = "\n";
        int caretOffset = $editor.getCaretModel().getOffset();
        $editor.getDocument().insertString(caretOffset, (CharSequence)eol);
        $editor.getCaretModel().moveToOffset(caretOffset + eol.length());
        EditorModificationUtil.scrollToCaret((Editor)$editor);
    }

    private static final void setupCustomKeyboardShortcuts$lambda$5$lambda$4(Editor $editor) {
        ApplicationManager.getApplication().runWriteAction(() -> AICodeGenerationPopupPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$5$lambda$4$lambda$3($editor));
    }

    private static final Unit setupCustomKeyboardShortcuts$lambda$5(AICodeGenerationPopupPromptWithEditorTextField this$0, Editor $editor, AnActionEvent it) {
        CommandProcessor.getInstance().executeCommand(this$0.project, () -> AICodeGenerationPopupPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$5$lambda$4($editor), null, null);
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupCustomKeyboardShortcuts$lambda$7(HistoryController $historyController, AnActionEvent it) {
        $historyController.selectPreviousHistoryItem();
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupCustomKeyboardShortcuts$lambda$9(HistoryController $historyController, AnActionEvent it) {
        $historyController.selectNextHistoryItem();
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getFieldText(AICodeGenerationPopupPromptWithEditorTextField $this) {
        return $this.getFieldText();
    }

    public static final /* synthetic */ void access$setFieldText(AICodeGenerationPopupPromptWithEditorTextField $this, String text2) {
        $this.setFieldText(text2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopupPromptWithEditorTextField$Companion;", "", "<init>", "()V", "PREVIOUS_HISTORY_SHORTCUT", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "getPREVIOUS_HISTORY_SHORTCUT", "()Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "NEXT_HISTORY_SHORTCUT", "getNEXT_HISTORY_SHORTCUT", "intellij.ml.llm.codeGeneration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeyboardShortcut getPREVIOUS_HISTORY_SHORTCUT() {
            return PREVIOUS_HISTORY_SHORTCUT;
        }

        @NotNull
        public final KeyboardShortcut getNEXT_HISTORY_SHORTCUT() {
            return NEXT_HISTORY_SHORTCUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

