/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.popup.changeNavigation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationUtils;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIDeletedCodeEditorTextField;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIDeletedCodeInlayRenderer;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.HihghlightType;
import com.intellij.ml.llm.codeGeneration.popup.changeNavigation.ChangeNavigation;
import com.intellij.ml.llm.codeGeneration.popup.changeNavigation.ChangesDocumentListener;
import com.intellij.ml.llm.codeGeneration.popup.changeNavigation.HighlightingChangeNavigation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n*\u0002 #\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020&H\u0016J\b\u0010*\u001a\u00020(H\u0016J\b\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020(H\u0014J\u0010\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020(H\u0002J\u0010\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u0007H\u0014J*\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\b\b\u0002\u0010.\u001a\u00020/H\u0004J\b\u00106\u001a\u00020(H\u0002J\u0010\u00107\u001a\u00020(2\u0006\u0010-\u001a\u00020&H\u0002J\b\u00108\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u0010\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$\u00a8\u00069"}, d2={"Lcom/intellij/ml/llm/codeGeneration/popup/changeNavigation/HighlightingChangeNavigation;", "Lcom/intellij/ml/llm/codeGeneration/popup/changeNavigation/ChangeNavigation;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "value", "", "currentFragmentIndex", "getCurrentFragmentIndex", "()I", "setCurrentFragmentIndex$intellij_ml_llm_codeGeneration", "(I)V", "currentFragment", "Lcom/intellij/diff/fragments/LineFragment;", "getCurrentFragment$intellij_ml_llm_codeGeneration", "()Lcom/intellij/diff/fragments/LineFragment;", "setCurrentFragment$intellij_ml_llm_codeGeneration", "(Lcom/intellij/diff/fragments/LineFragment;)V", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getHighlighter$intellij_ml_llm_codeGeneration", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "setHighlighter$intellij_ml_llm_codeGeneration", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "aiDeletedCodeInlayRenderer", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIDeletedCodeInlayRenderer;", "getAiDeletedCodeInlayRenderer$intellij_ml_llm_codeGeneration", "()Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIDeletedCodeInlayRenderer;", "setAiDeletedCodeInlayRenderer$intellij_ml_llm_codeGeneration", "(Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIDeletedCodeInlayRenderer;)V", "aiDeletedCodeInlayFocusListener", "com/intellij/ml/llm/codeGeneration/popup/changeNavigation/HighlightingChangeNavigation$aiDeletedCodeInlayFocusListener$1", "Lcom/intellij/ml/llm/codeGeneration/popup/changeNavigation/HighlightingChangeNavigation$aiDeletedCodeInlayFocusListener$1;", "caretListener", "com/intellij/ml/llm/codeGeneration/popup/changeNavigation/HighlightingChangeNavigation$caretListener$1", "Lcom/intellij/ml/llm/codeGeneration/popup/changeNavigation/HighlightingChangeNavigation$caretListener$1;", "canGoNext", "", "goNext", "", "canGoPrev", "goPrev", "dispose", "highlightCurrentFragment", "updateCursor", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "clearHighlighting", "updateCurrentFragmentByUser", "delta", "setCurrentFragmentIndex", "index", "updateFocus", "clearCurrentFragment", "onChangesModified", "installAiDeletedCodeInlayFocusListener", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHighlightingChangeNavigation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightingChangeNavigation.kt\ncom/intellij/ml/llm/codeGeneration/popup/changeNavigation/HighlightingChangeNavigation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n360#2,7:288\n*S KotlinDebug\n*F\n+ 1 HighlightingChangeNavigation.kt\ncom/intellij/ml/llm/codeGeneration/popup/changeNavigation/HighlightingChangeNavigation\n*L\n180#1:288,7\n*E\n"})
public class HighlightingChangeNavigation
implements ChangeNavigation {
    @NotNull
    private final EditorEx editor;
    private int currentFragmentIndex;
    @Nullable
    private LineFragment currentFragment;
    @Nullable
    private RangeHighlighter highlighter;
    @Nullable
    private AIDeletedCodeInlayRenderer aiDeletedCodeInlayRenderer;
    @NotNull
    private final aiDeletedCodeInlayFocusListener.1 aiDeletedCodeInlayFocusListener;
    @NotNull
    private final caretListener.1 caretListener;
    public static final int $stable = 8;

    public HighlightingChangeNavigation(@NotNull EditorEx editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.currentFragmentIndex = -1;
        this.aiDeletedCodeInlayFocusListener = new FocusAdapter(this){
            final /* synthetic */ HighlightingChangeNavigation this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(FocusEvent e) {
                AIDeletedCodeInlayRenderer aIDeletedCodeInlayRenderer = ChangeNavigation.Companion.getFocusedAIDeletedCodeInlayRenderer((Editor)HighlightingChangeNavigation.access$getEditor$p(this.this$0));
                if (aIDeletedCodeInlayRenderer == null) {
                    return;
                }
                AIDeletedCodeInlayRenderer aiDeletedCodeInlayRenderer = aIDeletedCodeInlayRenderer;
                int index = ChangeNavigation.Companion.getChanges((Editor)HighlightingChangeNavigation.access$getEditor$p(this.this$0)).indexOf(aiDeletedCodeInlayRenderer.getChange());
                if (index >= 0) {
                    this.this$0.setCurrentFragmentIndex(index, false, true, ScrollType.RELATIVE);
                }
            }
        };
        this.caretListener = new CaretListener(this){
            final /* synthetic */ HighlightingChangeNavigation this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor2 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                Editor editor3 = editor2;
                int caretLine = event.getNewPosition().line;
                List<LineFragment> changes2 = ChangeNavigation.Companion.getChanges(editor3);
                Iterator<T> iterator = ((Iterable)changes2).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int index = n++;
                    LineFragment change = (LineFragment)iterator.next();
                    if (change.getStartLine2() > caretLine || caretLine >= change.getEndLine2()) continue;
                    HighlightingChangeNavigation.setCurrentFragmentIndex$default(this.this$0, index, false, false, null, 8, null);
                    return;
                }
            }
        };
        this.onChangesModified(true);
        this.installAiDeletedCodeInlayFocusListener();
        this.editor.getCaretModel().addCaretListener((CaretListener)this.caretListener);
        new ChangesDocumentListener(this.editor, this, () -> HighlightingChangeNavigation._init_$lambda$0(this));
    }

    @Override
    public int getCurrentFragmentIndex() {
        return this.currentFragmentIndex;
    }

    public void setCurrentFragmentIndex$intellij_ml_llm_codeGeneration(int n) {
        this.currentFragmentIndex = n;
    }

    @Nullable
    public final LineFragment getCurrentFragment$intellij_ml_llm_codeGeneration() {
        return this.currentFragment;
    }

    public final void setCurrentFragment$intellij_ml_llm_codeGeneration(@Nullable LineFragment lineFragment) {
        this.currentFragment = lineFragment;
    }

    @Nullable
    public final RangeHighlighter getHighlighter$intellij_ml_llm_codeGeneration() {
        return this.highlighter;
    }

    public final void setHighlighter$intellij_ml_llm_codeGeneration(@Nullable RangeHighlighter rangeHighlighter) {
        this.highlighter = rangeHighlighter;
    }

    @Nullable
    public final AIDeletedCodeInlayRenderer getAiDeletedCodeInlayRenderer$intellij_ml_llm_codeGeneration() {
        return this.aiDeletedCodeInlayRenderer;
    }

    public final void setAiDeletedCodeInlayRenderer$intellij_ml_llm_codeGeneration(@Nullable AIDeletedCodeInlayRenderer aIDeletedCodeInlayRenderer) {
        this.aiDeletedCodeInlayRenderer = aIDeletedCodeInlayRenderer;
    }

    @Override
    public boolean canGoNext() {
        return !((Collection)ChangeNavigation.Companion.getChanges((Editor)this.editor)).isEmpty();
    }

    @Override
    public void goNext() {
        this.updateCurrentFragmentByUser(1);
    }

    @Override
    public boolean canGoPrev() {
        return !((Collection)ChangeNavigation.Companion.getChanges((Editor)this.editor)).isEmpty();
    }

    @Override
    public void goPrev() {
        this.updateCurrentFragmentByUser(-1);
    }

    public void dispose() {
        this.clearHighlighting();
        for (AIDeletedCodeInlayRenderer renderer2 : ChangeNavigation.Companion.getAllAIDeletedCodeInlayRenderers((Editor)this.editor)) {
            ((AIDeletedCodeEditorTextField)((Object)renderer2.getComponent())).removeFocusListener(this.aiDeletedCodeInlayFocusListener);
        }
        this.editor.getCaretModel().removeCaretListener((CaretListener)this.caretListener);
    }

    protected void highlightCurrentFragment() {
        this.clearHighlighting();
        LineFragment lineFragment = this.currentFragment;
        if (lineFragment == null) {
            return;
        }
        LineFragment fragment = lineFragment;
        boolean isDeletion = ChangeNavigation.Companion.isDeletion(fragment);
        if (isDeletion) {
            Inlay<AIDeletedCodeInlayRenderer> inlay = ChangeNavigation.Companion.getAIDeletedCodeInlay((Editor)this.editor, fragment);
            this.aiDeletedCodeInlayRenderer = inlay != null ? (AIDeletedCodeInlayRenderer)inlay.getRenderer() : null;
            Object object = this.aiDeletedCodeInlayRenderer;
            if (object != null && (object = (AIDeletedCodeEditorTextField)((Object)object.getComponent())) != null) {
                ((AIDeletedCodeEditorTextField)((Object)object)).setHighlightAsSelected(HihghlightType.FULL);
            }
        } else {
            Inlay<AIDeletedCodeInlayRenderer> inlay = ChangeNavigation.Companion.getAIDeletedCodeInlay((Editor)this.editor, fragment);
            this.aiDeletedCodeInlayRenderer = inlay != null ? (AIDeletedCodeInlayRenderer)inlay.getRenderer() : null;
            Object object = this.aiDeletedCodeInlayRenderer;
            if (object != null && (object = (AIDeletedCodeEditorTextField)((Object)object.getComponent())) != null) {
                ((AIDeletedCodeEditorTextField)((Object)object)).setHighlightAsSelected(HihghlightType.TOP);
            }
            int endOffset = fragment.getEndLine2() == this.editor.getDocument().getLineCount() ? this.editor.getDocument().getTextLength() : this.editor.logicalPositionToOffset(new LogicalPosition(fragment.getEndLine2(), 0)) - 1;
            RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(null, fragment.getStartOffset2(), endOffset, 6001, HighlighterTargetArea.LINES_IN_RANGE);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
            RangeHighlighter newHighlighter = rangeHighlighter;
            newHighlighter.setCustomRenderer(new CustomHighlighterRenderer(this){
                final /* synthetic */ HighlightingChangeNavigation this$0;
                {
                    this.this$0 = $receiver;
                }

                public void paint(Editor editor2, RangeHighlighter highlighter, Graphics g) {
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Color color = AICodeGenerationUtils.INSTANCE.getCurrentChangeHighlightColor(editor2);
                    if (color == null) {
                        return;
                    }
                    Color color2 = color;
                    int topY = editor2.offsetToXY((int)highlighter.getStartOffset()).y;
                    int bottomY = editor2.offsetToXY((int)highlighter.getEndOffset()).y + editor2.getLineHeight() - 1;
                    int width = editor2.getContentComponent().getWidth();
                    g.setColor(color2);
                    if (this.this$0.getAiDeletedCodeInlayRenderer$intellij_ml_llm_codeGeneration() == null) {
                        g.drawLine(0, topY, width, topY);
                    }
                    g.drawLine(0, bottomY, width, bottomY);
                }
            });
            this.highlighter = newHighlighter;
        }
    }

    private final void updateCursor(ScrollType scrollType) {
        LineFragment lineFragment = this.currentFragment;
        if (lineFragment == null) {
            return;
        }
        LineFragment fragment = lineFragment;
        boolean isDeletion = ChangeNavigation.Companion.isDeletion(fragment);
        int offset = fragment.getStartOffset2();
        if (offset >= 0 && offset < this.editor.getDocument().getTextLength()) {
            if (isDeletion && offset > 0) {
                --offset;
            }
            this.editor.getCaretModel().removeSecondaryCarets();
            this.editor.getCaretModel().moveToOffset(offset);
            this.editor.getSelectionModel().removeSelection();
            this.editor.getScrollingModel().scrollToCaret(scrollType);
        }
    }

    private final void clearHighlighting() {
        Object object = this.aiDeletedCodeInlayRenderer;
        if (object != null && (object = (AIDeletedCodeEditorTextField)((Object)object.getComponent())) != null) {
            ((AIDeletedCodeEditorTextField)((Object)object)).setHighlightAsSelected(HihghlightType.NONE);
        }
        this.aiDeletedCodeInlayRenderer = null;
        RangeHighlighter rangeHighlighter = this.highlighter;
        if (rangeHighlighter != null) {
            rangeHighlighter.dispose();
        }
        this.highlighter = null;
    }

    protected void updateCurrentFragmentByUser(int delta) {
        AIDeletedCodeInlayRenderer focusedAIDeletedCodeInlayRenderer = ChangeNavigation.Companion.getFocusedAIDeletedCodeInlayRenderer((Editor)this.editor);
        if (focusedAIDeletedCodeInlayRenderer != null) {
            HighlightingChangeNavigation.setCurrentFragmentIndex$default(this, this.getCurrentFragmentIndex() + delta, true, true, null, 8, null);
            return;
        }
        int indexByCursor = ChangeNavigation.Companion.getNearestToCurrentLineChangeIndex((Editor)this.editor);
        if (indexByCursor < 0) {
            HighlightingChangeNavigation.setCurrentFragmentIndex$default(this, 0, true, true, null, 8, null);
            return;
        }
        int currentLine = this.editor.getCaretModel().getLogicalPosition().line;
        List<LineFragment> changes2 = ChangeNavigation.Companion.getChanges((Editor)this.editor);
        if (!ChangeNavigation.Companion.isEditorOrDeletedCodeInlayFocused((Editor)this.editor) && delta > 0) {
            int deletionAfterCursor;
            block6: {
                int n;
                List<LineFragment> $this$indexOfFirst$iv = changes2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<LineFragment> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    LineFragment item$iv;
                    LineFragment it = item$iv = iterator.next();
                    boolean bl = false;
                    if (ChangeNavigation.Companion.isDeletion(it) && it.getStartLine2() == currentLine + 1) {
                        n = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n = deletionAfterCursor = -1;
            }
            if (deletionAfterCursor >= 0 && deletionAfterCursor + 1 < changes2.size()) {
                indexByCursor = deletionAfterCursor + 1;
            }
        }
        int newLineByCursor = changes2.get(indexByCursor).getStartLine2();
        int newIndex = newLineByCursor > currentLine && delta > 0 || newLineByCursor < currentLine && delta < 0 ? indexByCursor : indexByCursor + delta;
        HighlightingChangeNavigation.setCurrentFragmentIndex$default(this, newIndex, true, true, null, 8, null);
    }

    protected final void setCurrentFragmentIndex(int index, boolean updateFocus, boolean updateCursor, @NotNull ScrollType scrollType) {
        LineFragment newCurrentFragment;
        Intrinsics.checkNotNullParameter((Object)scrollType, (String)"scrollType");
        List<LineFragment> changes2 = ChangeNavigation.Companion.getChanges((Editor)this.editor);
        if (changes2.isEmpty()) {
            this.clearCurrentFragment();
            return;
        }
        this.setCurrentFragmentIndex$intellij_ml_llm_codeGeneration(RangesKt.coerceIn((int)index, (int)0, (int)(((Collection)changes2).size() - 1)));
        this.currentFragment = newCurrentFragment = changes2.get(this.getCurrentFragmentIndex());
        this.highlightCurrentFragment();
        if (updateCursor) {
            this.updateCursor(scrollType);
        }
        if (updateFocus) {
            ChangeNavigation.Companion.updateChangeFocus((Editor)this.editor, newCurrentFragment);
        }
    }

    public static /* synthetic */ void setCurrentFragmentIndex$default(HighlightingChangeNavigation highlightingChangeNavigation, int n, boolean bl, boolean bl2, ScrollType scrollType, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setCurrentFragmentIndex");
        }
        if ((n2 & 8) != 0) {
            scrollType = ScrollType.CENTER;
        }
        highlightingChangeNavigation.setCurrentFragmentIndex(n, bl, bl2, scrollType);
    }

    private final void clearCurrentFragment() {
        this.setCurrentFragmentIndex$intellij_ml_llm_codeGeneration(-1);
        this.currentFragment = null;
        this.clearHighlighting();
    }

    private final void onChangesModified(boolean updateCursor) {
        List<LineFragment> changes2 = ChangeNavigation.Companion.getChanges((Editor)this.editor);
        if (changes2.isEmpty()) {
            this.clearCurrentFragment();
            return;
        }
        this.installAiDeletedCodeInlayFocusListener();
        int newIndex = CollectionsKt.indexOf(changes2, (Object)this.currentFragment);
        if (newIndex < 0) {
            newIndex = ChangeNavigation.Companion.getNearestToCurrentLineChangeIndex((Editor)this.editor);
        }
        HighlightingChangeNavigation.setCurrentFragmentIndex$default(this, newIndex, false, updateCursor, null, 8, null);
    }

    private final void installAiDeletedCodeInlayFocusListener() {
        for (AIDeletedCodeInlayRenderer renderer2 : ChangeNavigation.Companion.getAllAIDeletedCodeInlayRenderers((Editor)this.editor)) {
            AIDeletedCodeEditorTextField component2 = (AIDeletedCodeEditorTextField)((Object)renderer2.getComponent());
            component2.removeFocusListener(this.aiDeletedCodeInlayFocusListener);
            component2.addFocusListener(this.aiDeletedCodeInlayFocusListener);
        }
    }

    private static final void _init_$lambda$0(HighlightingChangeNavigation this$0) {
        this$0.onChangesModified(false);
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(HighlightingChangeNavigation $this) {
        return $this.editor;
    }
}

