/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context;

import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.context.ContextPostProcessor;
import com.intellij.ml.llm.context.ContextPostProcessorFactory;
import com.intellij.ml.llm.context.ContextRetrievalFilter;
import com.intellij.ml.llm.context.ContextRetrievalRequest;
import com.intellij.ml.llm.context.ContextRetrievalRequestExecution;
import com.intellij.ml.llm.context.ContextRetrievalService;
import com.intellij.ml.llm.context.ContextRetrievalServiceKt;
import com.intellij.ml.llm.context.ContextRetrievalStatistics;
import com.intellij.ml.llm.context.ContextRetrievalStatisticsPrintingPolicy;
import com.intellij.ml.llm.context.ContextRetriever;
import com.intellij.ml.llm.context.ContextRetrieverFactory;
import com.intellij.ml.llm.context.ContextTransformer;
import com.intellij.ml.llm.context.ContextTransformerFactory;
import com.intellij.ml.llm.context.ExecStatsElement;
import com.intellij.ml.llm.context.MandatoryRegistrar;
import com.intellij.ml.llm.context.RetrievalSession;
import com.intellij.ml.llm.context.RetrievalSessionRegistrar;
import com.intellij.ml.llm.context.impl.CombinedContextLoader;
import com.intellij.ml.llm.context.impl.ContextLoaderOptions;
import com.intellij.ml.llm.context.interactive.InteractiveRetrievalSession;
import com.intellij.ml.llm.context.markers.SpamUpdatesCapability;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u008c\u00012\u00020\u0001:\u0004\u008c\u0001\u008d\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010\r\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bJ\u0014\u0010\u000f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010!\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J \u0010%\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(2\u0006\u0010)\u001a\u00020*H\u0086@\u00a2\u0006\u0002\u0010+J \u0010,\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(2\u0006\u0010)\u001a\u00020*H\u0087@\u00a2\u0006\u0002\u0010+J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020'0.2\u0006\u0010)\u001a\u00020*J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020'0.2\u0006\u0010)\u001a\u00020*H\u0007J2\u00100\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(2\u0006\u0010)\u001a\u00020*2\u0010\u00101\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(H\u0086@\u00a2\u0006\u0002\u00102J2\u00103\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(2\u0006\u0010)\u001a\u00020*2\u0010\u00101\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(H\u0087@\u00a2\u0006\u0002\u00102J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u0012052\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u00106\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020'0&j\u0002`(052\u0006\u0010\u0013\u001a\u00020\u0014J\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bJ\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020#0\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010;\u001a\u00020<2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010=\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J,\u0010>\u001a(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020*0@\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020C0B0A0?J\u001a\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020E0?2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010F\u001a\u00020\u00162\b\b\u0002\u0010G\u001a\u00020HJ\u0010\u0010Z\u001a\u00020\t2\u0006\u0010[\u001a\u00020\u0012H\u0007J\u0017\u0010\\\u001a\u00020\t2\u0006\u0010]\u001a\u00020^H\u0007\u00a2\u0006\u0004\b_\u0010`J\u001f\u0010a\u001a\u00020\t2\u0006\u0010b\u001a\u00020E2\u0006\u0010c\u001a\u00020^H\u0007\u00a2\u0006\u0004\bd\u0010eJ\"\u0010f\u001a\u00020\t2\u0018\u0010g\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\t0hH\u0007J\b\u0010i\u001a\u00020\tH\u0007J\b\u0010j\u001a\u00020\tH\u0007J\b\u0010k\u001a\u00020\tH\u0007J\r\u0010l\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bmJ\u0010\u0010n\u001a\u00020Q2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010o\u001a\u00020p2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010q\u001a\u00020Q2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010r\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(2\u0006\u0010)\u001a\u00020*2\u0006\u0010s\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010tJ\u001e\u0010u\u001a\b\u0012\u0004\u0012\u00020'0.2\u0006\u0010)\u001a\u00020*2\u0006\u0010s\u001a\u00020\u0012H\u0002J:\u0010v\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(2\u0006\u0010)\u001a\u00020*2\u0010\u0010w\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(2\u0006\u0010s\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010xJ\u00b3\u0001\u0010y\u001a\u0002Hz\"\u0004\b\u0000\u0010z2\u0006\u0010)\u001a\u00020*2\u0006\u0010s\u001a\u00020\u00122\u0006\u0010{\u001a\u00020|2\u0083\u0001\b\u0004\u0010}\u001a}\b\u0001\u0012\u0016\u0012\u00140\u007f\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0082\u0001\u0012\u0016\u0012\u00140p\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0083\u0001\u0012\u0017\u0012\u00150\u0084\u0001\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0085\u0001\u0012\u0019\u0012\u0017\u0018\u00010\u0084\u0001\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0086\u0001\u0012\u000b\u0012\t\u0012\u0004\u0012\u0002Hz0\u0087\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010~H\u0082H\u00a2\u0006\u0003\u0010\u0088\u0001JK\u0010\u0089\u0001\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(2\u0006\u0010)\u001a\u00020*2\u0006\u0010s\u001a\u00020\u00122\b\u0010\u0085\u0001\u001a\u00030\u0084\u00012\n\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0084\u00012\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020'0&j\u0002`(H\u0002J(\u0010\u008a\u0001\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\n\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0084\u00012\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010CH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020JX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020\f0LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020\u000e0LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00100LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020Q0PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010R\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020EX\u0082D\u00a2\u0006\u0002\n\u0000R\u00b7\u0001\u0010V\u001a\u00aa\u0001\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020* X*\f\u0012\u0006\b\u0001\u0012\u00020*\u0018\u00010@0@\u00120\u0012.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020C0B X*\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020C0B\u0018\u00010Y0Y X*T\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020* X*\f\u0012\u0006\b\u0001\u0012\u00020*\u0018\u00010@0@\u00120\u0012.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020C0B X*\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020C0B\u0018\u00010Y0Y\u0018\u00010?0WX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008e\u0001"}, d2={"Lcom/intellij/ml/llm/context/ContextRetrievalService;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "registerRetrieversFactories", "", "items", "", "Lcom/intellij/ml/llm/context/ContextRetrieverFactory;", "registerTransformersFactories", "Lcom/intellij/ml/llm/context/ContextTransformerFactory;", "registerPostProcessorsFactories", "Lcom/intellij/ml/llm/context/ContextPostProcessorFactory;", "isRetrieverRegistered", "", "session", "Lcom/intellij/ml/llm/context/RetrievalSession;", "id", "", "registerRetriever", "retriever", "Lcom/intellij/ml/llm/context/ContextRetriever;", "unregisterRetriever", "isTransformerRegistered", "registerTransformer", "transformer", "Lcom/intellij/ml/llm/context/ContextTransformer;", "unregisterTransformer", "isRankerRegistered", "registerRanker", "ranker", "Lcom/intellij/ml/llm/context/ContextPostProcessor;", "unregisterRanker", "computeContext", "", "Lcom/intellij/ml/llm/context/ContextEntity;", "Lcom/intellij/ml/llm/context/ContextEntities;", "request", "Lcom/intellij/ml/llm/context/ContextRetrievalRequest;", "(Lcom/intellij/ml/llm/context/ContextRetrievalRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tracingComputeContext", "gatherContextFlow", "Lkotlinx/coroutines/flow/Flow;", "tracingGatherContextFlow", "postProcessGatheredContext", "context", "(Lcom/intellij/ml/llm/context/ContextRetrievalRequest;Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tracingPostProcessGatheredContext", "isLoading", "Lkotlinx/coroutines/flow/StateFlow;", "getContext", "getSessions", "getRetrievers", "getTransformers", "getPostProcessors", "getContextRetrievalFilter", "Lcom/intellij/ml/llm/context/ContextRetrievalFilter;", "retriggerPostProcessingOnInteractiveFlow", "getLatestRequests", "", "Ljava/lang/Class;", "", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/context/ContextRetrievalRequestExecution;", "getSpammingInteractiveRetrievers", "", "printTimings", "policy", "Lcom/intellij/ml/llm/context/ContextRetrievalStatisticsPrintingPolicy;", "contextLoaderOpts", "Lcom/intellij/ml/llm/context/impl/ContextLoaderOptions;", "retrieversFactories", "Ljava/util/concurrent/CopyOnWriteArraySet;", "transformersFactories", "postProcessorsFactories", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/context/ContextRetrievalService$SessionStorage;", "serviceDebugMode", "getServiceDebugMode", "()Z", "DEBUG_NUM_LAST_REQUESTS_TO_STORE", "latestRequests", "", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CopyOnWriteArrayList;", "setComputeContextAsync", "value", "setInteractiveContextThrottleDelay", "delay", "Lkotlin/time/Duration;", "setInteractiveContextThrottleDelay-LRDsOJo", "(J)V", "setInteractiveRetrieverSpamCriteria", "spamSequenceSize", "spamEmitDelay", "setInteractiveRetrieverSpamCriteria-HG0u8IE", "(IJ)V", "setOnSpammingInteractiveRetriever", "callback", "Lkotlin/Function2;", "clearRetrieversFactories", "clearTransformersFactories", "clearPostProcessorsFactories", "getCoroutineScope", "getCoroutineScope$intellij_ml_llm_context", "sessionStorage", "sessionLoader", "Lcom/intellij/ml/llm/context/impl/CombinedContextLoader;", "getOrAddSession", "computeContextImpl", "withTracing", "(Lcom/intellij/ml/llm/context/ContextRetrievalRequest;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "gatherContextFlowImpl", "postProcessGatheredContextImpl", "gatheredContext", "(Lcom/intellij/ml/llm/context/ContextRetrievalRequest;Ljava/lang/Iterable;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execOperation", "T", "opKind", "Lcom/intellij/ml/llm/context/ContextRetrievalRequestExecution$OpKind;", "operation", "Lkotlin/Function5;", "Lkotlin/coroutines/CoroutineContext;", "Lkotlin/ParameterName;", "name", "tracingContext", "loader", "Lcom/intellij/ml/llm/context/ContextRetrievalRequestExecution$Builder;", "statsBuilder", "parentStatsBuilder", "Lkotlin/coroutines/Continuation;", "(Lcom/intellij/ml/llm/context/ContextRetrievalRequest;ZLcom/intellij/ml/llm/context/ContextRetrievalRequestExecution$OpKind;Lkotlin/jvm/functions/Function5;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleExecStats", "logExecStats", "execStats", "Companion", "SessionStorage", "intellij.ml.llm.context"})
@SourceDebugExtension(value={"SMAP\nContextRetrievalService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextRetrievalService.kt\ncom/intellij/ml/llm/context/ContextRetrievalService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ContextRetrievalService.kt\ncom/intellij/ml/llm/context/ExecStatsElement$Companion\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 8 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,568:1\n468#1,7:632\n475#1:642\n476#1,5:647\n468#1,7:661\n475#1:671\n476#1,5:676\n1068#2:569\n1563#2:570\n1634#2,3:571\n1563#2:575\n1634#2,3:576\n1491#2:579\n1516#2,3:580\n1519#2,3:590\n1563#2:597\n1634#2,3:598\n2783#2,7:601\n1563#2:608\n1634#2,2:609\n1563#2:611\n1634#2,3:612\n1636#2:615\n2783#2,7:616\n1563#2:623\n1634#2,2:624\n1563#2:626\n1634#2,3:627\n1636#2:630\n1068#2:631\n1#3:574\n382#4,7:583\n126#5:593\n153#5,3:594\n549#6,3:639\n554#6:652\n555#6,7:654\n549#6,3:668\n554#6:681\n555#6,7:683\n549#6,3:690\n554#6:701\n555#6,7:703\n68#7,4:643\n68#7,4:672\n68#7,4:693\n68#7,4:697\n14#7:710\n374#8:653\n374#8:682\n374#8:702\n*S KotlinDebug\n*F\n+ 1 ContextRetrievalService.kt\ncom/intellij/ml/llm/context/ContextRetrievalService\n*L\n406#1:632,7\n406#1:642\n406#1:647,5\n446#1:661,7\n446#1:671\n446#1:676,5\n151#1:569\n151#1:570\n151#1:571,3\n199#1:575\n199#1:576,3\n199#1:579\n199#1:580,3\n199#1:590,3\n202#1:597\n202#1:598,3\n204#1:601,7\n207#1:608\n207#1:609,2\n213#1:611\n213#1:612,3\n207#1:615\n216#1:616,7\n222#1:623\n222#1:624,2\n229#1:626\n229#1:627,3\n222#1:630\n236#1:631\n199#1:583,7\n199#1:593\n199#1:594,3\n406#1:639,3\n406#1:652\n406#1:654,7\n446#1:668,3\n446#1:681\n446#1:683,7\n474#1:690,3\n474#1:701\n474#1:703,7\n406#1:643,4\n446#1:672,4\n475#1:693,4\n480#1:697,4\n43#1:710\n406#1:653\n446#1:682\n474#1:702\n*E\n"})
public final class ContextRetrievalService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private volatile ContextLoaderOptions contextLoaderOpts;
    @NotNull
    private final CopyOnWriteArraySet<ContextRetrieverFactory> retrieversFactories;
    @NotNull
    private final CopyOnWriteArraySet<ContextTransformerFactory> transformersFactories;
    @NotNull
    private final CopyOnWriteArraySet<ContextPostProcessorFactory> postProcessorsFactories;
    @NotNull
    private final ConcurrentHashMap<RetrievalSession, SessionStorage> sessions;
    private final int DEBUG_NUM_LAST_REQUESTS_TO_STORE;
    private final Map<Class<? extends ContextRetrievalRequest>, CopyOnWriteArrayList<Pair<ContextRetrievalRequest, ContextRetrievalRequestExecution>>> latestRequests;
    @NotNull
    private static final Logger LOG;

    public ContextRetrievalService(@NotNull Project project2, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.contextLoaderOpts = new ContextLoaderOptions(Registry.Companion.is("llm.context.service.compute.context.async"), DurationKt.toDuration((int)Registry.Companion.intValue("llm.context.service.interactive.retrievers.throttle.ms"), (DurationUnit)DurationUnit.MILLISECONDS), 0, 0L, ContextRetrievalService::contextLoaderOpts$lambda$15, 12, null);
        this.retrieversFactories = new CopyOnWriteArraySet();
        this.transformersFactories = new CopyOnWriteArraySet();
        this.postProcessorsFactories = new CopyOnWriteArraySet();
        this.sessions = new ConcurrentHashMap();
        this.DEBUG_NUM_LAST_REQUESTS_TO_STORE = 10;
        this.latestRequests = Collections.synchronizedMap(new HashMap());
        this.registerRetrieversFactories(ContextRetrieverFactory.Companion.getEP_NAME$intellij_ml_llm_context().getExtensionList());
        this.registerTransformersFactories(ContextTransformerFactory.Companion.getEP_NAME$intellij_ml_llm_context().getExtensionList());
        this.registerPostProcessorsFactories(ContextPostProcessorFactory.Companion.getEP_NAME$intellij_ml_llm_context().getExtensionList());
    }

    public final void registerRetrieversFactories(@NotNull Collection<? extends ContextRetrieverFactory> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.retrieversFactories.addAll(items2);
    }

    public final void registerTransformersFactories(@NotNull Collection<? extends ContextTransformerFactory> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.transformersFactories.addAll(items2);
    }

    public final void registerPostProcessorsFactories(@NotNull Collection<? extends ContextPostProcessorFactory> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.postProcessorsFactories.addAll(items2);
    }

    public final boolean isRetrieverRegistered(@NotNull RetrievalSession session, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.sessionLoader(session).hasRetriever(id);
    }

    public final void registerRetriever(@NotNull RetrievalSession session, @NotNull ContextRetriever retriever) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)retriever, (String)"retriever");
        this.sessionLoader(session).addRetrievers(CollectionsKt.listOf((Object)retriever));
    }

    public final void unregisterRetriever(@NotNull RetrievalSession session, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.sessionLoader(session).removeRetrievers(CollectionsKt.listOf((Object)id));
    }

    public final boolean isTransformerRegistered(@NotNull RetrievalSession session, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.sessionLoader(session).hasTransformer(id);
    }

    public final void registerTransformer(@NotNull RetrievalSession session, @NotNull ContextTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        this.sessionLoader(session).addTransformers(CollectionsKt.listOf((Object)transformer));
    }

    public final void unregisterTransformer(@NotNull RetrievalSession session, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.sessionLoader(session).removeTransformers(CollectionsKt.listOf((Object)id));
    }

    public final boolean isRankerRegistered(@NotNull RetrievalSession session, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.sessionLoader(session).hasPostProcessor(id);
    }

    public final void registerRanker(@NotNull RetrievalSession session, @NotNull ContextPostProcessor ranker) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
        this.sessionLoader(session).addPostProcessors(CollectionsKt.listOf((Object)ranker));
    }

    public final void unregisterRanker(@NotNull RetrievalSession session, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.sessionLoader(session).removePostProcessors(CollectionsKt.listOf((Object)id));
    }

    @Nullable
    public final Object computeContext(@NotNull ContextRetrievalRequest request2, @NotNull Continuation<? super Iterable<? extends ContextEntity>> $completion) {
        return this.computeContextImpl(request2, false, $completion);
    }

    @ApiStatus.Internal
    @Nullable
    public final Object tracingComputeContext(@NotNull ContextRetrievalRequest request2, @NotNull Continuation<? super Iterable<? extends ContextEntity>> $completion) {
        return this.computeContextImpl(request2, true, $completion);
    }

    @NotNull
    public final Flow<ContextEntity> gatherContextFlow(@NotNull ContextRetrievalRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.gatherContextFlowImpl(request2, false);
    }

    @ApiStatus.Internal
    @NotNull
    public final Flow<ContextEntity> tracingGatherContextFlow(@NotNull ContextRetrievalRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.gatherContextFlowImpl(request2, true);
    }

    @Nullable
    public final Object postProcessGatheredContext(@NotNull ContextRetrievalRequest request2, @NotNull Iterable<? extends ContextEntity> context2, @NotNull Continuation<? super Iterable<? extends ContextEntity>> $completion) {
        return this.postProcessGatheredContextImpl(request2, context2, false, $completion);
    }

    @ApiStatus.Internal
    @Nullable
    public final Object tracingPostProcessGatheredContext(@NotNull ContextRetrievalRequest request2, @NotNull Iterable<? extends ContextEntity> context2, @NotNull Continuation<? super Iterable<? extends ContextEntity>> $completion) {
        return this.postProcessGatheredContextImpl(request2, context2, true, $completion);
    }

    @NotNull
    public final StateFlow<Boolean> isLoading(@NotNull RetrievalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.sessionLoader(session).isLoading();
    }

    @NotNull
    public final StateFlow<Iterable<ContextEntity>> getContext(@NotNull RetrievalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.sessionLoader(session).getContext();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<RetrievalSession> getSessions() {
        void $this$mapTo$iv$iv;
        Collection<SessionStorage> collection = this.sessions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)collection);
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SessionStorage it = (SessionStorage)b;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getCreationTimestamp();
                it = (SessionStorage)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getCreationTimestamp()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SessionStorage sessionStorage = (SessionStorage)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getLoader().getSession());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Collection<ContextRetriever> getRetrievers(@NotNull RetrievalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.sessionLoader(session).getRetrievers();
    }

    @NotNull
    public final Collection<ContextTransformer> getTransformers(@NotNull RetrievalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.sessionLoader(session).getTransformers();
    }

    @NotNull
    public final Collection<ContextPostProcessor> getPostProcessors(@NotNull RetrievalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.sessionLoader(session).getPostProcessors();
    }

    @NotNull
    public final ContextRetrievalFilter getContextRetrievalFilter(@NotNull RetrievalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.sessionLoader(session).getRetrievalFilter();
    }

    @ApiStatus.Internal
    public final void retriggerPostProcessingOnInteractiveFlow(@NotNull RetrievalSession session) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Object object = this.sessions.get(session);
            if (object == null || (object = ((SessionStorage)object).getLoader()) == null) break block0;
            ((CombinedContextLoader)object).retriggerPostProcessingOnInteractiveFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<Class<? extends ContextRetrievalRequest>, List<Pair<ContextRetrievalRequest, ContextRetrievalRequestExecution>>> getLatestRequests() {
        if (this.getServiceDebugMode()) {
            Map<Class<? extends ContextRetrievalRequest>, CopyOnWriteArrayList<Pair<ContextRetrievalRequest, ContextRetrievalRequestExecution>>> map2 = this.latestRequests;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"latestRequests");
            Map<Class<? extends ContextRetrievalRequest>, CopyOnWriteArrayList<Pair<ContextRetrievalRequest, ContextRetrievalRequestExecution>>> map3 = map2;
            synchronized (map3) {
                boolean bl = false;
                HashMap snapshot = new HashMap();
                Map<Class<? extends ContextRetrievalRequest>, CopyOnWriteArrayList<Pair<ContextRetrievalRequest, ContextRetrievalRequestExecution>>> map4 = this.latestRequests;
                Intrinsics.checkNotNullExpressionValue(map4, (String)"latestRequests");
                for (Map.Entry<Class<? extends ContextRetrievalRequest>, CopyOnWriteArrayList<Pair<ContextRetrievalRequest, ContextRetrievalRequestExecution>>> entry : map4.entrySet()) {
                    Class<? extends ContextRetrievalRequest> type2 = entry.getKey();
                    CopyOnWriteArrayList<Pair<ContextRetrievalRequest, ContextRetrievalRequestExecution>> requests2 = entry.getValue();
                    ((Map)snapshot).put(type2, requests2);
                }
                Map map5 = snapshot;
                return map5;
            }
        }
        throw new IllegalStateException("Latest requests collection is disabled. See registry key `llm.context.service.debug`");
    }

    @NotNull
    public final Map<ContextRetriever, Integer> getSpammingInteractiveRetrievers(@NotNull RetrievalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.sessionLoader(session).getSpammingInteractiveRetrievers();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String printTimings(@NotNull ContextRetrievalStatisticsPrintingPolicy policy) {
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000/\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J2\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"com/intellij/ml/llm/context/ContextRetrievalService$printTimings$SessionToPrint", "", "name", "", "stats", "Lcom/intellij/ml/llm/context/ContextRetrievalStatistics;", "retrieversToReport", "", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/context/ContextRetrievalStatistics;Ljava/util/Set;)V", "getName", "()Ljava/lang/String;", "getStats", "()Lcom/intellij/ml/llm/context/ContextRetrievalStatistics;", "getRetrieversToReport", "()Ljava/util/Set;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Lcom/intellij/ml/llm/context/ContextRetrievalStatistics;Ljava/util/Set;)Lcom/intellij/ml/llm/context/ContextRetrievalService$printTimings$SessionToPrint;", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.context"})
        public final class SessionToPrint {
            private final String name;
            private final ContextRetrievalStatistics stats;
            private final Set<String> retrieversToReport;

            public SessionToPrint(String name, ContextRetrievalStatistics stats, Set<String> retrieversToReport) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
                Intrinsics.checkNotNullParameter(retrieversToReport, (String)"retrieversToReport");
                this.name = name;
                this.stats = stats;
                this.retrieversToReport = retrieversToReport;
            }

            public final String getName() {
                return this.name;
            }

            public final ContextRetrievalStatistics getStats() {
                return this.stats;
            }

            public final Set<String> getRetrieversToReport() {
                return this.retrieversToReport;
            }

            public final String component1() {
                return this.name;
            }

            public final ContextRetrievalStatistics component2() {
                return this.stats;
            }

            public final Set<String> component3() {
                return this.retrieversToReport;
            }

            public final SessionToPrint copy(String name, ContextRetrievalStatistics stats, Set<String> retrieversToReport) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
                Intrinsics.checkNotNullParameter(retrieversToReport, (String)"retrieversToReport");
                return new SessionToPrint(name, stats, retrieversToReport);
            }

            public static /* synthetic */ SessionToPrint copy$default(SessionToPrint sessionToPrint, String string, ContextRetrievalStatistics contextRetrievalStatistics, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sessionToPrint.name;
                }
                if ((n & 2) != 0) {
                    contextRetrievalStatistics = sessionToPrint.stats;
                }
                if ((n & 4) != 0) {
                    set = sessionToPrint.retrieversToReport;
                }
                return sessionToPrint.copy(string, contextRetrievalStatistics, set);
            }

            public String toString() {
                return "SessionToPrint(name=" + this.name + ", stats=" + this.stats + ", retrieversToReport=" + this.retrieversToReport + ")";
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + this.stats.hashCode();
                result2 = result2 * 31 + ((Object)this.retrieversToReport).hashCode();
                return result2;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SessionToPrint)) {
                    return false;
                }
                SessionToPrint sessionToPrint = (SessionToPrint)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)sessionToPrint.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stats, (Object)sessionToPrint.stats)) {
                    return false;
                }
                return Intrinsics.areEqual(this.retrieversToReport, sessionToPrint.retrieversToReport);
            }
        }
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Collection collection2 = policy.getSessions();
        if (collection2.isEmpty()) {
            boolean bl = false;
            Set set = this.sessions.keySet();
            collection = set;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        } else {
            collection = collection2;
        }
        Set sessionsToPrint = (Set)collection;
        List statsList = null;
        if (policy.getMergeSessionsStats() && !((Collection)sessionsToPrint).isEmpty()) {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            void $this$reduce$iv2;
            void $this$mapTo$iv$iv2;
            Object list$iv$iv;
            Iterable $this$groupByTo$iv$iv;
            Object $this$groupBy$iv;
            String it;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = sessionsToPrint;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                RetrievalSession retrievalSession = (RetrievalSession)item$iv$iv;
                var28_39 = destination$iv$iv;
                boolean bl = false;
                var28_39.add(it.getName());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv3 = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                it = (String)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it;
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv3.entrySet().iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv;
                list$iv$iv = item$iv$iv = (Map.Entry)iterator.next();
                var28_39 = destination$iv$iv;
                boolean bl = false;
                String name = (String)list$iv$iv.getKey();
                List sessions = (List)list$iv$iv.getValue();
                var28_39.add(sessions.size() > 1 ? name + "(x" + sessions.size() + ")" : name);
            }
            String mergedNames = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
            Iterable $this$map$iv2 = sessionsToPrint;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                RetrievalSession bl = (RetrievalSession)item$iv$iv;
                var28_39 = destination$iv$iv2;
                boolean bl3 = false;
                var28_39.add(this.sessionLoader((RetrievalSession)it2).getTimings());
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv2.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void right;
                ContextRetrievalStatistics $i$f$mapTo22 = (ContextRetrievalStatistics)iterator$iv.next();
                ContextRetrievalStatistics left = (ContextRetrievalStatistics)accumulator$iv;
                boolean bl = false;
                accumulator$iv = left.merge((ContextRetrievalStatistics)right);
            }
            ContextRetrievalStatistics mergedTimings = (ContextRetrievalStatistics)accumulator$iv;
            Iterable $this$map$iv3 = sessionsToPrint;
            boolean $i$f$map3 = false;
            accumulator$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo32 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Set set;
                void it3;
                RetrievalSession bl3 = (RetrievalSession)item$iv$iv;
                var28_39 = destination$iv$iv3;
                boolean bl = false;
                ContextRetrievalStatistics timings = this.sessionLoader((RetrievalSession)it3).getTimings();
                boolean bl4 = !((Collection)policy.getRetrievers()).isEmpty();
                if (bl4) {
                    set = policy.getRetrievers();
                } else {
                    void $this$mapTo$iv$iv4;
                    Collection<ContextRetriever> sessionRetrievers = this.sessionLoader((RetrievalSession)it3).getRetrievers();
                    $this$map$iv = sessionRetrievers;
                    boolean $i$f$map4 = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo4 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                        void retriever;
                        ContextRetriever contextRetriever = (ContextRetriever)item$iv$iv2;
                        Collection collection3 = destination$iv$iv4;
                        boolean bl5 = false;
                        collection3.add(retriever.getId());
                    }
                    set = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv4)), (Iterable)timings.getTriggeredRetrieverIds());
                }
                var28_39.add(set);
            }
            $this$map$iv3 = (List)destination$iv$iv3;
            boolean $i$f$reduce2 = false;
            Iterator iterator$iv2 = $this$reduce$iv.iterator();
            if (!iterator$iv2.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv2 = iterator$iv2.next();
            while (iterator$iv2.hasNext()) {
                void right;
                Set $i$f$mapTo32 = (Set)iterator$iv2.next();
                Set left = (Set)accumulator$iv2;
                boolean bl = false;
                accumulator$iv2 = SetsKt.plus((Set)left, (Iterable)((Iterable)right));
            }
            mergedRetrieversToReport = (Set)accumulator$iv2;
            statsList = CollectionsKt.listOf((Object)new SessionToPrint(mergedNames, mergedTimings, (Set<String>)mergedRetrieversToReport));
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sessionsToPrint;
            boolean $i$f$map = false;
            mergedRetrieversToReport = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Set set;
                void it;
                RetrievalSession right = (RetrievalSession)item$iv$iv;
                var28_39 = destination$iv$iv;
                boolean bl = false;
                String name = it.getName();
                ContextRetrievalStatistics timings = this.sessionLoader((RetrievalSession)it).getTimings();
                boolean bl6 = !((Collection)policy.getRetrievers()).isEmpty();
                if (bl6) {
                    set = policy.getRetrievers();
                } else {
                    void $this$mapTo$iv$iv5;
                    Collection<ContextRetriever> sessionRetrievers = this.sessionLoader((RetrievalSession)it).getRetrievers();
                    Iterable $this$map$iv4 = sessionRetrievers;
                    boolean $i$f$map5 = false;
                    $this$map$iv = $this$map$iv4;
                    Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                    boolean $i$f$mapTo5 = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv5) {
                        void retriever;
                        ContextRetriever contextRetriever = (ContextRetriever)item$iv$iv3;
                        Collection collection4 = destination$iv$iv5;
                        boolean bl7 = false;
                        collection4.add(retriever.getId());
                    }
                    set = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv5)), (Iterable)timings.getTriggeredRetrieverIds());
                }
                Set retrieversToReport = set;
                var28_39.add(new SessionToPrint(name, timings, retrieversToReport));
            }
            statsList = (List)destination$iv$iv;
        }
        StringBuilder builder = new StringBuilder();
        Iterable $this$sortedByDescending$iv = statsList;
        boolean $i$f$sortedByDescending = false;
        for (SessionToPrint sessionToPrint : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SessionToPrint it = (SessionToPrint)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getStats().getComputeContextEventsNumber());
                it = (SessionToPrint)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStats().getComputeContextEventsNumber()));
            }
        })) {
            String name = sessionToPrint.component1();
            ContextRetrievalStatistics timings = sessionToPrint.component2();
            Set<String> retrievers = sessionToPrint.component3();
            builder.append(ContextRetrievalServiceKt.access$maybeS("=== Session", name)).append(": " + name + " ===\n");
            StringBuilder timingsBuilder = new StringBuilder();
            ContextRetrievalStatisticsPrintingPolicy newPolicy = ContextRetrievalStatisticsPrintingPolicy.copy$default(policy, retrievers, false, null, false, false, 30, null);
            timings.printStats(timingsBuilder, newPolicy);
            String string = timingsBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            builder.append(StringsKt.prependIndent((String)string, (String)"  "));
            builder.append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String printTimings$default(ContextRetrievalService contextRetrievalService, ContextRetrievalStatisticsPrintingPolicy contextRetrievalStatisticsPrintingPolicy, int n, Object object) {
        if ((n & 1) != 0) {
            contextRetrievalStatisticsPrintingPolicy = new ContextRetrievalStatisticsPrintingPolicy(null, false, null, false, false, 31, null);
        }
        return contextRetrievalService.printTimings(contextRetrievalStatisticsPrintingPolicy);
    }

    private final boolean getServiceDebugMode() {
        return Registry.Companion.is("llm.context.service.debug");
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void setComputeContextAsync(boolean value2) {
        void $this$setComputeContextAsync_u24lambda_u2416;
        ContextLoaderOptions.Builder builder;
        ContextLoaderOptions.Builder builder2 = builder = new ContextLoaderOptions.Builder(this.contextLoaderOpts);
        ContextRetrievalService contextRetrievalService = this;
        boolean bl = false;
        $this$setComputeContextAsync_u24lambda_u2416.setComputeContextAsync(value2);
        contextRetrievalService.contextLoaderOpts = builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void setInteractiveContextThrottleDelay-LRDsOJo(long delay) {
        void $this$setInteractiveContextThrottleDelay_LRDsOJo_u24lambda_u2417;
        ContextLoaderOptions.Builder builder;
        ContextLoaderOptions.Builder builder2 = builder = new ContextLoaderOptions.Builder(this.contextLoaderOpts);
        ContextRetrievalService contextRetrievalService = this;
        boolean bl = false;
        $this$setInteractiveContextThrottleDelay_LRDsOJo_u24lambda_u2417.setInteractiveContextThrottleDelay-LRDsOJo(delay);
        contextRetrievalService.contextLoaderOpts = builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void setInteractiveRetrieverSpamCriteria-HG0u8IE(int spamSequenceSize, long spamEmitDelay) {
        void $this$setInteractiveRetrieverSpamCriteria_HG0u8IE_u24lambda_u2418;
        ContextLoaderOptions.Builder builder;
        ContextLoaderOptions.Builder builder2 = builder = new ContextLoaderOptions.Builder(this.contextLoaderOpts);
        ContextRetrievalService contextRetrievalService = this;
        boolean bl = false;
        $this$setInteractiveRetrieverSpamCriteria_HG0u8IE_u24lambda_u2418.setInteractiveRetrieverSpamSequenceSize(spamSequenceSize);
        $this$setInteractiveRetrieverSpamCriteria_HG0u8IE_u24lambda_u2418.setInteractiveRetrieverSpamEmitDelay-LRDsOJo(spamEmitDelay);
        contextRetrievalService.contextLoaderOpts = builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void setOnSpammingInteractiveRetriever(@NotNull Function2<? super ContextRetriever, ? super Integer, Unit> callback) {
        void $this$setOnSpammingInteractiveRetriever_u24lambda_u2419;
        ContextLoaderOptions.Builder builder;
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ContextLoaderOptions.Builder builder2 = builder = new ContextLoaderOptions.Builder(this.contextLoaderOpts);
        ContextRetrievalService contextRetrievalService = this;
        boolean bl = false;
        $this$setOnSpammingInteractiveRetriever_u24lambda_u2419.setOnSpammingInteractiveRetriever(callback);
        contextRetrievalService.contextLoaderOpts = builder.build();
    }

    @TestOnly
    public final void clearRetrieversFactories() {
        this.retrieversFactories.clear();
    }

    @TestOnly
    public final void clearTransformersFactories() {
        this.transformersFactories.clear();
    }

    @TestOnly
    public final void clearPostProcessorsFactories() {
        this.postProcessorsFactories.clear();
    }

    @NotNull
    public final CoroutineScope getCoroutineScope$intellij_ml_llm_context() {
        return this.cs;
    }

    private final SessionStorage sessionStorage(RetrievalSession session) {
        SessionStorage session2 = this.getOrAddSession(session);
        return session2;
    }

    private final CombinedContextLoader sessionLoader(RetrievalSession session) {
        SessionStorage session2 = this.getOrAddSession(session);
        return session2.getLoader();
    }

    private final SessionStorage getOrAddSession(RetrievalSession session) {
        SessionStorage sessionStorage = this.sessions.computeIfAbsent(session, arg_0 -> ContextRetrievalService.getOrAddSession$lambda$21(arg_0 -> ContextRetrievalService.getOrAddSession$lambda$20(this, session, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sessionStorage, (String)"computeIfAbsent(...)");
        return sessionStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object computeContextImpl(ContextRetrievalRequest request, boolean withTracing, Continuation<? super Iterable<? extends ContextEntity>> $completion) {
        if (!($completion instanceof computeContextImpl.1)) ** GOTO lbl-1000
        var37_4 = $completion;
        if ((var37_4.label & -2147483648) != 0) {
            var37_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                Object L$14;
                Object L$15;
                Object L$16;
                Object L$17;
                boolean Z$0;
                boolean Z$1;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                /* synthetic */ Object result;
                final /* synthetic */ ContextRetrievalService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ContextRetrievalService.access$computeContextImpl(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var38_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = this;
                var5_10 = request;
                var6_11 = withTracing;
                var7_14 = ContextRetrievalRequestExecution.OpKind.COMPUTING;
                $i$f$execOperation = 0;
                storage$iv = ContextRetrievalService.access$sessionStorage(this_$iv, request$iv.getSession());
                $continuation.L$0 = request;
                $continuation.L$1 = this_$iv;
                $continuation.L$2 = request$iv;
                $continuation.L$3 = opKind$iv;
                $continuation.L$4 = storage$iv;
                $continuation.Z$0 = withTracing;
                $continuation.Z$1 = withTracing$iv;
                $continuation.I$0 = $i$f$execOperation;
                $continuation.label = 1;
                v0 = storage$iv.waitUntilInitialized((Continuation<? super Unit>)$continuation);
                if (v0 == var38_6) {
                    return var38_6;
                }
                ** GOTO lbl43
            }
            case 1: {
                $i$f$execOperation = $continuation.I$0;
                withTracing$iv = $continuation.Z$1;
                withTracing = $continuation.Z$0;
                storage$iv = (SessionStorage)$continuation.L$4;
                opKind$iv = (ContextRetrievalRequestExecution.OpKind)$continuation.L$3;
                request$iv = (ContextRetrievalRequest)$continuation.L$2;
                this_$iv = (ContextRetrievalService)$continuation.L$1;
                request = (ContextRetrievalRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl43:
                // 2 sources

                $continuation.L$0 = request;
                $continuation.L$1 = this_$iv;
                $continuation.L$2 = request$iv;
                $continuation.L$3 = opKind$iv;
                $continuation.L$4 = storage$iv;
                $continuation.Z$0 = withTracing;
                $continuation.Z$1 = withTracing$iv;
                $continuation.I$0 = $i$f$execOperation;
                $continuation.label = 2;
                v1 = ExecStatsElement.Companion.hasStatsElement((Continuation<? super Boolean>)$continuation);
                if (v1 == var38_6) {
                    return var38_6;
                }
                ** GOTO lbl67
            }
            case 2: {
                $i$f$execOperation = $continuation.I$0;
                withTracing$iv = $continuation.Z$1;
                withTracing = $continuation.Z$0;
                storage$iv = (SessionStorage)$continuation.L$4;
                opKind$iv = (ContextRetrievalRequestExecution.OpKind)$continuation.L$3;
                request$iv = (ContextRetrievalRequest)$continuation.L$2;
                this_$iv = (ContextRetrievalService)$continuation.L$1;
                request = (ContextRetrievalRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl67:
                // 2 sources

                needTracing$iv = (Boolean)v1 != false || withTracing$iv != false || ContextRetrievalService.access$getServiceDebugMode(this_$iv) != false ? 1 : 0;
                statsBuilder$iv = new ContextRetrievalRequestExecution.Builder(storage$iv.getLoader().getSession(), request$iv, opKind$iv, needTracing$iv != 0);
                var12_27 = ExecStatsElement.Companion;
                currentBuilder$iv$iv = statsBuilder$iv;
                $i$f$maybeWithTracingContext = 0;
                if (currentBuilder$iv$iv.getEnabled()) break;
                var15_36 = (Continuation)$continuation;
                var16_40 = null;
                tracingContext$iv = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = 0;
                $this$trace$iv$iv /* !! */  = ContextRetrievalService.access$getLOG$cp();
                $i$f$trace = false;
                if ($this$trace$iv$iv /* !! */ .isTraceEnabled()) {
                    var21_60 = $this$trace$iv$iv /* !! */ ;
                    $i$a$-trace-ContextRetrievalService$execOperation$2$1$iv = false;
                    var21_60.trace("started operation " + opKind$iv + " for " + request$iv);
                }
                var23_66 = (Continuation)$continuation;
                var24_70 = parentStatsBuilder$iv;
                var25_72 = statsBuilder$iv;
                var26_74 = storage$iv.getLoader();
                tracingContext = tracingContext$iv;
                $i$a$-execOperation-ContextRetrievalService$computeContextImpl$2 = 0;
                $continuation.L$0 = request;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                $continuation.L$2 = request$iv;
                $continuation.L$3 = opKind$iv;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)storage$iv);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder$iv);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)currentBuilder$iv$iv);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)tracingContext$iv);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                $continuation.L$11 = statsBuilder;
                $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)loader);
                $continuation.L$13 = SpillingKt.nullOutSpilledVariable((Object)tracingContext);
                $continuation.Z$0 = withTracing;
                $continuation.Z$1 = withTracing$iv;
                $continuation.I$0 = $i$f$execOperation;
                $continuation.I$1 = needTracing$iv;
                $continuation.I$2 = $i$f$maybeWithTracingContext;
                $continuation.I$3 = $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv;
                $continuation.I$4 = $i$a$-execOperation-ContextRetrievalService$computeContextImpl$2;
                $continuation.label = 3;
                v2 = BuildersKt.withContext((CoroutineContext)tracingContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Iterable<? extends ContextEntity>>, Object>((CombinedContextLoader)loader, request, statsBuilder, null){
                    int label;
                    final /* synthetic */ CombinedContextLoader $loader;
                    final /* synthetic */ ContextRetrievalRequest $request;
                    final /* synthetic */ ContextRetrievalRequestExecution.Builder $statsBuilder;
                    {
                        this.$loader = $loader;
                        this.$request = $request;
                        this.$statsBuilder = $statsBuilder;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$loader.computeContext(this.$request, this.$statsBuilder, (Continuation<? super Iterable<? extends ContextEntity>>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Iterable<? extends ContextEntity>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var38_6) goto lbl117
lbl116:
                // 1 sources

                return var38_6;
lbl117:
                // 1 sources

                ** GOTO lbl146
            }
            case 3: {
                $i$a$-execOperation-ContextRetrievalService$computeContextImpl$2 = $continuation.I$4;
                $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = $continuation.I$3;
                $i$f$maybeWithTracingContext = $continuation.I$2;
                needTracing$iv = $continuation.I$1;
                $i$f$execOperation = $continuation.I$0;
                withTracing$iv = $continuation.Z$1;
                withTracing = $continuation.Z$0;
                tracingContext = (CoroutineContext)$continuation.L$13;
                loader = (CombinedContextLoader)$continuation.L$12;
                statsBuilder = (ContextRetrievalRequestExecution.Builder)$continuation.L$11;
                parentStatsBuilder = null;
                $completion = (Continuation)$continuation.L$10;
                tracingContext$iv = (CoroutineContext)$continuation.L$9;
                parentStatsBuilder$iv = null;
                $completion$iv = (Continuation)$continuation.L$8;
                currentBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$7;
                this_$iv$iv = (ExecStatsElement.Companion)$continuation.L$6;
                statsBuilder$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$5;
                storage$iv = (SessionStorage)$continuation.L$4;
                opKind$iv = (ContextRetrievalRequestExecution.OpKind)$continuation.L$3;
                request$iv = (ContextRetrievalRequest)$continuation.L$2;
                this_$iv = (ContextRetrievalService)$continuation.L$1;
                request = (ContextRetrievalRequest)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl146:
                    // 2 sources

                    items = (Iterable)v2;
                    $this$trace$iv$iv /* !! */  = ContextRetrievalService.access$handleExecStats(this, request, withTracing != false, statsBuilder, parentStatsBuilder, items);
                    v3 /* !! */  = $this$trace$iv$iv /* !! */ ;
                    ** GOTO lbl275
                }
                catch (Throwable $this$trace$iv$iv) {
                    throw $this$trace$iv$iv;
                }
                finally {
                    $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
                    $i$f$trace = false;
                    if ($this$trace$iv$iv.isTraceEnabled()) {
                        var21_60 = $this$trace$iv$iv;
                        $i$a$-trace-ContextRetrievalService$execOperation$2$2$iv = false;
                        var21_60.trace("finished operation " + opKind$iv + " for " + request$iv);
                    }
                }
            }
        }
        $i$f$currentCoroutineContext = false;
        v4 = (ExecStatsElement)$continuation.getContext().get((CoroutineContext.Key)ExecStatsElement.Companion);
        if (v4 == null) {
            v4 = new ExecStatsElement();
        }
        execStatsElement$iv$iv = v4;
        parentStatsBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)CollectionsKt.lastOrNull((List)execStatsElement$iv$iv.getTracingBuilders());
        execStatsElement$iv$iv.getTracingBuilders().add(currentBuilder$iv$iv);
        $completion$iv = (Continuation)$continuation;
        parentStatsBuilder$iv = parentStatsBuilder$iv$iv;
        tracingContext$iv = (CoroutineContext)execStatsElement$iv$iv;
        $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = 0;
        $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
        $i$f$trace = false;
        if ($this$trace$iv$iv.isTraceEnabled()) {
            var21_61 = $this$trace$iv$iv;
            $i$a$-trace-ContextRetrievalService$execOperation$2$1$iv = false;
            var21_61.trace("started operation " + opKind$iv + " for " + request$iv);
        }
        $completion = (Continuation)$continuation;
        parentStatsBuilder = parentStatsBuilder$iv;
        statsBuilder = statsBuilder$iv;
        loader = storage$iv.getLoader();
        tracingContext = tracingContext$iv;
        $i$a$-execOperation-ContextRetrievalService$computeContextImpl$2 = 0;
        $continuation.L$0 = request;
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
        $continuation.L$2 = request$iv;
        $continuation.L$3 = opKind$iv;
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)storage$iv);
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder$iv);
        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)currentBuilder$iv$iv);
        $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
        $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)parentStatsBuilder$iv);
        $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)tracingContext$iv);
        $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)$completion);
        $continuation.L$12 = parentStatsBuilder;
        $continuation.L$13 = statsBuilder;
        $continuation.L$14 = SpillingKt.nullOutSpilledVariable((Object)loader);
        $continuation.L$15 = SpillingKt.nullOutSpilledVariable((Object)tracingContext);
        $continuation.L$16 = SpillingKt.nullOutSpilledVariable((Object)parentStatsBuilder$iv$iv);
        $continuation.L$17 = execStatsElement$iv$iv;
        $continuation.Z$0 = withTracing;
        $continuation.Z$1 = withTracing$iv;
        $continuation.I$0 = $i$f$execOperation;
        $continuation.I$1 = needTracing$iv;
        $continuation.I$2 = $i$f$maybeWithTracingContext;
        $continuation.I$3 = $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv;
        $continuation.I$4 = $i$a$-execOperation-ContextRetrievalService$computeContextImpl$2;
        $continuation.label = 4;
        v5 = BuildersKt.withContext((CoroutineContext)tracingContext, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)$continuation);
        ** if (v5 != var38_6) goto lbl220
lbl219:
        // 1 sources

        return var38_6;
lbl220:
        // 1 sources

        ** GOTO lbl252
        {
            case 4: {
                $i$a$-execOperation-ContextRetrievalService$computeContextImpl$2 = $continuation.I$4;
                $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = $continuation.I$3;
                $i$f$maybeWithTracingContext = $continuation.I$2;
                needTracing$iv = $continuation.I$1;
                $i$f$execOperation = $continuation.I$0;
                withTracing$iv = $continuation.Z$1;
                withTracing = $continuation.Z$0;
                execStatsElement$iv$iv = (ExecStatsElement)$continuation.L$17;
                parentStatsBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$16;
                tracingContext = (CoroutineContext)$continuation.L$15;
                loader = (CombinedContextLoader)$continuation.L$14;
                statsBuilder = (ContextRetrievalRequestExecution.Builder)$continuation.L$13;
                parentStatsBuilder = (ContextRetrievalRequestExecution.Builder)$continuation.L$12;
                $completion = (Continuation)$continuation.L$11;
                tracingContext$iv = (CoroutineContext)$continuation.L$10;
                parentStatsBuilder$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$9;
                $completion$iv = (Continuation)$continuation.L$8;
                currentBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$7;
                this_$iv$iv = (ExecStatsElement.Companion)$continuation.L$6;
                statsBuilder$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$5;
                storage$iv = (SessionStorage)$continuation.L$4;
                opKind$iv = (ContextRetrievalRequestExecution.OpKind)$continuation.L$3;
                request$iv = (ContextRetrievalRequest)$continuation.L$2;
                this_$iv = (ContextRetrievalService)$continuation.L$1;
                request = (ContextRetrievalRequest)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl252:
                    // 2 sources

                    items = (Iterable)v5;
                    var19_53 = ContextRetrievalService.access$handleExecStats(this, request, withTracing != false, statsBuilder, parentStatsBuilder, items);
                    ** GOTO lbl266
                    {
                        catch (Throwable var20_59) {
                            throw var20_59;
                        }
                    }
                    finally {
                        $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
                        $i$f$trace = false;
                        if ($this$trace$iv$iv.isTraceEnabled()) {
                            var21_61 = $this$trace$iv$iv;
                            $i$a$-trace-ContextRetrievalService$execOperation$2$2$iv = false;
                            var21_61.trace("finished operation " + opKind$iv + " for " + request$iv);
                        }
                    }
lbl266:
                    // 1 sources

                    var32_95 = var19_53;
                    v3 /* !! */  = var32_95;
                }
                catch (Throwable var35_99) {
                    throw var35_99;
                }
                finally {
                    CollectionsKt.removeLast((List)execStatsElement$iv$iv.getTracingBuilders());
                }
lbl275:
                // 2 sources

                return v3 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Flow<ContextEntity> gatherContextFlowImpl(ContextRetrievalRequest request2, boolean withTracing) {
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super ContextEntity>, Continuation<? super Unit>, Object>(this, request2, withTracing, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            Object L$9;
            Object L$10;
            Object L$11;
            Object L$12;
            Object L$13;
            Object L$14;
            Object L$15;
            Object L$16;
            Object L$17;
            Object L$18;
            Object L$19;
            Object L$20;
            boolean Z$0;
            boolean Z$1;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ContextRetrievalService this$0;
            final /* synthetic */ ContextRetrievalRequest $request;
            final /* synthetic */ boolean $withTracing;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$withTracing = $withTracing;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                block36: {
                    var2_2 = (FlowCollector)this.L$0;
                    var43_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var3_4 = this.this$0;
                            var4_5 = this.$request;
                            var5_6 = this.$withTracing;
                            var6_7 = ContextRetrievalRequestExecution.OpKind.GATHERING;
                            var7_8 = this.$request;
                            var8_9 = this.this$0;
                            var9_10 = this.$withTracing;
                            $i$f$execOperation = 0;
                            storage$iv = ContextRetrievalService.access$sessionStorage(this_$iv, request$iv.getSession());
                            this.L$0 = $this$flow;
                            this.L$1 = this_$iv;
                            this.L$2 = request$iv;
                            this.L$3 = opKind$iv;
                            this.L$4 = var7_8;
                            this.L$5 = var8_9;
                            this.L$6 = storage$iv;
                            this.Z$0 = withTracing$iv;
                            this.Z$1 = var9_10;
                            this.I$0 = $i$f$execOperation;
                            this.label = 1;
                            v0 = storage$iv.waitUntilInitialized((Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var43_3) {
                                return var43_3;
                            }
                            ** GOTO lbl42
                        }
                        case 1: {
                            $i$f$execOperation = this.I$0;
                            var9_10 = this.Z$1;
                            withTracing$iv = this.Z$0;
                            storage$iv = (SessionStorage)this.L$6;
                            var8_9 = (ContextRetrievalService)this.L$5;
                            var7_8 = (ContextRetrievalRequest)this.L$4;
                            opKind$iv = (ContextRetrievalRequestExecution.OpKind)this.L$3;
                            request$iv = (ContextRetrievalRequest)this.L$2;
                            this_$iv = (ContextRetrievalService)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl42:
                            // 2 sources

                            this.L$0 = $this$flow;
                            this.L$1 = this_$iv;
                            this.L$2 = request$iv;
                            this.L$3 = opKind$iv;
                            this.L$4 = var7_8;
                            this.L$5 = var8_9;
                            this.L$6 = storage$iv;
                            this.Z$0 = withTracing$iv;
                            this.Z$1 = var9_10;
                            this.I$0 = $i$f$execOperation;
                            this.label = 2;
                            v1 = ExecStatsElement.Companion.hasStatsElement((Continuation<? super Boolean>)((Continuation)this));
                            if (v1 == var43_3) {
                                return var43_3;
                            }
                            ** GOTO lbl69
                        }
                        case 2: {
                            $i$f$execOperation = this.I$0;
                            var9_10 = this.Z$1;
                            withTracing$iv = this.Z$0;
                            storage$iv = (SessionStorage)this.L$6;
                            var8_9 = (ContextRetrievalService)this.L$5;
                            var7_8 = (ContextRetrievalRequest)this.L$4;
                            opKind$iv = (ContextRetrievalRequestExecution.OpKind)this.L$3;
                            request$iv = (ContextRetrievalRequest)this.L$2;
                            this_$iv = (ContextRetrievalService)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl69:
                            // 2 sources

                            needTracing$iv = (Boolean)v1 != false || withTracing$iv != false || ContextRetrievalService.access$getServiceDebugMode(this_$iv) != false ? 1 : 0;
                            statsBuilder$iv = new ContextRetrievalRequestExecution.Builder(storage$iv.getLoader().getSession(), request$iv, opKind$iv, needTracing$iv != 0);
                            var14_15 = ExecStatsElement.Companion;
                            currentBuilder$iv$iv = statsBuilder$iv;
                            $i$f$maybeWithTracingContext = 0;
                            if (currentBuilder$iv$iv.getEnabled()) ** GOTO lbl238
                            var17_18 = (Continuation)this;
                            var18_20 = null;
                            tracingContext$iv = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                            $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = 0;
                            $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
                            $i$f$trace = false;
                            if ($this$trace$iv$iv.isTraceEnabled()) {
                                var23_34 = $this$trace$iv$iv;
                                $i$a$-trace-ContextRetrievalService$execOperation$2$1$iv = false;
                                var23_34.trace("started operation " + opKind$iv + " for " + request$iv);
                            }
                            var25_40 = (Continuation)this;
                            var26_42 = parentStatsBuilder$iv;
                            var27_44 = statsBuilder$iv;
                            var28_46 = storage$iv.getLoader();
                            tracingContext = tracingContext$iv;
                            $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1 = 0;
                            maybeCollectedItems = new ArrayList<E>();
                            this.L$0 = $this$flow;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                            this.L$2 = request$iv;
                            this.L$3 = opKind$iv;
                            this.L$4 = var7_8;
                            this.L$5 = var8_9;
                            this.L$6 = SpillingKt.nullOutSpilledVariable((Object)storage$iv);
                            this.L$7 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder$iv);
                            this.L$8 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                            this.L$9 = SpillingKt.nullOutSpilledVariable((Object)currentBuilder$iv$iv);
                            this.L$10 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                            this.L$11 = SpillingKt.nullOutSpilledVariable((Object)tracingContext$iv);
                            this.L$12 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                            this.L$13 = statsBuilder;
                            this.L$14 = SpillingKt.nullOutSpilledVariable((Object)loader);
                            this.L$15 = SpillingKt.nullOutSpilledVariable((Object)tracingContext);
                            this.L$16 = maybeCollectedItems;
                            this.Z$0 = withTracing$iv;
                            this.Z$1 = var9_10;
                            this.I$0 = $i$f$execOperation;
                            this.I$1 = needTracing$iv;
                            this.I$2 = $i$f$maybeWithTracingContext;
                            this.I$3 = $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv;
                            this.I$4 = $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1;
                            this.label = 3;
                            v2 = FlowKt.flowOn(loader.gatherContextFlow(var7_8, statsBuilder), (CoroutineContext)tracingContext).collect(new FlowCollector(statsBuilder, maybeCollectedItems, (FlowCollector<? super ContextEntity>)$this$flow){
                                final /* synthetic */ ContextRetrievalRequestExecution.Builder $statsBuilder;
                                final /* synthetic */ List<ContextEntity> $maybeCollectedItems;
                                final /* synthetic */ FlowCollector<ContextEntity> $$this$flow;
                                {
                                    this.$statsBuilder = $statsBuilder;
                                    this.$maybeCollectedItems = $maybeCollectedItems;
                                    this.$$this$flow = $$this$flow;
                                }

                                public final Object emit(ContextEntity it, Continuation<? super Unit> $completion) {
                                    Logger $this$trace$iv = ContextRetrievalService.access$getLOG$cp();
                                    boolean $i$f$trace = false;
                                    if ($this$trace$iv.isTraceEnabled()) {
                                        Logger logger = $this$trace$iv;
                                        boolean bl = false;
                                        logger.trace("collecting " + it);
                                    }
                                    if (this.$statsBuilder.getEnabled()) {
                                        this.$maybeCollectedItems.add(it);
                                    }
                                    Object object = this.$$this$flow.emit((Object)it, $completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            v3 = v2;
                            if (v2 == var43_3) {
                                return var43_3;
                            }
                            ** GOTO lbl157
                        }
                        case 3: {
                            $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1 = this.I$4;
                            $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = this.I$3;
                            $i$f$maybeWithTracingContext = this.I$2;
                            needTracing$iv = this.I$1;
                            $i$f$execOperation = this.I$0;
                            var9_10 = this.Z$1;
                            withTracing$iv = this.Z$0;
                            maybeCollectedItems = (List)this.L$16;
                            tracingContext = (CoroutineContext)this.L$15;
                            loader = (CombinedContextLoader)this.L$14;
                            statsBuilder = (ContextRetrievalRequestExecution.Builder)this.L$13;
                            parentStatsBuilder = null;
                            $completion = (Continuation)this.L$12;
                            tracingContext$iv = (CoroutineContext)this.L$11;
                            parentStatsBuilder$iv = null;
                            $completion$iv = (Continuation)this.L$10;
                            currentBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)this.L$9;
                            this_$iv$iv = (ExecStatsElement.Companion)this.L$8;
                            statsBuilder$iv = (ContextRetrievalRequestExecution.Builder)this.L$7;
                            storage$iv = (SessionStorage)this.L$6;
                            var8_9 = (ContextRetrievalService)this.L$5;
                            var7_8 = (ContextRetrievalRequest)this.L$4;
                            opKind$iv = (ContextRetrievalRequestExecution.OpKind)this.L$3;
                            request$iv = (ContextRetrievalRequest)this.L$2;
                            this_$iv = (ContextRetrievalService)this.L$1;
                            {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl157:
                                // 2 sources

                                execStats = statsBuilder.build(maybeCollectedItems);
                                ContextRetrievalService.access$logExecStats(var8_9, var7_8, parentStatsBuilder, execStats);
                                if (!var9_10 || execStats == null) ** GOTO lbl225
                                $this$trace$iv = ContextRetrievalService.access$getLOG$cp();
                                $i$f$trace = false;
                                if ($this$trace$iv.isTraceEnabled()) {
                                    var35_60 = $this$trace$iv;
                                    $i$a$-trace-ContextRetrievalService$gatherContextFlowImpl$1$1$2 = false;
                                    var35_60.trace("collected " + execStats);
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$flow);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                                this.L$2 = request$iv;
                                this.L$3 = opKind$iv;
                                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)storage$iv);
                                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder$iv);
                                this.L$6 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                                this.L$7 = SpillingKt.nullOutSpilledVariable((Object)currentBuilder$iv$iv);
                                this.L$8 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                                this.L$9 = SpillingKt.nullOutSpilledVariable((Object)tracingContext$iv);
                                this.L$10 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                this.L$11 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder);
                                this.L$12 = SpillingKt.nullOutSpilledVariable((Object)loader);
                                this.L$13 = SpillingKt.nullOutSpilledVariable((Object)tracingContext);
                                this.L$14 = SpillingKt.nullOutSpilledVariable((Object)maybeCollectedItems);
                                this.L$15 = SpillingKt.nullOutSpilledVariable((Object)execStats);
                                this.L$16 = null;
                                this.Z$0 = withTracing$iv;
                                this.I$0 = $i$f$execOperation;
                                this.I$1 = needTracing$iv;
                                this.I$2 = $i$f$maybeWithTracingContext;
                                this.I$3 = $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv;
                                this.I$4 = $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1;
                                this.label = 4;
                                v4 = $this$flow.emit((Object)execStats, (Continuation)this);
                                ** if (v4 != var43_3) goto lbl194
                            }
lbl193:
                            // 1 sources

                            return var43_3;
lbl194:
                            // 1 sources

                            ** GOTO lbl223
                        }
                        case 4: {
                            $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1 = this.I$4;
                            $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = this.I$3;
                            $i$f$maybeWithTracingContext = this.I$2;
                            needTracing$iv = this.I$1;
                            $i$f$execOperation = this.I$0;
                            withTracing$iv = this.Z$0;
                            execStats = (ContextRetrievalRequestExecution)this.L$15;
                            maybeCollectedItems = (List)this.L$14;
                            tracingContext = (CoroutineContext)this.L$13;
                            loader = (CombinedContextLoader)this.L$12;
                            statsBuilder = (ContextRetrievalRequestExecution.Builder)this.L$11;
                            parentStatsBuilder = null;
                            $completion = (Continuation)this.L$10;
                            tracingContext$iv = (CoroutineContext)this.L$9;
                            parentStatsBuilder$iv = null;
                            $completion$iv = (Continuation)this.L$8;
                            currentBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)this.L$7;
                            this_$iv$iv = (ExecStatsElement.Companion)this.L$6;
                            statsBuilder$iv = (ContextRetrievalRequestExecution.Builder)this.L$5;
                            storage$iv = (SessionStorage)this.L$4;
                            opKind$iv = (ContextRetrievalRequestExecution.OpKind)this.L$3;
                            request$iv = (ContextRetrievalRequest)this.L$2;
                            this_$iv = (ContextRetrievalService)this.L$1;
                            ** try [egrp 2[TRYBLOCK] [2 : 1480->1498)] { 
lbl220:
                            // 1 sources

                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl223:
                            // 2 sources

                            v5 = Unit.INSTANCE;
                            ** GOTO lbl226
                        }
lbl225:
                        // 1 sources

                        v5 = Unit.INSTANCE;
lbl226:
                        // 2 sources

                        $this$trace$iv$iv = v5;
                        v6 = $this$trace$iv$iv;
                        return Unit.INSTANCE;
lbl229:
                        // 1 sources

                        finally {
                            $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
                            $i$f$trace = false;
                            if ($this$trace$iv$iv.isTraceEnabled()) {
                                var23_34 = $this$trace$iv$iv;
                                $i$a$-trace-ContextRetrievalService$execOperation$2$2$iv = false;
                                var23_34.trace("finished operation " + opKind$iv + " for " + request$iv);
                            }
                        }
lbl238:
                        // 1 sources

                        $i$f$currentCoroutineContext = false;
                        v7 = (ExecStatsElement)this.getContext().get((CoroutineContext.Key)ExecStatsElement.Companion);
                        if (v7 == null) {
                            v7 = new ExecStatsElement();
                        }
                        execStatsElement$iv$iv = v7;
                        parentStatsBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)CollectionsKt.lastOrNull((List)execStatsElement$iv$iv.getTracingBuilders());
                        execStatsElement$iv$iv.getTracingBuilders().add(currentBuilder$iv$iv);
                        $completion$iv = (Continuation)this;
                        parentStatsBuilder$iv = parentStatsBuilder$iv$iv;
                        tracingContext$iv = (CoroutineContext)execStatsElement$iv$iv;
                        $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = 0;
                        $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
                        $i$f$trace = false;
                        if ($this$trace$iv$iv.isTraceEnabled()) {
                            var23_35 = $this$trace$iv$iv;
                            $i$a$-trace-ContextRetrievalService$execOperation$2$1$iv = false;
                            var23_35.trace("started operation " + opKind$iv + " for " + request$iv);
                        }
                        $completion = (Continuation)this;
                        parentStatsBuilder = parentStatsBuilder$iv;
                        statsBuilder = statsBuilder$iv;
                        loader = storage$iv.getLoader();
                        tracingContext = tracingContext$iv;
                        $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1 = 0;
                        maybeCollectedItems = new ArrayList<E>();
                        this.L$0 = $this$flow;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                        this.L$2 = request$iv;
                        this.L$3 = opKind$iv;
                        this.L$4 = var7_8;
                        this.L$5 = var8_9;
                        this.L$6 = SpillingKt.nullOutSpilledVariable((Object)storage$iv);
                        this.L$7 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder$iv);
                        this.L$8 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                        this.L$9 = SpillingKt.nullOutSpilledVariable((Object)currentBuilder$iv$iv);
                        this.L$10 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                        this.L$11 = SpillingKt.nullOutSpilledVariable((Object)parentStatsBuilder$iv);
                        this.L$12 = SpillingKt.nullOutSpilledVariable((Object)tracingContext$iv);
                        this.L$13 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                        this.L$14 = parentStatsBuilder;
                        this.L$15 = statsBuilder;
                        this.L$16 = SpillingKt.nullOutSpilledVariable((Object)loader);
                        this.L$17 = SpillingKt.nullOutSpilledVariable((Object)tracingContext);
                        this.L$18 = maybeCollectedItems;
                        this.L$19 = SpillingKt.nullOutSpilledVariable((Object)parentStatsBuilder$iv$iv);
                        this.L$20 = execStatsElement$iv$iv;
                        this.Z$0 = withTracing$iv;
                        this.Z$1 = var9_10;
                        this.I$0 = $i$f$execOperation;
                        this.I$1 = needTracing$iv;
                        this.I$2 = $i$f$maybeWithTracingContext;
                        this.I$3 = $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv;
                        this.I$4 = $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1;
                        this.label = 5;
                        v8 = FlowKt.flowOn(loader.gatherContextFlow(var7_8, statsBuilder), (CoroutineContext)tracingContext).collect(new /* invalid duplicate definition of identical inner class */, (Continuation)this);
                        v9 = v8;
                        if (v8 == var43_3) {
                            return var43_3;
                        }
                        ** GOTO lbl339
                        case 5: {
                            $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1 = this.I$4;
                            $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = this.I$3;
                            $i$f$maybeWithTracingContext = this.I$2;
                            needTracing$iv = this.I$1;
                            $i$f$execOperation = this.I$0;
                            var9_10 = this.Z$1;
                            withTracing$iv = this.Z$0;
                            execStatsElement$iv$iv = (ExecStatsElement)this.L$20;
                            parentStatsBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)this.L$19;
                            maybeCollectedItems = (List)this.L$18;
                            tracingContext = (CoroutineContext)this.L$17;
                            loader = (CombinedContextLoader)this.L$16;
                            statsBuilder = (ContextRetrievalRequestExecution.Builder)this.L$15;
                            parentStatsBuilder = (ContextRetrievalRequestExecution.Builder)this.L$14;
                            $completion = (Continuation)this.L$13;
                            tracingContext$iv = (CoroutineContext)this.L$12;
                            parentStatsBuilder$iv = (ContextRetrievalRequestExecution.Builder)this.L$11;
                            $completion$iv = (Continuation)this.L$10;
                            currentBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)this.L$9;
                            this_$iv$iv = (ExecStatsElement.Companion)this.L$8;
                            statsBuilder$iv = (ContextRetrievalRequestExecution.Builder)this.L$7;
                            storage$iv = (SessionStorage)this.L$6;
                            var8_9 = (ContextRetrievalService)this.L$5;
                            var7_8 = (ContextRetrievalRequest)this.L$4;
                            opKind$iv = (ContextRetrievalRequestExecution.OpKind)this.L$3;
                            request$iv = (ContextRetrievalRequest)this.L$2;
                            this_$iv = (ContextRetrievalService)this.L$1;
                            {
                                ResultKt.throwOnFailure((Object)$result);
                                v9 = $result;
lbl339:
                                // 2 sources

                                execStats = statsBuilder.build(maybeCollectedItems);
                                ContextRetrievalService.access$logExecStats(var8_9, var7_8, parentStatsBuilder, execStats);
                                if (!var9_10 || execStats == null) break;
                                $this$trace$iv = ContextRetrievalService.access$getLOG$cp();
                                $i$f$trace = false;
                                if ($this$trace$iv.isTraceEnabled()) {
                                    var35_61 = $this$trace$iv;
                                    $i$a$-trace-ContextRetrievalService$gatherContextFlowImpl$1$1$2 = false;
                                    var35_61.trace("collected " + execStats);
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$flow);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                                this.L$2 = request$iv;
                                this.L$3 = opKind$iv;
                                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)storage$iv);
                                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder$iv);
                                this.L$6 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                                this.L$7 = SpillingKt.nullOutSpilledVariable((Object)currentBuilder$iv$iv);
                                this.L$8 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                                this.L$9 = SpillingKt.nullOutSpilledVariable((Object)parentStatsBuilder$iv);
                                this.L$10 = SpillingKt.nullOutSpilledVariable((Object)tracingContext$iv);
                                this.L$11 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                this.L$12 = SpillingKt.nullOutSpilledVariable((Object)parentStatsBuilder);
                                this.L$13 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder);
                                this.L$14 = SpillingKt.nullOutSpilledVariable((Object)loader);
                                this.L$15 = SpillingKt.nullOutSpilledVariable((Object)tracingContext);
                                this.L$16 = SpillingKt.nullOutSpilledVariable((Object)maybeCollectedItems);
                                this.L$17 = SpillingKt.nullOutSpilledVariable((Object)execStats);
                                this.L$18 = SpillingKt.nullOutSpilledVariable((Object)parentStatsBuilder$iv$iv);
                                this.L$19 = execStatsElement$iv$iv;
                                this.L$20 = null;
                                this.Z$0 = withTracing$iv;
                                this.I$0 = $i$f$execOperation;
                                this.I$1 = needTracing$iv;
                                this.I$2 = $i$f$maybeWithTracingContext;
                                this.I$3 = $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv;
                                this.I$4 = $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1;
                                this.label = 6;
                                v10 = $this$flow.emit((Object)execStats, (Continuation)this);
                                ** if (v10 != var43_3) goto lbl380
                            }
lbl379:
                            // 1 sources

                            return var43_3;
lbl380:
                            // 1 sources

                            ** GOTO lbl411
                        }
                        case 6: {
                            $i$a$-execOperation-ContextRetrievalService$gatherContextFlowImpl$1$1 = this.I$4;
                            $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = this.I$3;
                            $i$f$maybeWithTracingContext = this.I$2;
                            needTracing$iv = this.I$1;
                            $i$f$execOperation = this.I$0;
                            withTracing$iv = this.Z$0;
                            execStatsElement$iv$iv = (ExecStatsElement)this.L$19;
                            parentStatsBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)this.L$18;
                            execStats = (ContextRetrievalRequestExecution)this.L$17;
                            maybeCollectedItems = (List)this.L$16;
                            tracingContext = (CoroutineContext)this.L$15;
                            loader = (CombinedContextLoader)this.L$14;
                            statsBuilder = (ContextRetrievalRequestExecution.Builder)this.L$13;
                            parentStatsBuilder = (ContextRetrievalRequestExecution.Builder)this.L$12;
                            $completion = (Continuation)this.L$11;
                            tracingContext$iv = (CoroutineContext)this.L$10;
                            parentStatsBuilder$iv = (ContextRetrievalRequestExecution.Builder)this.L$9;
                            $completion$iv = (Continuation)this.L$8;
                            currentBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)this.L$7;
                            this_$iv$iv = (ExecStatsElement.Companion)this.L$6;
                            statsBuilder$iv = (ContextRetrievalRequestExecution.Builder)this.L$5;
                            storage$iv = (SessionStorage)this.L$4;
                            opKind$iv = (ContextRetrievalRequestExecution.OpKind)this.L$3;
                            request$iv = (ContextRetrievalRequest)this.L$2;
                            this_$iv = (ContextRetrievalService)this.L$1;
                            ** try [egrp 7[TRYBLOCK] [6 : 2744->2762)] { 
lbl408:
                            // 1 sources

                            ResultKt.throwOnFailure((Object)$result);
                            v10 = $result;
lbl411:
                            // 2 sources

                            v11 = Unit.INSTANCE;
                            break block36;
                        }
                    }
                    v11 = Unit.INSTANCE;
                    break block36;
lbl415:
                    // 1 sources

                    finally {
                        $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
                        $i$f$trace = false;
                        if ($this$trace$iv$iv.isTraceEnabled()) {
                            var23_35 = $this$trace$iv$iv;
                            $i$a$-trace-ContextRetrievalService$execOperation$2$2$iv = false;
                            var23_35.trace("finished operation " + opKind$iv + " for " + request$iv);
                        }
                    }
                }
                var21_27 = v11;
                var39_71 = var21_27;
                v6 = var39_71;
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super ContextEntity> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object postProcessGatheredContextImpl(ContextRetrievalRequest request, Iterable<? extends ContextEntity> gatheredContext, boolean withTracing, Continuation<? super Iterable<? extends ContextEntity>> $completion) {
        if (!($completion instanceof postProcessGatheredContextImpl.1)) ** GOTO lbl-1000
        var38_5 = $completion;
        if ((var38_5.label & -2147483648) != 0) {
            var38_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                Object L$14;
                Object L$15;
                Object L$16;
                Object L$17;
                Object L$18;
                boolean Z$0;
                boolean Z$1;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                /* synthetic */ Object result;
                final /* synthetic */ ContextRetrievalService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ContextRetrievalService.access$postProcessGatheredContextImpl(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var39_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_8 = this;
                var6_11 = request;
                var7_12 = withTracing;
                var8_15 = ContextRetrievalRequestExecution.OpKind.POST_PROCESSING;
                $i$f$execOperation = 0;
                storage$iv = ContextRetrievalService.access$sessionStorage(this_$iv, request$iv.getSession());
                $continuation.L$0 = request;
                $continuation.L$1 = gatheredContext;
                $continuation.L$2 = this_$iv;
                $continuation.L$3 = request$iv;
                $continuation.L$4 = opKind$iv;
                $continuation.L$5 = storage$iv;
                $continuation.Z$0 = withTracing;
                $continuation.Z$1 = withTracing$iv;
                $continuation.I$0 = $i$f$execOperation;
                $continuation.label = 1;
                v0 = storage$iv.waitUntilInitialized((Continuation<? super Unit>)$continuation);
                if (v0 == var39_7) {
                    return var39_7;
                }
                ** GOTO lbl45
            }
            case 1: {
                $i$f$execOperation = $continuation.I$0;
                withTracing$iv = $continuation.Z$1;
                withTracing = $continuation.Z$0;
                storage$iv = (SessionStorage)$continuation.L$5;
                opKind$iv = (ContextRetrievalRequestExecution.OpKind)$continuation.L$4;
                request$iv = (ContextRetrievalRequest)$continuation.L$3;
                this_$iv = (ContextRetrievalService)$continuation.L$2;
                gatheredContext = (Iterable)$continuation.L$1;
                request = (ContextRetrievalRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl45:
                // 2 sources

                $continuation.L$0 = request;
                $continuation.L$1 = gatheredContext;
                $continuation.L$2 = this_$iv;
                $continuation.L$3 = request$iv;
                $continuation.L$4 = opKind$iv;
                $continuation.L$5 = storage$iv;
                $continuation.Z$0 = withTracing;
                $continuation.Z$1 = withTracing$iv;
                $continuation.I$0 = $i$f$execOperation;
                $continuation.label = 2;
                v1 = ExecStatsElement.Companion.hasStatsElement((Continuation<? super Boolean>)$continuation);
                if (v1 == var39_7) {
                    return var39_7;
                }
                ** GOTO lbl71
            }
            case 2: {
                $i$f$execOperation = $continuation.I$0;
                withTracing$iv = $continuation.Z$1;
                withTracing = $continuation.Z$0;
                storage$iv = (SessionStorage)$continuation.L$5;
                opKind$iv = (ContextRetrievalRequestExecution.OpKind)$continuation.L$4;
                request$iv = (ContextRetrievalRequest)$continuation.L$3;
                this_$iv = (ContextRetrievalService)$continuation.L$2;
                gatheredContext = (Iterable)$continuation.L$1;
                request = (ContextRetrievalRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl71:
                // 2 sources

                needTracing$iv = (Boolean)v1 != false || withTracing$iv != false || ContextRetrievalService.access$getServiceDebugMode(this_$iv) != false ? 1 : 0;
                statsBuilder$iv = new ContextRetrievalRequestExecution.Builder(storage$iv.getLoader().getSession(), request$iv, opKind$iv, needTracing$iv != 0);
                var13_28 = ExecStatsElement.Companion;
                currentBuilder$iv$iv = statsBuilder$iv;
                $i$f$maybeWithTracingContext = 0;
                if (currentBuilder$iv$iv.getEnabled()) break;
                var16_37 = (Continuation)$continuation;
                var17_41 = null;
                tracingContext$iv = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = 0;
                $this$trace$iv$iv /* !! */  = ContextRetrievalService.access$getLOG$cp();
                $i$f$trace = false;
                if ($this$trace$iv$iv /* !! */ .isTraceEnabled()) {
                    var22_61 = $this$trace$iv$iv /* !! */ ;
                    $i$a$-trace-ContextRetrievalService$execOperation$2$1$iv = false;
                    var22_61.trace("started operation " + opKind$iv + " for " + request$iv);
                }
                var24_67 = (Continuation)$continuation;
                var25_71 = parentStatsBuilder$iv;
                var26_73 = statsBuilder$iv;
                var27_75 = storage$iv.getLoader();
                tracingContext = tracingContext$iv;
                $i$a$-execOperation-ContextRetrievalService$postProcessGatheredContextImpl$2 = 0;
                $continuation.L$0 = request;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)gatheredContext);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                $continuation.L$3 = request$iv;
                $continuation.L$4 = opKind$iv;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)storage$iv);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder$iv);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)currentBuilder$iv$iv);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)tracingContext$iv);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                $continuation.L$12 = statsBuilder;
                $continuation.L$13 = SpillingKt.nullOutSpilledVariable((Object)loader);
                $continuation.L$14 = SpillingKt.nullOutSpilledVariable((Object)tracingContext);
                $continuation.Z$0 = withTracing;
                $continuation.Z$1 = withTracing$iv;
                $continuation.I$0 = $i$f$execOperation;
                $continuation.I$1 = needTracing$iv;
                $continuation.I$2 = $i$f$maybeWithTracingContext;
                $continuation.I$3 = $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv;
                $continuation.I$4 = $i$a$-execOperation-ContextRetrievalService$postProcessGatheredContextImpl$2;
                $continuation.label = 3;
                v2 = BuildersKt.withContext((CoroutineContext)tracingContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Iterable<? extends ContextEntity>>, Object>((CombinedContextLoader)loader, request, (Iterable<? extends ContextEntity>)gatheredContext, statsBuilder, null){
                    int label;
                    final /* synthetic */ CombinedContextLoader $loader;
                    final /* synthetic */ ContextRetrievalRequest $request;
                    final /* synthetic */ Iterable<ContextEntity> $gatheredContext;
                    final /* synthetic */ ContextRetrievalRequestExecution.Builder $statsBuilder;
                    {
                        this.$loader = $loader;
                        this.$request = $request;
                        this.$gatheredContext = $gatheredContext;
                        this.$statsBuilder = $statsBuilder;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$loader.postProcessContext(this.$request, this.$gatheredContext, this.$statsBuilder, (Continuation<? super Iterable<? extends ContextEntity>>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Iterable<? extends ContextEntity>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var39_7) goto lbl122
lbl121:
                // 1 sources

                return var39_7;
lbl122:
                // 1 sources

                ** GOTO lbl152
            }
            case 3: {
                $i$a$-execOperation-ContextRetrievalService$postProcessGatheredContextImpl$2 = $continuation.I$4;
                $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = $continuation.I$3;
                $i$f$maybeWithTracingContext = $continuation.I$2;
                needTracing$iv = $continuation.I$1;
                $i$f$execOperation = $continuation.I$0;
                withTracing$iv = $continuation.Z$1;
                withTracing = $continuation.Z$0;
                tracingContext = (CoroutineContext)$continuation.L$14;
                loader = (CombinedContextLoader)$continuation.L$13;
                statsBuilder = (ContextRetrievalRequestExecution.Builder)$continuation.L$12;
                parentStatsBuilder = null;
                $completion = (Continuation)$continuation.L$11;
                tracingContext$iv = (CoroutineContext)$continuation.L$10;
                parentStatsBuilder$iv = null;
                $completion$iv = (Continuation)$continuation.L$9;
                currentBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$8;
                this_$iv$iv = (ExecStatsElement.Companion)$continuation.L$7;
                statsBuilder$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$6;
                storage$iv = (SessionStorage)$continuation.L$5;
                opKind$iv = (ContextRetrievalRequestExecution.OpKind)$continuation.L$4;
                request$iv = (ContextRetrievalRequest)$continuation.L$3;
                this_$iv = (ContextRetrievalService)$continuation.L$2;
                gatheredContext = (Iterable)$continuation.L$1;
                request = (ContextRetrievalRequest)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl152:
                    // 2 sources

                    items = (Iterable)v2;
                    $this$trace$iv$iv /* !! */  = ContextRetrievalService.access$handleExecStats(this, request, withTracing != false, statsBuilder, parentStatsBuilder, items);
                    v3 /* !! */  = $this$trace$iv$iv /* !! */ ;
                    ** GOTO lbl283
                }
                catch (Throwable $this$trace$iv$iv) {
                    throw $this$trace$iv$iv;
                }
                finally {
                    $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
                    $i$f$trace = false;
                    if ($this$trace$iv$iv.isTraceEnabled()) {
                        var22_61 = $this$trace$iv$iv;
                        $i$a$-trace-ContextRetrievalService$execOperation$2$2$iv = false;
                        var22_61.trace("finished operation " + opKind$iv + " for " + request$iv);
                    }
                }
            }
        }
        $i$f$currentCoroutineContext = false;
        v4 = (ExecStatsElement)$continuation.getContext().get((CoroutineContext.Key)ExecStatsElement.Companion);
        if (v4 == null) {
            v4 = new ExecStatsElement();
        }
        execStatsElement$iv$iv = v4;
        parentStatsBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)CollectionsKt.lastOrNull((List)execStatsElement$iv$iv.getTracingBuilders());
        execStatsElement$iv$iv.getTracingBuilders().add(currentBuilder$iv$iv);
        $completion$iv = (Continuation)$continuation;
        parentStatsBuilder$iv = parentStatsBuilder$iv$iv;
        tracingContext$iv = (CoroutineContext)execStatsElement$iv$iv;
        $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = 0;
        $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
        $i$f$trace = false;
        if ($this$trace$iv$iv.isTraceEnabled()) {
            var22_62 = $this$trace$iv$iv;
            $i$a$-trace-ContextRetrievalService$execOperation$2$1$iv = false;
            var22_62.trace("started operation " + opKind$iv + " for " + request$iv);
        }
        $completion = (Continuation)$continuation;
        parentStatsBuilder = parentStatsBuilder$iv;
        statsBuilder = statsBuilder$iv;
        loader = storage$iv.getLoader();
        tracingContext = tracingContext$iv;
        $i$a$-execOperation-ContextRetrievalService$postProcessGatheredContextImpl$2 = 0;
        $continuation.L$0 = request;
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)gatheredContext);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
        $continuation.L$3 = request$iv;
        $continuation.L$4 = opKind$iv;
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)storage$iv);
        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)statsBuilder$iv);
        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
        $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)currentBuilder$iv$iv);
        $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
        $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)parentStatsBuilder$iv);
        $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)tracingContext$iv);
        $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)$completion);
        $continuation.L$13 = parentStatsBuilder;
        $continuation.L$14 = statsBuilder;
        $continuation.L$15 = SpillingKt.nullOutSpilledVariable((Object)loader);
        $continuation.L$16 = SpillingKt.nullOutSpilledVariable((Object)tracingContext);
        $continuation.L$17 = SpillingKt.nullOutSpilledVariable((Object)parentStatsBuilder$iv$iv);
        $continuation.L$18 = execStatsElement$iv$iv;
        $continuation.Z$0 = withTracing;
        $continuation.Z$1 = withTracing$iv;
        $continuation.I$0 = $i$f$execOperation;
        $continuation.I$1 = needTracing$iv;
        $continuation.I$2 = $i$f$maybeWithTracingContext;
        $continuation.I$3 = $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv;
        $continuation.I$4 = $i$a$-execOperation-ContextRetrievalService$postProcessGatheredContextImpl$2;
        $continuation.label = 4;
        v5 = BuildersKt.withContext((CoroutineContext)tracingContext, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)$continuation);
        ** if (v5 != var39_7) goto lbl227
lbl226:
        // 1 sources

        return var39_7;
lbl227:
        // 1 sources

        ** GOTO lbl260
        {
            case 4: {
                $i$a$-execOperation-ContextRetrievalService$postProcessGatheredContextImpl$2 = $continuation.I$4;
                $i$a$-maybeWithTracingContext-ContextRetrievalService$execOperation$2$iv = $continuation.I$3;
                $i$f$maybeWithTracingContext = $continuation.I$2;
                needTracing$iv = $continuation.I$1;
                $i$f$execOperation = $continuation.I$0;
                withTracing$iv = $continuation.Z$1;
                withTracing = $continuation.Z$0;
                execStatsElement$iv$iv = (ExecStatsElement)$continuation.L$18;
                parentStatsBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$17;
                tracingContext = (CoroutineContext)$continuation.L$16;
                loader = (CombinedContextLoader)$continuation.L$15;
                statsBuilder = (ContextRetrievalRequestExecution.Builder)$continuation.L$14;
                parentStatsBuilder = (ContextRetrievalRequestExecution.Builder)$continuation.L$13;
                $completion = (Continuation)$continuation.L$12;
                tracingContext$iv = (CoroutineContext)$continuation.L$11;
                parentStatsBuilder$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$10;
                $completion$iv = (Continuation)$continuation.L$9;
                currentBuilder$iv$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$8;
                this_$iv$iv = (ExecStatsElement.Companion)$continuation.L$7;
                statsBuilder$iv = (ContextRetrievalRequestExecution.Builder)$continuation.L$6;
                storage$iv = (SessionStorage)$continuation.L$5;
                opKind$iv = (ContextRetrievalRequestExecution.OpKind)$continuation.L$4;
                request$iv = (ContextRetrievalRequest)$continuation.L$3;
                this_$iv = (ContextRetrievalService)$continuation.L$2;
                gatheredContext = (Iterable)$continuation.L$1;
                request = (ContextRetrievalRequest)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl260:
                    // 2 sources

                    items = (Iterable)v5;
                    var20_54 = ContextRetrievalService.access$handleExecStats(this, request, withTracing != false, statsBuilder, parentStatsBuilder, items);
                    ** GOTO lbl274
                    {
                        catch (Throwable var21_60) {
                            throw var21_60;
                        }
                    }
                    finally {
                        $this$trace$iv$iv = ContextRetrievalService.access$getLOG$cp();
                        $i$f$trace = false;
                        if ($this$trace$iv$iv.isTraceEnabled()) {
                            var22_62 = $this$trace$iv$iv;
                            $i$a$-trace-ContextRetrievalService$execOperation$2$2$iv = false;
                            var22_62.trace("finished operation " + opKind$iv + " for " + request$iv);
                        }
                    }
lbl274:
                    // 1 sources

                    var33_96 = var20_54;
                    v3 /* !! */  = var33_96;
                }
                catch (Throwable var36_100) {
                    throw var36_100;
                }
                finally {
                    CollectionsKt.removeLast((List)execStatsElement$iv$iv.getTracingBuilders());
                }
lbl283:
                // 2 sources

                return v3 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <T> Object execOperation(ContextRetrievalRequest request2, boolean withTracing, ContextRetrievalRequestExecution.OpKind opKind, Function5<? super CoroutineContext, ? super CombinedContextLoader, ? super ContextRetrievalRequestExecution.Builder, ? super ContextRetrievalRequestExecution.Builder, ? super Continuation<? super T>, ? extends Object> operation, Continuation<? super T> $completion) {
        Object object;
        block14: {
            void $this$trace$iv;
            Object object2;
            String string;
            Logger logger;
            void currentBuilder$iv;
            ContextRetrievalRequestExecution.Builder statsBuilder;
            SessionStorage storage;
            block13: {
                String string2;
                void var19_29;
                Object $this$trace$iv2;
                boolean $i$f$execOperation = false;
                storage = this.sessionStorage(request2.getSession());
                InlineMarker.mark((int)0);
                storage.waitUntilInitialized($completion);
                InlineMarker.mark((int)1);
                InlineMarker.mark((int)0);
                Object object3 = ExecStatsElement.Companion.hasStatsElement($completion);
                InlineMarker.mark((int)1);
                boolean needTracing = (Boolean)object3 != false || withTracing || this.getServiceDebugMode();
                statsBuilder = new ContextRetrievalRequestExecution.Builder(storage.getLoader().getSession(), request2, opKind, needTracing);
                ExecStatsElement.Companion companion = ExecStatsElement.Companion;
                ContextRetrievalRequestExecution.Builder builder = statsBuilder;
                boolean $i$f$maybeWithTracingContext = false;
                if (currentBuilder$iv.getEnabled()) break block13;
                Continuation<? super T> continuation = $completion;
                ContextRetrievalRequestExecution.Builder builder2 = null;
                CoroutineContext tracingContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                boolean bl = false;
                Logger logger2 = ContextRetrievalService.LOG;
                boolean $i$f$trace22 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    var19_29 = $this$trace$iv2;
                    boolean bl2 = false;
                    string2 = "started operation " + opKind + " for " + request2;
                    var19_29.trace(string2);
                }
                try {
                    void parentStatsBuilder;
                    CombinedContextLoader combinedContextLoader = storage.getLoader();
                    InlineMarker.mark((int)3);
                    $this$trace$iv2 = operation.invoke((Object)tracingContext, (Object)combinedContextLoader, (Object)statsBuilder, (Object)parentStatsBuilder, null);
                }
                catch (Throwable $this$trace$iv3) {
                    void $this$trace$iv4;
                    InlineMarker.finallyStart((int)1);
                    Logger $i$f$trace = ContextRetrievalService.LOG;
                    boolean $i$f$trace3 = false;
                    if ($this$trace$iv4.isTraceEnabled()) {
                        var19_29 = $this$trace$iv4;
                        boolean bl3 = false;
                        string2 = "finished operation " + opKind + " for " + request2;
                        var19_29.trace(string2);
                    }
                    InlineMarker.finallyEnd((int)1);
                    throw $this$trace$iv3;
                }
                InlineMarker.finallyStart((int)1);
                Logger $i$f$trace22 = ContextRetrievalService.LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv3.isTraceEnabled()) {
                    var19_29 = $this$trace$iv3;
                    boolean bl4 = false;
                    string2 = "finished operation " + opKind + " for " + request2;
                    var19_29.trace(string2);
                }
                InlineMarker.finallyEnd((int)1);
                object = $this$trace$iv2;
                break block14;
            }
            boolean $i$f$currentCoroutineContext = false;
            InlineMarker.mark((int)3);
            ExecStatsElement execStatsElement = (ExecStatsElement)null.getContext().get((CoroutineContext.Key)ExecStatsElement.Companion);
            ExecStatsElement execStatsElement$iv = execStatsElement != null ? execStatsElement : new ExecStatsElement();
            ContextRetrievalRequestExecution.Builder parentStatsBuilder$iv = (ContextRetrievalRequestExecution.Builder)CollectionsKt.lastOrNull((List)execStatsElement$iv.getTracingBuilders());
            execStatsElement$iv.getTracingBuilders().add((ContextRetrievalRequestExecution.Builder)currentBuilder$iv);
            Continuation<? super T> $completion2 = $completion;
            ContextRetrievalRequestExecution.Builder parentStatsBuilder = parentStatsBuilder$iv;
            CoroutineContext tracingContext = (CoroutineContext)execStatsElement$iv;
            boolean bl = false;
            Logger $this$trace$iv2 = ContextRetrievalService.LOG;
            boolean $i$f$trace32 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl5 = false;
                string = "started operation " + opKind + " for " + request2;
                logger.trace(string);
            }
            try {
                CombinedContextLoader combinedContextLoader = storage.getLoader();
                InlineMarker.mark((int)3);
                object2 = operation.invoke((Object)tracingContext, (Object)combinedContextLoader, (Object)statsBuilder, (Object)parentStatsBuilder, null);
            }
            catch (Throwable throwable) {
                void $this$trace$iv5;
                InlineMarker.finallyStart((int)1);
                Logger $i$f$trace = ContextRetrievalService.LOG;
                boolean $i$f$trace4 = false;
                if ($this$trace$iv5.isTraceEnabled()) {
                    logger = $this$trace$iv5;
                    boolean bl6 = false;
                    string = "finished operation " + opKind + " for " + request2;
                    logger.trace(string);
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
            InlineMarker.finallyStart((int)1);
            Logger $i$f$trace32 = ContextRetrievalService.LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl7 = false;
                string = "finished operation " + opKind + " for " + request2;
                logger.trace(string);
            }
            InlineMarker.finallyEnd((int)1);
            Object object4 = object2;
            object = object4;
            break block14;
            finally {
                InlineMarker.finallyStart((int)1);
                CollectionsKt.removeLast((List)execStatsElement$iv.getTracingBuilders());
                InlineMarker.finallyEnd((int)1);
            }
        }
        return object;
    }

    private final Iterable<ContextEntity> handleExecStats(ContextRetrievalRequest request2, boolean withTracing, ContextRetrievalRequestExecution.Builder statsBuilder, ContextRetrievalRequestExecution.Builder parentStatsBuilder, Iterable<? extends ContextEntity> items2) {
        ContextRetrievalRequestExecution execStats = statsBuilder.build(items2);
        this.logExecStats(request2, parentStatsBuilder, execStats);
        if (withTracing && execStats != null) {
            ArrayList<ContextRetrievalRequestExecution> itemsAndStats = new ArrayList<ContextRetrievalRequestExecution>(CollectionsKt.count(items2) + 1);
            CollectionsKt.addAll((Collection)itemsAndStats, items2);
            itemsAndStats.add(execStats);
            return itemsAndStats;
        }
        return items2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logExecStats(ContextRetrievalRequest request2, ContextRetrievalRequestExecution.Builder parentStatsBuilder, ContextRetrievalRequestExecution execStats) {
        if (parentStatsBuilder != null && execStats != null) {
            parentStatsBuilder.logNestedRequest(execStats);
        }
        if (this.getServiceDebugMode() && execStats != null) {
            Map<Class<? extends ContextRetrievalRequest>, CopyOnWriteArrayList<Pair<ContextRetrievalRequest, ContextRetrievalRequestExecution>>> map2 = this.latestRequests;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"latestRequests");
            Map<Class<? extends ContextRetrievalRequest>, CopyOnWriteArrayList<Pair<ContextRetrievalRequest, ContextRetrievalRequestExecution>>> map3 = map2;
            synchronized (map3) {
                boolean bl = false;
                CopyOnWriteArrayList requestsList = this.latestRequests.computeIfAbsent(request2.getClass(), arg_0 -> ContextRetrievalService.logExecStats$lambda$29$lambda$28(ContextRetrievalService::logExecStats$lambda$29$lambda$27, arg_0));
                if (requestsList.size() > this.DEBUG_NUM_LAST_REQUESTS_TO_STORE) {
                    Intrinsics.checkNotNull((Object)requestsList);
                    CollectionsKt.removeLast((List)requestsList);
                }
                requestsList.add(0, TuplesKt.to((Object)request2, (Object)execStats));
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private static final Unit contextLoaderOpts$lambda$15(ContextRetriever retriever, int numViolations) {
        Intrinsics.checkNotNullParameter((Object)retriever, (String)"retriever");
        if (Registry.Companion.is("llm.context.service.interactive.retrievers.report.spam") && numViolations == 1 && !SpamUpdatesCapability.Companion.canSpamUpdates(retriever)) {
            LOG.error("Retriever \"" + retriever.getId() + "\" spamming updates!");
        }
        return Unit.INSTANCE;
    }

    private static final SessionStorage getOrAddSession$lambda$20(ContextRetrievalService this$0, RetrievalSession $session, RetrievalSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SessionStorage(this$0.cs, new CombinedContextLoader($session, this$0.contextLoaderOpts), (Iterable<? extends ContextRetrieverFactory>)this$0.retrieversFactories, (Iterable<? extends ContextTransformerFactory>)this$0.transformersFactories, (Iterable<? extends ContextPostProcessorFactory>)this$0.postProcessorsFactories);
    }

    private static final SessionStorage getOrAddSession$lambda$21(Function1 $tmp0, Object p0) {
        return (SessionStorage)$tmp0.invoke(p0);
    }

    private static final CopyOnWriteArrayList logExecStats$lambda$29$lambda$27(Class it) {
        return new CopyOnWriteArrayList();
    }

    private static final CopyOnWriteArrayList logExecStats$lambda$29$lambda$28(Function1 $tmp0, Object p0) {
        return (CopyOnWriteArrayList)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$computeContextImpl(ContextRetrievalService $this, ContextRetrievalRequest request2, boolean withTracing, Continuation $completion) {
        return $this.computeContextImpl(request2, withTracing, (Continuation<? super Iterable<? extends ContextEntity>>)$completion);
    }

    public static final /* synthetic */ void access$logExecStats(ContextRetrievalService $this, ContextRetrievalRequest request2, ContextRetrievalRequestExecution.Builder parentStatsBuilder, ContextRetrievalRequestExecution execStats) {
        $this.logExecStats(request2, parentStatsBuilder, execStats);
    }

    public static final /* synthetic */ Object access$postProcessGatheredContextImpl(ContextRetrievalService $this, ContextRetrievalRequest request2, Iterable gatheredContext, boolean withTracing, Continuation $completion) {
        return $this.postProcessGatheredContextImpl(request2, gatheredContext, withTracing, (Continuation<? super Iterable<? extends ContextEntity>>)$completion);
    }

    public static final /* synthetic */ Iterable access$handleExecStats(ContextRetrievalService $this, ContextRetrievalRequest request2, boolean withTracing, ContextRetrievalRequestExecution.Builder statsBuilder, ContextRetrievalRequestExecution.Builder parentStatsBuilder, Iterable items2) {
        return $this.handleExecStats(request2, withTracing, statsBuilder, parentStatsBuilder, items2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ContextRetrievalService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/context/ContextRetrievalService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ml/llm/context/ContextRetrievalService;", "project", "Lcom/intellij/openapi/project/Project;", "asyncInstance", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.context"})
    @SourceDebugExtension(value={"SMAP\nContextRetrievalService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextRetrievalService.kt\ncom/intellij/ml/llm/context/ContextRetrievalService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,568:1\n30#2,2:569\n75#2:571\n*S KotlinDebug\n*F\n+ 1 ContextRetrievalService.kt\ncom/intellij/ml/llm/context/ContextRetrievalService$Companion\n*L\n45#1:569,2\n46#1:571\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContextRetrievalService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ContextRetrievalService> serviceClass$iv = ContextRetrievalService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ContextRetrievalService)object;
        }

        @Nullable
        public final Object asyncInstance(@NotNull Project project2, @NotNull Continuation<? super ContextRetrievalService> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project2;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(ContextRetrievalService.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/context/ContextRetrievalService$SessionStorage;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "loader", "Lcom/intellij/ml/llm/context/impl/CombinedContextLoader;", "retrieversFactories", "", "Lcom/intellij/ml/llm/context/ContextRetrieverFactory;", "transformersFactories", "Lcom/intellij/ml/llm/context/ContextTransformerFactory;", "postProcessorsFactories", "Lcom/intellij/ml/llm/context/ContextPostProcessorFactory;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/ml/llm/context/impl/CombinedContextLoader;Ljava/lang/Iterable;Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "getLoader", "()Lcom/intellij/ml/llm/context/impl/CombinedContextLoader;", "creationTimestamp", "Lkotlinx/datetime/Instant;", "getCreationTimestamp", "()Lkotlinx/datetime/Instant;", "initializationJob", "Lkotlinx/coroutines/Job;", "waitUntilInitialized", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isTargetSessionTooGeneric", "", "targetSessionClass", "Ljava/lang/Class;", "Lcom/intellij/ml/llm/context/RetrievalSession;", "factoriesProvider", "Lcom/intellij/ml/llm/context/RetrievalSessionRegistrar;", "intellij.ml.llm.context"})
    private static final class SessionStorage {
        @NotNull
        private final CombinedContextLoader loader;
        @NotNull
        private final Iterable<ContextRetrieverFactory> retrieversFactories;
        @NotNull
        private final Iterable<ContextTransformerFactory> transformersFactories;
        @NotNull
        private final Iterable<ContextPostProcessorFactory> postProcessorsFactories;
        @NotNull
        private final Instant creationTimestamp;
        @NotNull
        private final Job initializationJob;

        public SessionStorage(@NotNull CoroutineScope cs, @NotNull CombinedContextLoader loader, @NotNull Iterable<? extends ContextRetrieverFactory> retrieversFactories, @NotNull Iterable<? extends ContextTransformerFactory> transformersFactories, @NotNull Iterable<? extends ContextPostProcessorFactory> postProcessorsFactories) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            Intrinsics.checkNotNullParameter(retrieversFactories, (String)"retrieversFactories");
            Intrinsics.checkNotNullParameter(transformersFactories, (String)"transformersFactories");
            Intrinsics.checkNotNullParameter(postProcessorsFactories, (String)"postProcessorsFactories");
            this.loader = loader;
            this.retrieversFactories = retrieversFactories;
            this.transformersFactories = transformersFactories;
            this.postProcessorsFactories = postProcessorsFactories;
            this.creationTimestamp = Clock.System.INSTANCE.now();
            this.initializationJob = BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                int label;
                final /* synthetic */ SessionStorage this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var21_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            allowedRetrieversFactories = new LinkedHashSet<E>();
                            allowedTransformersFactories = new LinkedHashSet<E>();
                            allowedPostProcessorsFactories = new LinkedHashSet<E>();
                            for (RetrievalSessionRegistrar factoryProvider : RetrievalSessionRegistrar.Companion.getEP_NAME().getExtensionList()) {
                                targetSessionClass = factoryProvider.getSessionClass();
                                ContextRetrievalService.access$getLOG$cp().assertTrue(this.this$0.isTargetSessionTooGeneric((Class<? extends RetrievalSession>)targetSessionClass, factoryProvider) == false, (Object)("The target session class " + (Class)targetSessionClass + " of " + factoryProvider + " is too generic!"));
                                if (!targetSessionClass.isAssignableFrom(this.this$0.getLoader().getSession().getClass())) continue;
                                allowedRetrieversFactories.addAll((Collection)factoryProvider.getRetrieverFactories());
                                allowedTransformersFactories.addAll((Collection)factoryProvider.getTransformerFactories());
                                allowedPostProcessorsFactories.addAll((Collection)factoryProvider.getPostProcessorFactories());
                            }
                            $this$filter$iv = SessionStorage.access$getRetrieversFactories$p(this.this$0);
                            $i$f$filter = false;
                            targetSessionClass = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (ContextRetrieverFactory)element$iv$iv;
                                $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$1 = false;
                                if (!allowedRetrieversFactories.contains(it.getClass())) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            $i$f$filter = this.this$0;
                            $i$f$mapNotNull = 0;
                            destination$iv$iv = $this$mapNotNull$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$mapNotNullTo = 0;
                            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            $i$f$forEach = 0;
                            $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$1 = $this$forEach$iv$iv$iv.iterator();
lbl41:
                            // 3 sources

                            while ($i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$1.hasNext()) {
                                element$iv$iv = element$iv$iv$iv = $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$1.next();
                                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = 0;
                                it = (ContextRetrieverFactory)element$iv$iv;
                                $i$a$-mapNotNull-ContextRetrievalService$SessionStorage$initializationJob$1$2 = 0;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)allowedRetrieversFactories);
                                this.L$1 = allowedTransformersFactories;
                                this.L$2 = allowedPostProcessorsFactories;
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNull$iv);
                                this.L$4 = $i$f$filter;
                                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNullTo$iv$iv);
                                this.L$6 = destination$iv$iv;
                                this.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv$iv$iv);
                                this.L$8 = $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$1;
                                this.L$9 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv$iv);
                                this.L$10 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                                this.L$11 = SpillingKt.nullOutSpilledVariable((Object)it);
                                this.I$0 = $i$f$mapNotNull;
                                this.I$1 = $i$f$mapNotNullTo;
                                this.I$2 = $i$f$forEach;
                                this.I$3 = $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv;
                                this.I$4 = $i$a$-mapNotNull-ContextRetrievalService$SessionStorage$initializationJob$1$2;
                                this.label = 1;
                                v0 = it.createRetriever($i$f$filter.getLoader().getSession(), (Continuation<? super ContextRetriever>)this);
                                if (v0 == var21_2) {
                                    return var21_2;
                                }
                                ** GOTO lbl89
                            }
                            break;
                        }
                        case 1: {
                            $i$a$-mapNotNull-ContextRetrievalService$SessionStorage$initializationJob$1$2 = this.I$4;
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = this.I$3;
                            $i$f$forEach = this.I$2;
                            $i$f$mapNotNullTo = this.I$1;
                            $i$f$mapNotNull = this.I$0;
                            it = (ContextRetrieverFactory)this.L$11;
                            element$iv$iv = this.L$10;
                            element$iv$iv$iv = this.L$9;
                            $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$1 = (Iterator<T>)this.L$8;
                            $this$forEach$iv$iv$iv = (Iterable)this.L$7;
                            destination$iv$iv = (Collection)this.L$6;
                            $this$mapNotNullTo$iv$iv = (Iterable)this.L$5;
                            $i$f$filter = (SessionStorage)this.L$4;
                            $this$mapNotNull$iv = (Iterable)this.L$3;
                            allowedPostProcessorsFactories = (Set)this.L$2;
                            allowedTransformersFactories = (Set)this.L$1;
                            allowedRetrieversFactories = (Set)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl89:
                            // 2 sources

                            if ((ContextRetriever)v0 == null) ** GOTO lbl41
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                            ** GOTO lbl41
                        }
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$filter = this.this$0;
                    retrievers = $this$mapNotNull$iv;
                    $i$a$-also-ContextRetrievalService$SessionStorage$initializationJob$1$3 = false;
                    $i$f$filter.getLoader().addRetrievers((Collection)retrievers);
                    $this$filter$iv = SessionStorage.access$getTransformersFactories$p(this.this$0);
                    $i$f$filter = false;
                    retrievers = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (ContextTransformerFactory)element$iv$iv;
                        $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$4 = false;
                        if (!allowedTransformersFactories.contains(it.getClass())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$filter = this.this$0;
                    $i$f$mapNotNull = 0;
                    destination$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = 0;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = 0;
                    $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$4 = $this$forEach$iv$iv$iv.iterator();
lbl122:
                    // 3 sources

                    while ($i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$4.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$4.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = 0;
                        it = (ContextTransformerFactory)element$iv$iv;
                        $i$a$-mapNotNull-ContextRetrievalService$SessionStorage$initializationJob$1$5 = 0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)allowedRetrieversFactories);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)allowedTransformersFactories);
                        this.L$2 = allowedPostProcessorsFactories;
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNull$iv);
                        this.L$4 = $i$f$filter;
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNullTo$iv$iv);
                        this.L$6 = destination$iv$iv;
                        this.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv$iv$iv);
                        this.L$8 = $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$4;
                        this.L$9 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv$iv);
                        this.L$10 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                        this.L$11 = SpillingKt.nullOutSpilledVariable((Object)it);
                        this.I$0 = $i$f$mapNotNull;
                        this.I$1 = $i$f$mapNotNullTo;
                        this.I$2 = $i$f$forEach;
                        this.I$3 = $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv;
                        this.I$4 = $i$a$-mapNotNull-ContextRetrievalService$SessionStorage$initializationJob$1$5;
                        this.label = 2;
                        v1 = it.createTransformer($i$f$filter.getLoader().getSession(), (Continuation<? super ContextTransformer>)this);
                        if (v1 == var21_2) {
                            return var21_2;
                        }
                        ** GOTO lbl170
                    }
                    {
                        break;
                        case 2: {
                            $i$a$-mapNotNull-ContextRetrievalService$SessionStorage$initializationJob$1$5 = this.I$4;
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = this.I$3;
                            $i$f$forEach = this.I$2;
                            $i$f$mapNotNullTo = this.I$1;
                            $i$f$mapNotNull = this.I$0;
                            it = (ContextTransformerFactory)this.L$11;
                            element$iv$iv = this.L$10;
                            element$iv$iv$iv = this.L$9;
                            $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$4 = (Iterator<T>)this.L$8;
                            $this$forEach$iv$iv$iv = (Iterable)this.L$7;
                            destination$iv$iv = (Collection)this.L$6;
                            $this$mapNotNullTo$iv$iv = (Iterable)this.L$5;
                            $i$f$filter = (SessionStorage)this.L$4;
                            $this$mapNotNull$iv = (Iterable)this.L$3;
                            allowedPostProcessorsFactories = (Set)this.L$2;
                            allowedTransformersFactories = (Set)this.L$1;
                            allowedRetrieversFactories = (Set)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl170:
                            // 2 sources

                            if ((ContextTransformer)v1 == null) ** GOTO lbl122
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                            ** GOTO lbl122
                        }
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$filter = this.this$0;
                    transformers = $this$mapNotNull$iv;
                    $i$a$-also-ContextRetrievalService$SessionStorage$initializationJob$1$6 = false;
                    $i$f$filter.getLoader().addTransformers((List<? extends ContextTransformer>)transformers);
                    $this$filter$iv = SessionStorage.access$getPostProcessorsFactories$p(this.this$0);
                    $i$f$filter = false;
                    transformers = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (ContextPostProcessorFactory)element$iv$iv;
                        $i$a$-filter-ContextRetrievalService$SessionStorage$initializationJob$1$7 = false;
                        if (!allowedPostProcessorsFactories.contains(it.getClass())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    var6_13 = this.this$0;
                    $i$f$mapNotNull = 0;
                    destination$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = 0;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = 0;
                    var13_51 = $this$forEach$iv$iv$iv.iterator();
lbl203:
                    // 3 sources

                    while (var13_51.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = var13_51.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = 0;
                        it = (ContextPostProcessorFactory)element$iv$iv;
                        $i$a$-mapNotNull-ContextRetrievalService$SessionStorage$initializationJob$1$8 = 0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)allowedRetrieversFactories);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)allowedTransformersFactories);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)allowedPostProcessorsFactories);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNull$iv);
                        this.L$4 = var6_13;
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNullTo$iv$iv);
                        this.L$6 = destination$iv$iv;
                        this.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv$iv$iv);
                        this.L$8 = var13_51;
                        this.L$9 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv$iv);
                        this.L$10 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                        this.L$11 = SpillingKt.nullOutSpilledVariable((Object)it);
                        this.I$0 = $i$f$mapNotNull;
                        this.I$1 = $i$f$mapNotNullTo;
                        this.I$2 = $i$f$forEach;
                        this.I$3 = $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv;
                        this.I$4 = $i$a$-mapNotNull-ContextRetrievalService$SessionStorage$initializationJob$1$8;
                        this.label = 3;
                        v2 = it.createPostProcessor(var6_13.getLoader().getSession(), (Continuation<? super ContextPostProcessor>)this);
                        if (v2 == var21_2) {
                            return var21_2;
                        }
                        ** GOTO lbl251
                    }
                    {
                        break;
                        case 3: {
                            $i$a$-mapNotNull-ContextRetrievalService$SessionStorage$initializationJob$1$8 = this.I$4;
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = this.I$3;
                            $i$f$forEach = this.I$2;
                            $i$f$mapNotNullTo = this.I$1;
                            $i$f$mapNotNull = this.I$0;
                            it = (ContextPostProcessorFactory)this.L$11;
                            element$iv$iv = this.L$10;
                            element$iv$iv$iv = this.L$9;
                            var13_51 = (Iterator<T>)this.L$8;
                            $this$forEach$iv$iv$iv = (Iterable)this.L$7;
                            destination$iv$iv = (Collection)this.L$6;
                            $this$mapNotNullTo$iv$iv = (Iterable)this.L$5;
                            var6_13 = (SessionStorage)this.L$4;
                            $this$mapNotNull$iv = (Iterable)this.L$3;
                            allowedPostProcessorsFactories = (Set)this.L$2;
                            allowedTransformersFactories = (Set)this.L$1;
                            allowedRetrieversFactories = (Set)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl251:
                            // 2 sources

                            if ((ContextPostProcessor)v2 == null) ** GOTO lbl203
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                            ** GOTO lbl203
                        }
                    }
                    var5_6 = (List)destination$iv$iv;
                    var6_13 = this.this$0;
                    postProcessors = var5_6;
                    $i$a$-also-ContextRetrievalService$SessionStorage$initializationJob$1$9 = false;
                    var6_13.getLoader().addPostProcessors(postProcessors);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @NotNull
        public final CombinedContextLoader getLoader() {
            return this.loader;
        }

        @NotNull
        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Nullable
        public final Object waitUntilInitialized(@NotNull Continuation<? super Unit> $completion) {
            Object object = this.initializationJob.join($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public final boolean isTargetSessionTooGeneric(@NotNull Class<? extends RetrievalSession> targetSessionClass, @NotNull RetrievalSessionRegistrar factoriesProvider) {
            Intrinsics.checkNotNullParameter(targetSessionClass, (String)"targetSessionClass");
            Intrinsics.checkNotNullParameter((Object)factoriesProvider, (String)"factoriesProvider");
            if (factoriesProvider instanceof MandatoryRegistrar) {
                return false;
            }
            return Intrinsics.areEqual(targetSessionClass, RetrievalSession.class) || Intrinsics.areEqual(targetSessionClass, InteractiveRetrievalSession.class);
        }

        public static final /* synthetic */ Iterable access$getRetrieversFactories$p(SessionStorage $this) {
            return $this.retrieversFactories;
        }

        public static final /* synthetic */ Iterable access$getTransformersFactories$p(SessionStorage $this) {
            return $this.transformersFactories;
        }

        public static final /* synthetic */ Iterable access$getPostProcessorsFactories$p(SessionStorage $this) {
            return $this.postProcessorsFactories;
        }
    }
}

